"""
 * ***** BEGIN LICENSE BLOCK *****
 * Portions Copyright (c) 1996-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 *
 * Contributor(s):
 *
 * ***** END LICENSE BLOCK *****
"""

import os
import sys
import gtk
import gobject
import string
import pango

from gettext import gettext as _

from sugar.graphics.toolbutton import ToolButton
from sugar.graphics.toggletoolbutton import ToggleToolButton
from sugar.graphics.icon import Icon
from sugar.graphics.objectchooser import ObjectChooser
from sugar.activity import activity

os.environ["HELIX_LIBS"] = activity.get_bundle_path() + '/helix'
helix_libs = os.environ.get("HELIX_LIBS")
sys.path.append(helix_libs)
import hxplay

class PlayToolbar(gtk.Toolbar):
    
    def previous_clicked(self, widget):
        self.mediaPlayer.player.previous()

    def next_clicked(self, widget):
        self.mediaPlayer.player.next()

    def repeat_clicked(self, widget):
        self.mediaPlayer.player.set_repeat()

    def play_clicked(self, widget):
        self.mediaPlayer.player.play()

    def stop_clicked(self, widget):
        self.mediaPlayer.stop()

    def progressbar_blank(self):
        if self.mediaPlayer.player.active():
            self.toolbar_label.set_markup("<span foreground=\"white\" size=\"x-large\">00:00:00/" + self.total_time + "</span>")
            self.adjustment.value = 0
        else:
            self.toolbar_label.set_markup("<span foreground=\"white\" size=\"x-large\">00:00:00/00:00:00</span>")
            self.adjustment.value = 0

    def update_time(self):
        self.time_elapsed = ("%02d" % (self.mediaPlayer.player.int_time/3600)) + \
            ":" + ("%02d" % ((self.mediaPlayer.player.int_time/60)%60)) + \
            ":" + ("%02d" % (self.mediaPlayer.player.int_time%60))
        #if time failed to set on init
        if not self.mediaPlayer.player.int_length:
            self.set_time()
        self.toolbar_label.set_markup("<span foreground=\"white\" size=\"x-large\">" + self.time_elapsed + "/" + self.total_time + "</span>")
        self.adjustment.value = self.mediaPlayer.player.int_time

    def set_time(self):
        self.mediaPlayer.player.set_length()
        self.total_time =   ("%02d" % (self.mediaPlayer.player.int_length/3600)) + \
            ":" + ("%02d" % ((self.mediaPlayer.player.int_length/60)%60)) + \
            ":" + ("%02d" % (self.mediaPlayer.player.int_length%60))
        self.adjustment.upper = self.mediaPlayer.player.int_length
        
    def fullscreen_clicked(self, widget):
        self.mediaPlayer.player.enter_fullscreen()

    def fit_screen_clicked(self, widget):
        if self.mediaPlayer.player.playing:
            self.mediaPlayer.player.fit_screen()
            if not self.mediaPlayer.player.is_fit():
                self.fit_to_screen.set_icon("zoom-native")
                self.fit_to_screen.set_tooltip(_("Native Size"))
            else:
                self.fit_to_screen.set_icon("zoom-best-fit")
                self.fit_to_screen.set_tooltip(_("Fit To Screen"))
        else:
            widget.set_active(False)

    def buttondown(self, widget, event, data=None):
        self.mediaPlayer.player.seekdown()

    def buttonup(self, widget, event, data=None):
        self.mediaPlayer.player.seekup()

    def barseek(self, widget, value=None, data=None):
        if self.mediaPlayer.player.playing:
            self.mediaPlayer.player.int_time = int(self.adjustment.value)
            self.time_elapsed = ("%02d" % (self.mediaPlayer.player.int_time/3600)) + \
                ":" + ("%02d" % ((self.mediaPlayer.player.int_time/60)%60)) + \
                ":" + ("%02d" % (self.mediaPlayer.player.int_time%60))
        self.toolbar_label.set_markup("<span foreground=\"white\" size=\"x-large\">" + self.time_elapsed + "/" + self.total_time + "</span>")

    def presentation_opened(self):
        self.toolbar_label.set_markup("<span foreground=\"white\" size=\"x-large\">00:00:00/" + self.total_time + "</span>")
        self.adjustment.value = 0
        self.adjustment.lower = 0
       

    def stop(self):
        if self.mediaPlayer.player.playing:
            self.play_button.set_icon("stock-play")
            self.play_button.set_tooltip(_("Play"))
            self.fit_to_screen.set_icon("zoom-native")
            self.fit_to_screen.set_tooltip(_("Native Size"))
        self.progressbar_blank()

    def paused(self):
        self.play_button.set_icon("stock-play")
        self.play_button.set_tooltip(_("Play"))

    def playing(self):
        self.play_button.set_icon("stock-pause")
        self.play_button.set_tooltip(_('Pause'))

    def buffering(self, bufferText):
        self.bufferText = bufferText
        if bufferText is not "":
            self.toolbar_label.set_markup("<span foreground=\"white\" size=\"x-large\">" + self.bufferText + "</span>")

    def repeat_on(self):
        self.repeat_button.set_icon("norepeat")
        self.repeat_button.set_tooltip(_("No Repeat"))

    def repeat_off(self):
        self.repeat_button.set_icon("repeat")
        self.repeat_button.set_tooltip(_("Repeat"))
    
    def open_clicked(self, button):
        chooser = ObjectChooser(_('Choose Media'), self.mediaPlayer,
                                gtk.DIALOG_MODAL | gtk.DIALOG_DESTROY_WITH_PARENT)
        try:
            result = chooser.run()
            if result == gtk.RESPONSE_ACCEPT:
                dsobject = chooser.get_selected_object()
                if dsobject and dsobject.file_path:
                    self.mediaPlayer.open_datastore(dsobject)
                    self.mediaPlayer.stop()
                    self.mediaPlayer.player.play()
        finally:
            chooser.destroy()
            del chooser
        
    def __init__(self, handle, mediaPlayer):
        self.total_time = "00:00:00"
        self.time_elapsed = "00:00:00"
        self.bufferText = ""
        
        gtk.Toolbar.__init__(self)
        self.mediaPlayer = mediaPlayer
        
        #this little diddy adds our icons folder to the default theme
        self.icontheme = gtk.icon_theme_get_default()
        self.icontheme.append_search_path(activity.get_bundle_path() + '/icons')
        
        self.previous_button = ToolButton('stock-previous')
        self.previous_button.connect("clicked", self.previous_clicked)
        self.previous_button.set_tooltip(_('Previous'))
        self.insert(self.previous_button, -1)
        self.previous_button.show()
       
        #Play/pause buttons.
        self.play_button = ToolButton('stock-play')
        self.play_button.connect("clicked", self.play_clicked)
        self.play_button.set_tooltip(_('Play'))
        self.insert(self.play_button, -1)
        self.play_button.show()
     
        self.stop_button = ToolButton('stock-stop')
        self.stop_button.connect("clicked", self.stop_clicked)
        self.stop_button.set_tooltip(_('Stop'))
        self.insert(self.stop_button, -1)
        self.stop_button.show()
        
        self.next_button = ToolButton('stock-next')
        self.next_button.connect("clicked", self.next_clicked)
        self.next_button.set_tooltip(_('Next'))
        self.insert(self.next_button, -1)
        self.next_button.show()
       
        self.repeat_button = ToolButton('repeat')
        self.repeat_button.connect("clicked", self.repeat_clicked)
        self.repeat_button.set_tooltip(_('Repeat'))
        self.insert(self.repeat_button, -1)
        self.repeat_button.show()
       
       	#We pack a vbox with our progressbar and time label, we pack our vbox in a ToolItem, 
        #and a ToolItem in our toolbar. Yay GUI's 
        self.progressbar_item = gtk.ToolItem()
        self.progressbar_item.set_expand(True)
        self.progressbar_vbox = gtk.VBox(homogeneous=False, spacing=0)
        self.progressbar_vbox.show()

        #Progress Bar
        self.adjustment = gtk.Adjustment(value=0, lower=0, upper=0, step_incr=0, page_incr=0, page_size=0)
        self.progressBar = gtk.HScale(self.adjustment)
    	self.progressBar.set_digits(int(0))
        self.progressBar.set_update_policy(gtk.UPDATE_CONTINUOUS)
        self.progressBar.set_value_pos(gtk.POS_TOP)
        self.progressBar.set_draw_value(False)
        self.progressBar.connect("button_release_event", self.buttonup)
        self.progressBar.connect("button_press_event", self.buttondown)
        self.progressBar.connect("change-value", self.barseek)
        self.progressBar.show()
        
        #Label Under Progress Bar
        self.toolbar_label = gtk.Label()
        self.toolbar_label.set_markup("<span foreground=\"white\" size=\"x-large\">00:00:00/00:00:00</span>")
        self.toolbar_label.show()
        
        #Packing Progress Bar and Label
        self.progressbar_vbox.pack_start(self.progressBar, expand=True, fill=True, padding=0)
        self.progressbar_vbox.pack_start(self.toolbar_label, expand=True, fill=True, padding=0)
	
        self.progressbar_item.add(self.progressbar_vbox)
        self.insert(self.progressbar_item, -1)
        self.progressbar_item.show()
        
        self.open_button = ToolButton('stock-open-location')
        self.open_button.connect('clicked', self.open_clicked)
        self.open_button.set_tooltip(_('Open Media File'))
        self.insert(self.open_button, -1)
        self.open_button.show()

        self.fullscreen_button = ToolButton('view-fullscreen')
        self.fullscreen_button.connect("clicked", self.fullscreen_clicked)
        self.fullscreen_button.set_tooltip(_('Enter Fullscreen'))
        self.insert(self.fullscreen_button, -1)
        self.fullscreen_button.show()

        #Zoom buttons.
        self.fit_to_screen = ToolButton('zoom-native')
        self.fit_to_screen.connect("clicked", self.fit_screen_clicked)
        self.fit_to_screen.set_tooltip(_('Native Size'))
        self.insert(self.fit_to_screen, -1)
        self.fit_to_screen.show()

