"""
 * ***** BEGIN LICENSE BLOCK *****
 * Portions Copyright (c) 1996-2004 RealNetworks, Inc. All Rights Reserved.
 *
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 *
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 *
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 *
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 *
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 *
 * Contributor(s):
 *
 * ***** END LICENSE BLOCK *****
"""

import os
import sys
import gtk
import gobject
import string
import pango

from gettext import gettext as _

from sugar.graphics.toolbutton import ToolButton
from sugar.graphics.toggletoolbutton import ToggleToolButton
from sugar.graphics.icon import Icon
from sugar.activity import activity

os.environ["HELIX_LIBS"] = activity.get_bundle_path() + '/helix'
helix_libs = os.environ.get("HELIX_LIBS")
sys.path.append(helix_libs)
import hxplay

MAX_WIDTH = 1200
MAX_HEIGHT = 740

class Play():
    def idle_function(self):
        try:
            hxplay.doevent()
        except Exception, e:
            print e
        return True

    def stop(self):
        if self.idlefunction:
           gobject.source_remove(self.idlefunction)
        self.playing = 0
        self.paused = 0
        self.mediaPlayer.blank()
        self.mediaPlayer.stopped = 1
        self.player.stop()

    def play(self, force=None):
        if (self.player != None):
            if self.playing or force:
                    self.playing=0
                    gobject.source_remove(self.idlefunction)
                    self.mediaPlayer.toolbar.paused()
                    self.player.pause()
            else:
                if self.mediaPlayer.stopped:
                    self.openfile(self.mediaPlayer.file)
                    self.paused = 0
                else:
                    self.paused = 0
                    self.playing = 1
                    self.idlefunction = gobject.idle_add(self.idle_function)
                    self.stopped = 0
                    self.mediaPlayer.toolbar.playing()
                    self.player.start()

        elif self.mediaPlayer.file:
            self.openfile(self.mediaPlayer.file)

    def previous(self):
        if self.player and self.playing:
            self.player.previous()

    def next(self):
        #group index starts at 0, so we need +1
        if self.player and self.playing and \
        (self.player.currentGroup() + 1 < self.player.numGroups()):
            self.player.next()
        elif (self.player.currentGroup() + 1 == self.player.numGroups()) and \
        self.repeat and (self.player.numGroups is not 0):
            self.player.goToGroup(0)

    def set_repeat(self):
        if (self.player != None) and (self.playing == 1):
            self.toggle_repeat()

    def toggle_repeat(self):
        if (self.repeat == 0):
            self.repeat = 1
            self.mediaPlayer.toolbar.repeat_on()
        else:
            self.repeat = 0
            self.mediaPlayer.toolbar.repeat_off()

    def handle_uri_timer(self):
        if (self.mediaPlayer.file) and (not self.player):
            self.openfile(self.mediaPlayer.file)
        return False

    def active(self):
        return self.player != None

    def openfile(self, file = None):
        if self.dsobject:
            self.mediaPlayer.file = 'file://' + self.dsobject.file_path
            file = self.mediaPlayer.file
        if self.mediaPlayer.file:
            xid = self.mediaPlayer.subwin.window.xid
            xdisplayname = self.mediaPlayer.subwin.get_screen().make_display_name()
            site = (xdisplayname,xid)
            callbacks = [
                    (hxplay.ON_PRESENTATION_OPENED, self.on_presentation_opened, None),
                    (hxplay.ON_ERROR,               self.on_error,               None),
                    (hxplay.ON_PRESENTATION_CLOSED, self.on_presentation_closed, None),
                    (hxplay.ON_POS_LENGTH,          self.on_pos_length,          None),
                    (hxplay.ON_BUFFERING,           self.on_buffering,           None),
                    (hxplay.ON_PAUSE,               self.on_pause,               None),
                    (hxplay.ON_CHANGING_SIZE,       self.on_changing_size,       None),
                    (hxplay.ON_STOP,                self.on_stop,                None)
                    ]
            if (self.player == None):
                self.player = hxplay.open(file,
                       callbacks=callbacks, site=site)
            else:
                if not self.mediaPlayer.stopped:
                    self.player.stop()
                self.player.open(file)

            self.mediaPlayer.stopped = 0
            self.playing = 0
            self.play()
    
    def set_dsobject(self, dsobject):
        self.dsobject = dsobject

    def on_pause(self, player, data, data1, data2):
        self.paused = 1

    def on_buffering(self, player, data, data1, data2):
        ulArgs, bufferPercent = data2
        if (bufferPercent == 100):
            self.mediaPlayer.toolbar.buffering("")
            self.buffering = 0
            self.generateLabel()
        else:
            self.buffering = 1
            self.mediaPlayer.toolbar.buffering("Buffering (%d%%)" % (bufferPercent))

    def generateLabel(self):
        title = self.player.stats("Title")
        author = self.player.stats("Author")

        if not title:
            title = "Unknown"

        if not author:
            author = "Unknown"

        self.mediaPlayer.label.set_markup("<span foreground=\"white\" size=\"x-large\">" + \
                              "Title: " + title + "  |  " + \
                              "Author: " + author + "</span>")

    def on_changing_size(self, player, data, data1, data2):
        #oldx, oldy, newx, newy = data2
        # XXXgfw This is just a hack for now. We can not call aspectSafeResize
        # or positionInCenter from here because it will result in a recursive
        # callstack until the stack blows up. So, we check in ON_POS_LENGTH and
        # do it there, yuk. Once we have buttons for 1x, wide screen and full
        # screen we won't need this ugliness and it can be yanked out.
        if self.playing:
            self.needRepos = 1

    def on_pos_length(self,player,cb,args,(pos,length)):
        if self.playing:
            if self.int_time != int(self.player.time()):
                self.int_time = int(self.player.time())
                self.mediaPlayer.toolbar.update_time()
                #for failure to set on init (playlists)
                if not self.original_height:
                    self.original_width, self.original_height = self.player.getSize()
                #it doesn't stop on playlists, so we can perform end of file stuff here
                if self.int_time == self.int_length:
                    self.player.exitFullScreen()
        #only update the progress bar when its not being dragged
        if (self.needRepos):
            self.positionInCenter()
            self.needRepos=0
        if (not self.sizeupdated and self.player.hasSite() and not self.fit):
            self.sizeupdated = 1
            self.aspectSafeResize(MAX_WIDTH, MAX_HEIGHT)
            self.positionInCenter()

    def set_length(self):
        self.int_length = int(self.player.length())

    def enter_fullscreen(self):
        if self.playing:
            self.player.enterFullScreen()

    def aspectSafeResize(self, width, height):
        oldWidth, oldHeight = self.player.getSize()
        if (width >= height):
            newWidth = width
            newHeight = (oldHeight * newWidth) / oldWidth
            if (newHeight > MAX_HEIGHT):
                newHeight = height
                newWidth = (oldWidth * newHeight) / oldHeight
        else:
            newHeight = height
            newWidth = (oldWidth * newHeight) / oldHeight
            if (newWidth > MAX_WIDTH):
                newWidth = width
                newHeight = (oldHeight * newWidth) / oldWidth
        self.player.setSize(int(newWidth),int(newHeight))

    def positionInCenter(self):
        playerWidth, playerHeight = self.player.getSize()
        windowWidth, windowHeight = self.mediaPlayer.subwin.size_request()

        x = (windowWidth / 2) - (playerWidth / 2)
        y = (windowHeight / 2) - (playerHeight / 2)

        self.player.setPosition(int(x), int(y))

    def is_fit(self):
        return self.fit

    def seekdown(self):
        if self.player != None:
            if(self.playing):
                    self.play(0)
                    self.wasPlaying = 1

    def seekup(self):
        if self.player != None:
            self.player.seek(self.mediaPlayer.toolbar.adjustment.value)
	    if self.wasPlaying:
	    	self.play(0)
	    self.wasPlaying = 0

    def fit_screen(self):
        if self.fit == 0: #widget.get_active():
            self.aspectSafeResize(self.original_width, self.original_height)
            self.positionInCenter()
            self.fit = 1
        else:
            self.aspectSafeResize(MAX_WIDTH, MAX_HEIGHT)
            self.positionInCenter()
            self.fit = 0

    def on_presentation_closed(self, player, one, two, three):
        if self.fullscreen:
            self.fullscreen = 0
            self.player.exitFullScreen()
        self.stop()

    def on_presentation_opened(self, player, one, two, three):
        self.mediaPlayer.blank()
        self.currentPos = 0
        self.mediaPlayer.toolbar.set_time()
        self.original_width, self.original_height = self.player.getSize()
        self.mediaPlayer.toolbar.presentation_opened()

        self.sizeupdated = 0

    def on_stop(self, player, one, two, three):
        if (self.repeat == 1 and self.mediaPlayer.stopped == 0):
            repeat_timer = gobject.timeout_add(10, self.repeat_timer)
        self.mediaPlayer.toolbar.stop()

    def repeat_timer(self):
        self.play()
        return False

    def on_error(self, player, one, two, three):
        severity, hxcode, usercode, msg, userstring, moreinfo = three
        self.mediaPlayer.error_dialog(msg, userstring)

    def __init__(self, mediaPlayer):
        self.wasPlaying = 0
        self.fit = 0
        self.currentPos = 0
        self.playing = 0
        self.sizeupdated = 1
        self.player = None
        self.needRepos = 0
        self.original_width = 0
        self.original_height = 0
        self.fullscreen = 0
        self.paused = 0
        self.buffering = 0
        self.repeat = 0
        self.int_time = 0
        self.int_length = 0

        self.mediaPlayer = mediaPlayer

