import pygtk
import gtk
import time

from sugar.activity.activity import ActivityToolbox

from sound_toolbar import SoundToolbar
from sensor_toolbar import SensorToolbar
from logging_ui import LogToolbar


class Toolbar(ActivityToolbox):

	def __init__(self, activity, wave, audiograb, journal, textbox):

		ActivityToolbox.__init__(self, activity)

		self._SOUND_TOOLBAR = 1
		self._SENSOR_TOOLBAR = 2

		self._sound_toolbar = SoundToolbar(wave, audiograb, textbox)
		self.add_toolbar('Sound', self._sound_toolbar)
		self._sound_toolbar.show()

		self._sensors_toolbar = SensorToolbar(audiograb, textbox)
		self.add_toolbar('Sensors', self._sensors_toolbar)
		self._sensors_toolbar.show()

		"""
		self._camera_toolbar = CameraToolbar(activity, camera_ui)
		self.add_toolbar('Camera', self._camera_toolbar)
		self._camera_toolbar.show()

		self._wifi_toolbar = MeasureToolbar(wave, audiograb)
		self.add_toolbar('Wireless', self._wifi_toolbar)
		self._wifi_toolbar.show()

		self._log_toolbar = LogToolbar(audiograb, journal, activity)
		self.add_toolbar('Log View', self._log_toolbar)
		self._log_toolbar.show()
		"""

		self.connect("current-toolbar-changed", self._toolbar_changed_cb)
		self.wave = wave
		self.activity = activity
		self.toolbar_active_id = 1
		self.set_current_toolbar(self._SOUND_TOOLBAR)


	def _toolbar_changed_cb(self, tbox, num):
		if num==0:                              #Activity
			pass
		elif num==self._SOUND_TOOLBAR:                           #Sound
			self.activity.set_show_hide_windows(self._SOUND_TOOLBAR)
			self._sensors_toolbar.context_off()
			time.sleep(0.5)
			self._sound_toolbar.context_on()
			self.wave.set_context_on()
		elif num==self._SENSOR_TOOLBAR:                            #Sensor
			self.activity.set_show_hide_windows(self._SENSOR_TOOLBAR)
			self._sound_toolbar.context_off()
			time.sleep(0.5)
			self._sensors_toolbar.context_on()
			self.wave.set_context_on()

		self.toolbar_active_id = num
		"""
		elif num==3:                            #Camera
			self.activity.set_show_hide_windows(1)
			self._sound_toolbar.context_off()
			self.wave.set_context_off()
			time.sleep(0.5)
			self._camera_toolbar.set_context_on()
		elif num==4:        
			self.wave.set_context_off()
			self._sound_toolbar.context_off()
			self._camera_toolbar.set_context_off()
			time.sleep(0.5)
		elif num==5:
			self.wave.set_context_off() 
			self._sound_toolbar.context_off()
			self._camera_toolbar.set_context_off()
			time.sleep(0.5)
		"""
		return True
		

	def get_which_toolbar_active(self):
		"""Returns which toolbar is active
		Activity toolbar - 1
		Sound toolbar 	 - 2
		Sensors toolbar  - 3
		"""
		return self.toolbar_active_id



