import pygst
pygst.require("0.10")
import pygtk
import gtk
import os
import gobject
from time import *
from gettext import gettext as _

import config  	#This has all the globals
import audioop

from sugar.graphics.toolbutton import ToolButton


class SoundToolbar(gtk.Toolbar):

	def __init__(self, wave, audiograb, textbox):
		
		gtk.Toolbar.__init__(self)

		self.wave_copy = wave
		self.audiograb_copy = audiograb
		self.textbox_copy = textbox


		#######################time#########################
		self._time = ToolButton('domain-time2')
		self.insert(self._time, -1)
		self._time.show()
		self._time.set_tooltip(_('Time base'))
		self._time.connect('clicked', self._timefreq_control_cb, True)
		###################################################

		#######################frequency######################
		self._freq = ToolButton('domain-freq')
		self.insert(self._freq, -1)
		self._freq.show()
		self._freq.set_tooltip(_('Frequency base'))
		self._freq.connect('clicked', self._timefreq_control_cb, False)
		####################################################

		#self.time_freq_state = self.wave_copy.get_fft_mode()
		#self._time.set_active(not(self.time_freq_state))
		#self._freq.set_active(self.time_freq_state)

		separator = gtk.SeparatorToolItem()
		separator.set_draw(True)
		self.insert(separator, -1)
		separator.show()	

		self.freq_low_img = gtk.Image()
		self.freq_high_img = gtk.Image()

		self.freq_low_img.set_from_file(config.ICONS_DIR + '/freq-high.svg')
		self.freq_high_img.set_from_file(config.ICONS_DIR + '/freq-low.svg')

		self.freq_low_img_tool = gtk.ToolItem()
		self.freq_high_img_tool = gtk.ToolItem()

		self.freq_low_img_tool.add(self.freq_low_img)
		self.freq_high_img_tool.add(self.freq_high_img)


		#######################frequency control#####################
		self.adjustmentf = gtk.Adjustment(70, 10, 70 ,20, 20, 0.0)
		self.adjustmentf.connect("value_changed", self.cb_page_sizef, self.adjustmentf)
		self._freq_range = gtk.HScale(self.adjustmentf)
		self._freq_range.set_draw_value(False)
		self._freq_range.set_update_policy(gtk.UPDATE_CONTINUOUS)
		self._freq_range.set_size_request(120,15)
		self._freq_range_tool = gtk.ToolItem()
		self._freq_range_tool.add(self._freq_range)
		############################################################

		self.insert(self.freq_low_img_tool,-1)
		self.insert(self._freq_range_tool, -1)
		self.insert(self.freq_high_img_tool,-1)		

		self.freq_low_img.show()
		self.freq_high_img.show()

		self.freq_low_img_tool.show()
		self.freq_high_img_tool.show()

		self._STR_BASIC = "Sound "
		self._STR1 = "Time Base      "
		self._STR2 = "Frequency Base "
		self._STR_SCALEX = ""
		self._STR_XAXIS1 = "X Axis Scale: 1 division = "
		self._STR_XAXIS2 = "ms "
		self._STR_XAXIS3 = "Hz "

		self.string_for_textbox = ""


		

	def _timefreq_control_cb(self, data=None, time_state=True):

		if time_state==True and self.wave_copy.get_fft_mode()==True:
			self.wave_copy.set_fft_mode(False)
			self._time.set_icon('domain-time2')
			self._freq.set_icon('domain-freq')
			self._time.show()
			self._freq.show()
			self._update_string_for_textbox()
			return False

		if time_state==False and self.wave_copy.get_fft_mode()==False:		
			self.wave_copy.set_fft_mode(True)
			self._time.set_icon('domain-time')
			self._freq.set_icon('domain-freq2')
			self._time.show()
			self._freq.show()
			self._update_string_for_textbox()
			return False

		return False


	def cb_page_sizef(self, get, data=None):

		if(get.value>=10 and get.value<20):
			self._freq_range.set_value(10)
			self.audiograb_copy.set_sampling_rate(4000)
			self.wave_copy.set_freq_range(1)

		if(get.value>=20 and get.value<46):
			self._freq_range.set_value(30)
			self.audiograb_copy.set_sampling_rate(4000)
			self.wave_copy.set_freq_range(2)
			
		if(get.value>=46 and get.value<62):
			self._freq_range.set_value(50)
			self.audiograb_copy.set_sampling_rate(16000)
			self.wave_copy.set_freq_range(3)

		if(get.value>=62 and get.value<=70):
			self._freq_range.set_value(70)
			self.audiograb_copy.set_sampling_rate(48000)
			self.wave_copy.set_freq_range(4)

		self._update_string_for_textbox()

		return True


	def calculate_x_axis_scale(self):	
		sampling_rate = self.audiograb_copy.get_sampling_rate()
		draw_interval = self.wave_copy.get_drawing_interval()

		if self.wave_copy.get_fft_mode() == False:
			scale = (50000.0/sampling_rate)/draw_interval
			self._STR_SCALEX = self._STR_XAXIS1 + str(scale) + self._STR_XAXIS2
			return
		else:
			scale = 1.04167/draw_interval
			self._STR_SCALEX = self._STR_XAXIS1 + str(scale) + self._STR_XAXIS3
			return


	def context_off(self):
		"""When some other context is switched to and the sound context is switched off"""
		self.audiograb_copy.pause_grabbing()
		self.wave_copy.set_fft_mode(False)

	
	def context_on(self):
		"""When the sound context is switched on"""
		self.audiograb_copy.resume_grabbing()
		self.audiograb_copy.set_dc_mode(False)
		self.audiograb_copy.set_bias(True)
		self.wave_copy.set_fft_mode(False)
		self._update_string_for_textbox()


	def _update_string_for_textbox(self):
		self.calculate_x_axis_scale()
		self.string_for_textbox = ""
		self.string_for_textbox += (self._STR_BASIC + "\t")
		if self.wave_copy.get_fft_mode() == False:
			self.string_for_textbox += self._STR1
		else:
			self.string_for_textbox += self._STR2
		self.string_for_textbox += ("\n" + self._STR_SCALEX)
		self.textbox_copy.set_data_params(0, self.string_for_textbox)

