import pygtk
import gtk
from gettext import gettext as _

import config  	#This has all the globals

from sugar.graphics.toolbutton import ToolButton


# 'Sensor' toolbar class
class SensorToolbar(gtk.Toolbar):

	def __init__(self, audiograb, textbox):
		
		gtk.Toolbar.__init__(self)
	
		self.ag = audiograb
		self.textbox_copy = textbox
	
		#######################Resistance#####################
		self._resistance = ToolButton('bias-on2')
		self.insert(self._resistance, -1)
		self._resistance.show()
		self._resistance.set_tooltip(_('Resistance Sensor'))
		self._resistance.connect('clicked', self.set_resistance_voltage_mode, 'resistance')
		###################################################
	
		#######################Voltage########################
		self._voltage = ToolButton('bias-off')
		self.insert(self._voltage, -1)
		self._voltage.show()
		self._voltage.set_tooltip(_('Voltage Sensor'))
		self._voltage.connect('clicked', self.set_resistance_voltage_mode, 'voltage')
		####################################################


		self._STR_BASIC = "Sensors, DC (connect sensor to pink 'Mic In') "
		self._STR1 = "Bias/Offset Enabled  "
		self._STR2 = "Bias/Offset Disabled "

		self.string_for_textbox = ""

		
		
		
	def set_resistance_voltage_mode(self, data=None, mode_to_set='resistance'):
		if mode_to_set == 'resistance' and self.get_mode()=='voltage' :
			self.set_mode('resistance')
			self._resistance.set_icon('bias-on2')
			self._voltage.set_icon('bias-off')
			self._resistance.show()
			self._voltage.show()
			self._update_string_for_textbox()
			return False

		if mode_to_set == 'voltage' and self.get_mode()=='resistance' :
			self.set_mode('voltage')
			self._resistance.set_icon('bias-on')
			self._voltage.set_icon('bias-off2')
			self._resistance.show()
			self._voltage.show()
			self._update_string_for_textbox()
			return False
		return False


	def get_mode(self):
		if self.ag.get_bias()==False and self.ag.get_dc_mode()==True :
			return 'voltage'
		elif self.ag.get_bias()==True and self.ag.get_dc_mode()==True :
			return 'resistance'
		else:
			return 'error'


	def set_mode(self, mode='resistance'):
		if mode=='resistance':
			self.ag.set_bias(True)
	   	else:
			self.ag.set_bias(False)
		return 


	def context_off(self):
		self.ag.pause_grabbing()
		
	def context_on(self):
		self.ag.resume_grabbing()
		self.ag.set_dc_mode(True)
		self.ag.set_bias(True)
		self._update_string_for_textbox()


	def _update_string_for_textbox(self):
		self.string_for_textbox = ""
		self.string_for_textbox += (self._STR_BASIC + "\n")
		if self.ag.get_bias() == True:
			self.string_for_textbox += self._STR1
		else:
			self.string_for_textbox += self._STR2
		self.textbox_copy.set_data_params(0, self.string_for_textbox)



