#! /usr/bin/python

import pygtk
import gtk
import os

import config  	#This has all the globals


class SideToolbar(gtk.DrawingArea):

	def __init__(self, wave):
		gtk.DrawingArea.__init__(self)
		
		self.wave_copy = wave

		self.adjustmenty = gtk.Adjustment(0.7, 0.0, 4.0 ,0.1, 0.1, 0.0)
		self.adjustmenty.connect("value_changed", self.cb_page_sizey, self.adjustmenty)
		self.yscrollbar = gtk.VScale(self.adjustmenty)
		self.yscrollbar.set_draw_value(False)
		self.yscrollbar.set_inverted(True)
		self.yscrollbar.set_update_policy(gtk.UPDATE_CONTINUOUS)
				
		self.img_amphigh = gtk.Image()
		self.img_amplow =  gtk.Image()		

		self.img_amphigh.set_from_file(config.ICONS_DIR + '/amp-high.svg')
		self.img_amplow.set_from_file(config.ICONS_DIR + '/amp-low.svg')
		
		self.box1 = gtk.VBox(False,0)
		self.box1.pack_start(self.img_amphigh, False, True, 0)
		self.box1.pack_start(self.yscrollbar, True, True, 0)
		self.box1.pack_start(self.img_amplow, False, True, 0)


	def cb_page_sizey(self, get, data=None):
		if(get.value<=1.5):		
			self.wave_copy.y_mag= get.value
		
		if(get.value>1.5 and get.value<=2.5 ):
			self.wave_copy.y_mag= (get.value*1.5)		
		
		if(get.value>2.5 and get.value<=3.5 ):
			self.wave_copy.y_mag= (get.value*3)
		
		if(get.value>3.5 and get.value<=4.0 ):
			self.wave_copy.y_mag= (get.value*4)						

		return True		
