import pygst
pygst.require("0.10")
import pygtk
import gtk
import gobject
from time import *

import os

import config  	#This has all the globals
import audioop

from sugar.activity.activity import ActivityToolbox, EditToolbar
from sugar.graphics.toolcombobox import ToolComboBox
from sugar.graphics.toolbutton import ToolButton
from sugar.graphics.toggletoolbutton import ToggleToolButton
from sugar.graphics.combobox import ComboBox
from sugar.graphics.palette import Palette
from sugar.graphics.menuitem import MenuItem



#'Log' Toolbar class
class LogToolbar(gtk.Toolbar):

	def __init__(self, _jobject, audiograb, existing):
		
		gtk.Toolbar.__init__(self)

		self._jobject = _jobject
		self.audiograb_copy = audiograb


		self.loginterval_img = gtk.Image()
		self.loginterval_img.set_from_file(config.ICONS_DIR + '/sample_rate.svg')
		self.loginterval_img_tool = gtk.ToolItem()
		self.loginterval_img_tool.add(self.loginterval_img)
		self.insert(self.loginterval_img_tool,-1)
		self.loginterval_img.show()
		self.loginterval_img_tool.show()

		#######################Logging Interval#####################
		self._loginterval_combo = ComboBox()
		self.interval = ['1 second' , '1 minute', '1 hour' , 'Snapshot']
		
		self._interval_changed_id = self._loginterval_combo.connect('changed', self.loginterval_control)

		for i, s in enumerate(self.interval):
			self._loginterval_combo.append_item(i, s, None)
			if s == '1 second':
				self._loginterval_combo.set_active(i)
		
		self._loginterval_tool=ToolComboBox(self._loginterval_combo)
		self.insert(self._loginterval_tool,-1)
		self._loginterval_tool.show()
		self.logginginterval_status = 'sec'		
		############################################################



		separator = gtk.SeparatorToolItem()
		separator.set_draw(True)
		self.insert(separator, -1)
		separator.show()

		#######################Start Logging/Stop Logging#####################
		self._record = ToolButton('media-record')
		self.insert(self._record, -1)
		self._record.show()
		self._record.set_tooltip('Start Logging')
		self._record_status=False  	    #True means recording in progress, False means not recording
		self._record.connect('clicked', self.record_control)
		######################################################################

		separator = gtk.SeparatorToolItem()
		separator.set_draw(True)
		self.insert(separator, -1)
		separator.show()

		#######################Play / Resume#######################
		self._showlog = ToolButton('media-playback-start')
		self.insert(self._showlog, -1)
		self._showlog.show()
		self._showlog.set_tooltip('Show Log')
		self._drawlog_status=False	    #True means log being drawn, False means not drawn i.e. real time wave 
					            #displayed rather than the log
		self._showlog.connect('clicked', self.showlog_control)
		############################################################

		self.f = None
		self.record_showlog='showlog'

		#If activity opened from Journal, directly show log
		if(existing==True):	
			self._showlog.emit("clicked")
	
				
	def record_control(self, data=None):
		if(self.record_showlog=='showlog' or self.record_showlog=='notshowlog'):

			if(self._record_status==False):
				if(self.logginginterval_status=='snapshot'):
					self.audiograb_copy.snapshot()	
					
				self.f = open(self._jobject.file_path, 'w')
				self.f.write("measure.activity.log.start\n")
			

				if (self.logginginterval_status=='sec'):
					multiplier = 1
					self.f.write("second\n")
				elif (self.logginginterval_status=='min'):
					multiplier = 60
					self.f.write("minute\n")
				elif (self.logginginterval_status=='hour'):
					multiplier = 3600
					self.f.write("hour\n")
				elif (self.logginginterval_status=='snapshot'):
					multiplier = 7777
					self.f.write("snapshot\n")
					self._record_status=True
				self.audiograb_copy.set_logging_status(True, self.f, multiplier)			

				if(self._record_status==False):
					self._record.set_icon('media-playback-stop')
					self._record.show()
					self._record.set_tooltip('Stop Logging')
					self._record_status=True
					self.record_showlog='notshowlog'
				else:
					self._record_status=False

			else:
				self.audiograb_copy.set_logging_status(False,self.f,0)		
				self._record.set_icon('media-record')
				self._record.show()
				self._record.set_tooltip('Start Logging')
				self._record_status=False
				self.record_showlog='showlog'
		return



	def showlog_control(self,data=None):
		if(self.record_showlog=='showlog' or self.record_showlog=='showinglog'):
			if(self._drawlog_status==False):
				self.f = open(self._jobject.file_path, 'r')
				self.audiograb_copy.start_drawing_graph(True, self.f)

				self._showlog.set_icon('media-eject')
				self._showlog.show()
				self._showlog.set_tooltip('Remove Log')
				self._drawlog_status=True
				self.record_showlog='showinglog'

			else:
				self.audiograb_copy.start_drawing_graph(False, self.f)
				self._showlog.set_icon('media-playback-start')
				self._showlog.show()
				self._showlog.set_tooltip('Show Log')
				self._drawlog_status=False
				self.record_showlog='showlog'
		return


	
	def loginterval_control(self, combobox):

		if (self._loginterval_combo.get_active() != -1):
			if (self._loginterval_combo.get_active()==0):
				self.logginginterval_status = 'sec'		
				
			if (self._loginterval_combo.get_active()==1):
				self.logginginterval_status = 'min'		
			
			if (self._loginterval_combo.get_active()==2):
				self.logginginterval_status = 'hour'		

			if (self._loginterval_combo.get_active()==3):
				self.logginginterval_status = 'snapshot'		
 
