import pygst
pygst.require("0.10")
import pygtk
import gtk
import gobject
from time import *

import os

import config  	#This has all the globals
import audioop

from sugar.activity.activity import ActivityToolbox, EditToolbar
from sugar.graphics.toolcombobox import ToolComboBox
from sugar.graphics.toolbutton import ToolButton
from sugar.graphics.toggletoolbutton import ToggleToolButton
from sugar.graphics.combobox import ComboBox
from sugar.graphics.palette import Palette
from sugar.graphics.menuitem import MenuItem


# 'Measure' toolbar class
class MeasureToolbar(gtk.Toolbar):

	def __init__(self, wave):
		
		gtk.Toolbar.__init__(self)
		
		self.wave_copy = wave
		
		#######################ac / dc#####################
		self._acdc = ToolButton('current-ac')
		self.insert(self._acdc, -1)
		self._acdc.show()
		self._acdc.set_tooltip('Click for DC')

		self.acdc_status = 'ac'
		
		self._acdc.connect('clicked', self.acdc_control)
		#################################################

		
		#######################bias_on / bias_off#####################
		self._biasonoff = ToolButton('bias-on')
		self.insert(self._biasonoff, -1)
		self._biasonoff.show()
		self._biasonoff.set_tooltip('Click for Bias Off')

		self.bias_status = 'biason'
		
		self._biasonoff.connect('clicked', self.bias_control)
		############################################################

		#######################time / frequency#####################
		self._timefreq = ToolButton('domain-time')
		self.insert(self._timefreq, -1)
		self._timefreq.show()
		self._timefreq.set_tooltip('Click for Frequency base')

		self.timefreq_status = 'time'
		
		self._timefreq.connect('clicked', self.timefreq_control)
		#########################################################

		separator = gtk.SeparatorToolItem()
		separator.set_draw(True)
		self.insert(separator, -1)
		separator.show()

		
		self.freq_low_img = gtk.Image()
		self.freq_high_img = gtk.Image()

		self.freq_low_img.set_from_file(config.ICONS_DIR + '/freq-high.svg')
		self.freq_high_img.set_from_file(config.ICONS_DIR + '/freq-low.svg')
		
		self.freq_low_img_tool = gtk.ToolItem()
		self.freq_high_img_tool = gtk.ToolItem()
	
		self.freq_low_img_tool.add(self.freq_low_img)
		self.freq_high_img_tool.add(self.freq_high_img)


		#######################frequency control#####################
		self.adjustmentf = gtk.Adjustment(70, 30, 70 ,20, 20, 0.0)
		self.adjustmentf.connect("value_changed", self.cb_page_sizef, self.adjustmentf)
		self._freq_range = gtk.HScale(self.adjustmentf)
		self._freq_range.set_draw_value(False)
		self._freq_range.set_update_policy(gtk.UPDATE_CONTINUOUS)
		self._freq_range.set_size_request(120,15)
		self._freq_range_tool = gtk.ToolItem()
		self._freq_range_tool.add(self._freq_range)
		#########################################################

		self.insert(self.freq_low_img_tool,-1)
		self.insert(self._freq_range_tool, -1)
		self.insert(self.freq_high_img_tool,-1)		
		
		self.freq_low_img.show()
		self.freq_high_img.show()
		
		self.freq_low_img_tool.show()
		self.freq_high_img_tool.show()

		separator = gtk.SeparatorToolItem()
		separator.set_draw(True)
		self.insert(separator, -1)
		separator.show()

		#######################play , pause#####################
		self._play = ToolButton('media-playback-pause')
		self.insert(self._play, -1)
		self._play.show()
		self._play.set_tooltip('Pause')
		self._play_status=True	    #True means play mode, False means in pause mode
		self._play.connect('clicked', self.play_control)
		######################################################

				
	def acdc_control(self, data=None):
		if( self.acdc_status=='ac'):
			#Toggle to DC coupling
			os.system("amixer set 'DC Mode Enable' unmute")
			os.system("amixer set 'Capture' 0%, 0% unmute captur")
			os.system("amixer set 'Mic Boost (+20dB)' mute")
			self._acdc.set_icon('current-dc')
			self._acdc.show()			
			self._acdc.set_tooltip('Click for AC')
			self.acdc_status = 'dc'
			return

		if(self.acdc_status=='dc'):
			#Toggle to AC coupling
			os.system("amixer set 'DC Mode Enable' mute")
			os.system("amixer set 'Capture' 50%, 70% unmute captur")
			os.system("amixer set 'Mic Boost (+20dB)' unmute")
			self._acdc.set_icon('current-ac')
			self._acdc.show()			
			self._acdc.set_tooltip('Click for DC')
			self.acdc_status = 'ac'
			return



	def bias_control(self, data=None):
		if(self.bias_status=='biason'):
			#Toggle to Bias Off
			os.system("amixer set 'V_REFOUT Enable' mute")
			self._biasonoff.set_icon('bias-off')
			self._biasonoff.show()
			self._biasonoff.set_tooltip('Click for Bias On')
			self.bias_status = 'biasoff'
			return

		if(self.bias_status=='biasoff'):
			#Toggle to Bias On
			os.system("amixer set 'V_REFOUT Enable' unmute")
			self._biasonoff.set_icon('bias-on')
			self._biasonoff.show()
			self._biasonoff.set_tooltip('Click for Bias Off')
			self.bias_status = 'biason'
			return


	def timefreq_control(self, data=None):
		if(self.timefreq_status=='time'):
			#Toggle to Frequency mode
			self.wave_copy.fft_show=True
			self._timefreq.set_icon('domain-freq')
			self._timefreq.show()
			self._timefreq.set_tooltip('Click for Time base')
			self.timefreq_status = 'freq'
			return

		if(self.timefreq_status=='freq'):
			#Toggle to Time mode
			self.wave_copy.fft_show=False
			self._timefreq.set_icon('domain-time')
			self._timefreq.show()
			self._timefreq.set_tooltip('Click for Frequency base')
			self.timefreq_status = 'time'
			return


	def cb_page_sizef(self, get, data=None):
		# Set the page size and page increment size of the sample
		# adjustment to the value specified by the "Page Size" scale
		
		if(get.value%10>0 and get.value%10<5):
			get.value = get.value-(get.value%10)
		
		if(get.value%10>=5 and get.value%10<10):
			get.value = get.value + 10 -(get.value%10)		
			
		self.wave_copy.freq_range = int(get.value)			

		return True	



	def play_control(self,data=None):
		if(self._play_status==True):
			self.wave_copy.stop=True			
			self._play.set_icon('media-playback-start')
			self._play.show()
			self._play.set_tooltip('Resume')
			self._play_status=False

		else:
			self.wave_copy.stop=False			
			self._play.set_icon('media-playback-pause')
			self._play.show()
			self._play.set_tooltip('Pause')
			self._play_status=True
		return True

