#! /usr/bin/python

import pygst
pygst.require("0.10")
import pygtk
import gtk
import cairo
import gobject
from time import *
from struct import *
import pango

from gtk import gdk

import os

import config  	#This has all the globals

import audioop

from Numeric import *
from FFT import *

class DrawWaveform(gtk.DrawingArea):
	def __init__(self, grabber):
		
		gtk.DrawingArea.__init__(self)
		self.connect("expose_event",self.expose)
		self.buffers = []
		self.str_buffer=''
		self.buffers_temp=[]
		self.integer_buffer=[]	

		grabber.connect("new-buffer", self._new_buffer)

		self.peaks = []
		self.main_buffers = []		
	
		self.rms=''
		self.avg=''
		self.pp=''	
		self.count=0
	
		self.param1= config.WINDOW_H/65536.0
		self.param2= config.WINDOW_H/2.0	
		
		self.y_mag = 0.7
		self.freq_range=70
		self.draw_interval = 1
		self.num_of_points = 105
		
		#self.overlay_surface = cairo.ImageSurface(cairo.FORMAT_ARGB32,1200,800)
		#self.overlay_context = cairo.Context(self.overlay_surface)
		#self.overlay_surface = cairo.ImageSurface.create_from_png("/home/olpc/Desktop/Screenshot.png")	        
		#self.overlay_context.save() # save as blank!

		self.details_show = False
		self.logging_status=False
		self.f=None

		self.stop=False

		self.fft_show = False
		self.fftx = []

		self.y_mag_bias_multiplier = 1	#constant to multiply with self.param2 while scaling values 
		
		self.scaleX = "10"
		self.scaleY = "10"
		
		self.font_desc = pango.FontDescription('Serif 6')
		self._back_surf = None
		# This might become a list of GCs for each log.
		self._line_gc = None

	def _init_background(self):
 		if self._back_surf:
 			return

		colmap = self.get_colormap()
		clr = colmap.alloc_color(0, 65535, 0, False, False)
		self._line_gc = self.window.new_gc(foreground = clr)
		self._line_gc.set_line_attributes(4, gdk.LINE_SOLID,\
			gdk.CAP_ROUND, gdk.JOIN_BEVEL)	 
		
 		self._back_surf = gdk.Pixmap(self.window, config.WINDOW_W, config.WINDOW_H)
 		cr = self._back_surf.cairo_create()
 		
 		#background
		cr.set_source_rgb(0, 0, 0)
                cr.rectangle(0, 0, config.WINDOW_W, config.WINDOW_H)
                cr.fill()
               
                #grid
                cr.set_line_width(0.4)
                cr.set_source_rgb(0.2, 0.2, 0.2)
 
                x = 0
                y = 0
                for j in range(1, 24):
                	cr.move_to(x, y)
                        cr.rel_line_to(0, config.WINDOW_H)
                        x = x + 50
 		
 	        cr.set_line_width(1.0)
                 
 		x = 0
                y = 0
                for j in range(1, 17):
                	cr.move_to(x, y)
                        cr.rel_line_to(config.WINDOW_W, 0)
	                y = y + 50
 
		cr.stroke()
			
	def _new_buffer(self, obj, buf, status, f):
		self.str_buffer = buf
		self.integer_buffer = list(unpack( str(int(len(buf))/2)+'h' , buf))		
		if(len(self.main_buffers)>6301):
			del self.main_buffers[0:(len(self.main_buffers)-6301)]
		self.main_buffers += self.integer_buffer
		self.logging_status=status
		self.f=f
		return True

			
	#######################################################################
	# This function is the "expose" event handler and does all the drawing
	#######################################################################
	def expose(self, widget, event):
		
		

		###############REAL TIME DRAWING##########################################
		if(self.logging_status==False):
			if(self.stop==False):		
				
				if(self.fft_show==False):				
					
					######################filtering####################
					if(self.logging_status==False):		#we dont want to apply filtering on the values read from a file
						weights = [1,2,3,4,3,2,1] 
						weights_sum = 16.0
						
						for i in range(3,len(self.integer_buffer)-3):
							self.integer_buffer[i] = (self.integer_buffer[(i-3)]+2*self.integer_buffer[(i-2)] + 3*self.integer_buffer[(i-1)] + 4*self.integer_buffer[(i)]+3*self.integer_buffer[(i+1)] + 2*self.integer_buffer[(i+2)]  + self.integer_buffer[(i+3)]) / weights_sum					
					###################################################
				
					self.y_mag_bias_multiplier=1					
					self.draw_interval=10					
					
					#100hz
					if(self.freq_range==30):
						self.spacing = 60
						self.num_of_points=6300
							
					#1khz
					if(self.freq_range==50):
						self.spacing = 6
						self.num_of_points=630
							
					#4khz
					if(self.freq_range==70):
						self.spacing = 1
						self.num_of_points = 105
					
					self.scaleX = str(self.spacing*.104) + " msec"	#.104 = 5/48; 5 points per division and 48 khz sampling				
					
					if(len(self.main_buffers)>=self.num_of_points):
						del self.main_buffers[0:len(self.main_buffers)-(self.num_of_points+1)]
						self.buffers=[]
						i=0
						while i<self.num_of_points:
							self.buffers.append(self.main_buffers[i])						
							i+=self.spacing
				
					self.scaleY=" "
				
				else:
					###############fft################		
					Fs = 48000
					nfft= 65536
					self.integer_buffer=self.integer_buffer[0:256]
					self.fftx = fft(self.integer_buffer, 256,-1)
					
					self.fftx=self.fftx[0:self.freq_range*2]
					self.draw_interval=config.WINDOW_W/(self.freq_range*2)
					
					NumUniquePts = ceil((nfft+1)/2)
					self.buffers=abs(self.fftx)*0.02
					self.y_mag_bias_multiplier=0.1
					self.scaleX = "hz"
					self.scaleY = ""
					##################################
								

				
		###########################drawing from a file#################################		
		else:
			if(self.f.closed==False):			
				self.buffers = []			
				line = self.f.readline()
				if(line=="measure.activity.log.start\n"):	

					line = self.f.readline()
					if(line=="second\n" or line=="minute\n" or line=="hour\n" or line=="snapshot\n"):
						if(line=="second\n"):
							self.scaleX="5 seconds"
						if(line=="minute\n"):
							self.scaleX="5 minutes"
						if(line=="hour\n"):
							self.scaleX="5 hours  "
						if(line=="snapshot\n"):
							self.scaleX="temp     "

						for line in self.f.readlines():
							if(line != "stop"):						
								self.buffers.append(float(line))
								
					self.f.close()
		################################################################################
		
					
		if(len(self.buffers)==0):
			return False
			
		
		###############Scaling the values################		
		val=[]
		for i in self.buffers:
			temp_val_float = float(self.param1*i*self.y_mag) + self.y_mag_bias_multiplier * self.param2
			
			if(temp_val_float>=config.WINDOW_H):
				temp_val_float= config.WINDOW_H-25
			if(temp_val_float<=0):
				temp_val_float= 25
			val.append( temp_val_float  )
		
		self.peaks=val

		#Draw the background
		#We could probably make this faster with another pixmap.
		self._init_background()
 		self.window.draw_drawable(self.get_style().bg_gc[0], self._back_surf, 0, 0,\
			0, 0, config.WINDOW_W, config.WINDOW_H)
		
		#Draw the waveform		
		count = 0
		#There is probably a way to cache these lines between draws. (?)
		lines = []
		for peak in self.peaks:
			lines.append((count, config.WINDOW_H - peak))
			count = count + self.draw_interval
		self.window.draw_lines(self._line_gc, lines)
		
		#BUG - This doesn't seem to work properly yet.
		#Text Display
		if (self.details_show == True):	
			if(self.count%65==0):
				self.rms=str( (audioop.rms( self.str_buffer,2)*.0253)+300 ) + " mV"
				self.avg=str( (audioop.avg( self.str_buffer,2)*.0253)+300 ) + " mV"
				self.pp=str( (audioop.avgpp( self.str_buffer,2)*.0253)+300 ) + " mV"
			self.count+=1
			if(self.count==65536):
				self.count=0
			
			#BUG - create_pango_context() was creating a new one each time.	
			self.pango_context = self.get_pango_context()
			layout = pango.Layout(self.pango_context)
			layout.set_font_description(self.font_desc)

			if(self.scaleY != ""):		
				#106.25 = (1960-300)*50/800	
				self.scaleY = str(self.y_mag*103.75) + " mV"	

			layout.set_text("Real time parameters:" + "\nRMS:" + self.rms +"\nAVG: "+ self.avg + "\nPK-PK: " + self.pp + "\n\nScale:" + "\nX Axis one division: " + self.scaleX + "\nY Axis one division: " + self.scaleY)
				
			white_gc = self.style.white_gc
			self.window.draw_layout(white_gc, int(config.TEXT_X_M * config.WINDOW_W),\
				int(config.TEXT_Y_M * config.WINDOW_H), layout)
	
		############################################		
		
		return True


	#A very approximate smoothing algorithm
	def __smooth(self, l):
		 
		return rl



