import pygst
pygst.require("0.10")
import pygtk
import gtk
import gobject
from time import *

import os

import config  	#This has all the globals
import audioop

from sugar.activity.activity import ActivityToolbox, EditToolbar
from sugar.graphics.toolcombobox import ToolComboBox
from sugar.graphics.toolbutton import ToolButton
from sugar.graphics.toggletoolbutton import ToggleToolButton
from sugar.graphics.combobox import ComboBox
from sugar.graphics.palette import Palette
from sugar.graphics.menuitem import MenuItem


# 'Current' toolbar class
class DisplayToolbar(gtk.Toolbar):

	def __init__(self, wave):
		
		gtk.Toolbar.__init__(self)

		self.wave_copy = wave

		#######################time , frequency#####################
		self._time = ToggleToolButton('icon-test')
		self.insert(self._time, -1)
		self._time.show()
		self._time.set_tooltip('Time')

		self._freq = ToggleToolButton('icon-test')
		self.insert(self._freq, -1)
		self._freq.show()
		self._freq.set_tooltip('Frequency')

		self._time.set_active(True)
		self._freq.set_active(False)

		self.timefreq_status = 'time'
		
		self._time.connect('toggled', self.timefreq_control, 'time_button')
		self._freq.connect('toggled', self.timefreq_control, 'freq_button')
		#########################################################


		separator = gtk.SeparatorToolItem()
		separator.set_draw(True)
		self.insert(separator, -1)
		separator.show()


		#######################low_freq , med_freq , high_freq#####################
		self._flow = ToggleToolButton('icon-test')
		self.insert(self._flow, -1)
		self._flow.show()
		self._flow.set_tooltip('Low Frequency Range')

		self._fmid = ToggleToolButton('icon-test')
		self.insert(self._fmid, -1)
		self._fmid.show()
		self._fmid.set_tooltip('Mid Frequency Range')

		self._fhigh = ToggleToolButton('icon-test')
		self.insert(self._fhigh, -1)
		self._fhigh.show()
		self._fhigh.set_tooltip('High Frequency Range')


		self._flow.set_active(False)
		self._fmid.set_active(False)
		self._fhigh.set_active(True)

		self.freqrange_status = 'fhigh'
		
		self._flow.connect('toggled', self.freqrange_control, 'flow')
		self._fmid.connect('toggled', self.freqrange_control, 'fmid')
		self._fhigh.connect('toggled', self.freqrange_control, 'fhigh')		
		#######################################################################

		separator = gtk.SeparatorToolItem()
		separator.set_draw(True)
		self.insert(separator, -1)
		separator.show()

		#######################details_show , details_hide#####################
		self._details = ToolButton('icon-test')
		self.insert(self._details, -1)
		self._details.show()
		self._details.set_tooltip('Show details')
		self._details_status=False  #True means details being shown, False means details hidden
		self._details.connect('clicked', self.details_control)
		#####################################################################

		separator = gtk.SeparatorToolItem()
		separator.set_draw(True)
		self.insert(separator, -1)
		separator.show()

		
		#######################play , pause#####################
		self._play = ToolButton('icon-test')
		self.insert(self._play, -1)
		self._play.show()
		self._play.set_tooltip('Pause')
		self._play_status=True	    #True means play mode, False means in pause mode
		self._play.connect('clicked', self.play_control)
		######################################################

	
	def details_control(self, data=None):
		if(self._details_status==False):
			self.wave_copy.details_show=True
			self._details.set_icon('icon-test2')
			self._details.show()
			self._details.set_tooltip('Hide details')
			self._details_status=True
			
		else:
			self.wave_copy.details_show=False
			self._details.set_icon('icon-test')
			self._details.show()
			self._details.set_tooltip('Show details')
			self._details_status=False
		return


	def play_control(self,data=None):
		if(self._play_status==True):
			self.wave_copy.stop=True			
			self._play.set_icon('icon-test2')
			self._play.show()
			self._play.set_tooltip('Resume')
			self._play_status=False

		else:
			self.wave_copy.stop=False			
			self._play.set_icon('icon-test')
			self._play.show()
			self._play.set_tooltip('Pause')
			self._play_status=True
		return True

	
	def timefreq_control(self, data, pressed):
		if(pressed=='freq_button' and self.timefreq_status=='time'):
			#Toggle to Frequency mode
			self.wave_copy.fft_show=True
			self._time.set_active(False)
			self._freq.set_active(True)
			self.timefreq_status = 'freq'
			return

		if(pressed=='time_button' and self.timefreq_status=='freq'):
			#Toggle to Time mode
			self.wave_copy.fft_show=False
			self._time.set_active(True)
			self._freq.set_active(False)
			self.timefreq_status = 'time'
			return

		

		
	def freqrange_control(self, data, pressed):
		if(pressed=='flow' and (self.freqrange_status=='fhigh' or self.freqrange_status=='fmid')):
		#Toggle to Low Frequency 
			self.wave_copy.freq_range = 30	#refer drawWaveform.py for details
			self._flow.set_active(True)
			self._fmid.set_active(False)
			self._fhigh.set_active(False)
			self.freqrange_status = 'flow'
			return

		if(pressed=='fmid' and (self.freqrange_status=='fhigh' or self.freqrange_status=='flow' )):
		#Toggle to Mid Frequency 
			self.wave_copy.freq_range = 50	#refer drawWaveform.py for details
			self._flow.set_active(False)
			self._fmid.set_active(True)
			self._fhigh.set_active(False)
			self.freqrange_status = 'fmid'
			return


		if(pressed=='fhigh' and (self.freqrange_status=='flow' or self.freqrange_status=='fmid' )):
		#Toggle to High Frequency 
			self.wave_copy.freq_range = 70	#refer drawWaveform.py for details
			self._flow.set_active(False)
			self._fmid.set_active(False)
			self._fhigh.set_active(True)
			self.freqrange_status = 'fhigh'			
			return

