#!/usr/bin/python
#
#    Project Adviser:
#    Walter Bender - walter@laptop.org
#
#    Core Developer(s):	
#    Arjun Sarwal - arjun@laptop.org
#    
#    Contributor(s):	
#    Cody Lodridge - cody@lodrige.com
#
#    Copyright (C) 2007, OLPC
#    
#    	
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


import pygst
pygst.require("0.10")
import pygtk
import gtk
import cairo
import gobject
import time
import config 		#This has all the globals
import os, sys

from audioGrab import AudioGrab
from drawWaveform import DrawWaveform
from toolbar_top import Toolbar
from toolbar_side import SideToolbar

import logging
from sugar.activity import activity
from sugar.datastore import datastore


class AnalogInput(activity.Activity):
	
	def __init__(self, handle):
		
		logging.debug('Starting Measure Activity')
		##############Alsamixer settings at Activity start################		
		#playback settings		
		#os.system("amixer set 'Master' unmute 50%")
		#os.system("amixer set 'Master Mono' unmute 50%")
		os.system("amixer set 'Mic' mute 0%")
		os.system("amixer set 'Mic Boost (+20dB)' unmute")
		os.system("amixer set 'DC Mode Enable' mute")
		os.system("amixer set 'V_REFOUT Enable' unmute")
		os.system("amixer set 'PCM' unmute 90%")
		#capture settings
		os.system("amixer set 'Mic' 0%, 0% mute captur")
		os.system("amixer set 'Capture' 50%, 70% unmute captur")
		##################################################################	
		
		activity.Activity.__init__(self, handle)
		
		os.system("mkdir /tmp/myLogs/")
		self.active_status = True 

		if self._jobject.file_path:
			print "Launched from journal"
			self.existing=True
		
		else: 
			print "Launched from frame or from Mesh View"
			self._jobject.file_path = os.path.join("/tmp/myLogs/" + str(time.time()))
			self.existing=False	
		
		self.ACTIVE = True
		self.connect( "notify::active", self._activeCb )
		

		self.audiograb=AudioGrab(datastore, self._jobject)
		self.wave=DrawWaveform(self.audiograb)
		self.audiograb.set_wave_copy(self.wave)
		self.side_toolbar = SideToolbar(self.wave)
		
		self.box2=gtk.HBox(False,0)
		self.box2.pack_start(self.wave,True,True,0)
		self.box2.pack_start(self.side_toolbar.box1,False,True,0)	

		self.box1= gtk.VBox(False,0)
		self.box1.pack_start(self.box2, True, True, 0)

		
		##	
		toolbox = Toolbar(self, self.wave, self.audiograb, self._jobject, self.existing)
		self.set_toolbox(toolbox)
		toolbox.show()
		##
		
		self.set_canvas(self.box1)
		
		self.connect("destroy", self.on_quit)	

		gobject.timeout_add(config.REFRESH_TIME, self.waveform_refresh)
			
		self.show_all()
		
		
		
	def waveform_refresh(self):
		self.wave.queue_draw()
		return self.active_status 						


	def on_quit(self,data=None):	
		################Alsamixer settings at Activity close#################
		#This is a well mannered activity. It takes care to set default settings back.
		#Although these are also handled by the Kernel.		
		os.system("amixer set 'Mic Boost (+20dB)' mute")		
		os.system("amixer set 'DC Mode Enable' mute")
		os.system("amixer set 'V_REFOUT Enable' mute")
		os.system("amixer set 'Master' unmute 70%")
		os.system("amixer set 'Master Mono' unmute 70%")
		os.system("amixer set 'Capture' 50%, 100% unmute captur")
		#####################################################################
		self.audiograb.on_quit()	
		os.system("amixer set 'Mic Boost (+20dB)' mute")

	##overriding the write function that writes data onto the journal; since in this activity data is written explicitly during the activity
	#def save(self):
	#	pass

	
	def _activeCb( self, widget, pspec ):
		if (not self.props.active and self.ACTIVE):
			self.audiograb.stop_sound_device()
			self.active_status = False 
		elif (self.props.active and not self.ACTIVE):
			self.audiograb.restart_sound_device()
			self.active_status = True                
                        gobject.timeout_add(config.REFRESH_TIME, self.waveform_refresh)        

		self.ACTIVE = self.props.active
	
		

		
gtk.gdk.threads_init()
	


