#!/usr/bin/python
#
#   Measure Activity for the XO Laptop
#
#    Project Adviser:
#    Walter Bender - walter@laptop.org
#
#    Core Developer(s):	
#    Arjun Sarwal - arjun@laptop.org
#    
#    Contributor(s):
#    Codyl Lodrige - codyl@lodrige.com  (Cairo and drawing code optimizations)			
#    Eben Eliason  - eben@laptop.org    (UI design)
#
#
#    Copyright (C) 2007, OLPC
#    
#    	
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


import pygst
pygst.require("0.10")
import pygtk
import gtk
import cairo
import gobject
import time
import config 		#This has all the globals
import os, sys
import tempfile
from os import environ
from os.path import join

from audiograb import AudioGrab
from drawWaveform import DrawWaveform
from toolbar_top import Toolbar
from toolbar_side import SideToolbar
from graphs import Graphs

import logging
from sugar.activity import activity
from sugar.datastore import datastore

from journal import JournalInteraction

class AnalogInput(activity.Activity):
	
    def __init__(self, handle):
        
        
        activity.Activity.__init__(self, handle)

        os.system("mkdir /home/olpc/myLogs")	#Remove this 	
        tmp_dir = "/home/olpc/myLogs/"		#Remove this 
        #act_root = environ['SUGAR_ACTIVITY_ROOT'] #Add this
        #tmp_dir = join(act_root, 'tmp')	   #Add this 	

            
        self.active_status = True
        self.ACTIVE = True
        self.connect( "notify::active", self._activeCb )
        self.connect("destroy", self.on_quit)	

        if self._jobject.file_path:
            logging.debug('1.0 Launched from journal')
            self.existing = True
        else: 
            logging.debug('1.1 Launched from frame or from Mesh View')
            #self._jobject.file_path = tempfile.TemporaryFile(dir=tmp_dir)#Add this
            self._jobject.file_path = "/home/olpc/Measure.activity/myfile1"##join(tmp_dir + str(time.time()))#Remove this			
            self.existing = False	
        
        self.graphs=Graphs()
        self.journal = JournalInteraction(self._jobject, self.existing)
        self.wave = DrawWaveform()
        self.audiograb = AudioGrab(self.wave.new_buffer)
        self.audiograb.set_wave_copy(self.wave)
        self.side_toolbar = SideToolbar(self.wave)
        self.wave.set_side_toolbar_reference(self.side_toolbar)
        
        self.box2 = gtk.HBox(False,0)
        self.box2.pack_start(self.graphs.vbox1,True,True,0)
        self.box2.pack_start(self.side_toolbar.box1,False,True,0)	

        self.box1 = gtk.VBox(False,0)
        self.box1.pack_start(self.box2, True, True, 0)
        
        self.set_canvas(self.box1)		
        
        toolbox = Toolbar(self, self.wave, self.audiograb, self._jobject, self.existing)
        self.set_toolbox(toolbox)
        toolbox.show()
        
        self.show_all()		
        
        self.first = True

        gobject.timeout_add(config.REFRESH_TIME, self.waveform_refresh)

        
    def waveform_refresh(self):
        self.wave.queue_draw()
        return self.active_status 						


    def on_quit(self,data=None):	
        pass#self.audiograb.on_quit()	
	
	
    def _activeCb( self, widget, pspec):
        if(self.first == True):
            self.audiograb.start_grabbing()
            self.first = False
        if (not self.props.active and self.ACTIVE):
            #self.audiograb.save_state()
            self.audiograb.stop_grabbing()
            self.active_status = False 
        elif (self.props.active and not self.ACTIVE):
            self.audiograb.start_grabbing()
            self.audiograb.resume_state()
            self.active_status = True                
            gobject.timeout_add(config.REFRESH_TIME, self.waveform_refresh)        
        self.ACTIVE = self.props.active

    """
    def read_file(self, file_path):
        pass
        
    def write_file(self, file_path):
        pass
	"""	
gtk.gdk.threads_init()
	


