#! /usr/bin/python
#
#    Author:  Arjun Sarwal   arjun@laptop.org
#    Copyright (C) 2007, OLPC
#    
#    	
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

import csv


class JournalInteraction():
    def __init__(self, _jobject, existing):
        """_jobject is the Journal object
        exiting denotes if a file exists with that journal object (resumed from journal) 
        or not (started afresh)"""
        self.filepath= _jobject
        ##self.filepath = _jobject.file_path
        self.existing = existing    #Denotes if associated journal file exists or not
        self.session_id = -1
        self.writer1 = None
        self.writer2 = None
        self.making_row = False
        self.temp_buffer = []
        self.append_row=False
        
        self.num_rows = 0
        
        self.user=""
        self.Xscale = 0
        self.Yscale = 0
    
    def __del__(self):
        pass
    
    def set_session_params(self, user="", Xscale=0, Yscale=0):
        self.user = user
        self.Xscale = Xscale
        self.Yscale = Yscale
    
    def write_value(self, value=0):
        """Append the value passed to temp_buffer if a logging session is started 
        and continuted If a previous logging session is to be continued upon, read 
        the corresponding row from the file and continue to append it and then 
        rewrite the whole row"""
        if self.append_row==False:
            if self.making_row==False:
                    self.write_session_params()
                    self.temp_buffer.append(value)
                    self.making_row = True
            else:   
                self.temp_buffer.append(value)
        else:
            pass    #append an existing row by reading a row from a file 


    def read_value_set(self, session_id=0):
        """Return the list of values recorded in one logging session specified by session_id"""

    def stop_session(self):
        """Write onto a file, the temp_buffer"""
        if self.existing==True:
            self.writer1 = csv.writer(open(self.filepath, "ab"))
        else:
            self.writer1 = csv.writer(open(self.filepath, "wb"))
            self.existing =  True
        self.writer1.writerow(self.temp_buffer)
        self.temp_buffer = []
        self.making_row = False
    
    
    def write_value_set(self, values=[]):
        """Write a complete row specified by values
        If file doesn't exist, open a new file and write to it"""
        self.write_session_params()
        self.temp_buffer+=values
        self.stop_session()
    
    def delete_value_set(self, session=0):
        """Delete a logging session specified by session"""
    
    def write_session_params(self):
        """Write the session parameters to temp_buffers"""
        self.session_id+=1
        self.num_rows+=1
        self.temp_buffer.append(self.session_id)
        self.temp_buffer.append(self.user)
        self.temp_buffer.append(self.Xscale)
        self.temp_buffer.append(self.Yscale)

    
    def get_session_params(self):
        """ Interval of logging
        AC/DC mode
        Y Scale
        Time"""

    def find_record(self, session_id=-1):
        """Returns the index 0 to N-1 of the record
        session_id may be shifted around due to deletion and editing
        returns -1 i it doesn't find it"""
        reader = csv.reader(open(self.filepath, "rb"))
        found=0
        for i in range(0, self.num_rows):
            temp = reader.next()
            if int(temp[0])==session_id:
                return found
            else:
                found+=1
        return -1
    
    def append_session(self, session_id=-1):
        """Deletes that record from the file and returns the existing
        data in self.temp_buffer so that further recording can be done"""
        reader = csv.reader(open(self.filepath, "rb"))
        data_new = []
        found  = -1
        ##Copy all data except row to be deleted, to a temporary buffer
        for row in reader:
            if int(row[0])!=session_id:
                data_new.append(row)
            else:
                self.temp_buffer = row
        ##Write the temporary buffer to the file again   
        self.num_rows=len(data_new)
        writer = csv.writer(open(self.filepath, "wb"))
        for i in range(0, len(data_new)):
            writer.writerow(data_new[i])
        return 0
        
    
    def delete_record(self, session_id=-1):
        """Delete the record identified by its session_id"""
        reader = csv.reader(open(self.filepath, "rb"))
        data_new = []
        found  = -1
        ##Copy all data except row to be deleted, to a temporary buffer
        for row in reader:
            if int(row[0])!=session_id:
                data_new.append(row)
            else:
                found= 0
        if found==-1:
            return found
        ##Write the temporary buffer to the file again   
        self.num_rows=len(data_new)
        writer = csv.writer(open(self.filepath, "wb"))
        for i in range(0, len(data_new)):
            writer.writerow(data_new[i])
        return 0
            
            
        
    
    """
     import string
    for rec in data:   # for each CVS record
        itmz = rec.items()  # get the items from the dictionary
    print "- = " * 20
    for key,val in itmz:
        print key.upper()+":  \t\t",splitjoin(val)
         """       
    
ji = JournalInteraction("tmp", False)
ji.set_session_params("guitar", 6, 6)
ji.write_value_set([1,1,1])
ji.write_value_set([2,2,2])
ji.write_value_set([3,3,3])
ji.write_value_set([4,4,4])
ji.write_value_set([5,5,5])
ji.write_value_set([6,6,6])
ji.write_value_set([7,7,7])
