import pygst
pygst.require("0.10")
import pygtk
import gtk
import os
import gobject
from time import *
from gettext import gettext as _

import config  	#This has all the globals
import audioop

from sugar.activity.activity import ActivityToolbox, EditToolbar
from sugar.graphics.toolcombobox import ToolComboBox
from sugar.graphics.toolbutton import ToolButton
from sugar.graphics.toggletoolbutton import ToggleToolButton
from sugar.graphics.combobox import ComboBox
from sugar.graphics.palette import Palette
from sugar.graphics.menuitem import MenuItem


# 'Measure' toolbar class
class MeasureToolbar(gtk.Toolbar):

	def __init__(self, wave, audiograb):
		
		gtk.Toolbar.__init__(self)
		
		self.wave_copy = wave
		self.audiograb_copy = audiograb
		
		self._freq_range_ch = 'h'
		
		#######################ac / dc#####################
		self._acdc = ToolButton('current-ac')
		self.insert(self._acdc, -1)
		self._acdc.show()
		self._acdc.set_tooltip(_('Click for DC'))

		self.acdc_status = 'ac'
		
		self._acdc.connect('clicked', self.acdc_control)
		#################################################

		
		#######################bias_on / bias_off#####################
		self._biasonoff = ToolButton('bias-on')
		self.insert(self._biasonoff, -1)
		self._biasonoff.show()
		self._biasonoff.set_tooltip(_('Click for Bias Off'))

		self.bias_status = 'biason'
		
		self._biasonoff.connect('clicked', self.bias_control)
		############################################################

		#######################time / frequency#####################
		self._timefreq = ToolButton('domain-time')
		self.insert(self._timefreq, -1)
		self._timefreq.show()
		self._timefreq.set_tooltip(_('Click for Frequency base'))

		self.timefreq_status = 'time'
		
		self._timefreq.connect('clicked', self.timefreq_control)
		#########################################################

		separator = gtk.SeparatorToolItem()
		separator.set_draw(True)
		self.insert(separator, -1)
		separator.show()	
		
		self.freq_low_img = gtk.Image()
		self.freq_high_img = gtk.Image()

		self.freq_low_img.set_from_file(config.ICONS_DIR + '/freq-high.svg')
		self.freq_high_img.set_from_file(config.ICONS_DIR + '/freq-low.svg')
		
		self.freq_low_img_tool = gtk.ToolItem()
		self.freq_high_img_tool = gtk.ToolItem()
	
		self.freq_low_img_tool.add(self.freq_low_img)
		self.freq_high_img_tool.add(self.freq_high_img)


		#######################frequency control#####################
		self.adjustmentf = gtk.Adjustment(70, 30, 70 ,20, 20, 0.0)
		self.adjustmentf.connect("value_changed", self.cb_page_sizef, self.adjustmentf)
		self._freq_range = gtk.HScale(self.adjustmentf)
		self._freq_range.set_draw_value(False)
		self._freq_range.set_update_policy(gtk.UPDATE_CONTINUOUS)
		self._freq_range.set_size_request(120,15)
		self._freq_range_tool = gtk.ToolItem()
		self._freq_range_tool.add(self._freq_range)
		#########################################################

		self.insert(self.freq_low_img_tool,-1)
		self.insert(self._freq_range_tool, -1)
		self.insert(self.freq_high_img_tool,-1)		
		
		self.freq_low_img.show()
		self.freq_high_img.show()
		
		self.freq_low_img_tool.show()
		self.freq_high_img_tool.show()

		separator = gtk.SeparatorToolItem()
		separator.set_draw(True)
		self.insert(separator, -1)
		separator.show()

		#######################play , pause#####################
		self._play = ToolButton('media-playback-pause')
		self.insert(self._play, -1)
		self._play.show()
		self._play.set_tooltip(_('Pause'))
		self._play_status=True	    #True means play mode, False means in pause mode
		self._play.connect('clicked', self.play_control)
		######################################################

		#######################details show/hide#####################
		self._details = ToggleToolButton('view-details')
		self._details.set_active(False)
		self.insert(self._details, -1)
		self._details.show()
		self._details.set_tooltip(_('Show values'))

		self.details_status = "hide"
		
		self._details.connect("toggled", self.details_control)
		#########################################################

				
	def acdc_control(self, data=None):
		if( self.acdc_status=='ac'):
			#Toggle to DC coupling
			os.system("amixer set 'DC Mode Enable' unmute")
			os.system("amixer set 'Capture' 0%, 0% unmute captur")
			self._acdc.set_icon('current-dc')
			self._acdc.show()			
			self._acdc.set_tooltip(_('Click for AC'))
			self.acdc_status = 'dc'
			return

		if(self.acdc_status=='dc'):
			#Toggle to AC coupling
			os.system("amixer set 'DC Mode Enable' mute")
			os.system("amixer set 'Capture' 50%, 70% unmute captur")
			self._acdc.set_icon('current-ac')
			self._acdc.show()			
			self._acdc.set_tooltip(_('Click for DC'))
			self.acdc_status = 'ac'
			return



	def bias_control(self, data=None):
		if(self.bias_status=='biason'):
			#Toggle to Bias Off
			os.system("amixer set 'V_REFOUT Enable' mute")
			self._biasonoff.set_icon('bias-off')
			self._biasonoff.show()
			self._biasonoff.set_tooltip(_('Click for Bias On'))
			self.bias_status = 'biasoff'
			return

		if(self.bias_status=='biasoff'):
			#Toggle to Bias On
			os.system("amixer set 'V_REFOUT Enable' unmute")
			self._biasonoff.set_icon('bias-on')
			self._biasonoff.show()
			self._biasonoff.set_tooltip(_('Click for Bias Off'))
			self.bias_status = 'biason'
			return


	def timefreq_control(self, data=None):
		if(self.timefreq_status=='time'):
			#Toggle to Frequency mode
			self.wave_copy.fft_show=True
			self._timefreq.set_icon('domain-freq')
			self._timefreq.show()
			self._timefreq.set_tooltip(_('Click for Time base'))
			self.timefreq_status = 'freq'
			return

		if(self.timefreq_status=='freq'):
			#Toggle to Time mode
			self.wave_copy.fft_show=False
			self._timefreq.set_icon('domain-time')
			self._timefreq.show()
			self._timefreq.set_tooltip(_('Click for Frequency base'))
			self.timefreq_status = 'time'
			return


	def details_control(self, data=None):
		if(self.details_status== "show"):
			#Hide the details
			self.wave_copy.details_show = False
			self._details.set_active(False)
			self._details.show()
			self._details.set_tooltip(_('Show values'))
			self.details_status = "hide"
			return

		if(self.details_status=="hide"):
			#Show the details
			self.wave_copy.details_show = True
			self._details.set_active(True)
			self._details.show()
			self._details.set_tooltip(_('Hide values'))
			self.details_status = "show"
			return


	def cb_page_sizef(self, get, data=None):

		if(get.value>=30 and get.value<46):
			self._freq_range.set_value(30)
			self._freq_range_ch = 'l'
			if(self.wave_copy.fft_show == False):
				self.wave_copy.scaleX = str( 12.5/self.wave_copy.draw_interval ) + " ms"
			
		if(get.value>=46 and get.value<62):
			self._freq_range.set_value(50)
			self._freq_range_ch = 'm'
			if(self.wave_copy.fft_show == False):
				self.wave_copy.scaleX = str( 3.125/self.wave_copy.draw_interval ) + " ms"

		if(get.value>=62 and get.value<=70):
			self._freq_range.set_value(70)
			self._freq_range_ch = 'h'
			if(self.wave_copy.fft_show == False):
				self.wave_copy.scaleX = str( 1.04167/self.wave_copy.draw_interval ) + " ms"
			
		self.wave_copy.freq_range = int(get.value)
		self.audiograb_copy.set_sampling_rate(self._freq_range_ch)

		return True	



	def play_control(self,data=None):
		if(self._play_status==True):
			self.wave_copy.stop=True			
			self._play.set_icon('media-playback-start')
			self._play.show()
			self._play.set_tooltip(_('Resume'))
			self._play_status=False

		else:
			self.wave_copy.stop=False			
			self._play.set_icon('media-playback-pause')
			self._play.show()
			self._play.set_tooltip(_('Pause'))
			self._play_status=True
		return True

