#!/usr/bin/python
#
#    Project Adviser:
#    Walter Bender - walter@laptop.org
#
#    Core Developer(s):	
#    Arjun Sarwal - arjun@laptop.org
#    
#    Contributor(s):
#    Codyl Lodrige - codyl@lodrige.com  (Cairo and drawing code optimizations)			
#    Eben Eliason  - eben@laptop.org    (UI design)
#
#
#    Copyright (C) 2007, OLPC
#    
#    	
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


import pygst
pygst.require("0.10")
import pygtk
import gtk
import cairo
import gobject
import time
import config 		#This has all the globals
import os, sys
import tempfile
from os import environ
from os.path import join

from audiograbinterface import AudioGrabInterface
from drawWaveform import DrawWaveform
from toolbar_top import Toolbar
from toolbar_side import SideToolbar

import logging
from sugar.activity import activity
from sugar.datastore import datastore


class AnalogInput(activity.Activity):
	
    def __init__(self, handle):

        activity.Activity.__init__(self, handle)

        self.active_status = True
        self.ACTIVE = True
        self.connect( "notify::active", self._activeCb )
        self.connect("destroy", self.on_quit)	

        self.wave = DrawWaveform()
        self.audiograbinterface = AudioGrabInterface(self.wave.new_buffer)


        self.box2 = gtk.HBox(False,0)
        self.box2.pack_start(self.wave,True,True,0)

        self.box1 = gtk.VBox(False,0)
        self.box1.pack_start(self.box2, True, True, 0)

        self.set_canvas(self.box1)		

        toolbox = Toolbar(self, self.wave, self.audiograbinterface)
        self.set_toolbox(toolbox)
        toolbox.show()

        self.show_all()		

        self.first = True

        gobject.timeout_add(config.REFRESH_TIME, self.waveform_refresh)

		
    def waveform_refresh(self):
        self.wave.queue_draw()
        return self.active_status 						


    def on_quit(self,data=None):	
        self.audiograbinterface.on_quit()	
        
    
    def _activeCb( self, widget, pspec ):
        if(self.first == True):
            self.audiograbinterface.audio_capture_start_stop(True)
            self.first = False
        if (not self.props.active and self.ACTIVE):
            self.audiograbinterface.audio_capture_start_stop(False)
            self.active_status = False 
        elif (self.props.active and not self.ACTIVE):
            self.audiograbinterface.audio_capture_start_stop(True)
            self.active_status = True                
            gobject.timeout_add(config.REFRESH_TIME, self.waveform_refresh)        
        self.ACTIVE = self.props.active
	
		
gtk.gdk.threads_init()
	


