"""
 * ***** BEGIN LICENSE BLOCK *****
 * Portions Copyright (c) 1996-2004 RealNetworks, Inc. All Rights Reserved.
 *
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 *
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 *
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 *
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 *
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 *
 * Contributor(s):
 *
 * ***** END LICENSE BLOCK *****
"""

import os
import sys
import gtk
#import logging
import gobject
import string
import pango

import PlayToolbar
import Play

from gettext import gettext as _

from sugar.graphics.toolbutton import ToolButton
from sugar.graphics.toggletoolbutton import ToggleToolButton
from sugar.graphics.icon import Icon
from sugar.activity import activity

os.environ["HELIX_LIBS"] = activity.get_bundle_path() + '/helix'
helix_libs = os.environ.get("HELIX_LIBS")
sys.path.append(helix_libs)
import hxplay

MAX_WIDTH = 1200
MAX_HEIGHT = 740
#not used yet
PLAYER_ACTIVE = 1
RECORDER_ACTIVE = 2

class MediaPlayerActivity(activity.Activity):
    def idle_function(self):
        return self.player.idle_function()

    def stop(self):
        if self.player.active():
            self.toolbar.stop()
            self.player.stop()

    def destroy(self):
    	self.stop()
        activity.Activity.destroy(self)

    def blank(self):
        #Needs to set to 1,1 before blanking and resetting
        #This is ugly and should be redone when recorder is implemented
        width, height = self.player.player.getSize()
        self.player.player.setSize(1, 1)
        self.subwin.hide()
        self.subwin.show()
        self.player.player.setSize(width, height)
        self.player.player.exitFullScreen()

    def error_dialog(self, msg, userstring = None):
        dialog = gtk.Dialog("Error",
                            None,
                            gtk.DIALOG_MODAL,
                            (gtk.STOCK_OK, gtk.RESPONSE_OK))

        dialog.set_default_response(gtk.RESPONSE_OK)
        hbox = gtk.HBox(False, 12)
        hbox.set_border_width(12)
        dialog.vbox.pack_start(hbox, True, True, 0)
        hbox.show()

        if userstring != None:
            label = gtk.Label(msg + "\n(" + userstring + ")")
        else:
            label = gtk.Label(msg)

        hbox.pack_start(label, False, False, 0)
        label.show()

        response = dialog.run()
        dialog.destroy()


    def read_file(self, file_path):
        self.file = 'file://' + file_path
        self.player.openfile(self.file)

    def open_datastore(self, dsobject):
        self.dsobject = dsobject
        self.player.set_dsobject(self.dsobject)
        self.player.openfile('none')

    def __init__(self, handle):

        # All of our flags. Pretty important stuff as these tell us the
        # state of our player.
        self.stopped = 1
        self.file = None
        self.lastDir = None
        self.site = None
        self.callbacks = None

        activity.Activity.__init__ (self, handle)

        #create a player and a recorder
        self.player = Play.Play(self)

        toolbox = activity.ActivityToolbox(self)
        self.set_toolbox(toolbox)

        self.toolbar = PlayToolbar.PlayToolbar(toolbox, self)
        toolbox.add_toolbar(_('Media Player'), self.toolbar)
        self.toolbar.show()
        toolbox.show()

        #set the mediaplayer toolbar as the default
        toolbox.set_current_toolbar(1)

        self.file_list = gtk.ListStore(gobject.TYPE_STRING)

        self.subwin_vbox = gtk.VBox(homogeneous=False, spacing=0)

        self.subwin = gtk.DrawingArea()
        color = gtk.gdk.color_parse('#000000')
        self.subwin.modify_bg(gtk.STATE_NORMAL, color)
        self.subwin.set_size_request(MAX_WIDTH, MAX_HEIGHT)
        self.subwin.show()

        #I want the label backgrond color to be black, but I can't directly set that
        #because lables aren't drawable. So this just creates a label and adds it to
        #an event box.
        self.label = gtk.Label()
        self.label.set_alignment(.5, 0)
        self.label.show()
        self.event_box = gtk.EventBox()
        self.event_box.show()
        self.event_box.add(self.label)
        self.event_box.modify_bg(gtk.STATE_NORMAL, color)

        self.subwin_vbox.pack_start(self.subwin, expand=False, fill=True, padding=0)
        self.subwin_vbox.pack_start(self.event_box, expand=True, fill=True, padding=0)
        self.subwin_vbox.show()

        self.set_canvas(self.subwin_vbox)

        if handle.uri:
            self.file = handle.uri

        handle_uri_timer = gobject.timeout_add(10, self.player.handle_uri_timer)

hxplay.init()
