import locale
locale.setlocale(locale.LC_NUMERIC, 'C')
import signal , time , sys , os, shutil
import pygtk
pygtk.require( '2.0' )
import gtk

import gobject
import time

import common.Util.Instruments
import common.Config as Config
from   common.Util.CSoundClient import new_csound_client
from   common.Util.Profiler import TP

from   Mini.InstrumentPanel import InstrumentPanel
from   Mini.miniTamTamMain import miniTamTamMain
from   common.Util.Trackpad import Trackpad
from   gettext import gettext as _
import commands
from sugar.activity import activity

class TamTamMini(activity.Activity):
    def __init__(self, handle):
        activity.Activity.__init__(self, handle)

        color = gtk.gdk.color_parse(Config.WS_BCK_COLOR)
        self.modify_bg(gtk.STATE_NORMAL, color)

        self.set_title('TamTam Mini')
        self.set_resizable(False)

        self.trackpad = Trackpad( self )

        self.preloadTimeout = None

        self.connect('notify::active', self.onActive)
        self.connect('destroy', self.onDestroy)

        self.instrumentPanel = InstrumentPanel( force_load = False )
        self.preloadList = [ self.instrumentPanel ]

        #load the sugar toolbar
        self.toolbox = activity.ActivityToolbox(self)
        self.set_toolbox(self.toolbox)

        self.activity_toolbar = self.toolbox.get_activity_toolbar()
        self.activity_toolbar.share.hide()
        self.activity_toolbar.keep.hide()

        self.toolbox.show()

        self.trackpad.setContext('mini')
        self.mini = miniTamTamMain(self)
        self.connect('key-press-event', self.mini.onKeyPress)
        self.connect('key-release-event', self.mini.onKeyRelease)
        #self.modeList[mode].regenerate()
        if self.instrumentPanel in self.preloadList:
            self.instrumentPanel.load() # finish loading
        self.mini.setInstrumentPanel( self.instrumentPanel )

        self.set_canvas( self.mini )

        self.mini.onActivate(arg = None)
        self.show()

    def onPreloadTimeout( self ):
        if Config.DEBUG > 4: print "TamTam::onPreloadTimeout", self.preloadList

        t = time.time()
        if self.preloadList[0].load( t + 0.100 ): # finished preloading this object
            self.preloadList.pop(0)
            if not len(self.preloadList):
                if Config.DEBUG > 1: print "TamTam::finished preloading", time.time() - t
                self.preloadTimeout = False
                return False # finished preloading everything

        if Config.DEBUG > 4: print "TamTam::preload returned after", time.time() - t

        return True

    def onActive(self, widget = None, event = None):
        if widget.props.active == False:
            csnd = new_csound_client()
            csnd.connect(False)
        else:
            csnd = new_csound_client()
            csnd.connect(True)

    def onKeyPress(self, widget, event):
        pass

    def onKeyRelease(self, widget, event):
        pass

    def onDestroy(self, arg2):
        if Config.DEBUG: print 'DEBUG: TamTam::onDestroy()'

        self.mini.onDestroy()

        csnd = new_csound_client()
        csnd.connect(False)
        csnd.destroy()

        gtk.main_quit()

# no more dir created by TamTam
    def ensure_dir(self, dir, perms=0777, rw=os.R_OK|os.W_OK):
        if not os.path.isdir( dir ):
            try:
                os.makedirs(dir, perms)
            except OSError, e:
                print 'ERROR: failed to make dir %s: %i (%s)\n' % (dir, e.errno, e.strerror)
        if not os.access(dir, rw):
            print 'ERROR: directory %s is missing required r/w access\n' % dir

    def read_file(self,file_path):
        self.metadata['tamtam_subactivity'] = 'mini'

    def write_file(self,file_path):
        f = open(file_path,'w')
        f.close()
