"""Story loading dialog using PGU, for StoryBuilder."""

from gettext import gettext as _

from pgu import gui
from pgu.gui import table, area, basic, button, app, Dialog
from pgu.gui.const import *

class LoadDialog(Dialog):
    """A story picker dialog window.

    Similar to the PGU FileDialog, but shows story titles instead of files.
    """
    def __init__(self, game):
        """game -- storybuilder.Game()"""
        self.game = game
        cls = 'dialog'
        cls1 = 'filedialog'
        self.dir_img = basic.Image(app.App.app.theme.get(cls1+'.folder',
                                                             '', 'image'))
        td_style = {'padding_left': 4,
                    'padding_right': 4,
                    'padding_top': 2,
                    'padding_bottom': 2}
        self.title = basic.Label(_('Click on a Story'), cls=cls+".title.label")
        self.body = table.Table()
        self.list = area.List(width=350, height=150)
        self._list_dir_()
        self.button_ok = button.Button(_('LOAD'))
        self.body.tr()
        self.body.td(self.list, colspan=3, style=td_style)
        self.list.connect(CHANGE, self._item_select_changed_, None)
        self.button_ok.connect(CLICK, self._button_okay_clicked_, None)
        self.body.tr()
        self.body.td(self.button_ok, style=td_style)
        self.value = None
        Dialog.__init__(self, self.title, self.body)
        
    def _list_dir_(self):
        index = self.game._stories_index
        titles = index.keys()
        titles.sort()
        
        for i in titles:
            self.list.add(i,value=index[i]['sha'])
        self.list.set_vertical_scroll(0)

    def _item_select_changed_(self, arg):
        self.value = self.list.value
        
    def _button_okay_clicked_(self, arg):
        self.send(CHANGE)
        self.close()

