import os

import kivy
kivy.require('1.8.0')

from kivy.app import App
from kivy.uix.button import Button
from kivy.uix.label import Label
from kivy.uix.widget import Widget
from kivy.uix.carousel import Carousel 
from kivy.factory import Factory
from kivy.uix.boxlayout import BoxLayout
from kivy.uix.dropdown import DropDown
from kivy.uix.popup import Popup
from kivy.uix.image import Image

from kivy.properties import ListProperty

from glob import glob
from ConfigParser import SafeConfigParser

from Globales import get_vocabulario, decir_demorado, decir, guardar

import gtk
gtk.threads_init()

BASE_PATH = os.path.dirname(__file__)

_dict = {
    "Nombre": "Kivy",
    "Apellido": "User",
    "Edad": "",
    "Escuela": "",
     "Grado": ""}

class PleCarouselApp(App):

    screen_names = ListProperty([])

    def build(self):

        vbox = BoxLayout(orientation="vertical")
        hbox = BoxLayout(orientation="horizontal")
        hbox.size_hint_y = 0.14

        self.user = _dict

        dropdown = DropDown()

        topics = os.path.join(BASE_PATH, "Topics")
        for arch in sorted(os.listdir(topics)):

            parser = SafeConfigParser()
            self.topic = os.path.abspath(os.path.join(topics, arch))
            metadata = os.path.join(topics, arch, "topic.ini")
            parser.read(metadata)

            title = parser.get('topic', 'title')

            btn = Button(text=title, size_hint_y=None, height=44)
            btn.data = arch
            btn.bind(on_release=lambda btn: dropdown.select(btn))
            dropdown.add_widget(btn)


        self.mainbutton = Button(text='Topics', size_hint=(None, None))
        self.mainbutton.bind(on_release=dropdown.open)
        self.mainbutton.size_hint_x = 1
        self.mainbutton.size_hint_y = 0.7
        self.mainbutton.font_size = '28sp'

        instructionsbutton = Button(text='Instructions', size_hint=(None, None))
        instructionsbutton.size_hint_x = 1
        instructionsbutton.size_hint_y = 0.7
        instructionsbutton.bind(on_release=self.reset)

        pleimage = Image(source="Imagenes/ple.png")
        pleimage.size_hint_x = 2

        #plebutton = Button(text="Peru Learns English", Image=image, size_hint=(None, None))
        #plebutton.size_hint_x = 2
        #plebutton.size_hint_y = 0.7

        dropdown.bind(on_select=self.select)

        self.carousel = Carousel(direction='right', loop=True)

        hbox.add_widget(pleimage)
        hbox.add_widget(instructionsbutton)
        hbox.add_widget(self.mainbutton)

        vbox.add_widget(hbox)
        vbox.add_widget(self.carousel)

        self.reset(None)
        return vbox

    def reset(self, widget):
        self.carousel.scroll_timeout = 200
        self.remove_all()
        setattr(self.mainbutton, 'text', "Topics")
        src = "Imagenes/welcome_slide.png"
        image = Factory.AsyncImage(source=src, allow_stretch=False)
        self.carousel.add_widget(image)

        img_files = os.path.join(BASE_PATH, "Imagenes", "slides", "*.png")
        for src in sorted(glob(img_files)):
            image = Factory.AsyncImage(source=src, allow_stretch=True)
            self.carousel.add_widget(image)

    def remove_all(self):
        for widget in list(self.carousel.slides):
            self.carousel.remove_widget(widget)

    def select(self, widget, btn):
        setattr(self.mainbutton, 'text', btn.text)
        
        self.remove_all()
        
        self.vocabulario = get_vocabulario(os.path.join(BASE_PATH, "Topics", btn.data), _dict)
        if len(self.vocabulario) > 14:
            self.vocabulario = self.vocabulario[:15]

        self.carousel.scroll_timeout = 0
        if self.vocabulario:
            for item in self.vocabulario:
                vbox = BoxLayout(orientation="vertical")
                img_file = os.path.join(BASE_PATH, "Topics", btn.data, "Imagenes", item[0]+".png")
                image = Factory.AsyncImage(source=img_file, allow_stretch=True)

                utterance = item[2] or "What is this?"
                label = Label(text=utterance, font_size='24sp')
                label.size_hint_y = 0.1

                hbox = BoxLayout(orientation="horizontal")
                hbox.size_hint_y = 0.1
                self.set_show_ans(hbox, label, item)

                vbox.add_widget(label)
                vbox.add_widget(image)
                vbox.add_widget(hbox)

                self.carousel.add_widget(vbox)
        else:
            box = BoxLayout(orientation="vertical")
            box.add_widget(Label(text="Memorization task completed for today."))
            btn = Button(text="OK", size_hint_y=0.2)

            box.add_widget(btn)
            popup = Popup(title='Congratulations!',
                            content=box,
                            size_hint=(None, None), size=(400, 400), auto_dismiss=False)
            btn.bind(on_release=popup.dismiss)
            popup.open()
            self.reset()


    def set_show_ans(self, hbox, label, item):
        onebutton = Button(text="Show me the answer!")
        hbox.add_widget(onebutton)
        onebutton.bind(on_release=self.set_buttons)
        onebutton.data = (hbox, label, item)

    def set_buttons(self, button):
        hbox, label, item = button.data
        hbox.clear_widgets()
        label.text = item[3]
        label.font_size = '32sp'
        decir(170, 50, 0, "en", label.text)
        greenbutton = Button(text="I knew it!")
        greenbutton.background_color = [0.5, 1, 0.5, 1]
        greenbutton.score = 5
        yellowbutton = Button(text="I wasn't sure!")
        yellowbutton.background_color = [1, 1, 0.5, 1]
        yellowbutton.score = 3
        redbutton = Button(text="I had no idea!")
        redbutton.background_color = [1, 0.5, 0.5, 1]
        redbutton.score = 0

        for button in [greenbutton, yellowbutton, redbutton]:
            hbox.add_widget(button)
            button.bind(on_release=self.ahead)
            button.data = item

    def ahead(self, widget):
        #self.carousel.remove_widget(self.carousel.slides[self.carousel.index])

        respuesta = widget.score

        guardar(self.user, self.topic,
            widget.data[0], respuesta)
        if self.carousel.index < len(self.vocabulario) - 1:
            #self.index_select += 1
            #gobject.timeout_add(500, self.__load, self.index_select)
            self.carousel.load_next()
        else:
            box = BoxLayout(orientation="vertical")
            box.add_widget(Label(text="Memorization task completed for today."))
            btn = Button(text="OK", size_hint_y=0.2)

            box.add_widget(btn)
            popup = Popup(title='Congratulations!',
                            content=box,
                            size_hint=(None, None), size=(400, 400), auto_dismiss=False)
            btn.bind(on_release=popup.dismiss)
            popup.open()
            """dialog = Dialog("Congratulations!", self.get_toplevel(),
                ("OK", gtk.RESPONSE_ACCEPT),
                "Memorization task completed for today.")
            dialog.run()
            dialog.destroy()
            self.emit("video", self.topic)
            """

if __name__ == '__main__':
    PleCarouselApp().run()
