shared="/build_shared/sweets"

[ -e /etc/resolv.conf ] || cp $shared/resolv.conf /etc/

olpc_release=$(cat $shared/olpc_release)
fedora_release=$(cat $shared/fedora_release)
deployment_repository=$(cat $shared/deployment_repository)
obs_repos=$(cat $shared/obs_repos)
locales=$(cat $shared/locales)

for repo in $obs_repos; do
    repo_name=`echo $repo | awk -F/ '{print $1}'`
    cat <<EOF >/etc/yum.repos.d/${repo////_}.repo
[$repo_name]
name=$repo_name
failovermethod=priority
baseurl=http://download.sugarlabs.org/packages/${repo//:/:/}/
enabled=1
gpgcheck=1
EOF
done

wget -O /tmp/pubkey http://download.sugarlabs.org/packages/SweetsDistribution/Fedora-$fedora_release/repodata/repomd.xml.key
rpm --import /tmp/pubkey

echo OLPC::$olpc_release $deployment_repository > /etc/PackageKit/presolve-repos

sugar_network() {
    lang=$(awk -F, '{print $1}' $shared/langs)
    sudo -u olpc sugar-network --no-dbus --anonymous --api-url=http://node.sugarlabs.org --accept-language=$lang "$@"
}

for i in `cat $shared/offline_activities`; do
    echo " - Clone $i" >&2
    sugar_network PUT /context/$i cmd=clone nodeps=1 stability=stable requires=sugar-0.88,sugar-0.90,sugar-0.92,sugar-0.94 -jd 1
done

for i in `cat $shared/favorite_activities`; do
    echo " - Favorite $i" >&2
    sugar_network PUT /context/$i cmd=favorite -jd true
done

for i in $locales; do
    echo $i >> /etc/locale.gen
done

cat >/home/olpc/.xsession <<EOF
exec sweets-sugar
EOF
chown olpc:olpc /home/olpc/.xsession

rm -rf /home/olpc/Activities/*_1.activity

fix_permissions="/etc/init.d/fix-permissions"
cat >$fix_permissions <<EOF
#!/bin/sh
# chkconfig: 345 99 99
case \$1 in
    start|restart)
        sudo -u olpc test -O /home/olpc/.gnome2 || chown olpc:olpc -R /home/olpc/.gnome2
        ;;
esac
EOF
chmod a+rx $fix_permissions
/sbin/chkconfig $(basename $fix_permissions) on
