# Copyright (C) 2012 Aleksey Lim
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from sugar_network import optparse, sugar

from jarabe.plugins.sn import sugar_network


ORDER = 90

SN_APP_URL = 'http://127.0.0.1:5000'
SN_BROWSER_NAME = 'sugar-network-browser'


def init():
    global _launcher

    if not sugar_network.value:
        return

    from jarabe.journal import misc
    from jarabe.model.shell import Activity
    from jarabe.view import palettes
    from .launcher import Launcher
    from .browser import Palette

    _launcher = Launcher()
    misc.launch = _launcher.launch
    Activity.get_bundle_path = _get_bundle_path
    palettes.predefined[SN_BROWSER_NAME] = Palette


def enable():
    if not sugar_network.value:
        return

    from jarabe.model.shell import get_model
    shell = get_model()

    def activity_added_cb(model, activity):
        if activity.is_journal():
            shell.disconnect_by_func(activity_added_cb)
            get_browser()

    shell.connect('activity-added', activity_added_cb)


def disable():
    pass


def get_browser():
    global _browser

    if not sugar_network.value:
        return

    if _browser is None:
        from .browser import Browser
        _browser = Browser()

    return _browser


def _get_bundle_path(self):
    if not self._windows:
        return None

    pid = self._windows[0].get_pid()
    with file('/proc/%d/environ' % pid) as f:
        for env in f.read().split('\0'):
            if env.startswith('SUGAR_BUNDLE_PATH='):
                return env.split('=', 1)[-1]


_launcher = None
_browser = None
