# Copyright (C) 2012 Aleksey Lim
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import subprocess
from gettext import gettext as _

import local_document
from sugar_network import optparse, sugar, glib_client


ORDER = 5

sugar_network = optparse.Option(
        _('enable Sugar Network support in Sugar Shell'),
        default=False, type_cast=optparse.Option.bool_cast,
        action='store_true')

client = None

_bundleregistry = None


def init():
    global _bundleregistry, client

    optparse.Option.seek('sweets')
    optparse.Option.seek('local-document', local_document)
    optparse.Option.load([sugar.profile_path('sweets.conf')])

    if not sugar_network.value:
        return

    subprocess.check_call(['sugar-network-service', 'start'])
    subprocess.check_call(['mejorar-sistema', 'start'])

    client = glib_client.Client()

    import jarabe.model.bundleregistry
    from .bundleregistry import BundleRegistry

    _bundleregistry = BundleRegistry()
    jarabe.model.bundleregistry.get_registry = lambda: _bundleregistry


def enable():
    pass


def disable():
    pass
