#!/usr/bin/env python

# Copyright (C) 2007  Phyrum Tea <phyrum.tea@sign.ch>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import logging
from sugar.activity import activity
from wordsearchapp import WordsearchApp
from wordsearch import Wordsearch

class WordsearchActivity(activity.Activity):

  def __init__(self, handle):
    activity.Activity.__init__(self, handle)
    self.set_title("Wordsearch")
    # TODO Change to current directory?
    # os.chdir(os.path.expanduser('~'))
    toolbox = activity.ActivityToolbox(self)
    self.set_toolbox(toolbox)
    self.connect('destroy', self._on_destroy)
    toolbox.show()
    bundle_dir = activity.get_bundle_path()
    app = WordsearchApp(self, bundle_dir)
    app.compile(10, 15, bundle_dir+"/wordlist/sample.txt")

  def _on_destroy(self, data = None):
    logging.info('WordsearchActivity._on_destroy')
    return True