#!/usr/bin/env python
#EduKT - Lincensed under the GPL license

import sys
try:
	import pygtk
	pygtk.require('2.0')
except Error, e:
	print "Error Found:",e

try:
	import gtk
	import gtk.glade
except:
	sys.exit(1)

try:
	from pysqlite2 import dbapi2 as sqlite
except:
	pass
import time
import gobject
import os
import os.path
import pickle
import shutil
import string
from gettext import gettext as _
#import codecs


try:
	import sugar.env
	from sugar.activity import activity
	import logging
	SUGAR=True
except:
	SUGAR=False


#if not SUGAR:
try:
	import pygst
	import gst
except:
	pass
#	import gobject


TARGET_TYPE_TEXT = 80
TARGET_TYPE_PIXMAP = 81

target = [
	('text/plain', 0, TARGET_TYPE_TEXT),
	('image/x-xpixmap', 0, TARGET_TYPE_PIXMAP), 
]

(
	COLUMN_FIXED,
	COLUMN_PAGE,
	COLUMN_ID,
	COLUMN_DESCRIPTION
) = range(4)






class eduKT:
	
	PTool=0
	PagesData={}
	PrjPath=''
	CurrentPage=1
	IDx=''
	ProjectPlace='None'
	ProjectName='None'
	
	def __init__(self):
		self.gladefile="EduKT.glade"
		if not SUGAR:
			appdir = os.getcwd()
			self.PrjPath = appdir
		else:
			appdir = os.path.join(activity.get_bundle_path(),'edukt')
			self.PrjPath = activity.get_bundle_path()
		if not SUGAR:
			self.wTree = gtk.glade.XML(os.path.join(os.path.join(appdir,'edukt/glade'),self.gladefile),"MainWindow")
			self.MainWdw=self.wTree.get_widget("MainWindow")
		else:
			self.wTree = gtk.glade.XML(os.path.join(os.path.join(appdir,'glade'),self.gladefile), "Container")
			self.MainWdw=self.wTree.get_widget("Container")
		self.PrjtToolBar=self.wTree.get_widget("PrjtToolBar")
		self.PageData=self.wTree.get_widget("PageContents")
		self.AddGrphx=self.wTree.get_widget("AddGrphx")
		self.OpenPrjt=self.wTree.get_widget("OpenPrjt")
		self.FileChoose=self.wTree.get_widget("FileChoose")
		self.StatusBar=self.wTree.get_widget("StatusBar")
		self.pangolayout = self.PageData.create_pango_layout("")
		dic = { "on_PrjtBld_clicked" : self.on_PrjtBld_clicked,
				"on_PageContents_drag_data_received":self.on_PageContents_drag_data_received,
				"on_PageContents_button_press_event":self.on_PageContents_button_press_event,
				"on_PageContents_expose_event":self.on_PageContents_expose_event,
				"on_OpenCont_clicked":self.on_OpenPrjt_clicked,
				"on_PlayCont_clicked":self.on_PlayCont_clicked,
				"on_StopCont_clicked":self.on_StopCont_clicked,
				"on_PrevPage_clicked":self.on_PPrevPage_clicked,
				"on_NextPage_clicked":self.on_PNextPage_clicked,
				"on_NewPrjt_clicked":self.on_NewPrjt_clicked,
				"on_OpenPrjt_clicked":self.on_OpenPrjt_clicked,
				"on_SavePrjt_clicked":self.on_SavePrjt_clicked,
				"on_MakePage_clicked":self.on_MakePage_clicked,
				"on_RemvPage_clicked":self.on_RemvPage_clicked,
				"on_AddGrphx_clicked":self.on_AddGrphx_clicked,
				"on_AddText_clicked":self.on_AddText_clicked,
				"on_AddSound_clicked":self.on_AddSound_clicked,
				"on_EdtObject_clicked":self.on_EdtObject_clicked,
				"on_DelObject_clicked":self.on_DelObject_clicked,
				"on_PPrevPage_clicked":self.on_PPrevPage_clicked,
				"on_PNextPage_clicked":self.on_PNextPage_clicked,
				"on_MainWindow_destroy": gtk.main_quit
			}
		self.wTree.signal_autoconnect(dic)
		self.context_id = self.StatusBar.get_context_id("Info")
		self.StatusBar.push(self.context_id,"EduKT")



	def on_PlayCont_clicked(self, widget):
		self.PTool = 1
		self.IDx = ''
		self.on_PrjtBld_clicked(None)


	def on_StopCont_clicked(self, widget):
		pass


	def on_PrjtBld_clicked(self, widget):
		if self.PTool==0:
			self.PTool=1
			self.PrjtToolBar.show()
		else:
			self.PTool=0
			self.PrjtToolBar.hide()
		if len(self.PagesData)>0:
			self.refresh_Prjt_Wdw()


	def on_NewPrjt_clicked(self,widget):
		if len(self.PagesData)>0:
			Question=QuestionDialog("Esta Seguro?")
			resp=Question.run()
		else:
			resp='OK'
		if resp=='OK':
			self.IDx=''
			self.PagesData={}
			FileChoose=FileDialog(self.PrjPath,"New Project","Project",["*.epj"])
			Result,self.ProjectPlace=FileChoose.run()
			if Result==1:
				if not self.ProjectPlace is None:
					self.ProjectName=str(os.path.basename(self.ProjectPlace))+'.epj'
					self.ProjectFLoc=self.PrjPath+'/'+self.ProjectPlace+'/'+self.ProjectName
					Location=self.PrjPath+'/'+self.ProjectPlace
					os.mkdir(Location)
					dirs=['grx','snd','btn','txt']
					for dir in dirs:
						loc=Location+'/'+dir
						os.mkdir(loc)
					self.PagesData={}
					self.CurrentPage=1
					file=open(self.ProjectFLoc,'w')
					pickle.dump(self.PagesData, file)
					file.close()
#					print self.ProjectFLoc, self.ProjectPlace
		self.refresh_Prjt_Wdw()


	def on_OpenPrjt_clicked(self,widget):
		FileChoose=FileDialog(self.PrjPath,"Open Project","Project",["*.epj"])
		Result,self.ProjectFLoc=FileChoose.run()
		if Result==1:
			self.IDx=''
			self.ProjectPlace=os.path.dirname(self.ProjectFLoc)
			self.ProjectName=str(os.path.basename(self.ProjectFLoc))
			file=open(self.ProjectFLoc,'r')
			self.PagesData=pickle.load(file)
			file.close()
		self.refresh_Prjt_Wdw()


	def on_SavePrjt_clicked(self,widget):
		self.IDx=''
		self.ProjectPlace=os.path.dirname(self.ProjectFLoc)
		self.ProjectName=str(os.path.basename(self.ProjectFLoc))
		file=open(self.ProjectFLoc,'w')
		pickle.dump(self.PagesData, file)
		file.close()
		self.refresh_Prjt_Wdw()


	def on_PageContents_expose_event(self,widget,event):
		self.refresh_Prjt_Wdw()


	def on_PageContents_button_press_event(self,widget,event):
		x_value=int(event.x)
		y_value=int(event.y)
		if len(self.PagesData)>0:
			PageData=self.PagesData[self.CurrentPage]
		else:
			PageData={}
#		print self.PagesData
#		ChngPage=self.CurrentPage
		for Objt in PageData:
			DataName=PageData[Objt][0]
			StartXArea=PageData[Objt][1]
			StartYArea=PageData[Objt][2]
			SizeX=PageData[Objt][3]
			SizeY=PageData[Objt][4]
			Format=PageData[Objt][5]
			Type=PageData[Objt][6]
			DataAux=PageData[Objt][7]
			Action=PageData[Objt][8]
			Color=PageData[Objt][9]
			Title=PageData[Objt][10]
			EndXArea=StartXArea+SizeX
			EndYArea=StartYArea+SizeY
			if (x_value>=StartXArea and x_value<=EndXArea) and (y_value>=StartYArea and y_value<=EndYArea) and self.IDx=='':
				if self.PTool == 0:
					elem=string.split(DataAux,'-')
					if Action == 1:
						File=self.PrjPath+'/'+self.PagesData[int(elem[0])][elem[1]][0]
						self.play_Audio(File)
					elif Action == 2:
						self.CurrentPage=int(elem[0])
						self.refresh_Prjt_Wdw()
						return
				else:
					self.IDx=str(Objt)
			else:
				if Objt==self.IDx:
					StartXArea=x_value
					StartYArea=y_value
					self.IDx=''
			self.PagesData[self.CurrentPage][Objt]=[DataName,StartXArea,StartYArea,SizeX,SizeY,Format,Type,DataAux,Action,Color,Title]
		self.refresh_Prjt_Wdw()


	def refresh_Prjt_Wdw(self,PageData=[]):
		if len(PageData)==0:
			if self.PagesData.has_key(self.CurrentPage):
				PageData=self.PagesData[self.CurrentPage]
		self.PageData.window.clear()
#		print PageData
		for Objt in PageData:
			DataName=PageData[Objt][0]
			StartXArea=PageData[Objt][1]
			StartYArea=PageData[Objt][2]
			SizeX=PageData[Objt][3]
			SizeY=PageData[Objt][4]
			Format=PageData[Objt][5]
			Type=PageData[Objt][6]
			DataAux=PageData[Objt][7]
			Color=PageData[Objt][9]
			Title=PageData[Objt][10]
			File=self.PrjPath+'/'+DataName
			if Type=='Grx':
				grafx= gtk.gdk.pixbuf_new_from_file(File)
				self.PageData.window.draw_pixbuf(self.PageData.style.black_gc,grafx,0,0,StartXArea,StartYArea,-1,-1)
			elif Type=='Txt':
				arch=open(File,'r')
				texto=arch.read()
				arch.close()
				texto=unicode(texto, 'iso-8859-1')
				texto.encode('utf-8')
				self.pangolayout.set_text(texto)
				self.PageData.window.draw_layout(self.PageData.style.black_gc, StartXArea, StartYArea, self.pangolayout)
			elif Type=='Snd':
				pass
#				self.play_Audio('file://'+DataName)
			else:
				pass
			if self.IDx==Objt:
				self.PageData.window.draw_rectangle(self.PageData.style.black_gc,False,StartXArea,StartYArea,SizeX,SizeY)
		DataStatus="EduKT - Project: %s - Page: %s - Element: %s" % (self.ProjectName, self.CurrentPage,self.IDx)
		self.StatusBar.push(self.context_id,DataStatus)


	def play_Audio(self,file):
#		print file
		gobject.threads_init()
		pipestr = 'filesrc location=' + file + ' ! \n  oggdemux ! vorbisdec ! audioconvert ! alsasink \n'
		try:
			pipeline = gst.parse_launch(pipestr)
		except gobject.GError, e:
			print "Error Playing" +str(e)
			return -1
		pipeline.get_bus().add_watch(self.Audio_events)
		pipeline.set_state(gst.STATE_PLAYING)
		self.loopAudio = gobject.MainLoop()
		self.loopAudio.run()
		pipeline.set_state(gst.STATE_NULL)


	def Audio_events(self,bus, msg):
		t = msg.type
		if t == gst.MESSAGE_EOS: 
			self.loopAudio.quit()
			
		elif t == gst.MESSAGE_ERROR:
			e, d = msg.parse_error()
			print "ERROR:", e
			self.loopAudio.quit()
		return True


	def on_PageContents_drag_data_received(self, img, context, x, y, data, info, timeX):
		idx=str(int(timeX))
		pos_x=x
		pos_y=y
		file=data.data[7:]
		self.add_PageContents(idx,pos_x,pos_y,file)
		self.refresh_Prjt_Wdw()


	def add_PageContents(self,idx,pos_x,pos_y,file,type='Text'):
		format='file'
		data_aux=''
		action=0
		color=''
		title=os.path.basename(file)
		File=self.PrjPath+'/'+file
		if type=='Grx':
			grafx= gtk.gdk.pixbuf_new_from_file(File)
			width=grafx.get_width()
			height=grafx.get_height()
		elif type=='Txt':
			try:
				arch=open(File,'r')
				texto=arch.read()
			except:
				arch=open(File,'w')
				texto='demo'
				arch.write(texto)
			arch.close()
			texto=unicode(texto, 'iso-8859-1')
			texto.encode('utf-8')
			self.pangolayout.set_text(texto)
			SizeData=self.pangolayout.get_pixel_size()
			width=SizeData[0]
			height=SizeData[1]
		elif type=='Snd':
			width=0
			height=0
		elif type=='Btn':
			grafx= gtk.gdk.pixbuf_new_from_file(File)
			width=grafx.get_width()
			height=grafx.get_height()
			data_aux='1'
		else:
			pass
		Objt=[file,pos_x,pos_y,width,height,format,type,data_aux,action,color,title]
		if len(self.PagesData)==0:
			self.PagesData[self.CurrentPage]={}
		if not self.PagesData.has_key(self.CurrentPage):
			self.PagesData[self.CurrentPage]={}
		self.PagesData[self.CurrentPage][idx]=Objt
#		self.IDx=idx
		self.refresh_Prjt_Wdw()


	def on_MakePage_clicked(self,widget):
		if self.ProjectName == 'None':
			return
		self.IDx=''
		PageT=len(self.PagesData)+1
		if self.PagesData.has_key(self.CurrentPage):
			self.PagesData[PageT]={}
			self.CurrentPage=PageT
		else:
			self.PagesData[self.CurrentPage]={}
		self.refresh_Prjt_Wdw()


	def on_RemvPage_clicked(self,widget):
		if len(self.PagesData[self.CurrentPage])>0:
			Question=QuestionDialog("Are You Sure?")
			resp=Question.run()
		else:
			resp=''
		if resp=='OK':
			self.IDx=''
			del self.PagesData[self.CurrentPage]
			PageN=self.CurrentPage-1
			self.CurrentPage=PageN
		self.refresh_Prjt_Wdw()


	def on_PPrevPage_clicked(self,widget):
		self.IDx=''
		PageN=self.CurrentPage-1
		if PageN<=1:
			PageN=1
		self.CurrentPage=PageN
		self.refresh_Prjt_Wdw()


	def on_PNextPage_clicked(self,widget):
		self.IDx=''
		PageT=len(self.PagesData)
		PageN=self.CurrentPage+1
		if PageN>=PageT:
			PageN=PageT
		self.CurrentPage=PageN
		self.refresh_Prjt_Wdw()


	def on_AddGrphx_clicked(self,widget):
		if self.ProjectName == 'None':
			return
		FileChoose=FileDialog(self.PrjPath,"Add Graphics","Images",["*.png","*.gif" "*.jpg","*.svg"])
		Result,FileName=FileChoose.run()
		if Result==1:
			if FileName is not None:
				NewFileName=os.path.basename(self.ProjectPlace)+'/grx/'+os.path.basename(FileName)
				FileNew=self.PrjPath+'/'+NewFileName
				try:
					shutil.copy (FileName, FileNew)
					idx=str(int(time.time()))
					pos_x=1
					pos_y=1
					self.add_PageContents(idx,pos_x,pos_y,NewFileName,'Grx')
				except:
					pass
		self.refresh_Prjt_Wdw()


	def on_AddText_clicked(self,widget):
		if self.ProjectName == 'None':
			return
		FileChoose=FileDialog(self.PrjPath,"Add Text","Text",["*.*"])
		Result,FileName=FileChoose.run()
		if Result==1:
			if FileName is not None:
				NewFileName=os.path.basename(self.ProjectPlace)+'/txt/'+os.path.basename(FileName)
				FileNew=self.PrjPath+'/'+NewFileName
				try:
					shutil.copy (FileName, FileNew)
				except:
					pass
				idx=str(int(time.time()))
				pos_x=1
				pos_y=1
				self.add_PageContents(idx,pos_x,pos_y,NewFileName,'Txt')
		self.refresh_Prjt_Wdw()


	def on_AddSound_clicked(self,widget):
		if self.ProjectName == 'None':
			return
		FileChoose=FileDialog(self.PrjPath,"Add Sound","Audio",["*.mp3","*.ogg","*.wav"])
		Result,FileName=FileChoose.run()
		if Result==1:
			if FileName is not None:
				NewFileName=os.path.basename(self.ProjectPlace)+'/snd/'+os.path.basename(FileName)
				FileNew=self.PrjPath+'/'+NewFileName
				try:
					shutil.copy (FileName, FileNew)
					idx=str(int(time.time()))
					pos_x=1
					pos_y=1
					self.add_PageContents(idx,pos_x,pos_y,NewFileName,'Snd')
				except:
					pass
		self.refresh_Prjt_Wdw()


	def on_DelObject_clicked(self,widget):
		del self.PagesData[self.CurrentPage][self.IDx]
		self.IDx=''
		self.refresh_Prjt_Wdw()


	def on_EdtObject_clicked(self,widget):
		if self.IDx!='':
			data=self.PagesData[self.CurrentPage][self.IDx]
		else:
			data=[]
		OptionChoose=PropertiesDialog(self.IDx,data,self.PagesData,self.PrjPath)
		Result,Values=OptionChoose.run()
		if Result==1: 
			if self.IDx=='':
				try:
					color=gtk.color_selection_palette_from_string(Values['color'])
					self.PageData.modify_bg(gtk.STATE_NORMAL,color[0])
				except:
					pass
			else:
				self.PagesData[self.CurrentPage][self.IDx]=[Values['file'],Values['pos_x'],Values['pos_y'],Values['width'],Values['height'],Values['format'],Values['type'],Values['aux_data'],Values['action'],Values['color'],Values['title']]
		self.refresh_Prjt_Wdw()



class FileDialog:

	def __init__(self, currentpath='.',title='FileManager',name="All files",pattern=["*.*"]):
		self.gladefile = "EduKT.glade"
		self.CurPath=currentpath
		self.title = title
		self.filter = gtk.FileFilter()
		self.filter.set_name(name)
		for elem in pattern:
			self.filter.add_pattern(elem)


	def run(self):
		"""This function will show the FileDialog"""	
		#load the dialog from the glade file	  
		if not SUGAR:
			appdir = os.getcwd()
		else:
			appdir = os.path.join(activity.get_bundle_path(),'edukt')
		if not SUGAR:
			self.wTree = gtk.glade.XML(os.path.join(os.path.join(appdir,'edukt/glade'),self.gladefile), "FileChoose")
		else:
			self.wTree = gtk.glade.XML(os.path.join(os.path.join(appdir,'glade'),self.gladefile), "FileChoose")
		#Get the actual dialog widget
		self.dlg = self.wTree.get_widget("FileChoose")
		self.pnam = self.wTree.get_widget("NewPrjtName")
		self.dlg.set_default_response(gtk.RESPONSE_OK)
		self.dlg.add_filter(self.filter)
		self.dlg.set_current_folder(self.CurPath)
		self.Result = self.dlg.run()
		filename_sel = self.dlg.get_filename()
		filename_inp = self.pnam.get_text()
		if len(filename_inp)>0:
			self.Filename=filename_inp
		else:
			self.Filename=filename_sel
		self.dlg.destroy()
		return self.Result,self.Filename


class QuestionDialog:

	def __init__(self, Message="Esta Seguro?"):
		self.gladefile = "EduKT.glade"
		self.Message=Message


	def run(self):
		"""This function will show the FileDialog"""	
		#load the dialog from the glade file	  
		if not SUGAR:
			appdir = os.getcwd()
		else:
#			print activity.get_bundle_path()
			appdir = os.path.join(activity.get_bundle_path(),'edukt')
		if not SUGAR:
			self.wTree = gtk.glade.XML(os.path.join(os.path.join(appdir,'edukt/glade'),self.gladefile), "ConfirmMessage")
		else:
			self.wTree = gtk.glade.XML(os.path.join(os.path.join(appdir,'glade'),self.gladefile), "ConfirmMessage") 
		#Get the actual dialog widget
		self.dlg = self.wTree.get_widget("ConfirmMessage")
		self.dlg.set_markup(self.Message)
		self.Result = self.dlg.run()
		self.dlg.destroy()
		if self.Result==-5:
			result='OK'
		else:
			result='CANCEL'
		return result



class PropertiesDialog:
	"""This class is used to show wineDlg"""
	
	def __init__(self,ID,data=[],pages={},prjpath=''):
		self.gladefile = "EduKT.glade"
		self.pages = pages
		self.Values={}
		self.Start=0
		self.Path=prjpath
		if ID!='':
			self.Values['id']=str(ID)
		if len(data)>0:
			self.Values['file']=data[0]
			self.Values['pos_x']=str(data[1])
			self.Values['pos_y']=str(data[2])
			self.Values['width']=str(data[3])
			self.Values['height']=str(data[4])
			self.Values['format']=data[5]
			self.Values['type']=data[6]
			self.Values['aux_data']=data[7]
			self.Values['action']=data[8]
			self.Values['color']=data[9]
			self.Values['title']=data[10]


	def run(self):
		"""This function will show the wineDlg"""	
		
		#load the dialog from the glade file	  
		if not SUGAR:
			appdir = os.getcwd()
		else:
#			print activity.get_bundle_path()
			appdir = os.path.join(activity.get_bundle_path(),'edukt')
		if not SUGAR:
			self.wTree = gtk.glade.XML(os.path.join(os.path.join(appdir,'edukt/glade'),self.gladefile), "Properties")
		else:
			self.wTree = gtk.glade.XML(os.path.join(os.path.join(appdir,'glade'),self.gladefile), "Properties")
		#Get the actual dialog widget
		self.dlg = self.wTree.get_widget("Properties")
		self.ColorChoose=self.wTree.get_widget("ColorChoose")
		self.ColorEntry=self.wTree.get_widget("ColorEntry")
		self.TitleEntry=self.wTree.get_widget("TitleEntry")
		self.TypeEntry=self.wTree.get_widget("TypeEntry")
		self.Aux_DataEntry=self.wTree.get_widget("Aux_DataEntry")
		self.Pos_XEntry=self.wTree.get_widget("Pos_XEntry")
		self.Pos_YEntry=self.wTree.get_widget("Pos_YEntry")
		self.WidthEntry=self.wTree.get_widget("WidthEntry")
		self.HeightEntry=self.wTree.get_widget("HeightEntry")
		self.FileEntry=self.wTree.get_widget("FileEntry")
		self.UIdEntry=self.wTree.get_widget("UIdEntry")
		self.ActionCombo=self.wTree.get_widget("ActionCombo")
		self.PropCancel=self.wTree.get_widget("PropCancel")
		self.PropOk=self.wTree.get_widget("PropOK")
		dic = { "on_ColorChoose_color_set" : self.on_ColorChoose_color_set,
					"on_ActionCombo_changed" : self.on_ActionCombo_changed,
					"on_FileEdit_activate" : self.on_FileEdit_activate 
				}
		self.wTree.signal_autoconnect(dic)
		#Get all of the Entry Widgets and set their text
		if len(self.Values)>0:
			self.ColorEntry.set_text(self.Values['color'])
			self.TitleEntry.set_text(self.Values['title'])
			self.TypeEntry.set_text(self.Values['type'])
			self.Aux_DataEntry.set_text(self.Values['aux_data'])
			self.Pos_XEntry.set_text(self.Values['pos_x'])
			self.Pos_YEntry.set_text(self.Values['pos_y'])
			self.WidthEntry.set_text(self.Values['width'])
			self.HeightEntry.set_text(self.Values['height'])
			self.FileEntry.set_text(self.Values['file'])
			self.UIdEntry.set_text(self.Values['id'])
			self.ActionCombo.set_active(self.Values['action'])
		self.Result=self.dlg.run()
		self.Values['color']=self.ColorEntry.get_text()
		self.Values['file']=self.FileEntry.get_text()
		try:
			self.Values['width']=int(self.WidthEntry.get_text())
		except:
			self.Values['width']=0
		try:
			self.Values['height']=int(self.HeightEntry.get_text())
		except:
			self.Values['height']=0
		try:
			self.Values['pos_x']=int(self.Pos_XEntry.get_text())
		except:
			self.Values['pos_x']=0
		try:
			self.Values['pos_y']=int(self.Pos_YEntry.get_text())
		except:
			self.Values['pos_y']=0
		self.Values['type']=self.TypeEntry.get_text()
		self.Values['aux_data']=self.Aux_DataEntry.get_text()
		self.Values['action']=self.ActionCombo.get_active()
		self.Values['title']=self.TitleEntry.get_text()
		self.Values['id']=self.UIdEntry.get_text()
		self.dlg.destroy()
		return self.Result,self.Values


	def on_ActionCombo_changed(self,widget):
		if self.Start == 0:
			self.Start = 1
			return
		Result=0
		resp=self.ActionCombo.get_active()
		if resp==0:
			pass
		elif resp==1:
			ActionData=ActionSelection(1,self.pages)
			Result,Changed=ActionData.run()
		elif resp==2:
			ActionData=ActionSelection(2,self.pages)
			Result,Changed=ActionData.run()
		elif resp==3:
			pass
		if Result==1:
			self.Aux_DataEntry.set_text(Changed)


	def on_ColorChoose_color_set(self,widget):
		color_chain=gtk.color_selection_palette_to_string([self.ColorChoose.get_color()])
		self.ColorEntry.set_text(color_chain)


	def on_FileEdit_activate(self,widget):
		if self.TypeEntry.get_text()=='Txt':
			Edit=TextEditing(self.Path,self.FileEntry.get_text())
			Result=Edit.run()



class TextEditing:

	def __init__(self, Path, File):
		self.gladefile = "EduKT.glade"
		self.File=Path+'/'+File
#		print self.File
		try:
			File=open(self.File,'r')
			Data=File.read()
			File.close()
			Data=unicode(Data, 'iso-8859-1')
			Data.encode('utf-8')
		except Exception,error:
			print 'Error',error
			Data=''
		self.Data=Data


	def run(self):
		"""This function will show the FileDialog"""	
		#load the dialog from the glade file	  
		if not SUGAR:
			appdir = os.getcwd()
		else:
#			print activity.get_bundle_path()
			appdir = os.path.join(activity.get_bundle_path(),'edukt')
		if not SUGAR:
			self.wTree = gtk.glade.XML(os.path.join(os.path.join(appdir,'edukt/glade'),self.gladefile), "TextEditor")
		else:
			self.wTree = gtk.glade.XML(os.path.join(os.path.join(appdir,'glade'),self.gladefile), "TextEditor") 
		#Get the actual dialog widget
		self.dlg = self.wTree.get_widget("TextEditor")
		self.TextChange = self.wTree.get_widget("TextChange")
		self.TextChange.set_justification(gtk.JUSTIFY_LEFT)
		self.TextBuffer = self.TextChange.get_buffer()
		dato=self.TextBuffer.set_text(self.Data)
		Result = self.dlg.run()
		self.dlg.destroy()
		start,end=self.TextBuffer.get_bounds()
		self.NewBuffer=self.TextBuffer.get_text(start,end)
		if not self.Data==self.NewBuffer:
			File=open(self.File,'w')
			File.write(self.NewBuffer)
			File.close()
		return Result



class ActionSelection:


	def __init__(self, Mode, Data):
		self.gladefile = "EduKT.glade"
		self.Mode = Mode
		self.Data = Data
		self.Selex = []


	def run(self):
		"""This function will show the FileDialog"""	
		#load the dialog from the glade file	  
		if not SUGAR:
			appdir = os.getcwd()
		else:
#			print activity.get_bundle_path()
			appdir = os.path.join(activity.get_bundle_path(),'edukt')
		if not SUGAR:
			self.wTree = gtk.glade.XML(os.path.join(os.path.join(appdir,'edukt/glade'),self.gladefile), "ActionSelect")
		else:
			self.wTree = gtk.glade.XML(os.path.join(os.path.join(appdir,'glade'),self.gladefile), "ActionSelect") 
		#Get the actual dialog widget
		self.dlg = self.wTree.get_widget("ActionSelect")
		self.DataTree = self.wTree.get_widget("SelectData")
		Model=self.__create_model()
		self.DataTree.set_model(Model)
		self.__add_columns()
		Result = self.dlg.run()
		self.dlg.destroy()
#		print self.Selex
		return Result,self.Selex


	def __create_model(self):
		if self.Mode == 1:
			lstore = gtk.ListStore(
				gobject.TYPE_BOOLEAN,
				gobject.TYPE_UINT,
				gobject.TYPE_STRING,
				gobject.TYPE_STRING)
			if self.Mode==1:
				for elem in self.Data:
					page=self.Data[elem]
					for part in page:
						item=[False,elem,part,page[part][10]]
						iter = lstore.append()
						lstore.set(iter,
							COLUMN_FIXED, item[COLUMN_FIXED],
							COLUMN_PAGE, item[COLUMN_PAGE],
							COLUMN_ID, item[COLUMN_ID],
							COLUMN_DESCRIPTION, item[COLUMN_DESCRIPTION])
		else:
			lstore = gtk.ListStore(
				gobject.TYPE_BOOLEAN,
				gobject.TYPE_UINT)
			if self.Mode==2:
				for elem in self.Data:
#					page=self.Data[elem]
					item=[False,elem]
					iter = lstore.append()
					lstore.set(iter,
						COLUMN_FIXED, item[COLUMN_FIXED],
						COLUMN_PAGE, item[COLUMN_PAGE])
		return lstore


	def __add_columns(self):
		treeview=self.DataTree
		model = treeview.get_model()
		# column for fixed toggles
		renderer = gtk.CellRendererToggle()
		renderer.connect('toggled', self.fixed_toggled, model)
		column = gtk.TreeViewColumn('Selection', renderer, active=COLUMN_FIXED)
		# set this column to a fixed sizing(of 50 pixels)
		column.set_sizing(gtk.TREE_VIEW_COLUMN_FIXED)
		column.set_fixed_width(50)
		treeview.append_column(column)
		# column for bug numbers
		column = gtk.TreeViewColumn('Page', gtk.CellRendererText(),
									text=COLUMN_PAGE)
		column.set_sort_column_id(COLUMN_PAGE)
		treeview.append_column(column)
		if self.Mode == 1:
			# columns for severities
			column = gtk.TreeViewColumn('ID', gtk.CellRendererText(),
										text=COLUMN_ID)
			column.set_sort_column_id(COLUMN_ID)
			treeview.append_column(column)
			# column for description
			column = gtk.TreeViewColumn('Description', gtk.CellRendererText(),
										text=COLUMN_DESCRIPTION)
			column.set_sort_column_id(COLUMN_DESCRIPTION)
			treeview.append_column(column)


	def fixed_toggled(self, cell, path, model):
		# get toggled iter
		iter = model.get_iter((int(path),))
		fixed = model.get_value(iter, COLUMN_FIXED)
		# do something with the value
		fixed = not fixed
		# set new value
		model.set(iter, COLUMN_FIXED, fixed)
		if self.Mode == 1:
			self.Selex=str(model.get_value(iter, COLUMN_PAGE))+'-'+str(model.get_value(iter, COLUMN_ID))
		else:
			self.Selex=str(model.get_value(iter, COLUMN_PAGE))+'-'+''


if __name__=="__main__":
#	win=gtk.Window(gtk.WINDOW_TOPLEVEL)
	Glob=eduKT()
	gtk.main()
