/*
 *  This file is part of ixemul.library for the Amiga.
 *  Copyright (C) 1991, 1992  Markus M. Wild
 *  Changed to avoid buffer overflows by J. Hoehle and
 *  restricted output length for: str(n)cat, strlen
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <sys/tracecntl.h>

#define LWS  ".35"	/* output Limited argument Width */
					/* Requires compiler string concatenation (ANSI-C) */

#define MAXCALLS	607 	/* total number of ixemul system calls */

struct call {
  int  interesting;	
  char *name;		/* Function Name */

  void (*func)(char *, int, struct call *, struct trace_packet *);

  char *fmt;		/* Input format */
  char *rfmt;		/* Return format */
};

static void vp (char *buf, int len, struct call *c, struct trace_packet *tp);
static void vp_fcntl (char *buf, int len, struct call *c, struct trace_packet *tp);
static void vp_ioctl (char *buf, int len, struct call *c, struct trace_packet *tp);
static void vp_open (char *buf, int len, struct call *c, struct trace_packet *tp);
static void vp_pipe (char *buf, int len, struct call *c, struct trace_packet *tp);

static struct call call_table[] = {
/*syscall #*/
/*   0: */  { 1, "bad call",	vp,	"",		"",		},
/*   1: */  { 1, "abort",		vp,	"()",		"",		},
/*   2: */  { 1, "abs",		vp,	"(%d)",		"%d",		},
/*   3: */  { 1, "access",	vp,	"(\"%s\", %d)",	"%d",		},
/*   4: */  { 1, "alarm",		vp,	"(%d)",		"%d",		},
/*   5: */  { 1, "atexit",	vp,	"($%lx)",	"%d",		},
/*   6: */  { 1, "atof",	vp,	"(\"%s\")",		"%g",		},
/*   7: */  { 1, "atoi",	vp,	"(\"%s\")",		"%d",		},
/*   8: */  { 1, "atol",	vp,	"(\"%s\")",		"%d",		},
/*   9: */  { 1, "bcmp",	vp,	"($%lx, $%lx, %d)",	"%d",		},
/*  10: */  { 1, "bcopy",	vp,	"($%lx, $%lx, %d)",	"",		},
/*  11: */  { 1, "bsearch",	vp,	"($%lx, $%lx, %d, %d, $%lx)", 	"$%lx",		},
/*  12: */  { 1, "bzero",		vp,	"($%lx, %d)",	"",		},
/*  13: */  { 1, "calloc",	vp,	"(%d, %d)",	"$%lx",		},
/*  14: */  { 1, "cfgetispeed",	vp,	"($%lx)",	"%d",		},
/*  15: */  { 1, "cfgetospeed",	vp,	"($%lx)",	"%d",		},
/*  16: */  { 1, "cfmakeraw",	vp,	"($%lx)",	"%d",		},
/*  17: */  { 1, "cfree",		vp,	"($%lx)",	"",		},
/*  18: */  { 1, "cfsetispeed",	vp,	"($%lx)",	"%d",		},
/*  19: */  { 1, "cfsetospeed",	vp,	"($%lx)",	"%d",		},
/*  20: */  { 1, "cfsetspeed",	vp,	"($%lx)",	"%d",		},
/*  21: */  { 1, "chdir",		vp,	"(\"%s\")",	"%d",		},
/*  22: */  { 1, "chmod",		vp,	"(\"%s\", %o)",	"%d",		},
/*  23: */  { 1, "chown",		vp,	"(\"%s\", %d, %d)",	"%d",	},
/*  24: */  { 1, "clock",		vp,	"()",		"%d",		},
/*  25: */  { 1, "close",		vp,	"(%d)",		"%d",		},
/*  26: */  { 1, "creat",		vp,	"(\"%s\", %o)",	"%d",		},
/*  27: */  { 0, "__must_recompile27",	vp,	"()",	"CreateExtIO has been removed, recompile",		},
/*  28: */  { 0, "__must_recompile28",	vp,	"()",	"CreatePort has been removed, recompile",		},
/*  29: */  { 0, "__must_recompile29",	vp,	"()",	"CreateStdIO has been removed, recompile",		},
/*  30: */  { 0, "__must_recompile30",	vp,	"()",	"CreateTask has been removed, recompile",		},
/*  31: */  { 0, "__must_recompile31",	vp,	"()",	"DeleteExtIO has been removed, recompile",		},
/*  32: */  { 0, "__must_recompile32",	vp,	"()",	"DeletePort has been removed, recompile",		},
/*  33: */  { 0, "__must_recompile33",	vp,	"()",	"DeleteStdIO has been removed, recompile",		},
/*  34: */  { 0, "__must_recompile34",	vp,	"()",	"DeleteTask has been removed, recompile",		},
/*  35: */  { 1, "difftime",	vp,	"(%d,%d)",	"%d",		},
/*  36: */  { 0, "__obsolete_div",		vp,	"()","__obsolete_div, recompile",},
/*  37: */  { 1, "dup",		vp,	"(%d)",		"%d",		},
/*  38: */  { 1, "dup2",		vp,	"(%d, %d)",	"%d",		},
/*  39: */  { 1, "exit",		vp,	"(%d)",		"",		},
/*  40: */  { 1, "fchmod",	vp,	"(%d, %o)",	"%d",		},
/*  41: */  { 1, "fcntl",		vp_fcntl,	"(%d, \"%s\", %d)", "%d",		},
/*  42: */  { 1, "ffs",		vp,	"(%d)",		"%d",		},
/*  43: */  { 1, "flock",		vp,	"(%d, %d)",	"%d",		},
/*  44: */  { 1, "free",		vp,	"($%lx)",	"",		},
/*  45: */  { 1, "frexp",		vp,	"(%g, %g)",	"%g",		},
/*  46: */  { 1, "fstat",		vp, 	"(%d, $%lx)",	"%d",		},
/*  47: */  { 1, "fsync",		vp,	"(%d)",		"%d",		},
/*  48: */  { 1, "ftime",		vp,	"(%d)",		"%d",		},
/*  49: */  { 1, "ftruncate",	vp,	"(%d, %d)",	"%d",		},
/*  50: */  { 1, "getcwd",	vp,	"(\"%s\", %d)",	"%d",		},
/*  51: */  { 1, "getdtablesize",	vp,	"()",		"%d",		},
/*  52: */  { 1, "getegid",	vp,	"(%d)",		"%d",		},
/*  53: */  { 1, "getenv",	vp,	"(\"%s\")",		"\"%s\"",		},
/*  54: */  { 1, "geteuid",	vp,	"()",		"%d",		},
/*  55: */  { 1, "getgid",	vp,	"()",		"%d",		},
/*  56: */  { 1, "getgrgid",	vp,	"()",		"%d",		},
/*  57: */  { 1, "getgroups",	vp,	"(%d, $%lx)",	"%d",		},
/*  58: */  { 1, "gethostname",	vp,	"(\"%s\", %d)",	"%d",		},
/*  59: */  { 1, "getitimer",	vp,	"(%d, $%lx)",	"%d",		},
/*  60: */  { 1, "getpagesize",	vp,	"()",		"%d",		},
/*  61: */  { 1, "getpgrp",	vp,	"(%d)",		"%d",		},
/*  62: */  { 1, "getpid",	vp,	"()",		"$%lx",		},
/*  63: */  { 1, "getppid",	vp,	"()",		"$%lx",		},
/*  64: */  { 1, "getpriority",	vp,	"(%d, %d)",	"%d",		},
/*  65: */  { 1, "getpwnam",	vp,	"(\"%s\")",		"$%lx",		},
/*  66: */  { 1, "getpwuid",	vp,	"(%d)",		"$%lx",		},
/*  67: */  { 1, "getrlimit",	vp,	"(%d, $%lx)",	"%d",		},
/*  68: */  { 1, "getrusage",	vp,	"(%d, $%lx)",	"%d",		},
/*  69: */  { 1, "gettimeofday",	vp,	"($%lx, $%lx)",	"%d",		},
/*  70: */  { 1, "getuid",	vp,	"()",		"%d",		},
/*  71: */  { 1, "getwd",		vp,	"(\"%s\")",		"%d",		},
/*  72: */  { 1, "index",		vp,	"(\"%s\", %c)",	"$%lx",		},
/*  73: */  { 1, "initgroups",	vp,	"(\"%s\", %d)",	"%d",		},
/*  74: */  { 1, "insque",	vp,	"($%lx, $%lx)",	"",		},
/*  75: */  { 1, "ioctl",		vp_ioctl,	"(%d, $%lx, $%lx)", "%d",		},
/*  76: */  { 1, "isalnum",	vp,	"(%c)",		"%d",		},
/*  77: */  { 1, "isalpha",	vp,	"(%c)",		"%d",		},
/*  78: */  { 1, "isatty",	vp,	"(%d)",		"%d",		},
/*  79: */  { 1, "iscntrl",	vp,	"(%c)",		"%d",		},
/*  80: */  { 1, "isdigit",	vp,	"(%c)",		"%d",		},
/*  81: */  { 1, "isgraph",	vp,	"(%c)",		"%d",		},
/*  82: */  { 1, "islower",	vp,	"(%c)",		"%d",		},
/*  83: */  { 1, "isprint",	vp,	"(%c)",		"%d",		},
/*  84: */  { 1, "ispunct",	vp,	"(%c)",		"%d",		},
/*  85: */  { 1, "isspace",	vp,	"(%c)",		"%d",		},
/*  86: */  { 1, "isupper",	vp,	"(%c)",		"%d",		},
/*  87: */  { 1, "isxdigit",	vp,	"(%c)",		"%d",		},
/*  88: */  { 1, "ix_startup",	vp,	"(\"%s\", %d, %d, \"%s\", $%lx, $%lx)", "%d",		},
/*  89: */  { 1, "kill",		vp,	"($%lx, %d)",	"%d",		},
/*  90: */  { 1, "killpg",	vp,	"($%lx, %d)",	"%d",		},
/*  91: */  { 1, "labs",		vp,	"(%d)",		"%d",		},
/*  92: */  { 1, "__obsolete_ldiv",		vp,	"()","__obsolete_ldiv, recompile",},
/*  93: */  { 1, "link",		vp,	"(\"%s\", \"%s\")",	"%d",		},
/*  94: */  { 1, "longjmp",	vp,	"($%lx, %d)",	"%d",		},
/*  95: */  { 1, "longjmperror",	vp,	"()",		"",		},
/*  96: */  { 1, "lseek",		vp,	"(%d, %d, %d)",	"%d",		},
/*  97: */  { 1, "lstat",		vp,	"(\"%s\", $%lx)",		"%d",		},
/*  98: */  { 1, "malloc",	vp,	"(%d)",		"$%lx",		},
/*  99: */  { 1, "memalign",	vp,	"(%d, %d)",	"$%lx",		},
/* 100: */  { 1, "memccpy",	vp,	"($%lx, $%lx, %d, %d)", "$%lx",		},
/* 101: */  { 1, "memchr",	vp,	"($%lx, %d, %d)",	"$%lx",		},
/* 102: */  { 1, "memcmp",	vp,	"($%lx, $%lx, %d)",	"%d",		},
/* 103: */  { 1, "memcpy",	vp,	"($%lx, $%lx, %d)",	"$%lx",		},
/* 104: */  { 1, "memmove",	vp,	"($%lx, $%lx, %d)",	"$%lx",		},
/* 105: */  { 1, "memset",	vp,	"($%lx, %d, %d)",	"$%lx",		},
/* 106: */  { 1, "mkdir",		vp,	"(\"%s\", %o)",	"%d",		},
/* 107: */  { 1, "mkstemp",	vp,	"(\"%s\")",		"%d",		},
/* 108: */  { 1, "mktemp",	vp,	"(\"%s\")",		"\"%s\"",		},
/* 109: */  { 1, "open",		vp_open,	"(\"%s\", \"%s\", %o)",	"%d",		},
/* 110: */  { 1, "pause",		vp,	"()",	"%d",		},
/* 111: */  { 1, "perror",	vp,	"(\"%s\")",	"%d",		},
/* 112: */  { 1, "pipe",		vp_pipe,	"([%d, %d])",	"%d",		},
/* 113: */  { 1, "psig",		vp,	"bad call",	"",		},
/* 114: */  { 1, "psignal",	vp,	"(%d, \"%s\")",	"",		},
/* 115: */  { 1, "putenv",	vp,	"(\"%s\")",		"",		},
/* 116: */  { 1, "qsort",		vp,	"($%lx, %d, %d, $%lx)",	"",		},
/* 117: */  { 1, "rand",		vp,	"()",	"%d",		},
/* 118: */  { 1, "random",	vp,	"()",	"%d",		},
/* 119: */  { 1, "read",		vp,	"(%d, $%lx, %d)",	"%d",		},
/* 120: */  { 1, "readlink",	vp,	"(\"%s\", \"%s\", %d)",		"%d",		},
/* 121: */  { 1, "readv",		vp,	"(%d, $%lx, %d)",	"%d",		},
/* 122: */  { 1, "realloc",	vp,	"($%lx, %d)",	"$%lx",		},
/* 123: */  { 1, "remove",	vp,	"(\"%s\")",	"%d",		},
/* 124: */  { 1, "remque",	vp,	"($%lx)",	"",		},
/* 125: */  { 1, "rename",	vp,	"(\"%s\", \"%s\")",	"%d",		},
/* 126: */  { 1, "rindex",	vp,	"(\"%s\", %c)",	"$%lx",		},
/* 127: */  { 1, "rmdir",		vp,	"(\"%s\")",	"%d",		},
/* 128: */  { 1, "select",	vp,	"(%d, $%lx, $%lx, $%lx, $%lx)",	"%d",		},
/* 129: */  { 1, "setenv",	vp,	"(\"%s\", \"%s\", %d)",	"%d",		},
/* 130: */  { 1, "setgroups",	vp,	"(%d, $%lx)",	"%d",		},
/* 131: */  { 1, "sethostname",	vp,	"(\"%s\", %d)",	"%d",		},
/* 132: */  { 1, "setitimer",	vp,	"(%d, $%lx, $%lx)",	"%d",		},
/* 133: */  { 1, "setjmp",	vp,	"($%lx, %d)",	"%d",		},
/* 134: */  { 1, "setpgrp",	vp,	"($%lx, $%lx)",	"%d",		},
/* 135: */  { 1, "setpriority",	vp,	"(%d, %d, %d)",	"%d",		},
/* 136: */  { 1, "setrlimit",	vp,	"(%d, $%lx)",	"%d",		},
/* 137: */  { 1, "settimeofday",	vp,	"($%lx, $%lx)",	"%d",		},
/* 138: */  { 1, "sigaction",	vp,	"(%d, $%lx, $%lx)",	"%d",		},
/* 139: */  { 1, "sigaddset",	vp,	"($%lx, %d)",	"%d",		},
/* 140: */  { 1, "sigblock",	vp,	"($%lx)",	"%d",		},
/* 141: */  { 1, "sigdelset",	vp,	"($%lx, %d)",	"%d",		},
/* 142: */  { 1, "sigemptyset",	vp,	"($%lx)",	"%d",		},
/* 143: */  { 1, "sigfillset",	vp,	"($%lx)",	"%d",		},
/* 144: */  { 1, "siginterrupt",	vp,	"(%d, %d)",	"%d",		},
/* 145: */  { 1, "sigismember",	vp,	"($%lx, %d)",	"%d",		},
/* 146: */  { 1, "siglongjmp",	vp,	"($%lx, %d)",	"%d",		},
/* 147: */  { 1, "signal",	vp,	"(%d, $%lx)",	"$%lx",		},
/* 148: */  { 1, "sigpause",	vp,	"($%lx)",	"%d",		},
/* 149: */  { 1, "sigpending",	vp,	"($%lx)",	"%d",		},
/* 150: */  { 1, "sigprocmask",	vp,	"(%d, $%lx, $%lx)",	 "%d",		},
/* 151: */  { 1, "sigreturn",	vp,	"($%lx)",	"%d",		},
/* 152: */  { 1, "sigsetjmp",	vp,	"($%lx, %d)",	"%d",		},
/* 153: */  { 1, "sigsetmask",	vp,	"($%lx)",	"$%lx",		},
/* 154: */  { 1, "sigstack",	vp,	"($%lx)",	"%d",		},
/* 155: */  { 1, "sigsuspend",	vp,	"($%lx)",	"%d",		},
/* 156: */  { 1, "sigvec",	vp,	"(%d, $%lx, $%lx)",	"%d",		},
/* 157: */  { 1, "sleep",		vp,	"(%d)",	"%d",		},
/* 158: */  { 1, "srand",		vp,	"(%d)",	"",		},
/* 159: */  { 1, "srandom",	vp,	"(%d)",	"",		},
/* 160: */  { 1, "stat",		vp,	"(\"%s\", $%lx)",	"%d",		},
/* 161: */  { 1, "strcasecmp",	vp,	"(\"%s\", \"%s\")",	"%d",		},
/* 162: */  { 1, "strcat",	vp,	"(\"%"LWS"s\", \"%"LWS"s\")",	"$%lx",		},
/* 163: */  { 1, "strchr",	vp,	"(\"%s\", %c)",	"$%lx",		},
/* 164: */  { 1, "strcmp",	vp,	"(\"%"LWS"s\", \"%"LWS"s\")",	"%d",		},
/* 165: */  { 1, "strcoll",	vp,	"(\"%s\", \"%s\")",	"%d",		},
/* 166: */  { 1, "strcpy",	vp,	"($%lx, \"%s\")",	"$%lx",		},
/* 167: */  { 1, "strcspn",	vp,	"(\"%s\", \"%s\")",	"%d",		},
/* 168: */  { 1, "strdup",	vp,	"(\"%s\")",		"$%lx",		},
/* 169: */  { 1, "strerror",	vp,	"(%d)",		"\"%s\"",		},
/* 170: */  { 1, "strftime",	vp,	"(\"%s\", %d, \"%s\", $%lx)", "%d",		},
/* 171: */  { 1, "strlen",	vp,	"(\"%s\")",	"%d",		},
/* 172: */  { 1, "strmode",	vp,	"(\"%s\", %o)",	"",		},
/* 173: */  { 1, "strncasecmp",	vp,	"(\"%s\", \"%s\", %d)",	"%d",		},
/* 174: */  { 1, "strncat",	vp,	"(\"%s\", \"%s\", %d)",	"$%lx",		},
/* 175: */  { 1, "strncmp",	vp,	"(\"%"LWS"s\", \"%"LWS"s\", %d)",	"%d",		},
/* 176: */  { 1, "strncpy",	vp,	"($%lx, \"%s\", %d)", "$%lx",		},
/* 177: */  { 1, "strpbrk",	vp,	"(\"%s\", \"%s\")",	"$%lx",		},
/* 178: */  { 1, "strrchr",	vp,	"(\"%s\", %c)",	"$%lx",		},
/* 179: */  { 1, "strsep",	vp,	"($%lx, \"%s\")",	"\"%s\"",		},
/* 180: */  { 1, "strspn",	vp,	"(\"%s\", \"%s\")",	"%d",		},
/* 181: */  { 1, "strstr",	vp,	"(\"%s\", \"%s\")",	"\"%s\"",		},
/* 182: */  { 1, "strtok",	vp,	"(\"%s\", \"%s\")",	"\"%s\"",		},
/* 183: */  { 1, "strtol",	vp,	"(\"%s\", $%lx, %d)",	"%d",		},
/* 184: */  { 1, "strtoul",	vp,	"(\"%s\", $%lx, %d)",	"%d",		},
/* 185: */  { 1, "strunvis",	vp,	"(\"%s\", \"%s\")",	"%d",		},
/* 186: */  { 1, "strvis",	vp,	"(\"%s\", \"%s\")",	"%d",		},
/* 187: */  { 1, "strvisx",	vp,	"(\"%s\", \"%s\", %d, %d)",	"%d",		},
/* 188: */  { 1, "strxfrm",	vp,	"(\"%s\", \"%s\", %d)",	"%d",		},
/* 189: */  { 1, "swab",		vp,	"($%lx, $%lx, %d)",	"",		},
/* 190: */  { 1, "symlink",	vp,	"(\"%s\", \"%s\")",	"%d",		},
/* 191: */  { 1, "system",	vp,	"(\"%s\")",	"%d",		},
/* 192: */  { 1, "tcgetattr",	vp,	"(%d, $%lx)",	"%d",		},
/* 193: */  { 1, "tcgetpgrp",	vp,	"(%d)",	"$%lx",		},
/* 194: */  { 1, "tcsetattr",	vp,	"(%d, $%lx)",	"%d",		},
/* 195: */  { 1, "tcsetpgrp",	vp,	"(%d, $%lx)",	"%d",		},
/* 196: */  { 1, "time",		vp,	"($%lx)",	"%d",		},
/* 197: */  { 1, "tmpnam",	vp,	"(\"%s\")",	"\"%s\"",		},
/* 198: */  { 1, "tolower",	vp,	"(%c)",	"%c",		},
/* 199: */  { 1, "toupper",	vp,	"(%c)", "%c",		},
/* 200: */  { 1, "truncate",	vp,	"(\"%s\", %d)",	"%d",		},
/* 201: */  { 1, "ualarm",	vp,	"(%d, %d)",	"%d",		},
/* 202: */  { 1, "umask",		vp,	"(%o)",	"%d",		},
/* 203: */  { 1, "unlink",	vp,	"(\"%s\")",	"%d",		},
/* 204: */  { 1, "unvis",		vp,	"(\"%s\", %c, $%lx, %d)",	"%d",		},
/* 205: */  { 1, "usleep",	vp,	"(%d)",	"%d",		},
/* 206: */  { 1, "utime",		vp,	"(\"%s\", $%lx)",	"%d",		},
/* 207: */  { 1, "utimes",	vp,	"(\"%s\", $%lx)",	"%d",		},
/* 208: */  { 1, "valloc",	vp,	"(%d)",	"$%lx",		},
/* 209: */  { 1, "vis",		vp,	"(\"%s\", %c, $%lx, %d)",	"\"%s\"",		},
/* 210: */  { 1, "write",		vp,	"(%d, $%lx, %d)",	"%d",		},
/* 211: */  { 1, "writev",	vp,	"(%d, $%lx, %d)",	"%d",		},
/* 212: */  { 1, "_exit",		vp,	"(%d)",	"",		},
/* 213: */  { 1, "_longjmp",	vp,	"($%lx, %d)",	"",		},
/* 214: */  { 1, "_setjmp",	vp,	"($%lx)",	"%d",		},
/* 215: */  { 0, "__must_recompile215",	vp,	"()",	"_wb_parse has been removed, recompile",		},
/* 216: */  { 0, "__must_recompile216",	vp,	"()",	"_cli_parse has been removed, recompile",		},
/* 217: */  { 0, "__must_recompile217",	vp,	"()",	"_main has been removed, recompile",		},
/* 218: */  { 0, "__adddf3",	vp,	"(%g, %g)",	"%g",		},
/* 219: */  { 0, "__addsf3",	vp,	"(%g, %g)",	"%g",		},
/* 220: */  { 0, "__must_recompile220", vp, "()", "__ashldi3() is obsolete, recompile",},
/* 221: */  { 0, "__must_recompile221", vp, "()", "__ashlsi3() is obsolete, recompile",},
/* 222: */  { 0, "__must_recompile222", vp, "()", "__ashrdi3() is obsolete, recompile",},
/* 223: */  { 0, "__must_recompile223", vp, "()", "__ashrsi3() is obsolete, recompile",},
/* 224: */  { 0, "__must_recompile224", vp, "()", "__clear_cache() is obsolete, recompile",},
/* 225: */  { 0, "__cmpdf2",	vp,	"(%g, %g)",	"%d",		},
/* 226: */  { 0, "__must_recompile226", vp, "()", "__cmpdi2() is obsolete, recompile",},
/* 227: */  { 0, "__cmpsf2",	vp,	"(%g, %g)",	"%d",		},
/* 228: */  { 0, "__divdf3",	vp,	"(%g, %g)",	"%g",		},
/* 229: */  { 0, "__must_recompile229", vp, "()", "__divdi3() is obsolete, recompile",},
/* 230: */  { 0, "__divsf3",	vp,	"(%g, %g)",	"%g",		},
/* 231: */  { 0, "__divsi3",	vp,	"(%d, %d)",	"%d",		},
/* 232: */  { 0, "__eqdf2",	vp,	"(%g, %g)",	"%d",		},
/* 233: */  { 0, "__eqsf2",	vp,	"(%g, %g)",	"%d",		},
/* 234: */  { 0, "__extendsfdf2",	vp,	"(%g)",	"%g",		},
/* 235: */  { 0, "__must_recompile235", vp, "()", "__fixdfdi() is obsolete, recompile",},
/* 236: */  { 0, "__fixdfsi",	vp,	"(%g)",	"%g",		},
/* 237: */  { 0, "__must_recompile237", vp, "()", "__fixsfdi() is obsolete, recompile",},
/* 238: */  { 0, "__fixsfsi",	vp,	"(%g)",	"%d",		},
/* 239: */  { 0, "__must_recompile239", vp, "()", "__fixunsdfdi() is obsolete, recompile", },
/* 240: */  { 0, "__must_recompile240", vp, "()", "__fixunsdfsi() is obsolete, recompile", },
/* 241: */  { 0, "__must_recompile241", vp, "()", "__fixunssfdi() is obsolete, recompile", },
/* 242: */  { 0, "__must_recompile242", vp, "()", "__fixunssfsi() is obsolete, recompile", },
/* 243: */  { 0, "__must_recompile243", vp, "()", "__floatdidf() is obsolete, recompile", },
/* 244: */  { 0, "__must_recompile244", vp, "()", "__floatdisf() is obsolete, recompile", },
/* 245: */  { 0, "__floatsidf",	vp,	"(%d)",	"%g",		},
/* 246: */  { 0, "__floatsisf",	vp,	"(%d)",	"%g",		},
/* 247: */  { 0, "__gedf2",	vp,	"(%g, %g)",	"%d",		},
/* 248: */  { 0, "__gesf2",	vp,	"(%g, %g)",	"%d",		},
/* 249: */  { 0, "__gtdf2",	vp,	"(%g, %g)",	"%d",		},
/* 250: */  { 0, "__gtsf2",	vp,	"(%g, %g)",	"%d",		},
/* 251: */  { 0, "__ledf2",	vp,	"(%g, %g)",	"%d",		},
/* 252: */  { 0, "__lesf2",	vp,	"(%g, %g)",	"%d",		},
/* 253: */  { 0, "__must_recompile253", vp, "()", "__lshldi3() is obsolete, recompile", },
/* 254: */  { 0, "__must_recompile254", vp, "()", "__lshlsi3() is obsolete, recompile", },
/* 255: */  { 0, "__must_recompile255", vp, "()", "__lshrdi3() is obsolete, recompile", },
/* 256: */  { 0, "__must_recompile256", vp, "()", "__lshrsi3() is obsolete, recompile", },
/* 257: */  { 0, "__ltdf2",	vp,	"(%g, %g)",	"%d",		},
/* 258: */  { 0, "__ltsf2",	vp,	"(%g, %g)",	"%d",		},
/* 259: */  { 0, "__must_recompile259", vp, "()", "__moddi3() is obsolete, recompile", },
/* 260: */  { 0, "__modsi3",	vp,	"(%d, %d)",	"%d",		},
/* 261: */  { 0, "__muldf3",	vp,	"(%g, %g)",	"%g",		},
/* 262: */  { 0, "__must_recompile262", vp, "()", "__muldi3() is obsolete, recompile", },
/* 263: */  { 0, "__mulsf3",	vp,	"(%g, %g)",	"%g",		},
/* 264: */  { 0, "__mulsi3",	vp,	"(%d, %d)",	"%d",		},
/* 265: */  { 0, "__nedf2",	vp,	"(%g, %g)",	"%d",		},
/* 266: */  { 0, "__negdf2",	vp,	"(%g)",	"%g",		},
/* 267: */  { 0, "__must_recompile267", vp, "()", "__negdi2() is obsolete, recompile", },
/* 268: */  { 0, "__negsf2",	vp,	"(%g)",	"%g",		},
/* 269: */  { 0, "__nesf2",	vp,	"(%g)",	"%g",		},
/* 270: */  { 0, "__subdf3",	vp,	"(%g, %g)",	"%g",		},
/* 271: */  { 0, "__subsf3",	vp,	"(%g, %g)",	"%g",		},
/* 272: */  { 0, "__truncdfsf2",	vp,	"(%g)",	"%g",		},
/* 273: */  { 0, "__must_recompile273", vp, "()", "__ucmpdi2() is obsolete, recompile", },
/* 274: */  { 0, "__must_recompile274", vp, "()", "__udivdi3() is obsolete, recompile", },
/* 275: */  { 0, "__must_recompile275", vp, "()", "__udivmoddi4() is obsolete, recompile", },
/* 276: */  { 0, "__udivsi3",	vp,	"(%d, %d)",	"%d",		},
/* 277: */  { 0, "__must_recompile277", vp, "()", "__umoddi3() is obsolete, recompile", },
/* 278: */  { 0, "__umodsi3",	vp,	"(%d, %d)",	"%d",		},
/* 279: */  { 1, "__must_recompile279",	vp,	"()",	"ix_get_vars has been removed, recompile",		},
/* 280: */  { 1, "modf",		vp,	"(%g, $%lx)",	"%g",		},
/* 281: */  { 1, "opendir",	vp,	"(\"%s\")",	"$%lx",		},
/* 282: */  { 1, "readdir",	vp,	"($%lx)",	"$%lx",		},
/* 283: */  { 1, "rewinddir",	vp,	"($%lx)",	"",		},
/* 284: */  { 1, "closedir",	vp,	"($%lx)",	"",		},
/* 285: */  { 1, "telldir",	vp,	"($%lx)",	"%d",		},
/* 286: */  { 1, "seekdir",	vp,	"($%lx, %d)",	"%d",		},
/* 287: */  { 1, "__obsolete_ssystem",       vp,     "(\"%s\")",     "ssystem() is obsolete, recompile", },
/* 288: */  { 1, "isinf",		vp,	"(%g)",	"%d",		},
/* 289: */  { 1, "isnan",		vp,	"(%g)",	"%d",		},
/* 290: */  { 1, "ldexp",		vp,	"(%g, %d)",	"%g",		},
/* 291: */  { 1, "ix_chmod",	vp,	"(\"%s\", $%lx)",	"%d",		},
/* 292: */  { 1, "stricmp",	vp,	"(\"%s\", \"%s\")",	"%d",		},
/* 293: */  { 1, "strnicmp",	vp,	"(\"%s\", \"%s\", %d)",	"%d",		},
/* 294: */  { 1, "atan",		vp,	"(%g)",	"%g",		},
/* 295: */  { 1, "sin",		vp,	"(%g)",	"%g",		},
/* 296: */  { 1, "cos",		vp,	"(%g)",	"%g",		},
/* 297: */  { 1, "tan",		vp,	"(%g)",	"%g",		},
/* 298: */  { 1, "sincos",	vp,	"($%lx, %g)",	"%g",		},
/* 299: */  { 1, "sinh",		vp,	"(%g)",	"%g",		},
/* 300: */  { 1, "cosh",		vp,	"(%g)",	"%g",		},
/* 301: */  { 1, "tanh",		vp,	"(%g)",	"%g",		},
/* 302: */  { 1, "exp",		vp,	"(%g)",	"%g",		},
/* 303: */  { 1, "log",		vp,	"(%g)",	"%g",		},
/* 304: */  { 1, "pow",		vp,	"(%g, %g)",	"%g",		},
/* 305: */  { 1, "sqrt",		vp,	"(%g)",	"%g",		},
/* 306: */  { 1, "asin",		vp,	"(%g)",	"%g",		},
/* 307: */  { 1, "acos",		vp,	"(%g)",	"%g",		},
/* 308: */  { 1, "log10",		vp,	"(%g)",	"%g",		},
/* 309: */  { 1, "fabs",		vp,	"(%g)",	"%g",		},
/* 310: */  { 1, "initstate",	vp,	"(%d, $%lx, %d)",	"$%lx",		},
/* 311: */  { 1, "setstate",	vp,	"($%lx)",	"$%lx",		},
/* 312: */  { 1, "ix_exec_entry",	vp,	"(%d, $%lx, $%lx, $%lx, $%lx)",	"%d",		},
/* 313: */  { 1, "ix_get_vars",	vp,	"(%d, $%lx, $%lx, $%lx, $%lx, $%lx, $%lx)",	"",		},
/* 314: */  { 1, "execve",	vp,	"(\"%s\", $%lx, $%lx)",	"%d",		},
/* 315: */  { 1, "execl",		vp,	"(\"%s\", \"%s\", \"%s\", ...)",	"%d",		},
/* 316: */  { 1, "execv",		vp,	"(\"%s\", $%lx)",	"%d",		},
/* 317: */  { 1, "execle",	vp,	"(\"%s\", $%lx, $%lx)",	"%d",		},
/* 318: */  { 1, "execlp",	vp,	"(\"%s\", \"%s\", \"%s\", ...)",	"%d",		},
/* 319: */  { 1, "execvp",	vp,	"(\"%s\", $%lx)",	"%d",		},
/* 320: */  { 1, "ix_vfork",	vp,	"()",	"%d",		},
/* 321: */  { 1, "wait4",		vp,	"($%lx, $%lx, $%lx, $%lx)",	"%d",		},
/* 322: */  { 1, "wait",		vp,	"($%lx)",	"%d",		},
/* 323: */  { 1, "wait3",		vp,	"($%lx, $%lx, $%lx)",	"%d",		},
/* 324: */  { 1, "waitpid",	vp,	"($%lx, $%lx, $%lx)",	"%d",		},
/* 325: */  { 1, "ix_vfork_resume",	vp,	"()",	"",		},
/* 326: */  { 1, "profil",	vp,	"($%lx, %d, %d, $%lx)",	"%d",		},
/* 327: */  { 1, "ptrace",	vp,	"(%d, $%lx, $%lx, $%lx)",	"%d",		},
/* 328: */  { 1, "clearerr",	vp,	"($%lx)",	"",		},
/* 329: */  { 1, "fclose",	vp,	"($%lx)",	"%d",		},
/* 330: */  { 1, "fdopen",	vp,	"(%d, \"%s\")",	"$%lx",		},
/* 331: */  { 1, "feof",		vp,	"($%lx)",	"%d",		},
/* 332: */  { 1, "ferror",	vp,	"($%lx)",	"%d",		},
/* 333: */  { 1, "fflush",	vp,	"($%lx)",	"%d",		},
/* 334: */  { 1, "fgetc",		vp,	"($%lx)",	"%d",		},
/* 335: */  { 1, "fgetln",	vp,	"($%lx, $%lx)",	"\"%s\"",		},
/* 336: */  { 1, "fgetpos",	vp,	"($%lx, $%lx)",	"%d",		},
/* 337: */  { 1, "fgets",		vp,	"(\"%s\", %d, $%lx)",	"$%lx",		},
/* 338: */  { 1, "fileno",	vp,	"($%lx)",	"%d",		},
/* 339: */  { 1, "f_prealloc",	vp,	"()",	"",		},
/* 340: */  { 1, "fopen",		vp,	"(\"%s\", \"%s\")",	"$%lx",		},
/* 341: */  { 1, "fprintf",	vp,	"($%lx, \"%s\", ...)",	"%d",		},
/* 342: */  { 1, "fpurge",	vp,	"($%lx)",	"%d",		},
/* 343: */  { 1, "fputc",		vp,	"(%d, $%lx)",	"%d",		},
/* 344: */  { 1, "fputs",		vp,	"(\"%s\", $%lx)",	"%d",		},
/* 345: */  { 1, "fread",		vp,	"($%lx, %d, %d, $%lx)",	"%d",		},
/* 346: */  { 1, "freopen",	vp,	"(\"%s\", \"%s\", $%lx)",	"$%lx",		},
/* 347: */  { 1, "fscanf",	vp,	"($%lx, \"%s\", ...)",	"%d",		},
/* 348: */  { 1, "fseek",		vp,	"($%lx, %d, %d)",	"%d",		},
/* 349: */  { 1, "fsetpos",	vp,	"($%lx, $%lx)",	"%d",		},
/* 350: */  { 1, "ftell",		vp,	"($%lx)",	"%d",		},
/* 351: */  { 1, "funopen",	vp,	"($%lx, $%lx, $%lx, $%lx, $%lx)",	"%d",		},
/* 352: */  { 1, "fwrite",	vp,	"($%lx, %d, %d, $%lx)",	"%d",		},
/* 353: */  { 1, "getc",		vp,	"($%lx)",	"%d",		},
/* 354: */  { 1, "getchar",	vp,	"()",	"%d",		},
/* 355: */  { 1, "gets",		vp,	"(\"%s\")",	"\"%s\"",		},
/* 356: */  { 1, "getw",		vp,	"($%lx)",	"%d",		},
/* 357: */  { 1, "printf",	vp,	"(\"%s\", ...)",	"%d",		},
/* 358: */  { 1, "putc",		vp,	"(%d, $%lx)",	"%d",		},
/* 359: */  { 1, "putchar",	vp,	"(%d)",	"%d",		},
/* 360: */  { 1, "puts",		vp,	"(\"%s\")",	"%d",		},
/* 361: */  { 1, "putw",		vp,	"(%d, $%lx)",	"%d",		},
/* 362: */  { 1, "rewind",	vp,	"($%lx)",	"%d",		},
/* 363: */  { 1, "scanf",		vp,	"(\"%s\", ...)",	"%d",		},
/* 364: */  { 1, "setbuf",	vp,	"($%lx, $%lx)",	"",		},
/* 365: */  { 1, "setbuffer",	vp,	"($%lx, $%lx, %d)",	"",		},
/* 366: */  { 1, "setlinebuf",	vp,	"($%lx)",	"",		},
/* 367: */  { 1, "setvbuf",	vp,	"($%lx, $%lx, %d, %d)",	"%d",		},
/* 368: */  { 1, "snprintf",	vp,	"(\"%s\", %d, \"%s\", ...)",	"%d",		},
/* 369: */  { 1, "sprintf",	vp,	"($%lx, \"%s\", ...)",	"%d",		},
/* 370: */  { 1, "sscanf",	vp,	"(\"%s\", \"%s\", ...)",	"%d",		},
/* 371: */  { 1, "tempnam",	vp,	"(\"%s\", \"%s\")",	"\"%s\"",		},
/* 372: */  { 1, "tmpfile",	vp,	"()",	"$%lx",		},
/* 373: */  { 1, "ungetc",	vp,	"(%d, $%lx)",	"%d",		},
/* 374: */  { 1, "vfprintf",	vp,	"($%lx, \"%s\", $%lx)",	"%d",		},
/* 375: */  { 1, "vprintf",	vp,	"(\"%s\", $%lx)",	"%d",		},
/* 376: */  { 1, "vscanf",	vp,	"(\"%s\", $%lx)",	"%d",		},
/* 377: */  { 1, "vsnprintf",	vp,	"(\"%s\", %d, \"%s\", $%lx)",	"%d",		},
/* 378: */  { 1, "vsprintf",	vp,	"(\"%s\", $%lx)",	"%d",		},
/* 379: */  { 1, "vsscanf",	vp,	"(\"%s\", \"%s\", $%lx)",	"%d",		},
/* 380: */  { 1, "crypt",		vp,	"(\"%s\", \"%s\")",	"\"%s\"",		},
/* 381: */  { 1, "des_cipher",	vp,	"(\"%s\", \"%s\", %d, %d)",	"%d",		},
/* 382: */  { 1, "des_setkey",	vp,	"(\"%s\")",	"%d",		},
/* 383: */  { 1, "encrypt",	vp,	"(\"%s\", %d)", "%d",		},
/* 384: */  { 1, "setkey",	vp,	"(\"%s\")",	"%d",		},
/* 385: */  { 1, "fnmatch",	vp,	"(\"%s\", \"%s\", %d)",	"%d",		},
/* 386: */  { 1, "__must_recompile386", vp, "()", "fts_children() is obsolete, recompile", },
/* 387: */  { 1, "__must_recompile387", vp, "()", "fts_close() is obsolete, recompile", },
/* 388: */  { 1, "__must_recompile388", vp, "()", "fts_open() is obsolete, recompile", },
/* 389: */  { 1, "__must_recompile389", vp, "()", "fts_read() is obsolete, recompile", },
/* 390: */  { 1, "__must_recompile390", vp, "()", "fts_set() is obsolete, recompile", },
/* 391: */  { 1, "cuserid",	vp,	"(\"%s\")",	"\"%s\"",		},
/* 392: */  { 1, "getlogin",	vp,	"()",	"\"%s\"",		},
/* 393: */  { 1, "glob",		vp,	"(\"%s\", %d, $%lx, $%lx)",	"%d",		},
/* 394: */  { 1, "globfree",	vp,	"($%lx)",	"",		},
/* 395: */  { 1, "ix_filehandle",vp,	"(%d)",	"$%lx",		},
/* 396: */  { 1, "times",		vp,	"($%lx)",	"$%lx",		},
/* 397: */  { 1, "mblen",		vp,	"(\"%s\", %d)",	"%d",		},
/* 398: */  { 1, "mbstowcs",	vp,	"($%lx, \"%s\", %d)",	"%d",		},
/* 399: */  { 1, "mbtowc",	vp,	"($%lx, \"%s\", %d)",	"%d",		},
/* 400: */  { 1, "wcstombs",	vp,	"(\"%s\", $%lx, %d)",	"%d",		},
/* 401: */  { 1, "wctomb",	vp,	"(\"%s\", $%lx)",	"%d",		},
/* 402: */  { 1, "heapsort",	vp,	"($%lx, %d, %d, $%lx)",	"%d",		},
/* 403: */  { 1, "radixsort",	vp,	"($%lx, %d, \"%s\", %d)",	"%d",		},
/* 404: */  { 0, "__sflush",	vp,	"()",	"",		},
/* 405: */  { 0, "__slbexpand",	vp,	"()",	"",		},
/* 406: */  { 0, "__sfp",		vp,	"()",	"",		},
/* 407: */  { 0, "__sflags",	vp,	"()",	"",		},
/* 408: */  { 0, "__sfvwrite",	vp,	"()",	"",		},
/* 409: */  { 0, "__smakebuf",	vp,	"()",	"",		},
/* 410: */  { 0, "__srefill",	vp,	"()",	"",		},
/* 411: */  { 0, "__srget",	vp,	"()",	"",		},
/* 412: */  { 0, "__sclose",	vp,	"()",	"",		},
/* 413: */  { 0, "__sread",	vp,	"()",	"",		},
/* 414: */  { 0, "__sseek",	vp,	"()",	"",		},
/* 415: */  { 0, "__swrite",	vp,	"()",	"",		},
/* 416: */  { 0, "__svfscanf",	vp,	"()",	"",		},
/* 417: */  { 0, "__swbuf",	vp,	"()",	"",		},
/* 418: */  { 0, "__swsetup",	vp,	"()",	"",		},
/* 419: */  { 1, "fchdir",	vp,	"(%d)",	"%d",		},
/* 420: */  { 1, "strtod",	vp,	"(\"%s\", $%lx)",	"%g",		},
/* 421: */  { 1, "setgrent",	vp,	"()",	"",		},
/* 422: */  { 1, "getgrent",	vp,	"()",	"",		},
/* 423: */  { 1, "endgrent",	vp,	"()",	"",		},
/* 424: */  { 1, "ix_resident",	vp,	"(%d, $%lx, %d, $%lx)",	"",		},
/* 425: */  { 1, "ix_geta4",	vp,	"()",	"",		},
/* 426: */  { 1, "ix_check_cpu",	vp,	"(%d)",	"",		},
/* 427: */  { 1, "ix_tracecntl",	vp,	"(%d, $%lx)",	"%d",		},
/* 428: */  { 1, "sysconf",	vp,	"(%d)",	"%d",	},
/* 429: */  { 1, "pathconf",	vp,	"(\"%s\", %d)", "%d",	},
/* 430: */  { 1, "fpathconf",	vp,	"(%d, %d)",	"%d",	},
/* 431: */  { 1, "getfsstat",	vp,	"($%lx, %d, %d)", "%d",	},
/* 432: */  { 1, "fstatfs",	vp,	"(%d, $%lx)", "%d", },
/* 433: */  { 1, "statfs", 	vp, "(\"%s\", %d)", "%d", },
/* 434: */  { 1, "getmntinfo",	vp,	"($%lx, %d)",	"%d", },
/* 435: */  { 1, "getgrnam",	vp,	"(\"%s\")",	"%d", },
/* 436: */  { 1, "endpwent",	vp,	"()",	"", },
/* 437: */  { 1, "sync",		vp,	"()",	"", },
/* 438: */  { 1, "fork",		vp,	"()",	"%d", },
/* 439: */  { 1, "mkfifo",	vp,	"(\"%s\", %o)",	"%d", },
/* 440: */  { 1, "mknod",		vp,	"(\"%s\", %o)",	"%d", },
/* 441: */  { 1, "setuid",	vp,	"(%d)",	"%d", },
/* 442: */  { 1, "nice",		vp,	"(%d)",	"%d", },
/* 443: */  { 1, "floor",		vp,	"(%g)",	"%g", },
/* 444: */  { 1, "ceil",		vp,	"(%g)",	"%g", },
/* 445: */  { 1, "setgid",	vp,	"(%d)",	"%d", },
/* 446: */  { 1, "vfork",		vp,	"()",	"%d", },
/* 447: */  { 1, "__must_recompile447", vp, "()", "tcdrain() has moved", },
/* 448: */  { 1, "__must_recompile448", vp, "()", "tcflush() has moved", },
/* 449: */  { 1, "__must_recompile449", vp, "()", "tcflow() has moved", },
/* 450: */  { 1, "__must_recompile450", vp, "()", "tcsendbreak() has moved", },
/* 451: */  { 1, "connect",	vp,	"(%d, \"%s\", %d)", "%d", },
/* 452: */  { 1, "sendto",	vp,	"(%d, \"%s\", %d, %d, \"%s\", %d)",	"%d", },
/* 453: */  { 1, "send",	    	vp,	"(%d, \"%s\", %d, %d)",	"%d", },
/* 454: */  { 1, "sendmsg",	vp,	"(%d, \"%s\", %d)",	"%d", },
/* 455: */  { 1, "recvfrom",	vp,	"(%d, \"%s\", %d, %d, \"%s\", %d)",	"%d", },
/* 456: */  { 1, "recv",  	vp,	"(%d, \"%s\", %d, %d)",	"%d", },
/* 457: */  { 1, "recvmsg",	vp,	"(%d, \"%s\", %d)",	"%d", },
/* 458: */  { 1, "shutdown",	vp,	"(%d, %d)",	"%d", },
/* 459: */  { 1, "setsockopt",	vp,	"(%d, %d, %d, \"%s\", %d)",	"%d", },
/* 460: */  { 1, "getsockopt",	vp, "(%d,, %d, %d, \"%s\", %d)", "%d",},
/* 461: */  { 1, "getsockname",	vp,"(%d, \"%s\", %d)",			 "%d",},
/* 462: */  { 1, "getpeername",	vp,	"(%d, \"%s\", %d)",	"%d", },
/* 463: */  { 1, "unsetenv",	vp, "()", "",},
/* 464: */  { 1, "socket",	vp,	"(%d, %d, %d)",	"%d", },
/* 465: */  { 1, "bind"  ,	vp,	"(%d, \"%s\", %d)", "%d", },
/* 466: */  { 1, "listen",	vp,	"(%d, %d)",	"%d", },
/* 467: */  { 1, "accept",	vp,	"(%d, \"%s\", %d)", "%d", },
/* 468: */  { 1, "tcdrain",	vp, "(%d)", "%d",},
/* 469: */  { 1, "tcflush",	vp, "(%d, %d)", "%d",},
/* 470: */  { 1, "tcflow", 	vp, "(%d, %d)", "%d",},
/* 471: */  { 1, "tcsendbreak",	vp, "(%d, %d)", "%d",},
/* 472: */  { 1, "raise", 	vp, "(%d)", "%d",},
/* 473: */  { 1, "ix_get_gmt_offset", vp, "()", "%lx",},
/* 474: */  { 1, "ix_set_gmt_offset", vp, "(%lx)", "",},
/* 475: */  { 1, "ix_get_default_settings", vp, "()", "",},
/* 476: */  { 1, "ix_get_settings", vp, "()", "",},
/* 477: */  { 1, "ix_set_settings", vp, "()", "",},
/* 478: */  { 1, "uname",		vp, "()" , "%s",},
/* 479: */  { 1, "socketpair",	vp, "(%d, %d)" , "%d",},
/* 480: */  { 0, "__init_stk_limit",vp, "(%lx, %lu)" , "",},
/* 481: */  { 0, "__stkovf",	vp, "()" , "",},
/* 482: */  { 0, "__stkext",	vp, "()" , "",},
/* 483: */  { 0, "__stkext_f",	vp, "()" , "",},
/* 484: */  { 0, "__stkrst",	vp, "()" , "",},
/* 485: */  { 1, "inet_addr",	vp, "(%s)" , "%lu",},
/* 486: */  { 1, "inet_aton",	vp, "(%s, %lu)" , "%d",},
/* 487: */  { 1, "inet_lnaof",	vp, "(%lu)" , "%lu",},
/* 488: */  { 1, "__obsolete_inet_makeaddr",	vp, "()" , "__obsolete_inet_makeaddr, recompile",},
/* 489: */  { 1, "inet_netof",	vp, "(%lu)" , "%lu",},
/* 490: */  { 1, "inet_network",	vp, "(%s)" , "%lu",},
/* 491: */  { 1, "inet_ntoa",	vp, "(%lu)" , "%s",},
/* 492: */  { 1, "gethostbyname",	vp, "(%s)" , "%lu",},
/* 493: */  { 1, "gethostbyaddr",	vp, "(%lu, %d, %d)" , "%lu",},
/* 494: */  { 1, "getnetbyname",	vp, "(%s)" , "%lu",},
/* 495: */  { 1, "getnetbyaddr",	vp, "(%lu, %d)" , "%lu",},
/* 496: */  { 1, "setnetent",	vp, "(%d)" , "",},
/* 497: */  { 1, "endnetent",	vp, "()" , "",},
/* 498: */  { 1, "getnetent",	vp, "()" , "",},
/* 499: */  { 1, "setservent",	vp, "(%d)" , "",},
/* 500: */  { 1, "endservent",	vp, "()" , "",},
/* 501: */  { 1, "getservent",	vp, "()" , "%lu",},
/* 502: */  { 1, "__must_recompile502",	vp, "(%s)" , "%lu",},
/* 503: */  { 1, "__must_recompile503",	vp, "()" , "%lu",},
/* 504: */  { 1, "__must_recompile504",	vp, "()" , "",},
/* 505: */  { 1, "__must_recompile505",	vp, "()" , "%d",},
/* 506: */  { 1, "__must_recompile506",	vp, "(%d)" , "%s",},
/* 507: */  { 1, "__must_recompile507",	vp, "()" , "%d",},
/* 508: */  { 1, "setgroupent",	vp, "(%d)" , "%d",},
/* 509: */  { 1, "setpassent",	vp, "(%d)" , "%d",},
/* 510: */  { 1, "herror",	vp, "(%s)" , "",},
/* 511: */  { 1, "getservbyname",	vp, "(%s, %s)" , "%lu",},
/* 512: */  { 1, "getservbyport",	vp, "(%d, %s)" , "%lu",},
/* 513: */  { 1, "setpwent",	vp, "()" , "%d",},
/* 514: */  { 1, "getpwent",	vp, "()" , "%lu",},
/* 515: */  { 1, "getprotoent",	vp, "()" , "%lu",},
/* 516: */  { 1, "getprotobyname",vp, "(%s)" , "%lu",},
/* 517: */  { 1, "getprotobynumber",vp, "(%d)" , "%lu",},
/* 518: */  { 1, "setprotoent",	vp, "(%ld)" , "",},
/* 519: */  { 1, "endprotoent",	vp, "()" , "",},
/* 520: */  { 1, "__must_recompile520",vp, "(%lu, %d, %s, %s, %s, %lu)" , "",},
/* 521: */  { 1, "__must_recompile521",	vp, "(%lu)" , "%d",},
/* 522: */  { 1, "getpass",	vp, "(%s)" , "%s",},
/* 523: */  { 1, "__must_recompile523",	vp, "(%s, %s, %s, %s, %d)" , "%d",},
/* 524: */  { 1, "__must_recompile524",	vp, "(%s, %s, %d, %lu, %lu)" , "%d",},
/* 525: */  { 1, "__must_recompile525",	vp, "()" , "%d",},
/* 526: */  { 1, "__must_recompile526",	vp, "(%d, %s, %d, %d, %s, %d, %lu, %s, %d)" , "%d",},
/* 527: */  { 1, "__must_recompile527",	vp, "(%s, %d, %s, %d)" , "%d",},
/* 528: */  { 1, "__must_recompile528",	vp, "(%s, %d, %d, %s, %d)" , "%d",},
/* 529: */  { 1, "__must_recompile529",vp, "(%s, %s, %d, %d, %s, %d)" , "%d",},
/* 530: */  { 1, "__must_recompile530",	vp, "(%s, %d, %s, %d)" , "%d",},
/* 531: */  { 1, "sethostent",	vp, "(%d)" , "",},
/* 532: */  { 1, "endhostent",	vp, "()" , "",},
/* 533: */  { 1, "gethostid",	vp, "(%ld)" , "",},
/* 534: */  { 1, "vsyslog",	vp, "(%d, %s, %lu)" , "",},
/* 535: */  { 1, "openlog",	vp, "(%s, %d, %d)" , "",},
/* 536: */  { 1, "closelog",	vp, "()" , "",},
/* 537: */  { 1, "syslog",	vp, "(%d, %s, ...)" , "",},
/* 538: */  { 1, "setlogmask",	vp, "(%d)" , "%d",},
/* 539: */  { 0, "issig",	vp, "(%lu)" , "%d",},
/* 540: */  { 0, "setrun",	vp, "(%lu)" , "",},
/* 541: */  { 1, "seteuid",	vp, "(%d)" , "%d",},
/* 542: */  { 1, "setegid",	vp, "(%d)" , "%d",},
/* 543: */  { 1, "setreuid",	vp, "(%d, %d)" , "%d",},
/* 544: */  { 1, "setregid",	vp, "(%d, %d)" , "%d",},
/* 545: */  { 1, "fchown", 	vp, "(%d, %d, %d)", "%d", },
/* 546: */  { 1, "chroot", 	vp,  "(%s)", "%d",},
/* 547: */  { 1, "getusershell",vp, "", "%s",},
/* 548: */  { 1, "endusershell",vp, "", "",},
/* 549: */  { 1, "setusershell",vp, "", "",},
/* 550: */  { 1, "_getlogin",	vp, "(%s, %d)" , "%d",},
/* 551: */  { 0, "_psignal",	vp, "(%lu, %d)" , "",},
/* 552: */  { 0, "falloc",	vp, "(%lu, %lu)" , "%d",},
/* 553: */  { 0, "_set_socket_params",vp,"(%ld, %d, %d, %d)", "",},
/* 554: */  { 1, "setsid",	vp,	"()",		"$%lx",		},
/* 555: */  { 1, "getdomainname", vp,"(\"%s\",%d)","%d",},
/* 556: */  { 1, "setlogin",	vp,"(\"%s\")","%d",},
/* 557: */  { 1, "isblank", 	vp,"(%d)","%d",},
/* 558: */  { 1, "mmap", 	vp,"(\"%s\",%d,%d,%d,%d,%d)","\"%s\"",},
/* 559: */  { 1, "munmap",	vp,"(\"%s\",%d)","%d",},
/* 560: */  { 1, "mlock", 	vp,"(\"%s\",%d)","%d",},
/* 561: */  { 1, "munlock", 	vp,"(\"%s\",%d)","%d",},
/* 562: */  { 1, "madvise", 	vp,"(\"%s\",%d,%d)","",},
/* 563: */  { 1, "mprotect", 	vp,"(\"%s\",%d,%d)","",},
/* 564: */  { 1, "msync", 	vp,"(\"%s\",%d)","",},
/* 565: */  { 1, "setlocale",	vp,"(%d,\"%s\")","$%lx",},
/* 566: */  { 1, "localeconv",	vp,"()","$%lx",},
/* 567: */  { 1, "strtoq", 	vp,"(\"%s\",%lx,%d)","%lx",},
/* 568: */  { 1, "strtouq", 	vp,"(\"%s\",%lx,%d)","%lx",},
/* 569: */  { 1, "setpgid", 	vp,"(%d,%d)","%d",},
/* 570: */  { 0, "__must_recompile570", 	vp,"()","aselect has been removed, recompile",},
/* 571: */  { 0, "__stkext_startup", vp , "", "",},
/* 572: */  { 1, "div",		vp,"(%d,%d)","%d",},
/* 573: */  { 1, "ldiv",	vp,"(%ld,%ld)","%ld",},
/* 574: */  { 1, "inet_makeaddr",vp,"(%lu,%lu)","%lu",},
/* 575: */  { 1, "popen",	vp,"(%c,%c)","%lx",},
/* 576: */  { 1, "pclose",	vp,"(%lx)","%d",},
/* 577: */  { 1, "shmat",	vp,"(%d,%lx,%d)","%lx",},
/* 578: */  { 1, "shmdt",	vp,"(%lx)","%d",},
/* 579: */  { 1, "shmget",	vp,"(%ld,%d,%d)","%d",},
/* 580: */  { 1, "shmctl",	vp,"(%d,%d,%lx)","%d",},
/* 581: */  { 1, "ix_req", vp,"(\"%s\",\"%s\",\"%s\",\"%s\")","%d",},
/* 582: */  { 1, "ix_select", vp,"(%d,%lx,%lx,%lx,%lx,%lx)","%d",},
/* 583: */  { 1, "isascii", vp,"(%d)","%d",},
/* 584: */  { 1, "isiso", vp,"(%d)","%d",},
/* 585: */  { 1, "toascii", vp,"(%d)","%d",},
/* 586: */  { 1, "toiso", vp,"(%d)","%d",},
/* 587: */  { 1, "ix_get_first_segment", vp,"(%lx)","%lx",},
/* 588: */  { 1, "ix_get_next_segment", vp,"()","%lx",},
/* 589: */  { 1, "hstrerror", vp,"(%d)","\"%s\"",},
/* 590: */  { 1, "ix_obtain_socket", vp,"(%lx,%d,%d,%d)","%d",},
/* 591: */  { 1, "ix_release_socket", vp,"(%d)","%d",},
/* 592: */  { 1, "__flush_cache", vp,"(%lx,%d)","",},
/* 593: */  { 1, "ix_flush_insn_cache", vp,"(%lx,%d)","",},
/* 594: */  { 1, "ix_flush_caches", vp,"()","",},
/* 595: */  { 1, "ix_get_long", vp,"(%lu,%lx)","%lx",},
/* 596: */  { 1, "ix_set_long", vp,"(%lu,%lx)","%lx",},
/* 597: */  { 1, "ix_flush_data_cache", vp,"(%lx,%d)","",},
/* 598: */  { 1, "ix_mutex_lock", vp,"(%lx)","%d",},
/* 599: */  { 1, "ix_mutex_attempt_lock", vp,"(%lx)","%d",},
/* 600: */  { 1, "ix_mutex_unlock", vp,"(%lx)","",},
/* 601: */  { 1, "semop", vp,"(%d,%lx,%d)","%d",},
/* 602: */  { 1, "semctl", vp,"(%d,%d,%d,%lx)","%d",},
/* 603: */  { 1, "semget", vp,"(%lx,%d,%d)","%d",},
/* 604: */  { 1, "msgget", vp,"(%lx,%d)","%d",},
/* 605: */  { 1, "msgctl", vp,"(%d,%d,%lx)","%d",},
/* 606: */  { 1, "msgrcv", vp,"(%d,%lx,%d,%lx,%d)","%d",},
/* 607: */  { 1, "msgsnd", vp,"(%d,%lx,%d,%d)","%d",},
/* 608: */  { 1, "__ix_get_environ", vp,"()","%lx",},
/* 609: */  { 1, "__ix_cli_parse", vp,"(%lx,%ld,%s,%lx,%lx)","",},
/* 610: */  { 1, "__ix_wb_parse", vp,"(%lx,%lx,%lx)","%d",},
/* 611: */  { 1, "__ix_install_sigwinch", vp,"()","",},
/* 612: */  { 1, "__ix_remove_sigwinch", vp,"()","",},
/* 613: */  { 1, "__ix_init_ids", vp,"()","",},
};
