#include <stdio.h>
#include <string.h>

int main(int argc, char **argv)
{
  FILE *f;
  int major, minor, day, month, year;
  char tmp[1024];
  char *format;
  
  if (argc != 2)
  {
    fprintf(stderr, "Usage: parse_version <srcdir>\n");
    exit(2);
  }
  strcpy(tmp, argv[1]);
  strcat(tmp, "/../version.in");
  f = fopen(tmp, "r");
  if (f == NULL)
  {
    fprintf(stderr, "Cannot open %s\n", tmp);
    exit(2);
  }
  fscanf(f, "%d.%d,%d.%d.%d", &major, &minor, &day, &month, &year);
  fclose(f);
  format = "/*
 * version.h file. Automatically generated by parse_version.
 */

#ifndef __VERSION_H__
#define __VERSION_H__

/* Commodities.h defines IX_VERSION too, so wait for our defines
   to come last, and undef the sucker now! */
#undef IX_VERSION

#define IX_NAME		\"ixemul.library\"
#ifdef TRACE_LIBRARY
#define IX_IDSTRING	\"ixemul %d.%d [trace, %s] (%d.%d.%d)\"
#else
#define IX_IDSTRING	\"ixemul %d.%d [%s] (%d.%d.%d)\"
#endif
#define IX_VERSION	%d
#define IX_REVISION	%d
#define IX_PRIORITY	0

#endif
";

  tmp[0] = '\0';

#ifdef NOTRAP
  if (tmp[0])
    strcat(tmp, ", ");
  strcat(tmp, "notrap");
#endif

#ifdef DEBUG_VERSION
  if (tmp[0])
    strcat(tmp, ", ");
  strcat(tmp, "debug");
#endif

  if (tmp[0])
    strcat(tmp, ", ");

#if defined(mc68060)
  strcat(tmp, "68060");
#elif defined(mc68040)
  strcat(tmp, "68040");
#elif defined(mc68020)
  strcat(tmp, "68020");
#else
  strcat(tmp, "68000");
#endif

#ifdef __HAVE_68881__
  strcat(tmp, ", fpu");
#else
  strcat(tmp, ", soft-float");
#endif

#ifdef __pos__
  strcat(tmp, ", pos");
#else
  strcat(tmp, ", amigaos");
#endif

  printf(format, major, minor, tmp, day, month, year,
	         major, minor, tmp, day, month, year, major, minor);
  return 0;
}
