#ifdef __pos__

#define _KERNEL
#include <ixemul.h>
#include <pProto/pList.h>

/* size of FAKEBASE was generated by create_header.c */
/* include the generated header */
#include "ix_internals.h"

BOOL libOpen(struct ixemul_base *ixbase)
{
  return ix_open(ixbase) == ixbase;
}

void libClose(struct ixemul_base *ixbase)
{
  ix_close(ixbase);
}


struct pOS_SegmentLst *libExpunge(struct ixemul_base *ixbase)
{
  ixbase->ix_lib.lib_Flags |= LIBF_DELEXP;
  if (ixbase->ix_lib.lib_OpenCnt == 0)
  {
    struct pOS_SegmentLst *Seg = ixbase->ix_lib.lib_Segm;

    pOS_ListRemove((struct pOS_Node *)&ixbase->ix_lib.lib_Node);
    ix_expunge(ixbase);
    _pOS_FreeLibraryMem2(&ixbase->ix_lib);
    return Seg;
  }
  return 0;
}


ULONG libReserved(struct ixemul_base *ixbase)
{
  return 0;
}

char *ixfakebase = NULL;

BOOL initRoutine(struct pOS_ExecBase *exec, struct ixemul_base *ixbase)
{
  int i;
  extern long posFuncTable[];

  gb_ExecBase = (struct pOS_ExecBase *)exec;
  gb_ExecLib = *((struct pOS_ExecLibFunction**)ixbase->ix_lib.lib_Segm->sel_Seg.seg_Reserved2);
  ixbase->ix_seg_list = (BPTR)ixbase->ix_lib.lib_Segm;

  ixfakebase = ixbase->ix_fake_base = &ixbase->ix_func_table[IXFAKEBASE_SIZE + 24];

  for (i = 1; i <= IXFAKEBASE_SIZE / 6; i++)
  {
    *(short *)(&((char *)ixfakebase)[-(i + 4) * 6]) = 0x4ef9;   // jmp address
    *(long *)(&((char *)ixfakebase)[-(i + 4) * 6 + 2]) = posFuncTable[i - 1];
  }
  CacheClearU();
  return (BOOL)(int)ix_init_glue(ixbase);
}

#endif /* __pos__ */
