/* Stubs for crypt functions which may be export restricted by stupid USA
 * ITAR (International Trade in Arms Regulations).
 *
 * To compile a version of the library in the free world (IE outside the USA)
 * simply replace this file with the real crypt.c, which should be widely
 * available on ftp servers.
 * 
 */

#define _KERNEL
#include "ixemul.h"
#include <unistd.h>
#include <clib/alib_protos.h>

/*
 * Return a pointer to static data consisting of the "setting"
 * followed by an encryption produced by the "key" and "setting".
 */

char *crypt (const char *key, const char *setting)
{
  usetup;
  size_t setlen;

  if (muBase) return 0;

  if (u.u_ixnetbase)
    return (char *)netcall(NET_crypt, key, setting);

  setlen = strlen(setting);
  if (setlen != 9 && setlen != 2) return 0;
  strcpy(u.u_crypt_buf, setting);

#ifdef __pos__
  return NULL;
#else
  return ACrypt(u.u_crypt_buf + setlen, (char *)key, (char *)setting);
#endif
}

/*
 * Encrypt (or decrypt if num_iter < 0) the 8 chars at "in" with abs(num_iter)
 * iterations of DES, using the the given 24-bit salt and the pre-computed key
 * schedule, and store the resulting 8 chars at "out" (in == out is permitted).
 *
 * NOTE: the performance of this routine is critically dependent on your
 * compiler and machine architecture.
 */

int des_cipher (const char *in, char *out, long salt, int num_iter)
{
  ix_warning("This version of ixemul.library does not support encryption/decryption.");
  return 0;
}

/*
 * Set up the key schedule from the key.
 */

int des_setkey (const char *key)
{
  ix_warning("This version of ixemul.library does not support encryption/decryption.");
  return 0;
}

/*
 * "encrypt" routine (for backwards compatibility)
 */

int encrypt (char *block, int flag)
{
  ix_warning("This version of ixemul.library does not support encryption/decryption.");
  return 0;
}

/*
 * "setkey" routine (for backwards compatibility)
 */

int setkey (const char *key)
{
  ix_warning("This version of ixemul.library does not support encryption/decryption.");
  return 0;
}
