import sys
import os

FROMADDR = "cjb@laptop.org"
NAME = "Chris Ball"

def get_packages(filename):
	pkgs = []
	fd = open(filename, "r")
	for line in fd.readlines():
		pkgs.append(line.rstrip())
	fd.close()
	return set(pkgs)

if len(sys.argv) < 3:
	print "Args: oldbuild newbuild"
	sys.exit(1)

oldbuild = int(sys.argv[1])
newbuild = int(sys.argv[2])

oldpath = "/var/www/build/10.2.0/os%d" % oldbuild
newpath = "/var/www/build/10.2.0/os%d" % newbuild

old = get_packages("%s/os%d.packages.txt" % (oldpath, oldbuild))
new = get_packages("%s/os%d.packages.txt" % (newpath, newbuild))
additions = new - old
removals = old - new

changes = []
for pkg in additions:
	changes.append((pkg, '+'))

for pkg in removals:
	changes.append((pkg, '-'))

changes.sort()

oldsize = os.path.getsize("%s/os%d.zd" % (oldpath, oldbuild))
newsize = os.path.getsize("%s/os%d.zd" % (newpath, newbuild))

print "Return-Path: <%s>" % FROMADDR
print "From: %s <%s>" % (NAME, FROMADDR)
print "To: Fedora OLPC <fedora-olpc-list@redhat.com>"
print "Cc: Devel <devel@lists.laptop.org>"
print "Subject: New XO-1.5 10.2.0 build", newbuild
print ""

print "http://wiki.laptop.org/go/F11_for_1.5"
print "http://build.laptop.org/10.2.0/os%d" % newbuild
print ""

str = "Compressed image size: %.2fmb (" % (float(newsize) / 1024 / 1024)
if newsize == oldsize:
	str += "no change from"
elif newsize > oldsize:
	str += "+%.2fmb since" % (float(newsize - oldsize) / 1024 / 1024)
else:
	str += "-%.2fmb since" % (float(oldsize - newsize) / 1024 / 1024)
str += " build %d)" % oldbuild
print str
print ""

if os.path.exists("changelog"):
	print "Description of changes in this build:"
        for line in file("changelog").readlines():
		print line.rstrip()
	print
	os.unlink("changelog")

if len(changes) > 0:
	print "Package changes since build %d:" % oldbuild
	print ""

	for (pkg, direction) in changes:
		print direction + pkg

