/*
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * PRECISION INSIGHT AND/OR ITS SUPPLIERS BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#ifndef _SMI_DRV_H_
#define _SMI_DRV_H_

#ifdef __linux__
# include <linux/version.h>
#endif

#define DRIVER_AUTHOR		"TeH InTeRnEtZ"
#define DRIVER_NAME		"smi"
#define DRIVER_DESC		"SMI 501/502"
#define DRIVER_DATE		"20081120"
#define DRIVER_MAJOR		1
#define DRIVER_MINOR		0
#define DRIVER_PATCHLEVEL	0

#define SMI_READ(reg)		DRM_READ32(smi_dev->mmio, reg)
#define SMI_WRITE(reg, val)	DRM_WRITE32(smi_dev->mmio, reg, val)

#define SMI_DEBUG
#ifdef SMI_DEBUG
extern int smi_indent;
# define ENTER()							\
	printk("%*c %s\n", smi_indent++, '>', __FUNCTION__)
# define LEAVE(...)							\
	do {								\
		printk("%*c %s\n", --smi_indent, '<', __FUNCTION__);	\
		return __VA_ARGS__;					\
	} while (0)
# define DEBUG(...)		printk(__VA_ARGS__)
#else
# define ENTER()		/**/
# define LEAVE(...)		return __VA_ARGS__
# define DEBUG(...)		/**/
#endif

typedef struct drm_smi_private {
	wait_queue_head_t cli_wait;
	drm_local_map_t	*fb;
	drm_local_map_t	*mmio;
	drm_local_map_t *batch;
	unsigned int chipset;
} drm_smi_private_t;

#define	bits(lo, hi)			hi + 1 - lo

#define SMI_CLI_ADDRESS		0x00000018
typedef union drm_smi_cli_addr {
	struct {
		/* Command list address */
		int32_t address : bits( 0, 27);
		/* Reserved/unused bits */
		int32_t u0	: bits(28, 29);
		/* Command list idle if set */
		int32_t idle	: bits(30, 30);
		/* Start executing at address when set. Stop when unset. */
		int32_t start	: bits(31, 31);
	} f;
	int32_t value;
} drm_smi_cli_addr_t;

#define SMI_CLI_CONDITION	0x0000001c
#define SMI_CLI_RETURN_ADDRESS	0x00000020

#define SMI_IRQ_STATUS		0x00000028
#define SMI_IRQ_MASK		0x00000030

typedef union drm_smi_irq {
	struct {
		/* command list interpreter */
		int32_t cli	: bits( 0,  0);
		/* panel vsync */
		int32_t psync	: bits( 1,  1);
		int32_t zv0	: bits( 2,  2);
		/* engine 2d interrupt status */
		int32_t e2d	: bits( 2,  2);
		int32_t zv1	: bits( 3,  3);
		/* reserved and/or unused in this driver */
		int32_t u0	: bits( 4, 10);
		/* crt vsync */
		int32_t csync	: bits(11, 11);
		/* reserved and/or unused in this driver */
		int32_t u1	: bits(12, 19);
		int32_t dma	: bits(20, 20);
		/* reserved and/or unused in this driver */
		int32_t u2	: bits(21, 21);
		int32_t pwm	: bits(22, 22);
		int32_t i2c	: bits(23, 23);
		/* reserved and/or unused in this driver */
		int32_t u3	: bits(24, 31);
	} f;
	int32_t value;
} drm_smi_irq_t;

#endif /* _SMI_DRV_H_ */
