#!/usr/bin/env python
import subprocess
from string import find
from math import log, pow

class WifiGrab():

    def __init__(self):
        pass
    
    ############eth0 signal strength###############################
    def get_signal_strength_dbm_eth0(self):
        """Returns the signal strength in dBm"""
        p = str(subprocess.Popen(["iwconfig", "eth0"], stdout=subprocess.PIPE).communicate()[0])
        p = p[find(p,"Signal level="):]
        p=p[:find(p," dBm")]
        p=p[find(p,"=")+1:]
        return int(p)
    
    def get_signal_strength_watts_eth0(self):
        """Returns the signal strength in watts"""
        pwr_dbm = self.get_signal_strength_dbm_eth0()
        pwr_db = self.dbm_to_db(pwr_dbm)
        return self.db_to_watts(pwr_db)
    
    def get_signal_strength_db_eth0(self):
        """Returns the signal strength in db"""
        pwr_dbm = self.get_signal_strength_dbm_eth0()
        return self.dbm_to_db(pwr_dbm)
    #################################################
    
    ######eth0 noise strength###############################
    def get_noise_strength_dbm_eth0(self):
        """Returns the noise strength in dBm"""
        p = str(subprocess.Popen(["iwconfig", "eth0"], stdout=subprocess.PIPE).communicate()[0])
        p = p[find(p,"Noise level="):]
        p=p[:find(p," dBm")]
        p=p[find(p,"=")+1:]
        return int(p)
    
    def get_noise_strength_watts_eth0(self):
        """Returns the noise strength in watts"""
        pwr_dbm = self.get_noise_strength_dbm_eth0()
        pwr_db = self.dbm_to_db(pwr_dbm)
        return self.db_to_watts(pwr_db)
    
    def get_noise_strength_db_eth0(self):
        """Returns the noise strength in db"""
        pwr_dbm = self.get_noise_strength_dbm_eth0()
        return self.dbm_to_db(pwr_dbm)
    #################################################
    
    
    
    
    
    ############msh0 signal strength###############################
    def get_signal_strength_dbm_msh0(self):
        """Returns the signal strength in dBm"""
        p = str(subprocess.Popen(["iwconfig", "msh0"], stdout=subprocess.PIPE).communicate()[0])
        p = p[find(p,"Signal level="):]
        p=p[:find(p," dBm")]
        p=p[find(p,"=")+1:]
        return int(p)
    
    def get_signal_strength_watts_msh0(self):
        """Returns the signal strength in watts"""
        pwr_dbm = self.get_signal_strength_dbm_msh0()
        pwr_db = self.dbm_to_db(pwr_dbm)
        return self.db_to_watts(pwr_db)
    
    def get_signal_strength_db_msh0(self):
        """Returns the signal strength in db"""
        pwr_dbm = self.get_signal_strength_dbm_msh0()
        return self.dbm_to_db(pwr_dbm)
    #################################################
    
    ######msh0 noise strength###############################
    def get_noise_strength_dbm_msh0(self):
        """Returns the noise strength in dBm"""
        p = str(subprocess.Popen(["iwconfig", "msh0"], stdout=subprocess.PIPE).communicate()[0])
        p = p[find(p,"Noise level="):]
        p=p[:find(p," dBm")]
        p=p[find(p,"=")+1:]
        return int(p)
    
    def get_noise_strength_watts_msh0(self):
        """Returns the noise strength in watts"""
        pwr_dbm = self.get_noise_strength_dbm_msh0()
        pwr_db = self.dbm_to_db(pwr_dbm)
        return self.db_to_watts(pwr_db)
    
    def get_noise_strength_db_msh0(self):
        """Returns the noise strength in db"""
        pwr_dbm = self.get_noise_strength_dbm_msh0()
        return self.dbm_to_db(pwr_dbm)
    #################################################
    
    
    def dbm_to_db(self, strength=0):
        """Converts the value passed in dBm, to dB"""
        return (strength-30)
    
    def db_to_dbm(self, strenght=0):
        """Converts the values passed in dB, to dBm"""
        return (strength+30)
    
    def db_to_watts(self, db=0):
        """converts power in db to power in watts"""
        return pow(10, (db/10.0))
        
    def watts_to_db(self, watts=0):
        """converts power in watts to power in db"""
        return 10.0*log(watts)
        
    def watts_to_milliwatts(self, watts=0):
        """converts power in watts to power in milliwatts"""
        return watts*1000
        
    def milliwatts_to_watts(self, milliwatts=0):
        """converts power in milliwatts to power in watts"""
        return watts/1000.0

