"""
import pygtk
import gtk
from gettext import gettext as _
from camera_grab import CameraGrab  

import config  	#This has all the globals


class CameraUI(gtk.Window):

    def __init__(self):
        gtk.Window.__init__(self)
        self.cg = CameraGrab(self.update_text_box)
        self.hbox  = gtk.HBox(False)
        self.text_buffer = gtk.TextBuffer()
        self.text_box = gtk.TextView(self.text_buffer)
        self.da = gtk.DrawingArea()
        self.hbox.show_all()
        #self.text_box.set_overwrite(True)
        
        self.hbox.pack_start(self.da,True, True, 8)
        self.hbox.pack_start(self.text_box, True, True, 8)
        

    def update_text_box(self, val = 0):
        """Value that the text box will show about the frame"""
        str_val = str(val)
        self.text_buffer.set_text(str_val)
        
    
    
    def pause_grabbing(self):
        """Hook to stop the pipeline"""
        self.cg.stop_pipeline()
    
    def resume_grabbing(self):
        """Hook to stop the pipeline"""
        self.cg.start_pipeline(self.da.window.xid)
"""        
