#!/usr/bin/env python
#
#    Author:  Arjun Sarwal   arjun@laptop.org
#
#    A lot of code has been used from  Record Activity written by Media Modifications'
#
#    Copyright (C) 2007, OLPC
#    
#    	
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

import pygtk
pygtk.require ("2.0")
import gobject
gobject.threads_init ()
import pygst
pygst.require ("0.10")
import gst
import gtk
from struct import unpack

class CameraGrab():

    def __init__(self, callable1): 
        self._VIDEO_WIDTH = 160
        self._VIDEO_HEIGHT = 120
        self._VIDEO_FRAMERATE = 10
        self.avg_intensity = 0
        ###self.pipeline = gst.parse_launch("v4l2src name=v4l2src ! tee name=videoTee ! videorate ! video/x-raw-yuv,framerate=20/1 ! videoscale ! video/x-raw-yuv,width=320,height=240 ! xvimagesink name=xivsink videoTee . ! queue ! ffmpegcolorspace ! jpegenc ! fakesink name=fsink"  )
        
        self.pipeline = gst.parse_launch("v4l2src name=v4l2src ! tee name=videoTee ! videorate ! video/x-raw-yuv,framerate=1/1 ! xvimagesink name=xivsink videoTee. ! queue ! ffmpegcolorspace ! jpegenc ! fakesink name=fsink")
        
        self.xivsink = self.pipeline.get_by_name('xivsink')
        self.sink = self.pipeline.get_by_name('fsink')
        self.sink.connect("handoff", self._videoBufferCb)
        self.callable1 = callable1
        self.window_id = None
    
    def start_pipeline(self, window_id):
        self.sink.set_property("signal-handoffs", True)
        self.pipeline.set_state(gst.STATE_PLAYING)
        self.xivsink.set_xwindow_id(window_id)          #Setting the window in which it has to display
    
    def stop_pipeline(self):
        self.pipeline.set_state(gst.STATE_NULL)
        self.sink.set_property("signal-handoffs", False)

    def _videoBufferCb(self, fsink, buffer, pad, user_data=None):
        print "size of buffer is ", len(buffer), " and length of buf0 is ", len(buffer[0])
        #pic = gtk.gdk.pixbuf_loader_new_with_mime_type("image/jpeg")
        #pic.write( buffer )
        #pic.close()
        #pb = pic.get_pixbuf()
        #del pic
        #arr = pb.get_pixels_array()
        #gobject.idle_add(self.send_to_ui, arr)
        #if (copy):
        #    arr = arr.copy()
                #print y
        pass
        return False
   
    def send_to_ui(self, arr = []):
        for row in arr:
            for pxl in row:
                y = 0.3*pxl[0][0]+0.59*pxl[1][0]+0.11*pxl[2][0]
                self.callable1(y)

    def get_avg_intensity(self):
        return self.avg_intensity
    
    def extractRGB( self, pb, data = None ):
        arr = pb.get_pixels_array()
        r = 0
        g = 0
        b = 0
        count  = 0
        for row in arr:
            for pxl in row:
                for j in range(0, len(arr[i])):
                    r+=arr[i][j][0][0]
                    g+=arr[i][j][1][0]
                    b+=arr[i][j][2][0]
        print r, g, b
        return r,g,b
        
    
    def get_avg(self, seq = []):
        """returns the average value of a sequence"""
        return sum(seq)/len(seq)
        
    def get_avg_intensity(self):
        return self.avg_intensity
   
"""
#Testing the class
cb = CameraGrab()
cb.start_pipeline()
gtk.gdk.threads_init()
gtk.main()
"""
