# -*- coding: utf-8 -*-
"""List of constants, generated from the Telepathy spec version 0.19.10

Copyright © 2005-2010 Collabora Limited
Copyright © 2005-2010 Nokia Corporation
Copyright © 2006 INdT


This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

"""

# Conn_Mgr_Param_Flags (bitfield/set of flags, 0 for none)
CONN_MGR_PARAM_FLAG_REQUIRED = 1
CONN_MGR_PARAM_FLAG_REGISTER = 2
CONN_MGR_PARAM_FLAG_HAS_DEFAULT = 4
CONN_MGR_PARAM_FLAG_SECRET = 8
CONN_MGR_PARAM_FLAG_DBUS_PROPERTY = 16


# Handle_Type
HANDLE_TYPE_NONE = 0
HANDLE_TYPE_CONTACT = 1
HANDLE_TYPE_ROOM = 2
HANDLE_TYPE_LIST = 3
HANDLE_TYPE_GROUP = 4
LAST_HANDLE_TYPE = 4
# Connection_Status
CONNECTION_STATUS_CONNECTED = 0
CONNECTION_STATUS_CONNECTING = 1
CONNECTION_STATUS_DISCONNECTED = 2
LAST_CONNECTION_STATUS = 2
# Connection_Status_Reason
CONNECTION_STATUS_REASON_NONE_SPECIFIED = 0
CONNECTION_STATUS_REASON_REQUESTED = 1
CONNECTION_STATUS_REASON_NETWORK_ERROR = 2
CONNECTION_STATUS_REASON_AUTHENTICATION_FAILED = 3
CONNECTION_STATUS_REASON_ENCRYPTION_ERROR = 4
CONNECTION_STATUS_REASON_NAME_IN_USE = 5
CONNECTION_STATUS_REASON_CERT_NOT_PROVIDED = 6
CONNECTION_STATUS_REASON_CERT_UNTRUSTED = 7
CONNECTION_STATUS_REASON_CERT_EXPIRED = 8
CONNECTION_STATUS_REASON_CERT_NOT_ACTIVATED = 9
CONNECTION_STATUS_REASON_CERT_HOSTNAME_MISMATCH = 10
CONNECTION_STATUS_REASON_CERT_FINGERPRINT_MISMATCH = 11
CONNECTION_STATUS_REASON_CERT_SELF_SIGNED = 12
CONNECTION_STATUS_REASON_CERT_OTHER_ERROR = 13
LAST_CONNECTION_STATUS_REASON = 13
# Connection_Alias_Flags (bitfield/set of flags, 0 for none)
CONNECTION_ALIAS_FLAG_USER_SET = 1


# Anonymity_Mode_Flags (bitfield/set of flags, 0 for none)
ANONYMITY_MODE_CLIENT_INFO = 1
ANONYMITY_MODE_SHOW_CLIENT_INFO = 2
ANONYMITY_MODE_NETWORK_INFO = 4


# Connection_Capability_Flags (bitfield/set of flags, 0 for none)
CONNECTION_CAPABILITY_FLAG_CREATE = 1
CONNECTION_CAPABILITY_FLAG_INVITE = 2


# Contact_Info_Flags (bitfield/set of flags, 0 for none)
CONTACT_INFO_FLAG_CAN_SET = 1
CONTACT_INFO_FLAG_PUSH = 2


# Contact_Info_Field_Flags (bitfield/set of flags, 0 for none)
CONTACT_INFO_FIELD_FLAG_PARAMETERS_EXACT = 1


# Presence_State
PRESENCE_STATE_NO = 0
PRESENCE_STATE_ASK = 1
PRESENCE_STATE_YES = 2
LAST_PRESENCE_STATE = 2
# Contact_Metadata_Storage_Type
CONTACT_METADATA_STORAGE_TYPE_NONE = 0
CONTACT_METADATA_STORAGE_TYPE_SUBSCRIBED_OR_PENDING = 1
CONTACT_METADATA_STORAGE_TYPE_SUBSCRIBED = 2
CONTACT_METADATA_STORAGE_TYPE_ANYONE = 3
LAST_CONTACT_METADATA_STORAGE_TYPE = 3
# Forwarding_Condition
FORWARDING_CONDITION_UNCONDITIONAL = 0
FORWARDING_CONDITION_BUSY = 1
FORWARDING_CONDITION_NO_REPLY = 2
FORWARDING_CONDITION_NOT_REACHABLE = 3
LAST_FORWARDING_CONDITION = 3
# Location_Features (bitfield/set of flags, 0 for none)
LOCATION_FEATURE_CAN_SET = 1


# Mail_Notification_Flags (bitfield/set of flags, 0 for none)
MAIL_NOTIFICATION_FLAG_SUPPORTS_UNREAD_MAIL_COUNT = 1
MAIL_NOTIFICATION_FLAG_SUPPORTS_UNREAD_MAILS = 2
MAIL_NOTIFICATION_FLAG_EMITS_MAILS_RECEIVED = 4
MAIL_NOTIFICATION_FLAG_SUPPORTS_REQUEST_INBOX_URL = 8
MAIL_NOTIFICATION_FLAG_SUPPORTS_REQUEST_MAIL_URL = 16
MAIL_NOTIFICATION_FLAG_THREAD_BASED = 32


# HTTP_Method
HTTP_METHOD_GET = 0
HTTP_METHOD_POST = 1
LAST_HTTP_METHOD = 1
# Service_Point_Type
SERVICE_POINT_TYPE_NONE = 0
SERVICE_POINT_TYPE_EMERGENCY = 1
SERVICE_POINT_TYPE_COUNSELING = 2
LAST_SERVICE_POINT_TYPE = 2
# Connection_Presence_Type
CONNECTION_PRESENCE_TYPE_UNSET = 0
CONNECTION_PRESENCE_TYPE_OFFLINE = 1
CONNECTION_PRESENCE_TYPE_AVAILABLE = 2
CONNECTION_PRESENCE_TYPE_AWAY = 3
CONNECTION_PRESENCE_TYPE_EXTENDED_AWAY = 4
CONNECTION_PRESENCE_TYPE_HIDDEN = 5
CONNECTION_PRESENCE_TYPE_BUSY = 6
CONNECTION_PRESENCE_TYPE_UNKNOWN = 7
CONNECTION_PRESENCE_TYPE_ERROR = 8
LAST_CONNECTION_PRESENCE_TYPE = 8
# Rich_Presence_Access_Control_Type
RICH_PRESENCE_ACCESS_CONTROL_TYPE_WHITELIST = 0
RICH_PRESENCE_ACCESS_CONTROL_TYPE_PUBLISH_LIST = 1
RICH_PRESENCE_ACCESS_CONTROL_TYPE_GROUP = 2
RICH_PRESENCE_ACCESS_CONTROL_TYPE_OPEN = 3
LAST_RICH_PRESENCE_ACCESS_CONTROL_TYPE = 3
# Call_State
CALL_STATE_UNKNOWN = 0
CALL_STATE_PENDING_INITIATOR = 1
CALL_STATE_PENDING_RECEIVER = 2
CALL_STATE_ACCEPTED = 3
CALL_STATE_ENDED = 4
LAST_CALL_STATE = 4
# Call_Flags (bitfield/set of flags, 0 for none)
CALL_FLAG_LOCALLY_RINGING = 1
CALL_FLAG_QUEUED = 2
CALL_FLAG_LOCALLY_HELD = 4
CALL_FLAG_FORWARDED = 8
CALL_FLAG_IN_PROGRESS = 16
CALL_FLAG_CLEARING = 32
CALL_FLAG_MUTED = 64


# Call_State_Change_Reason
CALL_STATE_CHANGE_REASON_UNKNOWN = 0
CALL_STATE_CHANGE_REASON_USER_REQUESTED = 1
CALL_STATE_CHANGE_REASON_FORWARDED = 2
LAST_CALL_STATE_CHANGE_REASON = 2
# Call_Member_Flags (bitfield/set of flags, 0 for none)
CALL_MEMBER_FLAG_RINGING = 1
CALL_MEMBER_FLAG_HELD = 2


# Channel_Contact_Search_State
CHANNEL_CONTACT_SEARCH_STATE_NOT_STARTED = 0
CHANNEL_CONTACT_SEARCH_STATE_IN_PROGRESS = 1
CHANNEL_CONTACT_SEARCH_STATE_MORE_AVAILABLE = 2
CHANNEL_CONTACT_SEARCH_STATE_COMPLETED = 3
CHANNEL_CONTACT_SEARCH_STATE_FAILED = 4
LAST_CHANNEL_CONTACT_SEARCH_STATE = 4
# File_Transfer_State
FILE_TRANSFER_STATE_NONE = 0
FILE_TRANSFER_STATE_PENDING = 1
FILE_TRANSFER_STATE_ACCEPTED = 2
FILE_TRANSFER_STATE_OPEN = 3
FILE_TRANSFER_STATE_COMPLETED = 4
FILE_TRANSFER_STATE_CANCELLED = 5
LAST_FILE_TRANSFER_STATE = 5
# File_Transfer_State_Change_Reason
FILE_TRANSFER_STATE_CHANGE_REASON_NONE = 0
FILE_TRANSFER_STATE_CHANGE_REASON_REQUESTED = 1
FILE_TRANSFER_STATE_CHANGE_REASON_LOCAL_STOPPED = 2
FILE_TRANSFER_STATE_CHANGE_REASON_REMOTE_STOPPED = 3
FILE_TRANSFER_STATE_CHANGE_REASON_LOCAL_ERROR = 4
FILE_TRANSFER_STATE_CHANGE_REASON_REMOTE_ERROR = 5
LAST_FILE_TRANSFER_STATE_CHANGE_REASON = 5
# File_Hash_Type
FILE_HASH_TYPE_NONE = 0
FILE_HASH_TYPE_MD5 = 1
FILE_HASH_TYPE_SHA1 = 2
FILE_HASH_TYPE_SHA256 = 3
LAST_FILE_HASH_TYPE = 3
# Media_Stream_Type
MEDIA_STREAM_TYPE_AUDIO = 0
MEDIA_STREAM_TYPE_VIDEO = 1
LAST_MEDIA_STREAM_TYPE = 1
# Media_Stream_State
MEDIA_STREAM_STATE_DISCONNECTED = 0
MEDIA_STREAM_STATE_CONNECTING = 1
MEDIA_STREAM_STATE_CONNECTED = 2
LAST_MEDIA_STREAM_STATE = 2
# Media_Stream_Direction
MEDIA_STREAM_DIRECTION_NONE = 0
MEDIA_STREAM_DIRECTION_SEND = 1
MEDIA_STREAM_DIRECTION_RECEIVE = 2
MEDIA_STREAM_DIRECTION_BIDIRECTIONAL = 3
LAST_MEDIA_STREAM_DIRECTION = 3
# Media_Stream_Pending_Send (bitfield/set of flags, 0 for none)
MEDIA_STREAM_PENDING_LOCAL_SEND = 1
MEDIA_STREAM_PENDING_REMOTE_SEND = 2


# Channel_Media_Capabilities (bitfield/set of flags, 0 for none)
CHANNEL_MEDIA_CAPABILITY_AUDIO = 1
CHANNEL_MEDIA_CAPABILITY_VIDEO = 2
CHANNEL_MEDIA_CAPABILITY_NAT_TRAVERSAL_STUN = 4
CHANNEL_MEDIA_CAPABILITY_NAT_TRAVERSAL_GTALK_P2P = 8
CHANNEL_MEDIA_CAPABILITY_NAT_TRAVERSAL_ICE_UDP = 16
CHANNEL_MEDIA_CAPABILITY_IMMUTABLE_STREAMS = 32


# Channel_Text_Send_Error
CHANNEL_TEXT_SEND_ERROR_UNKNOWN = 0
CHANNEL_TEXT_SEND_ERROR_OFFLINE = 1
CHANNEL_TEXT_SEND_ERROR_INVALID_CONTACT = 2
CHANNEL_TEXT_SEND_ERROR_PERMISSION_DENIED = 3
CHANNEL_TEXT_SEND_ERROR_TOO_LONG = 4
CHANNEL_TEXT_SEND_ERROR_NOT_IMPLEMENTED = 5
LAST_CHANNEL_TEXT_SEND_ERROR = 5
# Channel_Text_Message_Type
CHANNEL_TEXT_MESSAGE_TYPE_NORMAL = 0
CHANNEL_TEXT_MESSAGE_TYPE_ACTION = 1
CHANNEL_TEXT_MESSAGE_TYPE_NOTICE = 2
CHANNEL_TEXT_MESSAGE_TYPE_AUTO_REPLY = 3
CHANNEL_TEXT_MESSAGE_TYPE_DELIVERY_REPORT = 4
LAST_CHANNEL_TEXT_MESSAGE_TYPE = 4
# Channel_Text_Message_Flags (bitfield/set of flags, 0 for none)
CHANNEL_TEXT_MESSAGE_FLAG_TRUNCATED = 1
CHANNEL_TEXT_MESSAGE_FLAG_NON_TEXT_CONTENT = 2
CHANNEL_TEXT_MESSAGE_FLAG_SCROLLBACK = 4
CHANNEL_TEXT_MESSAGE_FLAG_RESCUED = 8


# Tube_Type
TUBE_TYPE_DBUS = 0
TUBE_TYPE_STREAM = 1
LAST_TUBE_TYPE = 1
# Tube_State
TUBE_STATE_LOCAL_PENDING = 0
TUBE_STATE_REMOTE_PENDING = 1
TUBE_STATE_OPEN = 2
LAST_TUBE_STATE = 2
# Channel_Call_State_Flags (bitfield/set of flags, 0 for none)
CHANNEL_CALL_STATE_RINGING = 1
CHANNEL_CALL_STATE_QUEUED = 2
CHANNEL_CALL_STATE_HELD = 4
CHANNEL_CALL_STATE_FORWARDED = 8
CHANNEL_CALL_STATE_IN_PROGRESS = 16


# Channel_Chat_State
CHANNEL_CHAT_STATE_GONE = 0
CHANNEL_CHAT_STATE_INACTIVE = 1
CHANNEL_CHAT_STATE_ACTIVE = 2
CHANNEL_CHAT_STATE_PAUSED = 3
CHANNEL_CHAT_STATE_COMPOSING = 4
LAST_CHANNEL_CHAT_STATE = 4
# DTMF_Event
DTMF_EVENT_DIGIT_0 = 0
DTMF_EVENT_DIGIT_1 = 1
DTMF_EVENT_DIGIT_2 = 2
DTMF_EVENT_DIGIT_3 = 3
DTMF_EVENT_DIGIT_4 = 4
DTMF_EVENT_DIGIT_5 = 5
DTMF_EVENT_DIGIT_6 = 6
DTMF_EVENT_DIGIT_7 = 7
DTMF_EVENT_DIGIT_8 = 8
DTMF_EVENT_DIGIT_9 = 9
DTMF_EVENT_ASTERISK = 10
DTMF_EVENT_HASH = 11
DTMF_EVENT_LETTER_A = 12
DTMF_EVENT_LETTER_B = 13
DTMF_EVENT_LETTER_C = 14
DTMF_EVENT_LETTER_D = 15
LAST_DTMF_EVENT = 15
# Channel_Group_Flags (bitfield/set of flags, 0 for none)
CHANNEL_GROUP_FLAG_CAN_ADD = 1
CHANNEL_GROUP_FLAG_CAN_REMOVE = 2
CHANNEL_GROUP_FLAG_CAN_RESCIND = 4
CHANNEL_GROUP_FLAG_MESSAGE_ADD = 8
CHANNEL_GROUP_FLAG_MESSAGE_REMOVE = 16
CHANNEL_GROUP_FLAG_MESSAGE_ACCEPT = 32
CHANNEL_GROUP_FLAG_MESSAGE_REJECT = 64
CHANNEL_GROUP_FLAG_MESSAGE_RESCIND = 128
CHANNEL_GROUP_FLAG_CHANNEL_SPECIFIC_HANDLES = 256
CHANNEL_GROUP_FLAG_ONLY_ONE_GROUP = 512
CHANNEL_GROUP_FLAG_HANDLE_OWNERS_NOT_AVAILABLE = 1024
CHANNEL_GROUP_FLAG_PROPERTIES = 2048
CHANNEL_GROUP_FLAG_MEMBERS_CHANGED_DETAILED = 4096
CHANNEL_GROUP_FLAG_MESSAGE_DEPART = 8192


# Channel_Group_Change_Reason
CHANNEL_GROUP_CHANGE_REASON_NONE = 0
CHANNEL_GROUP_CHANGE_REASON_OFFLINE = 1
CHANNEL_GROUP_CHANGE_REASON_KICKED = 2
CHANNEL_GROUP_CHANGE_REASON_BUSY = 3
CHANNEL_GROUP_CHANGE_REASON_INVITED = 4
CHANNEL_GROUP_CHANGE_REASON_BANNED = 5
CHANNEL_GROUP_CHANGE_REASON_ERROR = 6
CHANNEL_GROUP_CHANGE_REASON_INVALID_CONTACT = 7
CHANNEL_GROUP_CHANGE_REASON_NO_ANSWER = 8
CHANNEL_GROUP_CHANGE_REASON_RENAMED = 9
CHANNEL_GROUP_CHANGE_REASON_PERMISSION_DENIED = 10
CHANNEL_GROUP_CHANGE_REASON_SEPARATED = 11
LAST_CHANNEL_GROUP_CHANGE_REASON = 11
# Local_Hold_State
LOCAL_HOLD_STATE_UNHELD = 0
LOCAL_HOLD_STATE_HELD = 1
LOCAL_HOLD_STATE_PENDING_HOLD = 2
LOCAL_HOLD_STATE_PENDING_UNHOLD = 3
LAST_LOCAL_HOLD_STATE = 3
# Local_Hold_State_Reason
LOCAL_HOLD_STATE_REASON_NONE = 0
LOCAL_HOLD_STATE_REASON_REQUESTED = 1
LOCAL_HOLD_STATE_REASON_RESOURCE_NOT_AVAILABLE = 2
LAST_LOCAL_HOLD_STATE_REASON = 2
# Message_Part_Support_Flags (bitfield/set of flags, 0 for none)
MESSAGE_PART_SUPPORT_FLAG_ONE_ATTACHMENT = 1
MESSAGE_PART_SUPPORT_FLAG_MULTIPLE_ATTACHMENTS = 2


# Message_Sending_Flags (bitfield/set of flags, 0 for none)
MESSAGE_SENDING_FLAG_REPORT_DELIVERY = 1
MESSAGE_SENDING_FLAG_REPORT_READ = 2
MESSAGE_SENDING_FLAG_REPORT_DELETED = 4


# Delivery_Status
DELIVERY_STATUS_UNKNOWN = 0
DELIVERY_STATUS_DELIVERED = 1
DELIVERY_STATUS_TEMPORARILY_FAILED = 2
DELIVERY_STATUS_PERMANENTLY_FAILED = 3
DELIVERY_STATUS_ACCEPTED = 4
DELIVERY_STATUS_READ = 5
DELIVERY_STATUS_DELETED = 6
LAST_DELIVERY_STATUS = 6
# Delivery_Reporting_Support_Flags (bitfield/set of flags, 0 for none)
DELIVERY_REPORTING_SUPPORT_FLAG_RECEIVE_FAILURES = 1
DELIVERY_REPORTING_SUPPORT_FLAG_RECEIVE_SUCCESSES = 2
DELIVERY_REPORTING_SUPPORT_FLAG_RECEIVE_READ = 4
DELIVERY_REPORTING_SUPPORT_FLAG_RECEIVE_DELETED = 8


# Channel_Password_Flags (bitfield/set of flags, 0 for none)
CHANNEL_PASSWORD_FLAG_PROVIDE = 8


# Tube_Channel_State
TUBE_CHANNEL_STATE_LOCAL_PENDING = 0
TUBE_CHANNEL_STATE_REMOTE_PENDING = 1
TUBE_CHANNEL_STATE_OPEN = 2
TUBE_CHANNEL_STATE_NOT_OFFERED = 3
LAST_TUBE_CHANNEL_STATE = 3
# Socket_Address_Type
SOCKET_ADDRESS_TYPE_UNIX = 0
SOCKET_ADDRESS_TYPE_ABSTRACT_UNIX = 1
SOCKET_ADDRESS_TYPE_IPV4 = 2
SOCKET_ADDRESS_TYPE_IPV6 = 3
LAST_SOCKET_ADDRESS_TYPE = 3
# Socket_Access_Control
SOCKET_ACCESS_CONTROL_LOCALHOST = 0
SOCKET_ACCESS_CONTROL_PORT = 1
SOCKET_ACCESS_CONTROL_NETMASK = 2
SOCKET_ACCESS_CONTROL_CREDENTIALS = 3
LAST_SOCKET_ACCESS_CONTROL = 3
# Media_Stream_Error
MEDIA_STREAM_ERROR_UNKNOWN = 0
MEDIA_STREAM_ERROR_EOS = 1
MEDIA_STREAM_ERROR_CODEC_NEGOTIATION_FAILED = 2
MEDIA_STREAM_ERROR_CONNECTION_FAILED = 3
MEDIA_STREAM_ERROR_NETWORK_ERROR = 4
MEDIA_STREAM_ERROR_NO_CODECS = 5
MEDIA_STREAM_ERROR_INVALID_CM_BEHAVIOR = 6
MEDIA_STREAM_ERROR_MEDIA_ERROR = 7
LAST_MEDIA_STREAM_ERROR = 7
# Media_Stream_Base_Proto
MEDIA_STREAM_BASE_PROTO_UDP = 0
MEDIA_STREAM_BASE_PROTO_TCP = 1
LAST_MEDIA_STREAM_BASE_PROTO = 1
# Media_Stream_Transport_Type
MEDIA_STREAM_TRANSPORT_TYPE_LOCAL = 0
MEDIA_STREAM_TRANSPORT_TYPE_DERIVED = 1
MEDIA_STREAM_TRANSPORT_TYPE_RELAY = 2
LAST_MEDIA_STREAM_TRANSPORT_TYPE = 2
# Call_Content_Disposition
CALL_CONTENT_DISPOSITION_NONE = 0
CALL_CONTENT_DISPOSITION_EARLY_MEDIA = 1
CALL_CONTENT_DISPOSITION_INITIAL = 2
LAST_CALL_CONTENT_DISPOSITION = 2
# Sending_State
SENDING_STATE_NONE = 0
SENDING_STATE_PENDING_SEND = 1
SENDING_STATE_SENDING = 2
LAST_SENDING_STATE = 2
# Stream_Transport_Type
STREAM_TRANSPORT_TYPE_RAW_UDP = 0
STREAM_TRANSPORT_TYPE_ICE = 1
STREAM_TRANSPORT_TYPE_GTALK_P2P = 2
STREAM_TRANSPORT_TYPE_WLM_8_5 = 3
STREAM_TRANSPORT_TYPE_WLM_2009 = 4
LAST_STREAM_TRANSPORT_TYPE = 4
# Debug_Level
DEBUG_LEVEL_ERROR = 0
DEBUG_LEVEL_CRITICAL = 1
DEBUG_LEVEL_WARNING = 2
DEBUG_LEVEL_MESSAGE = 3
DEBUG_LEVEL_INFO = 4
DEBUG_LEVEL_DEBUG = 5
LAST_DEBUG_LEVEL = 5
# Storage_Restriction_Flags (bitfield/set of flags, 0 for none)
STORAGE_RESTRICTION_FLAG_CANNOT_SET_PARAMETERS = 1
STORAGE_RESTRICTION_FLAG_CANNOT_SET_ENABLED = 2
STORAGE_RESTRICTION_FLAG_CANNOT_SET_PRESENCE = 4
STORAGE_RESTRICTION_FLAG_CANNOT_SET_SERVICE = 8


# Property_Flags (bitfield/set of flags, 0 for none)
PROPERTY_FLAG_READ = 1
PROPERTY_FLAG_WRITE = 2

