#include "_gen/svc-Channel_Request_Future.h"

#include <telepathy-glib/dbus.h>
#include "_gen/signals-marshal.h"

static const DBusGObjectInfo _mc_svc_channel_request_future_object_info;

struct _McSvcChannelRequestFutureClass {
    GTypeInterface parent_class;
};

enum {
    SIGNAL_CHANNEL_REQUEST_FUTURE_SucceededWithChannel,
    N_CHANNEL_REQUEST_FUTURE_SIGNALS
};
static guint channel_request_future_signals[N_CHANNEL_REQUEST_FUTURE_SIGNALS] = {0};

static void mc_svc_channel_request_future_base_init (gpointer klass);

GType
mc_svc_channel_request_future_get_type (void)
{
  static GType type = 0;

  if (G_UNLIKELY (type == 0))
    {
      static const GTypeInfo info = {
        sizeof (McSvcChannelRequestFutureClass),
        mc_svc_channel_request_future_base_init, /* base_init */
        NULL, /* base_finalize */
        NULL, /* class_init */
        NULL, /* class_finalize */
        NULL, /* class_data */
        0,
        0, /* n_preallocs */
        NULL /* instance_init */
      };

      type = g_type_register_static (G_TYPE_INTERFACE,
          "McSvcChannelRequestFuture", &info, 0);
    }

  return type;
}

/**
 * mc_svc_channel_request_future_emit_succeeded_with_channel:
 * @instance: The object implementing this interface
 * @arg_Connection: const gchar * (FIXME, generate documentation)
 * @arg_Channel: const gchar * (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * SucceededWithChannel signal on interface org.freedesktop.Telepathy.ChannelRequest.FUTURE.
 */
void
mc_svc_channel_request_future_emit_succeeded_with_channel (gpointer instance,
    const gchar *arg_Connection,
    const gchar *arg_Channel)
{
  g_assert (instance != NULL);
  g_assert (G_TYPE_CHECK_INSTANCE_TYPE (instance, MC_TYPE_SVC_CHANNEL_REQUEST_FUTURE));
  g_signal_emit (instance,
      channel_request_future_signals[SIGNAL_CHANNEL_REQUEST_FUTURE_SucceededWithChannel],
      0,
      arg_Connection,
      arg_Channel);
}

static inline void
mc_svc_channel_request_future_base_init_once (gpointer klass G_GNUC_UNUSED)
{
  static TpDBusPropertiesMixinPropInfo properties[2] = {
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "a{sv}", 0, NULL, NULL }, /* Hints */
      { 0, 0, NULL, 0, NULL, NULL }
  };
  static TpDBusPropertiesMixinIfaceInfo interface =
      { 0, properties, NULL, NULL };

  dbus_g_object_type_install_info (mc_svc_channel_request_future_get_type (),
      &_mc_svc_channel_request_future_object_info);

  interface.dbus_interface = g_quark_from_static_string ("org.freedesktop.Telepathy.ChannelRequest.FUTURE");
  properties[0].name = g_quark_from_static_string ("Hints");
  properties[0].type = (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE));
  tp_svc_interface_set_dbus_properties_info (MC_TYPE_SVC_CHANNEL_REQUEST_FUTURE, &interface);

  /**
   * McSvcChannelRequestFuture::succeeded-with-channel:
   * @arg_Connection: const gchar * (FIXME, generate documentation)
   * @arg_Channel: const gchar * (FIXME, generate documentation)
   *
   * The SucceededWithChannel D-Bus signal is emitted whenever this GObject signal is.
   */
  channel_request_future_signals[SIGNAL_CHANNEL_REQUEST_FUTURE_SucceededWithChannel] =
  g_signal_new ("succeeded-with-channel",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST|G_SIGNAL_DETAILED,
      0,
      NULL, NULL,
      _mcd_ext_marshal_VOID__BOXED_BOXED,
      G_TYPE_NONE,
      2,
      DBUS_TYPE_G_OBJECT_PATH,
      DBUS_TYPE_G_OBJECT_PATH);

}
static void
mc_svc_channel_request_future_base_init (gpointer klass)
{
  static gboolean initialized = FALSE;

  if (!initialized)
    {
      initialized = TRUE;
      mc_svc_channel_request_future_base_init_once (klass);
    }
}
static const DBusGMethodInfo _mc_svc_channel_request_future_methods[] = {
  { NULL, NULL, 0 }
};

static const DBusGObjectInfo _mc_svc_channel_request_future_object_info = {
  0,
  _mc_svc_channel_request_future_methods,
  0,
"\0",
"org.freedesktop.Telepathy.ChannelRequest.FUTURE\0SucceededWithChannel\0\0",
"\0\0",
};


