#include "_gen/svc-Account_Interface_Compat.h"

#include <telepathy-glib/dbus.h>
#include "_gen/signals-marshal.h"

static const DBusGObjectInfo _mc_svc_account_interface_compat_object_info;

struct _McSvcAccountInterfaceCompatClass {
    GTypeInterface parent_class;
    mc_svc_account_interface_compat_set_has_been_online_impl set_has_been_online;
};

enum {
    SIGNAL_ACCOUNT_INTERFACE_COMPAT_CompatPropertyChanged,
    N_ACCOUNT_INTERFACE_COMPAT_SIGNALS
};
static guint account_interface_compat_signals[N_ACCOUNT_INTERFACE_COMPAT_SIGNALS] = {0};

static void mc_svc_account_interface_compat_base_init (gpointer klass);

GType
mc_svc_account_interface_compat_get_type (void)
{
  static GType type = 0;

  if (G_UNLIKELY (type == 0))
    {
      static const GTypeInfo info = {
        sizeof (McSvcAccountInterfaceCompatClass),
        mc_svc_account_interface_compat_base_init, /* base_init */
        NULL, /* base_finalize */
        NULL, /* class_init */
        NULL, /* class_finalize */
        NULL, /* class_data */
        0,
        0, /* n_preallocs */
        NULL /* instance_init */
      };

      type = g_type_register_static (G_TYPE_INTERFACE,
          "McSvcAccountInterfaceCompat", &info, 0);
    }

  return type;
}

/**
 * mc_svc_account_interface_compat_set_has_been_online_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * SetHasBeenOnline on interface com.nokia.Account.Interface.Compat.
 */
static void
mc_svc_account_interface_compat_set_has_been_online (McSvcAccountInterfaceCompat *self,
    DBusGMethodInvocation *context)
{
  mc_svc_account_interface_compat_set_has_been_online_impl impl = (MC_SVC_ACCOUNT_INTERFACE_COMPAT_GET_CLASS (self)->set_has_been_online);

  if (impl != NULL)
    {
      (impl) (self,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

/**
 * mc_svc_account_interface_compat_implement_set_has_been_online:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the SetHasBeenOnline D-Bus method
 *
 * Register an implementation for the SetHasBeenOnline method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
mc_svc_account_interface_compat_implement_set_has_been_online (McSvcAccountInterfaceCompatClass *klass, mc_svc_account_interface_compat_set_has_been_online_impl impl)
{
  klass->set_has_been_online = impl;
}

/**
 * mc_svc_account_interface_compat_emit_compat_property_changed:
 * @instance: The object implementing this interface
 * @arg_Properties: GHashTable * (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * CompatPropertyChanged signal on interface com.nokia.Account.Interface.Compat.
 */
void
mc_svc_account_interface_compat_emit_compat_property_changed (gpointer instance,
    GHashTable *arg_Properties)
{
  g_assert (instance != NULL);
  g_assert (G_TYPE_CHECK_INSTANCE_TYPE (instance, MC_TYPE_SVC_ACCOUNT_INTERFACE_COMPAT));
  g_signal_emit (instance,
      account_interface_compat_signals[SIGNAL_ACCOUNT_INTERFACE_COMPAT_CompatPropertyChanged],
      0,
      arg_Properties);
}

static inline void
mc_svc_account_interface_compat_base_init_once (gpointer klass G_GNUC_UNUSED)
{
  static TpDBusPropertiesMixinPropInfo properties[4] = {
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ | TP_DBUS_PROPERTIES_MIXIN_FLAG_WRITE, "s", 0, NULL, NULL }, /* Profile */
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "s", 0, NULL, NULL }, /* AvatarFile */
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ | TP_DBUS_PROPERTIES_MIXIN_FLAG_WRITE, "as", 0, NULL, NULL }, /* SecondaryVCardFields */
      { 0, 0, NULL, 0, NULL, NULL }
  };
  static TpDBusPropertiesMixinIfaceInfo interface =
      { 0, properties, NULL, NULL };

  dbus_g_object_type_install_info (mc_svc_account_interface_compat_get_type (),
      &_mc_svc_account_interface_compat_object_info);

  interface.dbus_interface = g_quark_from_static_string ("com.nokia.Account.Interface.Compat");
  properties[0].name = g_quark_from_static_string ("Profile");
  properties[0].type = G_TYPE_STRING;
  properties[1].name = g_quark_from_static_string ("AvatarFile");
  properties[1].type = G_TYPE_STRING;
  properties[2].name = g_quark_from_static_string ("SecondaryVCardFields");
  properties[2].type = G_TYPE_STRV;
  tp_svc_interface_set_dbus_properties_info (MC_TYPE_SVC_ACCOUNT_INTERFACE_COMPAT, &interface);

  /**
   * McSvcAccountInterfaceCompat::compat-property-changed:
   * @arg_Properties: GHashTable * (FIXME, generate documentation)
   *
   * The CompatPropertyChanged D-Bus signal is emitted whenever this GObject signal is.
   */
  account_interface_compat_signals[SIGNAL_ACCOUNT_INTERFACE_COMPAT_CompatPropertyChanged] =
  g_signal_new ("compat-property-changed",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST|G_SIGNAL_DETAILED,
      0,
      NULL, NULL,
      g_cclosure_marshal_VOID__BOXED,
      G_TYPE_NONE,
      1,
      (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)));

}
static void
mc_svc_account_interface_compat_base_init (gpointer klass)
{
  static gboolean initialized = FALSE;

  if (!initialized)
    {
      initialized = TRUE;
      mc_svc_account_interface_compat_base_init_once (klass);
    }
}
static const DBusGMethodInfo _mc_svc_account_interface_compat_methods[] = {
  { (GCallback) mc_svc_account_interface_compat_set_has_been_online, g_cclosure_marshal_VOID__POINTER, 0 },
};

static const DBusGObjectInfo _mc_svc_account_interface_compat_object_info = {
  0,
  _mc_svc_account_interface_compat_methods,
  1,
"com.nokia.Account.Interface.Compat\0SetHasBeenOnline\0A\0\0\0",
"com.nokia.Account.Interface.Compat\0CompatPropertyChanged\0\0",
"\0\0",
};


