{
  GEnumClass *klass;
  GEnumValue *value_by_name;
  GEnumValue *value_by_nick;

  g_type_init ();
  klass = g_type_class_ref (TP_TYPE_ERROR);

  /* org.freedesktop.Telepathy.Error.NetworkError */
  value_by_name = g_enum_get_value_by_name (klass, "TP_ERROR_NETWORK_ERROR");
  value_by_nick = g_enum_get_value_by_nick (klass, "NetworkError");
  g_assert (value_by_name != NULL);
  g_assert (value_by_nick != NULL);
  g_assert_cmpint (value_by_name->value, ==, TP_ERROR_NETWORK_ERROR);
  g_assert_cmpint (value_by_nick->value, ==, TP_ERROR_NETWORK_ERROR);
  g_assert_cmpstr (value_by_name->value_name, ==, "TP_ERROR_NETWORK_ERROR");
  g_assert_cmpstr (value_by_nick->value_name, ==, "TP_ERROR_NETWORK_ERROR");
  g_assert_cmpstr (value_by_name->value_nick, ==, "NetworkError");
  g_assert_cmpstr (value_by_nick->value_nick, ==, "NetworkError");
  g_assert_cmpstr (TP_ERROR_STR_NETWORK_ERROR, ==, TP_ERROR_PREFIX ".NetworkError");

  /* org.freedesktop.Telepathy.Error.NotImplemented */
  value_by_name = g_enum_get_value_by_name (klass, "TP_ERROR_NOT_IMPLEMENTED");
  value_by_nick = g_enum_get_value_by_nick (klass, "NotImplemented");
  g_assert (value_by_name != NULL);
  g_assert (value_by_nick != NULL);
  g_assert_cmpint (value_by_name->value, ==, TP_ERROR_NOT_IMPLEMENTED);
  g_assert_cmpint (value_by_nick->value, ==, TP_ERROR_NOT_IMPLEMENTED);
  g_assert_cmpstr (value_by_name->value_name, ==, "TP_ERROR_NOT_IMPLEMENTED");
  g_assert_cmpstr (value_by_nick->value_name, ==, "TP_ERROR_NOT_IMPLEMENTED");
  g_assert_cmpstr (value_by_name->value_nick, ==, "NotImplemented");
  g_assert_cmpstr (value_by_nick->value_nick, ==, "NotImplemented");
  g_assert_cmpstr (TP_ERROR_STR_NOT_IMPLEMENTED, ==, TP_ERROR_PREFIX ".NotImplemented");

  /* org.freedesktop.Telepathy.Error.InvalidArgument */
  value_by_name = g_enum_get_value_by_name (klass, "TP_ERROR_INVALID_ARGUMENT");
  value_by_nick = g_enum_get_value_by_nick (klass, "InvalidArgument");
  g_assert (value_by_name != NULL);
  g_assert (value_by_nick != NULL);
  g_assert_cmpint (value_by_name->value, ==, TP_ERROR_INVALID_ARGUMENT);
  g_assert_cmpint (value_by_nick->value, ==, TP_ERROR_INVALID_ARGUMENT);
  g_assert_cmpstr (value_by_name->value_name, ==, "TP_ERROR_INVALID_ARGUMENT");
  g_assert_cmpstr (value_by_nick->value_name, ==, "TP_ERROR_INVALID_ARGUMENT");
  g_assert_cmpstr (value_by_name->value_nick, ==, "InvalidArgument");
  g_assert_cmpstr (value_by_nick->value_nick, ==, "InvalidArgument");
  g_assert_cmpstr (TP_ERROR_STR_INVALID_ARGUMENT, ==, TP_ERROR_PREFIX ".InvalidArgument");

  /* org.freedesktop.Telepathy.Error.NotAvailable */
  value_by_name = g_enum_get_value_by_name (klass, "TP_ERROR_NOT_AVAILABLE");
  value_by_nick = g_enum_get_value_by_nick (klass, "NotAvailable");
  g_assert (value_by_name != NULL);
  g_assert (value_by_nick != NULL);
  g_assert_cmpint (value_by_name->value, ==, TP_ERROR_NOT_AVAILABLE);
  g_assert_cmpint (value_by_nick->value, ==, TP_ERROR_NOT_AVAILABLE);
  g_assert_cmpstr (value_by_name->value_name, ==, "TP_ERROR_NOT_AVAILABLE");
  g_assert_cmpstr (value_by_nick->value_name, ==, "TP_ERROR_NOT_AVAILABLE");
  g_assert_cmpstr (value_by_name->value_nick, ==, "NotAvailable");
  g_assert_cmpstr (value_by_nick->value_nick, ==, "NotAvailable");
  g_assert_cmpstr (TP_ERROR_STR_NOT_AVAILABLE, ==, TP_ERROR_PREFIX ".NotAvailable");

  /* org.freedesktop.Telepathy.Error.PermissionDenied */
  value_by_name = g_enum_get_value_by_name (klass, "TP_ERROR_PERMISSION_DENIED");
  value_by_nick = g_enum_get_value_by_nick (klass, "PermissionDenied");
  g_assert (value_by_name != NULL);
  g_assert (value_by_nick != NULL);
  g_assert_cmpint (value_by_name->value, ==, TP_ERROR_PERMISSION_DENIED);
  g_assert_cmpint (value_by_nick->value, ==, TP_ERROR_PERMISSION_DENIED);
  g_assert_cmpstr (value_by_name->value_name, ==, "TP_ERROR_PERMISSION_DENIED");
  g_assert_cmpstr (value_by_nick->value_name, ==, "TP_ERROR_PERMISSION_DENIED");
  g_assert_cmpstr (value_by_name->value_nick, ==, "PermissionDenied");
  g_assert_cmpstr (value_by_nick->value_nick, ==, "PermissionDenied");
  g_assert_cmpstr (TP_ERROR_STR_PERMISSION_DENIED, ==, TP_ERROR_PREFIX ".PermissionDenied");

  /* org.freedesktop.Telepathy.Error.Disconnected */
  value_by_name = g_enum_get_value_by_name (klass, "TP_ERROR_DISCONNECTED");
  value_by_nick = g_enum_get_value_by_nick (klass, "Disconnected");
  g_assert (value_by_name != NULL);
  g_assert (value_by_nick != NULL);
  g_assert_cmpint (value_by_name->value, ==, TP_ERROR_DISCONNECTED);
  g_assert_cmpint (value_by_nick->value, ==, TP_ERROR_DISCONNECTED);
  g_assert_cmpstr (value_by_name->value_name, ==, "TP_ERROR_DISCONNECTED");
  g_assert_cmpstr (value_by_nick->value_name, ==, "TP_ERROR_DISCONNECTED");
  g_assert_cmpstr (value_by_name->value_nick, ==, "Disconnected");
  g_assert_cmpstr (value_by_nick->value_nick, ==, "Disconnected");
  g_assert_cmpstr (TP_ERROR_STR_DISCONNECTED, ==, TP_ERROR_PREFIX ".Disconnected");

  /* org.freedesktop.Telepathy.Error.InvalidHandle */
  value_by_name = g_enum_get_value_by_name (klass, "TP_ERROR_INVALID_HANDLE");
  value_by_nick = g_enum_get_value_by_nick (klass, "InvalidHandle");
  g_assert (value_by_name != NULL);
  g_assert (value_by_nick != NULL);
  g_assert_cmpint (value_by_name->value, ==, TP_ERROR_INVALID_HANDLE);
  g_assert_cmpint (value_by_nick->value, ==, TP_ERROR_INVALID_HANDLE);
  g_assert_cmpstr (value_by_name->value_name, ==, "TP_ERROR_INVALID_HANDLE");
  g_assert_cmpstr (value_by_nick->value_name, ==, "TP_ERROR_INVALID_HANDLE");
  g_assert_cmpstr (value_by_name->value_nick, ==, "InvalidHandle");
  g_assert_cmpstr (value_by_nick->value_nick, ==, "InvalidHandle");
  g_assert_cmpstr (TP_ERROR_STR_INVALID_HANDLE, ==, TP_ERROR_PREFIX ".InvalidHandle");

  /* org.freedesktop.Telepathy.Error.Channel.Banned */
  value_by_name = g_enum_get_value_by_name (klass, "TP_ERROR_CHANNEL_BANNED");
  value_by_nick = g_enum_get_value_by_nick (klass, "Channel.Banned");
  g_assert (value_by_name != NULL);
  g_assert (value_by_nick != NULL);
  g_assert_cmpint (value_by_name->value, ==, TP_ERROR_CHANNEL_BANNED);
  g_assert_cmpint (value_by_nick->value, ==, TP_ERROR_CHANNEL_BANNED);
  g_assert_cmpstr (value_by_name->value_name, ==, "TP_ERROR_CHANNEL_BANNED");
  g_assert_cmpstr (value_by_nick->value_name, ==, "TP_ERROR_CHANNEL_BANNED");
  g_assert_cmpstr (value_by_name->value_nick, ==, "Channel.Banned");
  g_assert_cmpstr (value_by_nick->value_nick, ==, "Channel.Banned");
  g_assert_cmpstr (TP_ERROR_STR_CHANNEL_BANNED, ==, TP_ERROR_PREFIX ".Channel.Banned");

  /* org.freedesktop.Telepathy.Error.Channel.Full */
  value_by_name = g_enum_get_value_by_name (klass, "TP_ERROR_CHANNEL_FULL");
  value_by_nick = g_enum_get_value_by_nick (klass, "Channel.Full");
  g_assert (value_by_name != NULL);
  g_assert (value_by_nick != NULL);
  g_assert_cmpint (value_by_name->value, ==, TP_ERROR_CHANNEL_FULL);
  g_assert_cmpint (value_by_nick->value, ==, TP_ERROR_CHANNEL_FULL);
  g_assert_cmpstr (value_by_name->value_name, ==, "TP_ERROR_CHANNEL_FULL");
  g_assert_cmpstr (value_by_nick->value_name, ==, "TP_ERROR_CHANNEL_FULL");
  g_assert_cmpstr (value_by_name->value_nick, ==, "Channel.Full");
  g_assert_cmpstr (value_by_nick->value_nick, ==, "Channel.Full");
  g_assert_cmpstr (TP_ERROR_STR_CHANNEL_FULL, ==, TP_ERROR_PREFIX ".Channel.Full");

  /* org.freedesktop.Telepathy.Error.Channel.InviteOnly */
  value_by_name = g_enum_get_value_by_name (klass, "TP_ERROR_CHANNEL_INVITE_ONLY");
  value_by_nick = g_enum_get_value_by_nick (klass, "Channel.InviteOnly");
  g_assert (value_by_name != NULL);
  g_assert (value_by_nick != NULL);
  g_assert_cmpint (value_by_name->value, ==, TP_ERROR_CHANNEL_INVITE_ONLY);
  g_assert_cmpint (value_by_nick->value, ==, TP_ERROR_CHANNEL_INVITE_ONLY);
  g_assert_cmpstr (value_by_name->value_name, ==, "TP_ERROR_CHANNEL_INVITE_ONLY");
  g_assert_cmpstr (value_by_nick->value_name, ==, "TP_ERROR_CHANNEL_INVITE_ONLY");
  g_assert_cmpstr (value_by_name->value_nick, ==, "Channel.InviteOnly");
  g_assert_cmpstr (value_by_nick->value_nick, ==, "Channel.InviteOnly");
  g_assert_cmpstr (TP_ERROR_STR_CHANNEL_INVITE_ONLY, ==, TP_ERROR_PREFIX ".Channel.InviteOnly");

  /* org.freedesktop.Telepathy.Error.NotYours */
  value_by_name = g_enum_get_value_by_name (klass, "TP_ERROR_NOT_YOURS");
  value_by_nick = g_enum_get_value_by_nick (klass, "NotYours");
  g_assert (value_by_name != NULL);
  g_assert (value_by_nick != NULL);
  g_assert_cmpint (value_by_name->value, ==, TP_ERROR_NOT_YOURS);
  g_assert_cmpint (value_by_nick->value, ==, TP_ERROR_NOT_YOURS);
  g_assert_cmpstr (value_by_name->value_name, ==, "TP_ERROR_NOT_YOURS");
  g_assert_cmpstr (value_by_nick->value_name, ==, "TP_ERROR_NOT_YOURS");
  g_assert_cmpstr (value_by_name->value_nick, ==, "NotYours");
  g_assert_cmpstr (value_by_nick->value_nick, ==, "NotYours");
  g_assert_cmpstr (TP_ERROR_STR_NOT_YOURS, ==, TP_ERROR_PREFIX ".NotYours");

  /* org.freedesktop.Telepathy.Error.Cancelled */
  value_by_name = g_enum_get_value_by_name (klass, "TP_ERROR_CANCELLED");
  value_by_nick = g_enum_get_value_by_nick (klass, "Cancelled");
  g_assert (value_by_name != NULL);
  g_assert (value_by_nick != NULL);
  g_assert_cmpint (value_by_name->value, ==, TP_ERROR_CANCELLED);
  g_assert_cmpint (value_by_nick->value, ==, TP_ERROR_CANCELLED);
  g_assert_cmpstr (value_by_name->value_name, ==, "TP_ERROR_CANCELLED");
  g_assert_cmpstr (value_by_nick->value_name, ==, "TP_ERROR_CANCELLED");
  g_assert_cmpstr (value_by_name->value_nick, ==, "Cancelled");
  g_assert_cmpstr (value_by_nick->value_nick, ==, "Cancelled");
  g_assert_cmpstr (TP_ERROR_STR_CANCELLED, ==, TP_ERROR_PREFIX ".Cancelled");

  /* org.freedesktop.Telepathy.Error.AuthenticationFailed */
  value_by_name = g_enum_get_value_by_name (klass, "TP_ERROR_AUTHENTICATION_FAILED");
  value_by_nick = g_enum_get_value_by_nick (klass, "AuthenticationFailed");
  g_assert (value_by_name != NULL);
  g_assert (value_by_nick != NULL);
  g_assert_cmpint (value_by_name->value, ==, TP_ERROR_AUTHENTICATION_FAILED);
  g_assert_cmpint (value_by_nick->value, ==, TP_ERROR_AUTHENTICATION_FAILED);
  g_assert_cmpstr (value_by_name->value_name, ==, "TP_ERROR_AUTHENTICATION_FAILED");
  g_assert_cmpstr (value_by_nick->value_name, ==, "TP_ERROR_AUTHENTICATION_FAILED");
  g_assert_cmpstr (value_by_name->value_nick, ==, "AuthenticationFailed");
  g_assert_cmpstr (value_by_nick->value_nick, ==, "AuthenticationFailed");
  g_assert_cmpstr (TP_ERROR_STR_AUTHENTICATION_FAILED, ==, TP_ERROR_PREFIX ".AuthenticationFailed");

  /* org.freedesktop.Telepathy.Error.EncryptionNotAvailable */
  value_by_name = g_enum_get_value_by_name (klass, "TP_ERROR_ENCRYPTION_NOT_AVAILABLE");
  value_by_nick = g_enum_get_value_by_nick (klass, "EncryptionNotAvailable");
  g_assert (value_by_name != NULL);
  g_assert (value_by_nick != NULL);
  g_assert_cmpint (value_by_name->value, ==, TP_ERROR_ENCRYPTION_NOT_AVAILABLE);
  g_assert_cmpint (value_by_nick->value, ==, TP_ERROR_ENCRYPTION_NOT_AVAILABLE);
  g_assert_cmpstr (value_by_name->value_name, ==, "TP_ERROR_ENCRYPTION_NOT_AVAILABLE");
  g_assert_cmpstr (value_by_nick->value_name, ==, "TP_ERROR_ENCRYPTION_NOT_AVAILABLE");
  g_assert_cmpstr (value_by_name->value_nick, ==, "EncryptionNotAvailable");
  g_assert_cmpstr (value_by_nick->value_nick, ==, "EncryptionNotAvailable");
  g_assert_cmpstr (TP_ERROR_STR_ENCRYPTION_NOT_AVAILABLE, ==, TP_ERROR_PREFIX ".EncryptionNotAvailable");

  /* org.freedesktop.Telepathy.Error.EncryptionError */
  value_by_name = g_enum_get_value_by_name (klass, "TP_ERROR_ENCRYPTION_ERROR");
  value_by_nick = g_enum_get_value_by_nick (klass, "EncryptionError");
  g_assert (value_by_name != NULL);
  g_assert (value_by_nick != NULL);
  g_assert_cmpint (value_by_name->value, ==, TP_ERROR_ENCRYPTION_ERROR);
  g_assert_cmpint (value_by_nick->value, ==, TP_ERROR_ENCRYPTION_ERROR);
  g_assert_cmpstr (value_by_name->value_name, ==, "TP_ERROR_ENCRYPTION_ERROR");
  g_assert_cmpstr (value_by_nick->value_name, ==, "TP_ERROR_ENCRYPTION_ERROR");
  g_assert_cmpstr (value_by_name->value_nick, ==, "EncryptionError");
  g_assert_cmpstr (value_by_nick->value_nick, ==, "EncryptionError");
  g_assert_cmpstr (TP_ERROR_STR_ENCRYPTION_ERROR, ==, TP_ERROR_PREFIX ".EncryptionError");

  /* org.freedesktop.Telepathy.Error.Cert.NotProvided */
  value_by_name = g_enum_get_value_by_name (klass, "TP_ERROR_CERT_NOT_PROVIDED");
  value_by_nick = g_enum_get_value_by_nick (klass, "Cert.NotProvided");
  g_assert (value_by_name != NULL);
  g_assert (value_by_nick != NULL);
  g_assert_cmpint (value_by_name->value, ==, TP_ERROR_CERT_NOT_PROVIDED);
  g_assert_cmpint (value_by_nick->value, ==, TP_ERROR_CERT_NOT_PROVIDED);
  g_assert_cmpstr (value_by_name->value_name, ==, "TP_ERROR_CERT_NOT_PROVIDED");
  g_assert_cmpstr (value_by_nick->value_name, ==, "TP_ERROR_CERT_NOT_PROVIDED");
  g_assert_cmpstr (value_by_name->value_nick, ==, "Cert.NotProvided");
  g_assert_cmpstr (value_by_nick->value_nick, ==, "Cert.NotProvided");
  g_assert_cmpstr (TP_ERROR_STR_CERT_NOT_PROVIDED, ==, TP_ERROR_PREFIX ".Cert.NotProvided");

  /* org.freedesktop.Telepathy.Error.Cert.Untrusted */
  value_by_name = g_enum_get_value_by_name (klass, "TP_ERROR_CERT_UNTRUSTED");
  value_by_nick = g_enum_get_value_by_nick (klass, "Cert.Untrusted");
  g_assert (value_by_name != NULL);
  g_assert (value_by_nick != NULL);
  g_assert_cmpint (value_by_name->value, ==, TP_ERROR_CERT_UNTRUSTED);
  g_assert_cmpint (value_by_nick->value, ==, TP_ERROR_CERT_UNTRUSTED);
  g_assert_cmpstr (value_by_name->value_name, ==, "TP_ERROR_CERT_UNTRUSTED");
  g_assert_cmpstr (value_by_nick->value_name, ==, "TP_ERROR_CERT_UNTRUSTED");
  g_assert_cmpstr (value_by_name->value_nick, ==, "Cert.Untrusted");
  g_assert_cmpstr (value_by_nick->value_nick, ==, "Cert.Untrusted");
  g_assert_cmpstr (TP_ERROR_STR_CERT_UNTRUSTED, ==, TP_ERROR_PREFIX ".Cert.Untrusted");

  /* org.freedesktop.Telepathy.Error.Cert.Expired */
  value_by_name = g_enum_get_value_by_name (klass, "TP_ERROR_CERT_EXPIRED");
  value_by_nick = g_enum_get_value_by_nick (klass, "Cert.Expired");
  g_assert (value_by_name != NULL);
  g_assert (value_by_nick != NULL);
  g_assert_cmpint (value_by_name->value, ==, TP_ERROR_CERT_EXPIRED);
  g_assert_cmpint (value_by_nick->value, ==, TP_ERROR_CERT_EXPIRED);
  g_assert_cmpstr (value_by_name->value_name, ==, "TP_ERROR_CERT_EXPIRED");
  g_assert_cmpstr (value_by_nick->value_name, ==, "TP_ERROR_CERT_EXPIRED");
  g_assert_cmpstr (value_by_name->value_nick, ==, "Cert.Expired");
  g_assert_cmpstr (value_by_nick->value_nick, ==, "Cert.Expired");
  g_assert_cmpstr (TP_ERROR_STR_CERT_EXPIRED, ==, TP_ERROR_PREFIX ".Cert.Expired");

  /* org.freedesktop.Telepathy.Error.Cert.NotActivated */
  value_by_name = g_enum_get_value_by_name (klass, "TP_ERROR_CERT_NOT_ACTIVATED");
  value_by_nick = g_enum_get_value_by_nick (klass, "Cert.NotActivated");
  g_assert (value_by_name != NULL);
  g_assert (value_by_nick != NULL);
  g_assert_cmpint (value_by_name->value, ==, TP_ERROR_CERT_NOT_ACTIVATED);
  g_assert_cmpint (value_by_nick->value, ==, TP_ERROR_CERT_NOT_ACTIVATED);
  g_assert_cmpstr (value_by_name->value_name, ==, "TP_ERROR_CERT_NOT_ACTIVATED");
  g_assert_cmpstr (value_by_nick->value_name, ==, "TP_ERROR_CERT_NOT_ACTIVATED");
  g_assert_cmpstr (value_by_name->value_nick, ==, "Cert.NotActivated");
  g_assert_cmpstr (value_by_nick->value_nick, ==, "Cert.NotActivated");
  g_assert_cmpstr (TP_ERROR_STR_CERT_NOT_ACTIVATED, ==, TP_ERROR_PREFIX ".Cert.NotActivated");

  /* org.freedesktop.Telepathy.Error.Cert.FingerprintMismatch */
  value_by_name = g_enum_get_value_by_name (klass, "TP_ERROR_CERT_FINGERPRINT_MISMATCH");
  value_by_nick = g_enum_get_value_by_nick (klass, "Cert.FingerprintMismatch");
  g_assert (value_by_name != NULL);
  g_assert (value_by_nick != NULL);
  g_assert_cmpint (value_by_name->value, ==, TP_ERROR_CERT_FINGERPRINT_MISMATCH);
  g_assert_cmpint (value_by_nick->value, ==, TP_ERROR_CERT_FINGERPRINT_MISMATCH);
  g_assert_cmpstr (value_by_name->value_name, ==, "TP_ERROR_CERT_FINGERPRINT_MISMATCH");
  g_assert_cmpstr (value_by_nick->value_name, ==, "TP_ERROR_CERT_FINGERPRINT_MISMATCH");
  g_assert_cmpstr (value_by_name->value_nick, ==, "Cert.FingerprintMismatch");
  g_assert_cmpstr (value_by_nick->value_nick, ==, "Cert.FingerprintMismatch");
  g_assert_cmpstr (TP_ERROR_STR_CERT_FINGERPRINT_MISMATCH, ==, TP_ERROR_PREFIX ".Cert.FingerprintMismatch");

  /* org.freedesktop.Telepathy.Error.Cert.HostnameMismatch */
  value_by_name = g_enum_get_value_by_name (klass, "TP_ERROR_CERT_HOSTNAME_MISMATCH");
  value_by_nick = g_enum_get_value_by_nick (klass, "Cert.HostnameMismatch");
  g_assert (value_by_name != NULL);
  g_assert (value_by_nick != NULL);
  g_assert_cmpint (value_by_name->value, ==, TP_ERROR_CERT_HOSTNAME_MISMATCH);
  g_assert_cmpint (value_by_nick->value, ==, TP_ERROR_CERT_HOSTNAME_MISMATCH);
  g_assert_cmpstr (value_by_name->value_name, ==, "TP_ERROR_CERT_HOSTNAME_MISMATCH");
  g_assert_cmpstr (value_by_nick->value_name, ==, "TP_ERROR_CERT_HOSTNAME_MISMATCH");
  g_assert_cmpstr (value_by_name->value_nick, ==, "Cert.HostnameMismatch");
  g_assert_cmpstr (value_by_nick->value_nick, ==, "Cert.HostnameMismatch");
  g_assert_cmpstr (TP_ERROR_STR_CERT_HOSTNAME_MISMATCH, ==, TP_ERROR_PREFIX ".Cert.HostnameMismatch");

  /* org.freedesktop.Telepathy.Error.Cert.SelfSigned */
  value_by_name = g_enum_get_value_by_name (klass, "TP_ERROR_CERT_SELF_SIGNED");
  value_by_nick = g_enum_get_value_by_nick (klass, "Cert.SelfSigned");
  g_assert (value_by_name != NULL);
  g_assert (value_by_nick != NULL);
  g_assert_cmpint (value_by_name->value, ==, TP_ERROR_CERT_SELF_SIGNED);
  g_assert_cmpint (value_by_nick->value, ==, TP_ERROR_CERT_SELF_SIGNED);
  g_assert_cmpstr (value_by_name->value_name, ==, "TP_ERROR_CERT_SELF_SIGNED");
  g_assert_cmpstr (value_by_nick->value_name, ==, "TP_ERROR_CERT_SELF_SIGNED");
  g_assert_cmpstr (value_by_name->value_nick, ==, "Cert.SelfSigned");
  g_assert_cmpstr (value_by_nick->value_nick, ==, "Cert.SelfSigned");
  g_assert_cmpstr (TP_ERROR_STR_CERT_SELF_SIGNED, ==, TP_ERROR_PREFIX ".Cert.SelfSigned");

  /* org.freedesktop.Telepathy.Error.Cert.Revoked */
  value_by_name = g_enum_get_value_by_name (klass, "TP_ERROR_CERT_REVOKED");
  value_by_nick = g_enum_get_value_by_nick (klass, "Cert.Revoked");
  g_assert (value_by_name != NULL);
  g_assert (value_by_nick != NULL);
  g_assert_cmpint (value_by_name->value, ==, TP_ERROR_CERT_REVOKED);
  g_assert_cmpint (value_by_nick->value, ==, TP_ERROR_CERT_REVOKED);
  g_assert_cmpstr (value_by_name->value_name, ==, "TP_ERROR_CERT_REVOKED");
  g_assert_cmpstr (value_by_nick->value_name, ==, "TP_ERROR_CERT_REVOKED");
  g_assert_cmpstr (value_by_name->value_nick, ==, "Cert.Revoked");
  g_assert_cmpstr (value_by_nick->value_nick, ==, "Cert.Revoked");
  g_assert_cmpstr (TP_ERROR_STR_CERT_REVOKED, ==, TP_ERROR_PREFIX ".Cert.Revoked");

  /* org.freedesktop.Telepathy.Error.Cert.Insecure */
  value_by_name = g_enum_get_value_by_name (klass, "TP_ERROR_CERT_INSECURE");
  value_by_nick = g_enum_get_value_by_nick (klass, "Cert.Insecure");
  g_assert (value_by_name != NULL);
  g_assert (value_by_nick != NULL);
  g_assert_cmpint (value_by_name->value, ==, TP_ERROR_CERT_INSECURE);
  g_assert_cmpint (value_by_nick->value, ==, TP_ERROR_CERT_INSECURE);
  g_assert_cmpstr (value_by_name->value_name, ==, "TP_ERROR_CERT_INSECURE");
  g_assert_cmpstr (value_by_nick->value_name, ==, "TP_ERROR_CERT_INSECURE");
  g_assert_cmpstr (value_by_name->value_nick, ==, "Cert.Insecure");
  g_assert_cmpstr (value_by_nick->value_nick, ==, "Cert.Insecure");
  g_assert_cmpstr (TP_ERROR_STR_CERT_INSECURE, ==, TP_ERROR_PREFIX ".Cert.Insecure");

  /* org.freedesktop.Telepathy.Error.Cert.Invalid */
  value_by_name = g_enum_get_value_by_name (klass, "TP_ERROR_CERT_INVALID");
  value_by_nick = g_enum_get_value_by_nick (klass, "Cert.Invalid");
  g_assert (value_by_name != NULL);
  g_assert (value_by_nick != NULL);
  g_assert_cmpint (value_by_name->value, ==, TP_ERROR_CERT_INVALID);
  g_assert_cmpint (value_by_nick->value, ==, TP_ERROR_CERT_INVALID);
  g_assert_cmpstr (value_by_name->value_name, ==, "TP_ERROR_CERT_INVALID");
  g_assert_cmpstr (value_by_nick->value_name, ==, "TP_ERROR_CERT_INVALID");
  g_assert_cmpstr (value_by_name->value_nick, ==, "Cert.Invalid");
  g_assert_cmpstr (value_by_nick->value_nick, ==, "Cert.Invalid");
  g_assert_cmpstr (TP_ERROR_STR_CERT_INVALID, ==, TP_ERROR_PREFIX ".Cert.Invalid");

  /* org.freedesktop.Telepathy.Error.Cert.LimitExceeded */
  value_by_name = g_enum_get_value_by_name (klass, "TP_ERROR_CERT_LIMIT_EXCEEDED");
  value_by_nick = g_enum_get_value_by_nick (klass, "Cert.LimitExceeded");
  g_assert (value_by_name != NULL);
  g_assert (value_by_nick != NULL);
  g_assert_cmpint (value_by_name->value, ==, TP_ERROR_CERT_LIMIT_EXCEEDED);
  g_assert_cmpint (value_by_nick->value, ==, TP_ERROR_CERT_LIMIT_EXCEEDED);
  g_assert_cmpstr (value_by_name->value_name, ==, "TP_ERROR_CERT_LIMIT_EXCEEDED");
  g_assert_cmpstr (value_by_nick->value_name, ==, "TP_ERROR_CERT_LIMIT_EXCEEDED");
  g_assert_cmpstr (value_by_name->value_nick, ==, "Cert.LimitExceeded");
  g_assert_cmpstr (value_by_nick->value_nick, ==, "Cert.LimitExceeded");
  g_assert_cmpstr (TP_ERROR_STR_CERT_LIMIT_EXCEEDED, ==, TP_ERROR_PREFIX ".Cert.LimitExceeded");

  /* org.freedesktop.Telepathy.Error.NotCapable */
  value_by_name = g_enum_get_value_by_name (klass, "TP_ERROR_NOT_CAPABLE");
  value_by_nick = g_enum_get_value_by_nick (klass, "NotCapable");
  g_assert (value_by_name != NULL);
  g_assert (value_by_nick != NULL);
  g_assert_cmpint (value_by_name->value, ==, TP_ERROR_NOT_CAPABLE);
  g_assert_cmpint (value_by_nick->value, ==, TP_ERROR_NOT_CAPABLE);
  g_assert_cmpstr (value_by_name->value_name, ==, "TP_ERROR_NOT_CAPABLE");
  g_assert_cmpstr (value_by_nick->value_name, ==, "TP_ERROR_NOT_CAPABLE");
  g_assert_cmpstr (value_by_name->value_nick, ==, "NotCapable");
  g_assert_cmpstr (value_by_nick->value_nick, ==, "NotCapable");
  g_assert_cmpstr (TP_ERROR_STR_NOT_CAPABLE, ==, TP_ERROR_PREFIX ".NotCapable");

  /* org.freedesktop.Telepathy.Error.Offline */
  value_by_name = g_enum_get_value_by_name (klass, "TP_ERROR_OFFLINE");
  value_by_nick = g_enum_get_value_by_nick (klass, "Offline");
  g_assert (value_by_name != NULL);
  g_assert (value_by_nick != NULL);
  g_assert_cmpint (value_by_name->value, ==, TP_ERROR_OFFLINE);
  g_assert_cmpint (value_by_nick->value, ==, TP_ERROR_OFFLINE);
  g_assert_cmpstr (value_by_name->value_name, ==, "TP_ERROR_OFFLINE");
  g_assert_cmpstr (value_by_nick->value_name, ==, "TP_ERROR_OFFLINE");
  g_assert_cmpstr (value_by_name->value_nick, ==, "Offline");
  g_assert_cmpstr (value_by_nick->value_nick, ==, "Offline");
  g_assert_cmpstr (TP_ERROR_STR_OFFLINE, ==, TP_ERROR_PREFIX ".Offline");

  /* org.freedesktop.Telepathy.Error.Channel.Kicked */
  value_by_name = g_enum_get_value_by_name (klass, "TP_ERROR_CHANNEL_KICKED");
  value_by_nick = g_enum_get_value_by_nick (klass, "Channel.Kicked");
  g_assert (value_by_name != NULL);
  g_assert (value_by_nick != NULL);
  g_assert_cmpint (value_by_name->value, ==, TP_ERROR_CHANNEL_KICKED);
  g_assert_cmpint (value_by_nick->value, ==, TP_ERROR_CHANNEL_KICKED);
  g_assert_cmpstr (value_by_name->value_name, ==, "TP_ERROR_CHANNEL_KICKED");
  g_assert_cmpstr (value_by_nick->value_name, ==, "TP_ERROR_CHANNEL_KICKED");
  g_assert_cmpstr (value_by_name->value_nick, ==, "Channel.Kicked");
  g_assert_cmpstr (value_by_nick->value_nick, ==, "Channel.Kicked");
  g_assert_cmpstr (TP_ERROR_STR_CHANNEL_KICKED, ==, TP_ERROR_PREFIX ".Channel.Kicked");

  /* org.freedesktop.Telepathy.Error.Busy */
  value_by_name = g_enum_get_value_by_name (klass, "TP_ERROR_BUSY");
  value_by_nick = g_enum_get_value_by_nick (klass, "Busy");
  g_assert (value_by_name != NULL);
  g_assert (value_by_nick != NULL);
  g_assert_cmpint (value_by_name->value, ==, TP_ERROR_BUSY);
  g_assert_cmpint (value_by_nick->value, ==, TP_ERROR_BUSY);
  g_assert_cmpstr (value_by_name->value_name, ==, "TP_ERROR_BUSY");
  g_assert_cmpstr (value_by_nick->value_name, ==, "TP_ERROR_BUSY");
  g_assert_cmpstr (value_by_name->value_nick, ==, "Busy");
  g_assert_cmpstr (value_by_nick->value_nick, ==, "Busy");
  g_assert_cmpstr (TP_ERROR_STR_BUSY, ==, TP_ERROR_PREFIX ".Busy");

  /* org.freedesktop.Telepathy.Error.NoAnswer */
  value_by_name = g_enum_get_value_by_name (klass, "TP_ERROR_NO_ANSWER");
  value_by_nick = g_enum_get_value_by_nick (klass, "NoAnswer");
  g_assert (value_by_name != NULL);
  g_assert (value_by_nick != NULL);
  g_assert_cmpint (value_by_name->value, ==, TP_ERROR_NO_ANSWER);
  g_assert_cmpint (value_by_nick->value, ==, TP_ERROR_NO_ANSWER);
  g_assert_cmpstr (value_by_name->value_name, ==, "TP_ERROR_NO_ANSWER");
  g_assert_cmpstr (value_by_nick->value_name, ==, "TP_ERROR_NO_ANSWER");
  g_assert_cmpstr (value_by_name->value_nick, ==, "NoAnswer");
  g_assert_cmpstr (value_by_nick->value_nick, ==, "NoAnswer");
  g_assert_cmpstr (TP_ERROR_STR_NO_ANSWER, ==, TP_ERROR_PREFIX ".NoAnswer");

  /* org.freedesktop.Telepathy.Error.DoesNotExist */
  value_by_name = g_enum_get_value_by_name (klass, "TP_ERROR_DOES_NOT_EXIST");
  value_by_nick = g_enum_get_value_by_nick (klass, "DoesNotExist");
  g_assert (value_by_name != NULL);
  g_assert (value_by_nick != NULL);
  g_assert_cmpint (value_by_name->value, ==, TP_ERROR_DOES_NOT_EXIST);
  g_assert_cmpint (value_by_nick->value, ==, TP_ERROR_DOES_NOT_EXIST);
  g_assert_cmpstr (value_by_name->value_name, ==, "TP_ERROR_DOES_NOT_EXIST");
  g_assert_cmpstr (value_by_nick->value_name, ==, "TP_ERROR_DOES_NOT_EXIST");
  g_assert_cmpstr (value_by_name->value_nick, ==, "DoesNotExist");
  g_assert_cmpstr (value_by_nick->value_nick, ==, "DoesNotExist");
  g_assert_cmpstr (TP_ERROR_STR_DOES_NOT_EXIST, ==, TP_ERROR_PREFIX ".DoesNotExist");

  /* org.freedesktop.Telepathy.Error.Terminated */
  value_by_name = g_enum_get_value_by_name (klass, "TP_ERROR_TERMINATED");
  value_by_nick = g_enum_get_value_by_nick (klass, "Terminated");
  g_assert (value_by_name != NULL);
  g_assert (value_by_nick != NULL);
  g_assert_cmpint (value_by_name->value, ==, TP_ERROR_TERMINATED);
  g_assert_cmpint (value_by_nick->value, ==, TP_ERROR_TERMINATED);
  g_assert_cmpstr (value_by_name->value_name, ==, "TP_ERROR_TERMINATED");
  g_assert_cmpstr (value_by_nick->value_name, ==, "TP_ERROR_TERMINATED");
  g_assert_cmpstr (value_by_name->value_nick, ==, "Terminated");
  g_assert_cmpstr (value_by_nick->value_nick, ==, "Terminated");
  g_assert_cmpstr (TP_ERROR_STR_TERMINATED, ==, TP_ERROR_PREFIX ".Terminated");

  /* org.freedesktop.Telepathy.Error.ConnectionRefused */
  value_by_name = g_enum_get_value_by_name (klass, "TP_ERROR_CONNECTION_REFUSED");
  value_by_nick = g_enum_get_value_by_nick (klass, "ConnectionRefused");
  g_assert (value_by_name != NULL);
  g_assert (value_by_nick != NULL);
  g_assert_cmpint (value_by_name->value, ==, TP_ERROR_CONNECTION_REFUSED);
  g_assert_cmpint (value_by_nick->value, ==, TP_ERROR_CONNECTION_REFUSED);
  g_assert_cmpstr (value_by_name->value_name, ==, "TP_ERROR_CONNECTION_REFUSED");
  g_assert_cmpstr (value_by_nick->value_name, ==, "TP_ERROR_CONNECTION_REFUSED");
  g_assert_cmpstr (value_by_name->value_nick, ==, "ConnectionRefused");
  g_assert_cmpstr (value_by_nick->value_nick, ==, "ConnectionRefused");
  g_assert_cmpstr (TP_ERROR_STR_CONNECTION_REFUSED, ==, TP_ERROR_PREFIX ".ConnectionRefused");

  /* org.freedesktop.Telepathy.Error.ConnectionFailed */
  value_by_name = g_enum_get_value_by_name (klass, "TP_ERROR_CONNECTION_FAILED");
  value_by_nick = g_enum_get_value_by_nick (klass, "ConnectionFailed");
  g_assert (value_by_name != NULL);
  g_assert (value_by_nick != NULL);
  g_assert_cmpint (value_by_name->value, ==, TP_ERROR_CONNECTION_FAILED);
  g_assert_cmpint (value_by_nick->value, ==, TP_ERROR_CONNECTION_FAILED);
  g_assert_cmpstr (value_by_name->value_name, ==, "TP_ERROR_CONNECTION_FAILED");
  g_assert_cmpstr (value_by_nick->value_name, ==, "TP_ERROR_CONNECTION_FAILED");
  g_assert_cmpstr (value_by_name->value_nick, ==, "ConnectionFailed");
  g_assert_cmpstr (value_by_nick->value_nick, ==, "ConnectionFailed");
  g_assert_cmpstr (TP_ERROR_STR_CONNECTION_FAILED, ==, TP_ERROR_PREFIX ".ConnectionFailed");

  /* org.freedesktop.Telepathy.Error.ConnectionLost */
  value_by_name = g_enum_get_value_by_name (klass, "TP_ERROR_CONNECTION_LOST");
  value_by_nick = g_enum_get_value_by_nick (klass, "ConnectionLost");
  g_assert (value_by_name != NULL);
  g_assert (value_by_nick != NULL);
  g_assert_cmpint (value_by_name->value, ==, TP_ERROR_CONNECTION_LOST);
  g_assert_cmpint (value_by_nick->value, ==, TP_ERROR_CONNECTION_LOST);
  g_assert_cmpstr (value_by_name->value_name, ==, "TP_ERROR_CONNECTION_LOST");
  g_assert_cmpstr (value_by_nick->value_name, ==, "TP_ERROR_CONNECTION_LOST");
  g_assert_cmpstr (value_by_name->value_nick, ==, "ConnectionLost");
  g_assert_cmpstr (value_by_nick->value_nick, ==, "ConnectionLost");
  g_assert_cmpstr (TP_ERROR_STR_CONNECTION_LOST, ==, TP_ERROR_PREFIX ".ConnectionLost");

  /* org.freedesktop.Telepathy.Error.AlreadyConnected */
  value_by_name = g_enum_get_value_by_name (klass, "TP_ERROR_ALREADY_CONNECTED");
  value_by_nick = g_enum_get_value_by_nick (klass, "AlreadyConnected");
  g_assert (value_by_name != NULL);
  g_assert (value_by_nick != NULL);
  g_assert_cmpint (value_by_name->value, ==, TP_ERROR_ALREADY_CONNECTED);
  g_assert_cmpint (value_by_nick->value, ==, TP_ERROR_ALREADY_CONNECTED);
  g_assert_cmpstr (value_by_name->value_name, ==, "TP_ERROR_ALREADY_CONNECTED");
  g_assert_cmpstr (value_by_nick->value_name, ==, "TP_ERROR_ALREADY_CONNECTED");
  g_assert_cmpstr (value_by_name->value_nick, ==, "AlreadyConnected");
  g_assert_cmpstr (value_by_nick->value_nick, ==, "AlreadyConnected");
  g_assert_cmpstr (TP_ERROR_STR_ALREADY_CONNECTED, ==, TP_ERROR_PREFIX ".AlreadyConnected");

  /* org.freedesktop.Telepathy.Error.ConnectionReplaced */
  value_by_name = g_enum_get_value_by_name (klass, "TP_ERROR_CONNECTION_REPLACED");
  value_by_nick = g_enum_get_value_by_nick (klass, "ConnectionReplaced");
  g_assert (value_by_name != NULL);
  g_assert (value_by_nick != NULL);
  g_assert_cmpint (value_by_name->value, ==, TP_ERROR_CONNECTION_REPLACED);
  g_assert_cmpint (value_by_nick->value, ==, TP_ERROR_CONNECTION_REPLACED);
  g_assert_cmpstr (value_by_name->value_name, ==, "TP_ERROR_CONNECTION_REPLACED");
  g_assert_cmpstr (value_by_nick->value_name, ==, "TP_ERROR_CONNECTION_REPLACED");
  g_assert_cmpstr (value_by_name->value_nick, ==, "ConnectionReplaced");
  g_assert_cmpstr (value_by_nick->value_nick, ==, "ConnectionReplaced");
  g_assert_cmpstr (TP_ERROR_STR_CONNECTION_REPLACED, ==, TP_ERROR_PREFIX ".ConnectionReplaced");

  /* org.freedesktop.Telepathy.Error.RegistrationExists */
  value_by_name = g_enum_get_value_by_name (klass, "TP_ERROR_REGISTRATION_EXISTS");
  value_by_nick = g_enum_get_value_by_nick (klass, "RegistrationExists");
  g_assert (value_by_name != NULL);
  g_assert (value_by_nick != NULL);
  g_assert_cmpint (value_by_name->value, ==, TP_ERROR_REGISTRATION_EXISTS);
  g_assert_cmpint (value_by_nick->value, ==, TP_ERROR_REGISTRATION_EXISTS);
  g_assert_cmpstr (value_by_name->value_name, ==, "TP_ERROR_REGISTRATION_EXISTS");
  g_assert_cmpstr (value_by_nick->value_name, ==, "TP_ERROR_REGISTRATION_EXISTS");
  g_assert_cmpstr (value_by_name->value_nick, ==, "RegistrationExists");
  g_assert_cmpstr (value_by_nick->value_nick, ==, "RegistrationExists");
  g_assert_cmpstr (TP_ERROR_STR_REGISTRATION_EXISTS, ==, TP_ERROR_PREFIX ".RegistrationExists");

  /* org.freedesktop.Telepathy.Error.ServiceBusy */
  value_by_name = g_enum_get_value_by_name (klass, "TP_ERROR_SERVICE_BUSY");
  value_by_nick = g_enum_get_value_by_nick (klass, "ServiceBusy");
  g_assert (value_by_name != NULL);
  g_assert (value_by_nick != NULL);
  g_assert_cmpint (value_by_name->value, ==, TP_ERROR_SERVICE_BUSY);
  g_assert_cmpint (value_by_nick->value, ==, TP_ERROR_SERVICE_BUSY);
  g_assert_cmpstr (value_by_name->value_name, ==, "TP_ERROR_SERVICE_BUSY");
  g_assert_cmpstr (value_by_nick->value_name, ==, "TP_ERROR_SERVICE_BUSY");
  g_assert_cmpstr (value_by_name->value_nick, ==, "ServiceBusy");
  g_assert_cmpstr (value_by_nick->value_nick, ==, "ServiceBusy");
  g_assert_cmpstr (TP_ERROR_STR_SERVICE_BUSY, ==, TP_ERROR_PREFIX ".ServiceBusy");

  /* org.freedesktop.Telepathy.Error.ResourceUnavailable */
  value_by_name = g_enum_get_value_by_name (klass, "TP_ERROR_RESOURCE_UNAVAILABLE");
  value_by_nick = g_enum_get_value_by_nick (klass, "ResourceUnavailable");
  g_assert (value_by_name != NULL);
  g_assert (value_by_nick != NULL);
  g_assert_cmpint (value_by_name->value, ==, TP_ERROR_RESOURCE_UNAVAILABLE);
  g_assert_cmpint (value_by_nick->value, ==, TP_ERROR_RESOURCE_UNAVAILABLE);
  g_assert_cmpstr (value_by_name->value_name, ==, "TP_ERROR_RESOURCE_UNAVAILABLE");
  g_assert_cmpstr (value_by_nick->value_name, ==, "TP_ERROR_RESOURCE_UNAVAILABLE");
  g_assert_cmpstr (value_by_name->value_nick, ==, "ResourceUnavailable");
  g_assert_cmpstr (value_by_nick->value_nick, ==, "ResourceUnavailable");
  g_assert_cmpstr (TP_ERROR_STR_RESOURCE_UNAVAILABLE, ==, TP_ERROR_PREFIX ".ResourceUnavailable");

  /* org.freedesktop.Telepathy.Error.WouldBreakAnonymity */
  value_by_name = g_enum_get_value_by_name (klass, "TP_ERROR_WOULD_BREAK_ANONYMITY");
  value_by_nick = g_enum_get_value_by_nick (klass, "WouldBreakAnonymity");
  g_assert (value_by_name != NULL);
  g_assert (value_by_nick != NULL);
  g_assert_cmpint (value_by_name->value, ==, TP_ERROR_WOULD_BREAK_ANONYMITY);
  g_assert_cmpint (value_by_nick->value, ==, TP_ERROR_WOULD_BREAK_ANONYMITY);
  g_assert_cmpstr (value_by_name->value_name, ==, "TP_ERROR_WOULD_BREAK_ANONYMITY");
  g_assert_cmpstr (value_by_nick->value_name, ==, "TP_ERROR_WOULD_BREAK_ANONYMITY");
  g_assert_cmpstr (value_by_name->value_nick, ==, "WouldBreakAnonymity");
  g_assert_cmpstr (value_by_nick->value_nick, ==, "WouldBreakAnonymity");
  g_assert_cmpstr (TP_ERROR_STR_WOULD_BREAK_ANONYMITY, ==, TP_ERROR_PREFIX ".WouldBreakAnonymity");

  /* org.freedesktop.Telepathy.Error.NotYet */
  value_by_name = g_enum_get_value_by_name (klass, "TP_ERROR_NOT_YET");
  value_by_nick = g_enum_get_value_by_nick (klass, "NotYet");
  g_assert (value_by_name != NULL);
  g_assert (value_by_nick != NULL);
  g_assert_cmpint (value_by_name->value, ==, TP_ERROR_NOT_YET);
  g_assert_cmpint (value_by_nick->value, ==, TP_ERROR_NOT_YET);
  g_assert_cmpstr (value_by_name->value_name, ==, "TP_ERROR_NOT_YET");
  g_assert_cmpstr (value_by_nick->value_name, ==, "TP_ERROR_NOT_YET");
  g_assert_cmpstr (value_by_name->value_nick, ==, "NotYet");
  g_assert_cmpstr (value_by_nick->value_nick, ==, "NotYet");
  g_assert_cmpstr (TP_ERROR_STR_NOT_YET, ==, TP_ERROR_PREFIX ".NotYet");
}
