/**
 * TpSvcProtocol:
 *
 * Dummy typedef representing any implementation of this interface.
 */
/**
 * TpSvcProtocolClass:
 *
 * The class of TpSvcProtocol.
 *
 * In a full implementation of this interface (i.e. all
 * methods implemented), the interface initialization
 * function used in G_IMPLEMENT_INTERFACE() would
 * typically look like this:
 *
 * <programlisting>
 * static void
 * implement_protocol (gpointer klass,
 *     gpointer unused G_GNUC_UNUSED)
 * {
 * #define IMPLEMENT(x) tp_svc_protocol_implement_&num;&num;x (\
 *   klass, my_object_&num;&num;x)
 *   IMPLEMENT (identify_account);
 *   IMPLEMENT (normalize_contact);
 * #undef IMPLEMENT
 * }
 * </programlisting>
 */

/**
 * tp_svc_protocol_identify_account_impl:
 * @self: The object implementing this interface
 * @in_Parameters: GHashTable * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * IdentifyAccount on interface org.freedesktop.Telepathy.Protocol.
 */
/**
 * tp_svc_protocol_implement_identify_account:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the IdentifyAccount D-Bus method
 *
 * Register an implementation for the IdentifyAccount method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_protocol_return_from_identify_account:
 * @context: The D-Bus method invocation context
 * @out_Account_ID: const gchar * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_protocol_normalize_contact_impl:
 * @self: The object implementing this interface
 * @in_Contact_ID: const gchar * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * NormalizeContact on interface org.freedesktop.Telepathy.Protocol.
 */
/**
 * tp_svc_protocol_implement_normalize_contact:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the NormalizeContact D-Bus method
 *
 * Register an implementation for the NormalizeContact method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_protocol_return_from_normalize_contact:
 * @context: The D-Bus method invocation context
 * @out_Normalized_Contact_ID: const gchar * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
