/**
 * TpSvcDBusIntrospectable:
 *
 * Dummy typedef representing any implementation of this interface.
 */
/**
 * TpSvcDBusIntrospectableClass:
 *
 * The class of TpSvcDBusIntrospectable.
 *
 * In a full implementation of this interface (i.e. all
 * methods implemented), the interface initialization
 * function used in G_IMPLEMENT_INTERFACE() would
 * typically look like this:
 *
 * <programlisting>
 * static void
 * implement_dbus_introspectable (gpointer klass,
 *     gpointer unused G_GNUC_UNUSED)
 * {
 * #define IMPLEMENT(x) tp_svc_dbus_introspectable_implement_&num;&num;x (\
 *   klass, my_object_&num;&num;x)
 *   IMPLEMENT (introspect);
 * #undef IMPLEMENT
 * }
 * </programlisting>
 */

/**
 * tp_svc_dbus_introspectable_introspect_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * Introspect on interface org.freedesktop.DBus.Introspectable.
 */
/**
 * tp_svc_dbus_introspectable_implement_introspect:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the Introspect D-Bus method
 *
 * Register an implementation for the Introspect method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_dbus_introspectable_return_from_introspect:
 * @context: The D-Bus method invocation context
 * @out_XML_Data: const gchar * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * TpSvcDBusProperties:
 *
 * Dummy typedef representing any implementation of this interface.
 */
/**
 * TpSvcDBusPropertiesClass:
 *
 * The class of TpSvcDBusProperties.
 *
 * In a full implementation of this interface (i.e. all
 * methods implemented), the interface initialization
 * function used in G_IMPLEMENT_INTERFACE() would
 * typically look like this:
 *
 * <programlisting>
 * static void
 * implement_dbus_properties (gpointer klass,
 *     gpointer unused G_GNUC_UNUSED)
 * {
 * #define IMPLEMENT(x) tp_svc_dbus_properties_implement_&num;&num;x (\
 *   klass, my_object_&num;&num;x)
 *   IMPLEMENT (get);
 *   IMPLEMENT (set);
 *   IMPLEMENT (get_all);
 * #undef IMPLEMENT
 * }
 * </programlisting>
 */

/**
 * tp_svc_dbus_properties_get_impl:
 * @self: The object implementing this interface
 * @in_Interface_Name: const gchar * (FIXME, generate documentation)
 * @in_Property_Name: const gchar * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * Get on interface org.freedesktop.DBus.Properties.
 */
/**
 * tp_svc_dbus_properties_implement_get:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the Get D-Bus method
 *
 * Register an implementation for the Get method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_dbus_properties_return_from_get:
 * @context: The D-Bus method invocation context
 * @out_Value: const GValue * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_dbus_properties_set_impl:
 * @self: The object implementing this interface
 * @in_Interface_Name: const gchar * (FIXME, generate documentation)
 * @in_Property_Name: const gchar * (FIXME, generate documentation)
 * @in_Value: const GValue * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * Set on interface org.freedesktop.DBus.Properties.
 */
/**
 * tp_svc_dbus_properties_implement_set:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the Set D-Bus method
 *
 * Register an implementation for the Set method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_dbus_properties_return_from_set:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_dbus_properties_get_all_impl:
 * @self: The object implementing this interface
 * @in_Interface_Name: const gchar * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * GetAll on interface org.freedesktop.DBus.Properties.
 */
/**
 * tp_svc_dbus_properties_implement_get_all:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the GetAll D-Bus method
 *
 * Register an implementation for the GetAll method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_dbus_properties_return_from_get_all:
 * @context: The D-Bus method invocation context
 * @out_Properties: GHashTable * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * TpSvcPropertiesInterface:
 *
 * Dummy typedef representing any implementation of this interface.
 */
/**
 * TpSvcPropertiesInterfaceClass:
 *
 * The class of TpSvcPropertiesInterface.
 *
 * In a full implementation of this interface (i.e. all
 * methods implemented), the interface initialization
 * function used in G_IMPLEMENT_INTERFACE() would
 * typically look like this:
 *
 * <programlisting>
 * static void
 * implement_properties_interface (gpointer klass,
 *     gpointer unused G_GNUC_UNUSED)
 * {
 * #define IMPLEMENT(x) tp_svc_properties_interface_implement_&num;&num;x (\
 *   klass, my_object_&num;&num;x)
 *   IMPLEMENT (get_properties);
 *   IMPLEMENT (list_properties);
 *   IMPLEMENT (set_properties);
 * #undef IMPLEMENT
 * }
 * </programlisting>
 */

/**
 * tp_svc_properties_interface_get_properties_impl:
 * @self: The object implementing this interface
 * @in_Properties: const GArray * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * GetProperties on interface org.freedesktop.Telepathy.Properties.
 */
/**
 * tp_svc_properties_interface_implement_get_properties:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the GetProperties D-Bus method
 *
 * Register an implementation for the GetProperties method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_properties_interface_return_from_get_properties:
 * @context: The D-Bus method invocation context
 * @out_Values: const GPtrArray * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_properties_interface_list_properties_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * ListProperties on interface org.freedesktop.Telepathy.Properties.
 */
/**
 * tp_svc_properties_interface_implement_list_properties:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the ListProperties D-Bus method
 *
 * Register an implementation for the ListProperties method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_properties_interface_return_from_list_properties:
 * @context: The D-Bus method invocation context
 * @out_Available_Properties: const GPtrArray * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_properties_interface_set_properties_impl:
 * @self: The object implementing this interface
 * @in_Properties: const GPtrArray * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * SetProperties on interface org.freedesktop.Telepathy.Properties.
 */
/**
 * tp_svc_properties_interface_implement_set_properties:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the SetProperties D-Bus method
 *
 * Register an implementation for the SetProperties method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_properties_interface_return_from_set_properties:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_properties_interface_emit_properties_changed:
 * @instance: The object implementing this interface
 * @arg_Properties: const GPtrArray * (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * PropertiesChanged signal on interface org.freedesktop.Telepathy.Properties.
 */
/**
 * TpSvcPropertiesInterface::properties-changed:
 * @arg_Properties: const GPtrArray * (FIXME, generate documentation)
 *
 * The PropertiesChanged D-Bus signal is emitted whenever this GObject signal is.
 */

/**
 * tp_svc_properties_interface_emit_property_flags_changed:
 * @instance: The object implementing this interface
 * @arg_Properties: const GPtrArray * (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * PropertyFlagsChanged signal on interface org.freedesktop.Telepathy.Properties.
 */
/**
 * TpSvcPropertiesInterface::property-flags-changed:
 * @arg_Properties: const GPtrArray * (FIXME, generate documentation)
 *
 * The PropertyFlagsChanged D-Bus signal is emitted whenever this GObject signal is.
 */
