/**
 * TpSvcAccount:
 *
 * Dummy typedef representing any implementation of this interface.
 */
/**
 * TpSvcAccountClass:
 *
 * The class of TpSvcAccount.
 *
 * In a full implementation of this interface (i.e. all
 * methods implemented), the interface initialization
 * function used in G_IMPLEMENT_INTERFACE() would
 * typically look like this:
 *
 * <programlisting>
 * static void
 * implement_account (gpointer klass,
 *     gpointer unused G_GNUC_UNUSED)
 * {
 * #define IMPLEMENT(x) tp_svc_account_implement_&num;&num;x (\
 *   klass, my_object_&num;&num;x)
 *   IMPLEMENT (remove);
 *   IMPLEMENT (update_parameters);
 *   IMPLEMENT (reconnect);
 * #undef IMPLEMENT
 * }
 * </programlisting>
 */

/**
 * tp_svc_account_remove_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * Remove on interface org.freedesktop.Telepathy.Account.
 */
/**
 * tp_svc_account_implement_remove:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the Remove D-Bus method
 *
 * Register an implementation for the Remove method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_account_return_from_remove:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_account_update_parameters_impl:
 * @self: The object implementing this interface
 * @in_Set: GHashTable * (FIXME, generate documentation)
 * @in_Unset: const gchar ** (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * UpdateParameters on interface org.freedesktop.Telepathy.Account.
 */
/**
 * tp_svc_account_implement_update_parameters:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the UpdateParameters D-Bus method
 *
 * Register an implementation for the UpdateParameters method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_account_return_from_update_parameters:
 * @context: The D-Bus method invocation context
 * @out_Reconnect_Required: const gchar ** (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_account_reconnect_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * Reconnect on interface org.freedesktop.Telepathy.Account.
 */
/**
 * tp_svc_account_implement_reconnect:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the Reconnect D-Bus method
 *
 * Register an implementation for the Reconnect method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_account_return_from_reconnect:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_account_emit_removed:
 * @instance: The object implementing this interface
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * Removed signal on interface org.freedesktop.Telepathy.Account.
 */
/**
 * TpSvcAccount::removed:
 *
 * The Removed D-Bus signal is emitted whenever this GObject signal is.
 */

/**
 * tp_svc_account_emit_account_property_changed:
 * @instance: The object implementing this interface
 * @arg_Properties: GHashTable * (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * AccountPropertyChanged signal on interface org.freedesktop.Telepathy.Account.
 */
/**
 * TpSvcAccount::account-property-changed:
 * @arg_Properties: GHashTable * (FIXME, generate documentation)
 *
 * The AccountPropertyChanged D-Bus signal is emitted whenever this GObject signal is.
 */

/**
 * TpSvcAccountInterfaceAvatar:
 *
 * Dummy typedef representing any implementation of this interface.
 */
/**
 * TpSvcAccountInterfaceAvatarClass:
 *
 * The class of TpSvcAccountInterfaceAvatar.
 * This interface has no D-Bus methods, so an
 * implementation can typically pass %NULL to
 * G_IMPLEMENT_INTERFACE() as the interface
 * initialization function.
 */

/**
 * tp_svc_account_interface_avatar_emit_avatar_changed:
 * @instance: The object implementing this interface
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * AvatarChanged signal on interface org.freedesktop.Telepathy.Account.Interface.Avatar.
 */
/**
 * TpSvcAccountInterfaceAvatar::avatar-changed:
 *
 * The AvatarChanged D-Bus signal is emitted whenever this GObject signal is.
 */

/**
 * TpSvcAccountInterfaceStorage:
 *
 * Dummy typedef representing any implementation of this interface.
 */
/**
 * TpSvcAccountInterfaceStorageClass:
 *
 * The class of TpSvcAccountInterfaceStorage.
 * This interface has no D-Bus methods, so an
 * implementation can typically pass %NULL to
 * G_IMPLEMENT_INTERFACE() as the interface
 * initialization function.
 */
