/**
 * tp_cli_channel_request_signal_callback_failed:
 * @proxy: The proxy on which tp_cli_channel_request_connect_to_failed ()
 *  was called
 * @arg_Error: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           &lt;p&gt;The name of a D-Bus error. This can come from various sources,             including the error raised by &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Connection.Interface.Requests&quot;&gt;CreateChannel&lt;/tp:dbus-ref&gt;,             or an error generated             to represent failure to establish the &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy&quot;&gt;Connection&lt;/tp:dbus-ref&gt;.&lt;/p&gt;
 * @arg_Message: If the first argument of the D-Bus error message was a string,           that string. Otherwise, an empty string.
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal Failed.
 */

/**
 * tp_cli_channel_request_connect_to_failed:
 * @proxy: A #TpChannelRequest or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal Failed.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;The channel request has failed. It is no longer present,           and further methods must not be called on it.&lt;/p&gt;
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_channel_request_signal_callback_succeeded:
 * @proxy: The proxy on which tp_cli_channel_request_connect_to_succeeded ()
 *  was called
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal Succeeded.
 */

/**
 * tp_cli_channel_request_connect_to_succeeded:
 * @proxy: A #TpChannelRequest or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal Succeeded.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;The channel request has succeeded. It is no longer present,           and further methods must not be called on it.&lt;/p&gt;
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_channel_request_callback_for_proceed:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a Proceed method call
 * succeeds or fails.
 */

/**
 * tp_cli_channel_request_call_proceed:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a Proceed method call.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Proceed with the channel request.&lt;/p&gt;          &lt;tp:rationale&gt;           &lt;p&gt;The client that created this object calls this method             when it has connected signal handlers for             &lt;tp:member-ref&gt;Succeeded&lt;/tp:member-ref&gt; and             &lt;tp:member-ref&gt;Failed&lt;/tp:member-ref&gt;.&lt;/p&gt;         &lt;/tp:rationale&gt;          &lt;p&gt;Clients other than the client which created the ChannelRequest           MUST NOT call this method.&lt;/p&gt;          &lt;p&gt;This method SHOULD return immediately; on success, the request           might still fail, but this will be indicated asynchronously           by the &lt;tp:member-ref&gt;Failed&lt;/tp:member-ref&gt; signal.&lt;/p&gt;          &lt;p&gt;Proceed cannot fail, unless clients have got the life-cycle           of a ChannelRequest seriously wrong (e.g. a client calls this           method twice, or a client that did not create the ChannelRequest           calls this method). If it fails, clients SHOULD assume that the           whole ChannelRequest has become useless.&lt;/p&gt;
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */


/**
 * tp_cli_channel_request_callback_for_cancel:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a Cancel method call
 * succeeds or fails.
 */

/**
 * tp_cli_channel_request_call_cancel:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a Cancel method call.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Cancel the channel request. The precise effect depends on the           current progress of the request.&lt;/p&gt;          &lt;p&gt;If the connection manager has not already been asked to create           a channel, then &lt;tp:member-ref&gt;Failed&lt;/tp:member-ref&gt; is emitted           immediately, and the channel request is removed.&lt;/p&gt;          &lt;p&gt;If the connection manager has already been asked to create a           channel but has not produced one yet (e.g. if &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy&quot;&gt;Connection.Interface.Requests.CreateChannel&lt;/tp:dbus-ref&gt;           has been called, but has not yet returned), then the           ChannelDispatcher will remember that the request has been cancelled.           When the channel appears, it will be closed (if it was newly           created and can be closed), and will not be dispatched to a           handler.&lt;/p&gt;          &lt;p&gt;If the connection manager has already returned a channel, but the           channel has not yet been dispatched to a handler           then the channel dispatcher will not dispatch that           channel to a handler. If the channel was newly created for this           request, the channel dispatcher will close it with &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Channel&quot;&gt;Close&lt;/tp:dbus-ref&gt;;           otherwise, the channel dispatcher will ignore it. In either case,           &lt;tp:member-ref&gt;Failed&lt;/tp:member-ref&gt; will be emitted when processing           has been completed.&lt;/p&gt;          &lt;p&gt;If &lt;tp:member-ref&gt;Failed&lt;/tp:member-ref&gt; is emitted in response to           this method, the error SHOULD be           &lt;code&gt;org.freedesktop.Telepathy.Error.Cancelled&lt;/code&gt;.&lt;/p&gt;          &lt;p&gt;If the channel has already been dispatched to a handler, then           it&apos;s too late to call this method, and the channel request will           no longer exist.&lt;/p&gt;
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

