/**
 * tp_cli_account_signal_callback_removed:
 * @proxy: The proxy on which tp_cli_account_connect_to_removed ()
 *  was called
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal Removed.
 */

/**
 * tp_cli_account_connect_to_removed:
 * @proxy: A #TpAccount or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal Removed.
 *
 * This account has been removed.          &lt;tp:rationale&gt;           This is redundant with &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.AccountManager&quot;&gt;AccountRemoved&lt;/tp:dbus-ref&gt;,           but it&apos;s still worth having,           to avoid having to bind to AccountManager.AccountRemoved to tell           you whether your Account is valid — ideally, an account-editing UI           should only care about a single Account.         &lt;/tp:rationale&gt;
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_account_signal_callback_account_property_changed:
 * @proxy: The proxy on which tp_cli_account_connect_to_account_property_changed ()
 *  was called
 * @arg_Properties: A map from property names in this namespace (e.g.           &lt;tp:member-ref&gt;Nickname&lt;/tp:member-ref&gt;) to           values. Properties whose values have not changed SHOULD be           omitted, but this need not be done.
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal AccountPropertyChanged.
 */

/**
 * tp_cli_account_connect_to_account_property_changed:
 * @proxy: A #TpAccount or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal AccountPropertyChanged.
 *
 * The values of one or more properties on this interface (that do not         specify that this signal does not apply to them) may have changed.         This does not cover properties of other interfaces, which must         provide their own change notification if appropriate.
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_account_callback_for_remove:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a Remove method call
 * succeeds or fails.
 */

/**
 * tp_cli_account_call_remove:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a Remove method call.
 *
 * Delete the account.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */


/**
 * tp_cli_account_callback_for_update_parameters:
 * @proxy: the proxy on which the call was made
 * @out_Reconnect_Required: Used to return an 'out' argument if @error is %NULL: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           &lt;p&gt;If all of the parameters had the &lt;code&gt;DBus_Property&lt;/code&gt; flag,             the empty list, signifying that no reconnection is required for the             new parameters to take effect. For example, if the only parameter             updated is &lt;tt&gt;...Cellular.&lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Connection.Interface.Cellular&quot;&gt;MessageValidityPeriod&lt;/tp:dbus-ref&gt;&lt;/tt&gt;,             the new value can be applied immediately to the connection.&lt;/p&gt;            &lt;p&gt;Otherwise, a list of the names of parameters with changes that             will not take effect until the account is reconnected. User             interfaces that require &amp;quot;instant apply&amp;quot; semantics MAY call             &lt;tp:member-ref&gt;Reconnect&lt;/tp:member-ref&gt; in response to receiving a             non-empty list. For example, if the caller updates both             &lt;tt&gt;...Anonymity.&lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Connection.Interface.Anonymity&quot;&gt;AnonymityMandatory&lt;/tp:dbus-ref&gt;&lt;/tt&gt;             and &lt;tt&gt;require-encryption&lt;/tt&gt;, the former can be applied to the             current connection, but the latter needs a reconnect to take             effect, so this method should return             &lt;code&gt;[&amp;quot;require-encryption&amp;quot;]&lt;/code&gt;.&lt;/p&gt;
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a UpdateParameters method call
 * succeeds or fails.
 */

/**
 * tp_cli_account_call_update_parameters:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Set: Used to pass an 'in' argument: A mapping from parameter names to their values. These parameters           should be stored for future use.
 * @in_Unset: Used to pass an 'in' argument: A list of the names of parameters to be removed from the set of           stored values, allowing the default values to be used.           If the given parameters were not, in fact, stored, or even if they           do not exist at all, the account manager MUST accept this without           error.
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a UpdateParameters method call.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Change the value of the &lt;tp:member-ref&gt;Parameters&lt;/tp:member-ref&gt;           property.&lt;/p&gt;          &lt;p&gt;If any of the changed parameters&apos;           &lt;tp:type&gt;Conn_Mgr_Param_Flags&lt;/tp:type&gt; include           &lt;code&gt;DBus_Property&lt;/code&gt;, the change will be applied immediately to           the           corresponding D-Bus Property on the active           &lt;tp:member-ref&gt;Connection&lt;/tp:member-ref&gt;, if there is one. Changes to           other parameters will not take effect until the next time the account           is disconnected and reconnected.&lt;/p&gt;          &lt;tp:rationale&gt;           &lt;p&gt;In general, reconnecting is a destructive operation that shouldn&apos;t             happen as a side-effect. In particular, migration tools that             twiddle the settings of all accounts shouldn&apos;t cause an automatic             disconnect and reconnect.&lt;/p&gt;         &lt;/tp:rationale&gt;
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */


/**
 * tp_cli_account_callback_for_reconnect:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a Reconnect method call
 * succeeds or fails.
 */

/**
 * tp_cli_account_call_reconnect:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a Reconnect method call.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Re-connect this account. If the account is currently disconnected           and the requested presence is offline, or if the account           is not &lt;tp:member-ref&gt;Enabled&lt;/tp:member-ref&gt; or not           &lt;tp:member-ref&gt;Valid&lt;/tp:member-ref&gt;, this does nothing.&lt;/p&gt;          &lt;p&gt;If the account is disconnected and the requested presence is not           offline, this forces an attempt to connect with the requested           presence immediately.&lt;/p&gt;          &lt;p&gt;If the account is connecting or connected, this is equivalent to           remembering the current value of           &lt;tp:member-ref&gt;RequestedPresence&lt;/tp:member-ref&gt;, setting its value           to (OFFLINE, &amp;quot;offline&amp;quot;, &amp;quot;&amp;quot;), waiting for the change to take effect,           then setting its value to the value that was previously           remembered.&lt;/p&gt;          &lt;tp:rationale&gt;           &lt;p&gt;Clients desiring &amp;quot;instant apply&amp;quot; semantics for CM parameters MAY             call this method to achieve that.&lt;/p&gt;         &lt;/tp:rationale&gt;          &lt;p&gt;In particular, if the account&apos;s           &lt;tp:member-ref&gt;Connection&lt;/tp:member-ref&gt; is in the Connecting           state, calling this method causes the attempt to connect to be           aborted and re-tried.&lt;/p&gt;          &lt;tp:rationale&gt;           &lt;p&gt;This is necessary to ensure that the new parameters are             picked up.&lt;/p&gt;         &lt;/tp:rationale&gt;
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */


/**
 * tp_cli_account_interface_avatar_signal_callback_avatar_changed:
 * @proxy: The proxy on which tp_cli_account_interface_avatar_connect_to_avatar_changed ()
 *  was called
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal AvatarChanged.
 */

/**
 * tp_cli_account_interface_avatar_connect_to_avatar_changed:
 * @proxy: A #TpAccount or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal AvatarChanged.
 *
 * Emitted when the Avatar property changes.          &lt;tp:rationale&gt;The avatar itself is deliberately not included in this           signal, to reduce bus traffic in the (likely common) case where no           running application cares about the user&apos;s own avatar.&lt;/tp:rationale&gt;
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */
