/* Auto-generated, do not edit.
 *
 * This file may be distributed under the same terms
 * as the specification from which it was generated.
 */

/**
 * TP_HASH_TYPE_PROTOCOL_PROPERTIES_MAP:
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;A map from protocol identifiers supported by a connection           manager to the immutable properties of the corresponding           &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy&quot;&gt;Protocol&lt;/tp:dbus-ref&gt; objects.&lt;/p&gt;
 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GHashTable
 * appropriate for representing a D-Bus
 * dictionary of signature
 * <literal>a{sa{sv}}</literal>.
 *
 * Keys (D-Bus type <literal>s</literal>,
 * type <literal>Protocol</literal>,
 * named <literal>Protocol</literal>):
 * A protocol name
 *
 * Values (D-Bus type <literal>a{sv}</literal>,
 * type <literal>Qualified_Property_Value_Map</literal>,
 * named <literal>Properties</literal>):
 * The immutable properties of the corresponding           Protocol object
 *
 */
/**
 * TP_HASH_TYPE_ALIAS_MAP:
 *
 * A dictionary whose keys are contact handles and whose         values are aliases.
 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GHashTable
 * appropriate for representing a D-Bus
 * dictionary of signature
 * <literal>a{us}</literal>.
 *
 * Keys (D-Bus type <literal>u</literal>,
 * type <literal>Contact_Handle</literal>,
 * named <literal>Handle</literal>):
 * (Undocumented)
 *
 * Values (D-Bus type <literal>s</literal>,
 * named <literal>Alias</literal>):
 * (Undocumented)
 *
 */
/**
 * TP_HASH_TYPE_AVATAR_TOKEN_MAP:
 *
 * A dictionary whose keys are contact handles and whose         values are avatar tokens.
 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GHashTable
 * appropriate for representing a D-Bus
 * dictionary of signature
 * <literal>a{us}</literal>.
 *
 * Keys (D-Bus type <literal>u</literal>,
 * type <literal>Contact_Handle</literal>,
 * named <literal>Handle</literal>):
 * (Undocumented)
 *
 * Values (D-Bus type <literal>s</literal>,
 * type <literal>Avatar_Token</literal>,
 * named <literal>Token</literal>):
 * (Undocumented)
 *
 */
/**
 * TP_HASH_TYPE_CONTACT_CAPABILITIES_MAP:
 *
 * A mapping from contact handle to their capabilities.
 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GHashTable
 * appropriate for representing a D-Bus
 * dictionary of signature
 * <literal>a{ua(a{sv}as)}</literal>.
 *
 * Keys (D-Bus type <literal>u</literal>,
 * type <literal>Contact_Handle</literal>,
 * named <literal>Key</literal>):
 * A contact handle.
 *
 * Values (D-Bus type <literal>a(a{sv}as)</literal>,
 * type <literal>Requestable_Channel_Class[]</literal>,
 * named <literal>Value</literal>):
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;          &lt;p&gt;The contact&apos;s capabilities. These should be represented           in the same way as in &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Connection.Interface.Requests&quot;&gt;RequestableChannelClasses&lt;/tp:dbus-ref&gt;,           except that they may have more fixed properties or fewer allowed           properties, to represent contacts who do not have all the           capabilities of the connection.&lt;/p&gt;          &lt;p&gt;In particular, requestable channel classes for channels with           target handle type Contact MUST list &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Channel&quot;&gt;TargetHandleType&lt;/tp:dbus-ref&gt; among their fixed properties when           they appear here, and clients MAY assume that this will be the           case.&lt;/p&gt;          &lt;tp:rationale&gt;           &lt;p&gt;This matches the initial implementations - service-side in             telepathy-gabble, and client-side in telepathy-qt4 - and means             that clients can use exactly the same code to interpret             RequestableChannelClasses and contact capabilities.&lt;/p&gt;         &lt;/tp:rationale&gt;          &lt;p&gt;Channel classes with target handle type Handle_Type_Contact           indicate that a request that matches the channel class, and also           either has the contact&apos;s handle as &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Channel&quot;&gt;TargetHandle&lt;/tp:dbus-ref&gt; or the contact&apos;s identifier as           &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Channel&quot;&gt;TargetID&lt;/tp:dbus-ref&gt;, can be expected to succeed. Connection           managers SHOULD NOT include the TargetHandle or TargetID as a           fixed property in contact capabilities.&lt;/p&gt;          &lt;tp:rationale&gt;           &lt;p&gt;This makes one channel class sufficient to describe requests via             TargetHandle or TargetID, and is necessary in order to allow             clients to interpret RequestableChannelClasses and contact             capabilities with the same code.&lt;/p&gt;         &lt;/tp:rationale&gt;          &lt;p&gt;Channel classes with target handle type Handle_Type_Room or           Handle_Type_None indicate that if a channel matching the channel           class is created, then inviting the contact to that channel           can be expected to succeed.&lt;/p&gt;          &lt;tp:rationale&gt;           &lt;p&gt;To support room-based XMPP protocols like             &lt;a href=&quot;http://telepathy.freedesktop.org/wiki/Muji&quot;&gt;Muji&lt;/a&gt;             and MUC Tubes, it&apos;s necessary to be able to discover who can be             invited to a given room channel; most XMPP contacts won&apos;t             support being invited into a Muji conference call, at least             in the short to medium term.&lt;/p&gt;         &lt;/tp:rationale&gt;          &lt;p&gt;No interpretation is defined for channel classes with any other           target handle type, or for channel classes that do not fix a           target handle type, in this version of the Telepathy           specification.&lt;/p&gt;
 *
 */
/**
 * TP_ARRAY_TYPE_CONTACT_CAPABILITIES_MAP_LIST:

 * Expands to a call to a function
 * that returns the #GType of a #GPtrArray
 * of #TP_HASH_TYPE_CONTACT_CAPABILITIES_MAP.
 */

/**
 * TP_HASH_TYPE_CONTACT_INFO_MAP:
 *
 * A dictionary whose keys are contact handles and whose         values are contact information..
 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GHashTable
 * appropriate for representing a D-Bus
 * dictionary of signature
 * <literal>a{ua(sasas)}</literal>.
 *
 * Keys (D-Bus type <literal>u</literal>,
 * type <literal>Contact_Handle</literal>,
 * named <literal>Handle</literal>):
 * (Undocumented)
 *
 * Values (D-Bus type <literal>a(sasas)</literal>,
 * type <literal>Contact_Info_Field[]</literal>,
 * named <literal>Contact_Info</literal>):
 * (Undocumented)
 *
 */
/**
 * TP_HASH_TYPE_SIMPLE_CONTACT_PRESENCES:
 *
 * Mapping returned by &lt;tp:member-ref&gt;GetPresences&lt;/tp:member-ref&gt;         and signalled by &lt;tp:member-ref&gt;PresencesChanged&lt;/tp:member-ref&gt;,         indicating the presence of a number of contacts.
 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GHashTable
 * appropriate for representing a D-Bus
 * dictionary of signature
 * <literal>a{u(uss)}</literal>.
 *
 * Keys (D-Bus type <literal>u</literal>,
 * type <literal>Contact_Handle</literal>,
 * named <literal>Contact</literal>):
 * A contact
 *
 * Values (D-Bus type <literal>(uss)</literal>,
 * type <literal>Simple_Presence</literal>,
 * named <literal>Presence</literal>):
 * The contact&apos;s presence
 *
 */
/**
 * TP_HASH_TYPE_SIMPLE_STATUS_SPEC_MAP:
 *
 * A mapping describing possible statuses.
 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GHashTable
 * appropriate for representing a D-Bus
 * dictionary of signature
 * <literal>a{s(ubb)}</literal>.
 *
 * Keys (D-Bus type <literal>s</literal>,
 * named <literal>Identifier</literal>):
 * The string identifier of this status.
 *
 * Values (D-Bus type <literal>(ubb)</literal>,
 * type <literal>Simple_Status_Spec</literal>,
 * named <literal>Spec</literal>):
 * Details of this status.
 *
 */
/**
 * TP_HASH_TYPE_MULTIPLE_STATUS_MAP:
 *
 * Mapping used in         &lt;tp:type&gt;Last_Activity_And_Statuses&lt;/tp:type&gt; and passed to         &lt;tp:member-ref&gt;SetStatus&lt;/tp:member-ref&gt;, representing a collection of         statuses. Use of this mapping with more than one member is         deprecated.
 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GHashTable
 * appropriate for representing a D-Bus
 * dictionary of signature
 * <literal>a{sa{sv}}</literal>.
 *
 * Keys (D-Bus type <literal>s</literal>,
 * named <literal>Status</literal>):
 * (Undocumented)
 *
 * Values (D-Bus type <literal>a{sv}</literal>,
 * type <literal>String_Variant_Map</literal>,
 * named <literal>Parameters</literal>):
 * (Undocumented)
 *
 */
/**
 * TP_HASH_TYPE_CONTACT_PRESENCES:
 *
 * Mapping returned by         &lt;tp:member-ref&gt;GetPresence&lt;/tp:member-ref&gt; and signalled by         &lt;tp:member-ref&gt;PresenceUpdate&lt;/tp:member-ref&gt;, where the keys are         contacts and the values represent their presences.
 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GHashTable
 * appropriate for representing a D-Bus
 * dictionary of signature
 * <literal>a{u(ua{sa{sv}})}</literal>.
 *
 * Keys (D-Bus type <literal>u</literal>,
 * type <literal>Contact_Handle</literal>,
 * named <literal>Contact</literal>):
 * (Undocumented)
 *
 * Values (D-Bus type <literal>(ua{sa{sv}})</literal>,
 * type <literal>Last_Activity_And_Statuses</literal>,
 * named <literal>Presence</literal>):
 * (Undocumented)
 *
 */
/**
 * TP_HASH_TYPE_STATUS_SPEC_MAP:
 *
 * (Undocumented)
 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GHashTable
 * appropriate for representing a D-Bus
 * dictionary of signature
 * <literal>a{s(ubba{ss})}</literal>.
 *
 * Keys (D-Bus type <literal>s</literal>,
 * named <literal>Identifier</literal>):
 * (Undocumented)
 *
 * Values (D-Bus type <literal>(ubba{ss})</literal>,
 * type <literal>Status_Spec</literal>,
 * named <literal>Spec</literal>):
 * (Undocumented)
 *
 */
/**
 * TP_HASH_TYPE_SINGLE_CONTACT_ATTRIBUTES_MAP:
 *
 * Some of the attributes of a single contact.
 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GHashTable
 * appropriate for representing a D-Bus
 * dictionary of signature
 * <literal>a{sv}</literal>.
 *
 * Keys (D-Bus type <literal>s</literal>,
 * type <literal>Contact_Attribute</literal>,
 * named <literal>Attribute</literal>):
 * The name of the attribute
 *
 * Values (D-Bus type <literal>v</literal>,
 * named <literal>Value</literal>):
 * The value of the attribute
 *
 */
/**
 * TP_HASH_TYPE_CONTACT_ATTRIBUTES_MAP:
 *
 * Mapping returned by         &lt;tp:member-ref&gt;GetContactAttributes&lt;/tp:member-ref&gt;, representing a         collection of Contacts and their requested attributes.
 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GHashTable
 * appropriate for representing a D-Bus
 * dictionary of signature
 * <literal>a{ua{sv}}</literal>.
 *
 * Keys (D-Bus type <literal>u</literal>,
 * type <literal>Contact_Handle</literal>,
 * named <literal>Contact</literal>):
 * A contact
 *
 * Values (D-Bus type <literal>a{sv}</literal>,
 * type <literal>Single_Contact_Attributes_Map</literal>,
 * named <literal>Attributes</literal>):
 * Attributes of that contact
 *
 */
/**
 * TP_HASH_TYPE_CHANNEL_CLASS:
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Mapping representing a class of channels that can be requested           from a connection manager, can be handled by a user interface,           are supported by a contact, etc.&lt;/p&gt;          &lt;p&gt;Classes of channel are identified by the fixed values of           a subset of their properties.&lt;/p&gt;          &lt;p&gt;Channel classes SHOULD always include the keys           &lt;tp:dbus-ref&gt;org.freedesktop.Telepathy.Channel.ChannelType&lt;/tp:dbus-ref&gt;           and           &lt;tp:dbus-ref&gt;org.freedesktop.Telepathy.Channel.TargetHandleType&lt;/tp:dbus-ref&gt;.           &lt;/p&gt;
 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GHashTable
 * appropriate for representing a D-Bus
 * dictionary of signature
 * <literal>a{sv}</literal>.
 *
 * Keys (D-Bus type <literal>s</literal>,
 * type <literal>DBus_Qualified_Member</literal>,
 * named <literal>Key</literal>):
 * A D-Bus interface name, followed by a dot and a D-Bus property name.
 *
 * Values (D-Bus type <literal>v</literal>,
 * named <literal>Value</literal>):
 * The value of the property.
 *
 */
/**
 * TP_ARRAY_TYPE_CHANNEL_CLASS_LIST:

 * Expands to a call to a function
 * that returns the #GType of a #GPtrArray
 * of #TP_HASH_TYPE_CHANNEL_CLASS.
 */

/**
 * TP_HASH_TYPE_LOCATION:
 *
 * A user&apos;s location, represented as an extensible mapping.
 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GHashTable
 * appropriate for representing a D-Bus
 * dictionary of signature
 * <literal>a{sv}</literal>.
 *
 * Keys (D-Bus type <literal>s</literal>,
 * named <literal>Key</literal>):
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;            &lt;p&gt;Civic addresses are represented by the following well-known             keys (all of which have string values), which should be kept in             sync with those used in XEP-0080 and in the Geoclue project:&lt;/p&gt;            &lt;ul&gt;             &lt;li&gt;countrycode - s: an ISO-3166-1 alpha-2 (two-letter) country               code, e.g. &amp;quot;us&amp;quot;, &amp;quot;gb&amp;quot;, &amp;quot;fr&amp;quot;&lt;/li&gt;             &lt;li&gt;country - s: a country name in unspecified locale, e.g.               &amp;quot;USA&amp;quot;&lt;/li&gt;             &lt;li&gt;region - s: an administrative region of the nation, such as a               state or province&lt;/li&gt;             &lt;li&gt;locality - s: a locality within the administrative region, such               as a town or city&lt;/li&gt;             &lt;li&gt;area - s: a named area such as a campus or neighborhood&lt;/li&gt;             &lt;li&gt;postalcode - s: a code used for postal delivery&lt;/li&gt;             &lt;li&gt;street - s: a thoroughfare within the locality, or a crossing of               two thoroughfares&lt;/li&gt;           &lt;/ul&gt;            &lt;p&gt;The following address keys are defined in XEP-0080 but not by             Geoclue, and are also allowed:&lt;/p&gt;            &lt;ul&gt;             &lt;li&gt;building - s: a specific building on a street or in an area&lt;/li&gt;             &lt;li&gt;floor - s: a particular floor in a building&lt;/li&gt;             &lt;li&gt;room - s: a particular room in a building&lt;/li&gt;             &lt;li&gt;text - s: any more specific information, e.g.               &amp;quot;Northwest corner of the lobby&amp;quot;&lt;/li&gt;             &lt;li&gt;description - s: A natural-language name for or description of               the location, e.g. &amp;quot;Bill&apos;s house&amp;quot;&lt;/li&gt;             &lt;li&gt;uri - s: a URI representing the location or pointing to more               information about it&lt;/li&gt;           &lt;/ul&gt;            &lt;p&gt;Since the previous strings have data intended to be read by users,             the language used should be stated using:&lt;/p&gt;            &lt;ul&gt;             &lt;li&gt;language - s: a specific language or locale of location               information in a format compatible to RFC 4646. Note that UTF-8               is the only allowed encoding, e.g. &amp;quot;en&amp;quot; or &amp;quot;fr-CA&amp;quot;.&lt;/li&gt;           &lt;/ul&gt;            &lt;p&gt;Positions are represented by the following well-known keys:&lt;/p&gt;            &lt;ul&gt;             &lt;li&gt;lat - d: latitude in decimal degrees north, -90 to +90,               relative to the WGS-84 datum               &lt;tp:rationale&gt;                 This is from XEP-0080; the XEP allows use of a different                 datum, but recommends this one. We enforce sanity by requiring                 a consistent datum: a minimal compliant implementation of this                 specification in terms of XEP-0080 would simply ignore the                 &amp;lt;lat&amp;gt; and &amp;lt;lon&amp;gt; elements if &amp;lt;datum&amp;gt; exists                 and has a value other than WGS-84, while an advanced                 implementation might correct for the different datum.               &lt;/tp:rationale&gt;             &lt;/li&gt;             &lt;li&gt;lon - d: Longitude in decimal degrees east, -180 to +180,               relative to the WGS-84 datum               &lt;tp:rationale&gt;                 Same rationale as &apos;lat&apos;               &lt;/tp:rationale&gt;             &lt;/li&gt;             &lt;li&gt;alt - d: altitude in metres above sea level (negative               if below sea level)               &lt;tp:rationale&gt;                 This is from XEP-0080               &lt;/tp:rationale&gt;             &lt;/li&gt;              &lt;!-- Potentially to be reinstated later:                  http://bugs.freedesktop.org/show_bug.cgi?id=19585             &lt;li&gt;accuracy-level - i (&lt;tp:type&gt;Location_Accuracy_Level&lt;/tp:type&gt;):               an indication of accuracy, which SHOULD be omitted if it would be               Location_Accuracy_Level_None or               Location_Accuracy_Level_Detailed               &lt;tp:rationale&gt;                 This is a struct field in GeoClue; the name is new in this                 specification, and was chosen in an attempt to avoid clashing                 with any future XEP-0080 terminology.               &lt;/tp:rationale&gt;             &lt;/li&gt;             --&gt;              &lt;li&gt;accuracy - d: horizontal position error in metres if               known               &lt;tp:rationale&gt;                 This is from XEP-0080               &lt;/tp:rationale&gt;             &lt;/li&gt;           &lt;/ul&gt;            &lt;p&gt;Velocities are represented by the following well-known keys:&lt;/p&gt;            &lt;ul&gt;             &lt;li&gt;speed - d: speed in metres per second               &lt;tp:rationale&gt;                 This is from XEP-0080               &lt;/tp:rationale&gt;             &lt;/li&gt;             &lt;li&gt;bearing - d: direction of movement in decimal degrees,               where North is 0 and East is 90               &lt;tp:rationale&gt;                 This is from XEP-0080, and is equivalent to the struct field                 called &amp;quot;direction&amp;quot; in GeoClue               &lt;/tp:rationale&gt;             &lt;/li&gt;           &lt;/ul&gt;            &lt;p&gt;Other well-known keys:&lt;/p&gt;            &lt;ul&gt;             &lt;li&gt;timestamp - x (&lt;tp:type&gt;Unix_Timestamp64&lt;/tp:type&gt;): the time               that the contact was at this location, in seconds since               1970-01-01T00:00:00Z (i.e. the beginning of 1970 in UTC)               &lt;tp:rationale&gt;                 XEP-0080 uses an ISO 8601 string for this, but a number of                 seconds since the epoch is probably easier to work with.               &lt;/tp:rationale&gt;             &lt;/li&gt;           &lt;/ul&gt;
 *
 * Values (D-Bus type <literal>v</literal>,
 * named <literal>Value</literal>):
 * The value corresponding to the well-known key.
 *
 */
/**
 * TP_HASH_TYPE_CONTACT_LOCATIONS:
 *
 * A map from contacts to their locations.
 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GHashTable
 * appropriate for representing a D-Bus
 * dictionary of signature
 * <literal>a{ua{sv}}</literal>.
 *
 * Keys (D-Bus type <literal>u</literal>,
 * type <literal>Contact_Handle</literal>,
 * named <literal>Contact</literal>):
 * A contact
 *
 * Values (D-Bus type <literal>a{sv}</literal>,
 * type <literal>Location</literal>,
 * named <literal>Location</literal>):
 * The contact&apos;s location, which MAY be empty to indicate           that the contact&apos;s location is unknown
 *
 */
/**
 * TP_HASH_TYPE_CONTACT_SEARCH_MAP:
 *
 * A map from search keys to search terms.
 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GHashTable
 * appropriate for representing a D-Bus
 * dictionary of signature
 * <literal>a{ss}</literal>.
 *
 * Keys (D-Bus type <literal>s</literal>,
 * type <literal>Contact_Search_Key</literal>,
 * named <literal>Key</literal>):
 * The search key to match against
 *
 * Values (D-Bus type <literal>s</literal>,
 * named <literal>Term</literal>):
 * The term or terms to be searched for in the search key; depending on           the protocol and the server implementation, this may be matched by           exact or approximate equality, substring matching, word matching           or any other matching algorithm
 *
 */
/**
 * TP_HASH_TYPE_CONTACT_SEARCH_RESULT_MAP:
 *
 * A map from contact identifier to search result, emitted in         the &lt;tp:member-ref&gt;SearchResultReceived&lt;/tp:member-ref&gt;         signal.
 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GHashTable
 * appropriate for representing a D-Bus
 * dictionary of signature
 * <literal>a{sa(sasas)}</literal>.
 *
 * Keys (D-Bus type <literal>s</literal>,
 * named <literal>Contact_Identifier</literal>):
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           The identifier of a contact matching the search terms.            &lt;tp:rationale&gt;             This is an identifier rather than a handle in case we make handles             immortal; see &lt;a href=&quot;https://bugs.freedesktop.org/show_bug.cgi?id=23155&quot;&gt;fd.o#23155&lt;/a&gt;             and &lt;a href=&quot;https://bugs.freedesktop.org/show_bug.cgi?id=13347#c5&quot;&gt;fd.o#13347             comment 5&lt;/a&gt;.           &lt;/tp:rationale&gt;
 *
 * Values (D-Bus type <literal>a(sasas)</literal>,
 * type <literal>Contact_Info_Field[]</literal>,
 * named <literal>Info</literal>):
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           &lt;p&gt;An array of fields representing information about this             contact, in the same format used in the &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Connection.Interface&quot;&gt;ContactInfo&lt;/tp:dbus-ref&gt;             interface. It is possible that a separate call to &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Connection.Interface.ContactInfo&quot;&gt;RequestContactInfo&lt;/tp:dbus-ref&gt;             would return more information than this signal provides.&lt;/p&gt;
 *
 */
/**
 * TP_HASH_TYPE_SUPPORTED_SOCKET_MAP:
 *
 * The supported socket address and access-control types         for tubes. See GetAvailableStreamTubeTypes.
 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GHashTable
 * appropriate for representing a D-Bus
 * dictionary of signature
 * <literal>a{uau}</literal>.
 *
 * Keys (D-Bus type <literal>u</literal>,
 * type <literal>Socket_Address_Type</literal>,
 * named <literal>Address_Type</literal>):
 * (Undocumented)
 *
 * Values (D-Bus type <literal>au</literal>,
 * type <literal>Socket_Access_Control[]</literal>,
 * named <literal>Access_Control</literal>):
 * (Undocumented)
 *
 */
/**
 * TP_HASH_TYPE_DBUS_TUBE_PARTICIPANTS:
 *
 * Represents the participants in a multi-user D-Bus tube, as         used by the &lt;tp:member-ref&gt;DBusNames&lt;/tp:member-ref&gt; property and the         &lt;tp:member-ref&gt;DBusNamesChanged&lt;/tp:member-ref&gt; signal.
 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GHashTable
 * appropriate for representing a D-Bus
 * dictionary of signature
 * <literal>a{us}</literal>.
 *
 * Keys (D-Bus type <literal>u</literal>,
 * type <literal>Contact_Handle</literal>,
 * named <literal>Handle</literal>):
 * The handle of a participant in this D-Bus tube.
 *
 * Values (D-Bus type <literal>s</literal>,
 * type <literal>DBus_Unique_Name</literal>,
 * named <literal>Unique_Name</literal>):
 * That participant&apos;s unique name.
 *
 */
/**
 * TP_HASH_TYPE_CHANNEL_CALL_STATE_MAP:
 *
 * A map from contacts to call states.
 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GHashTable
 * appropriate for representing a D-Bus
 * dictionary of signature
 * <literal>a{uu}</literal>.
 *
 * Keys (D-Bus type <literal>u</literal>,
 * type <literal>Contact_Handle</literal>,
 * named <literal>Contact</literal>):
 * A contact involved in this call.
 *
 * Values (D-Bus type <literal>u</literal>,
 * type <literal>Channel_Call_State_Flags</literal>,
 * named <literal>State</literal>):
 * State flags for the given contact.
 *
 */
/**
 * TP_HASH_TYPE_CHAT_STATE_MAP:
 *
 * A map from contacts to their chat states.
 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GHashTable
 * appropriate for representing a D-Bus
 * dictionary of signature
 * <literal>a{uu}</literal>.
 *
 * Keys (D-Bus type <literal>u</literal>,
 * type <literal>Contact_Handle</literal>,
 * named <literal>Contact</literal>):
 * A contact
 *
 * Values (D-Bus type <literal>u</literal>,
 * type <literal>Channel_Chat_State</literal>,
 * named <literal>State</literal>):
 * The contact&apos;s chat state
 *
 */
/**
 * TP_HASH_TYPE_CHANNEL_ORIGINATOR_MAP:
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         A mapping from members of a conference to the original 1-1 channel with         that contact, if any. See         &lt;tp:member-ref&gt;OriginalChannels&lt;/tp:member-ref&gt; for details.
 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GHashTable
 * appropriate for representing a D-Bus
 * dictionary of signature
 * <literal>a{uo}</literal>.
 *
 * Keys (D-Bus type <literal>u</literal>,
 * type <literal>Contact_Handle</literal>,
 * named <literal>Channel_Specific_Handle</literal>):
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           A channel-specific handle for a participant in this conference.
 *
 * Values (D-Bus type <literal>o</literal>,
 * named <literal>Original_Channel</literal>):
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           The object path of &lt;tp:member-ref&gt;Channels&lt;/tp:member-ref&gt;           representing the original 1-1 channel with           &lt;var&gt;Channel_Specific_Handle&lt;/var&gt;.
 *
 */
/**
 * TP_HASH_TYPE_HANDLE_OWNER_MAP:
 *
 * A map from channel-specific handles to their owners.
 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GHashTable
 * appropriate for representing a D-Bus
 * dictionary of signature
 * <literal>a{uu}</literal>.
 *
 * Keys (D-Bus type <literal>u</literal>,
 * type <literal>Contact_Handle</literal>,
 * named <literal>Channel_Specific_Handle</literal>):
 * A nonzero channel-specific handle
 *
 * Values (D-Bus type <literal>u</literal>,
 * type <literal>Contact_Handle</literal>,
 * named <literal>Global_Handle</literal>):
 * The global handle that owns the corresponding channel-specific           handle, or 0 if this could not be determined
 *
 */
/**
 * TP_HASH_TYPE_HANDLE_IDENTIFIER_MAP:
 *
 * A map from handles to the corresponding normalized string identifier.
 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GHashTable
 * appropriate for representing a D-Bus
 * dictionary of signature
 * <literal>a{us}</literal>.
 *
 * Keys (D-Bus type <literal>u</literal>,
 * type <literal>Contact_Handle</literal>,
 * named <literal>Handle</literal>):
 * A nonzero handle
 *
 * Values (D-Bus type <literal>s</literal>,
 * named <literal>Identifier</literal>):
 * The same string that would be returned by &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Connection&quot;&gt;InspectHandles&lt;/tp:dbus-ref&gt;           for this handle.
 *
 */
/**
 * TP_HASH_TYPE_MESSAGE_PART:
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Part of a message&apos;s content. In practice, this mapping never           appears in isolation: incoming messages are represented by a list of           &lt;tp:type&gt;Message_Part&lt;/tp:type&gt; mappings in the           &lt;tp:member-ref&gt;MessageReceived&lt;/tp:member-ref&gt; signal, and outgoing           messages are passed to &lt;tp:member-ref&gt;SendMessage&lt;/tp:member-ref&gt; as           a list of these mappings.&lt;/p&gt;          &lt;p&gt;The first part of the message contains &amp;quot;headers&amp;quot;, which refer           to the entire message. The second and subsequent parts contain the           message&apos;s content, including plain text, formatted text and/or           attached files. Well-known keys for the header and body parts are           defined by the &lt;tp:type&gt;Message_Header_Key&lt;/tp:type&gt; and           &lt;tp:type&gt;Message_Body_Key&lt;/tp:type&gt; types, respectively.  It is an           error for a connection manager to put keys referring to the message           as a whole in the second or subsequent Message_Part, or keys intended           for body parts in the first Message_Part; clients MUST recover from           this error by ignoring these mis-placed keys.&lt;/p&gt;          &lt;tp:rationale&gt;           &lt;p&gt;Instead of representing messages as aa{sv} where the first             dictionary is special (a dictionary of headers), we could have             used a signature like (a{sv}aa{sv}) to separate out the headers             and the body parts.&lt;/p&gt;            &lt;p&gt;However, this would make access to the messages more awkward.             In Python, the syntax for access to a header field would remain             &lt;code&gt;message[0][&apos;message-type&apos;]&lt;/code&gt;, but access to a body             field in the second body part would change from             &lt;code&gt;message[2][&apos;content&apos;] to message[1][1][&apos;content&apos;]&lt;/code&gt;. In             GLib, the message would change from being a             &lt;code&gt;GPtrArray(GHashTable)&lt;/code&gt; to being a             &lt;code&gt;GValueArray(GHashTable, GPtrArray(GHashTable))&lt;/code&gt; which             is rather inconvenient to dereference.&lt;/p&gt;         &lt;/tp:rationale&gt;          &lt;p&gt;In any group of parts with the same non-empty value for the           &lt;tt&gt;alternative&lt;/tt&gt; key (which represent alternative versions of the           same content), more faithful versions of the intended message MUST           come before less faithful versions (note that this order is the           opposite of MIME &lt;tt&gt;multipart/alternative&lt;/tt&gt; parts). Clients           SHOULD display the first alternative that they understand.&lt;/p&gt;          &lt;tp:rationale&gt;           &lt;p&gt;Specifying the preference order means that if the underlying             protocol doesn&apos;t support alternatives, the CM can safely delete             everything apart from the first supported alternative when             sending messages.&lt;/p&gt;            &lt;p&gt;The order is the reverse of MIME because MIME&apos;s rationale for             placing the &amp;quot;plainest&amp;quot; part first (legibility in pre-MIME UAs)             does not apply to us, and placing the most preferred part             first simplifies display (a client can iterate the message             in order, display the first alternative that it understands,             and skip displaying all subsequent parts with the same             &amp;quot;alternative&amp;quot; key).&lt;/p&gt;         &lt;/tp:rationale&gt;          &lt;p&gt;Clients SHOULD present all parts that are not redundant           alternatives in the order they appear in this array, possibly           excluding parts that are referenced by another displayed part.           It is implementation-specific how the parts are presented to the           user.&lt;/p&gt;          &lt;tp:rationale&gt;           &lt;p&gt;This allows CMs to assume that all parts are actually shown to             the user, even if they are not explicitly referenced - we do             not yet recommend formatted text, and there is no way for             plain text to reference an attachment since it has no concept of             markup or references. This also forces clients to do something             sensible with messages that consist entirely of &amp;quot;attachments&amp;quot;,             with no &amp;quot;body&amp;quot; at all.&lt;/p&gt;            &lt;p&gt;For instance, when displaying the above example, a client that             understands the HTML part should display the JPEG image once,             between the two lines &amp;quot;Here is a photo of my cat:&amp;quot; and             &amp;quot;Isn&apos;t it cute?&amp;quot;; it may additionally present the image in some             way for a second time, after &amp;quot;Isn&apos;t it cute?&amp;quot;, or may choose             not to.&lt;/p&gt;            &lt;p&gt;A client that does not understand HTML, displaying the same             message, should display the plain-text part, followed by the JPEG             image.&lt;/p&gt;         &lt;/tp:rationale&gt;          &lt;h4&gt;Example messages&lt;/h4&gt;          &lt;p&gt;A rich-text message, with an embedded image, might be represented           as:&lt;/p&gt;            &lt;pre&gt; [   {     &apos;message-token&apos;: &apos;9de9546a-3400-4419-a505-3ea270cb834c&apos;,     &apos;message-sender&apos;: 42,     &apos;message-sent&apos;: 1210067943,     &apos;message-received&apos;: 1210067947,     &apos;message-type&apos;: 0,              # = Channel_Text_Message_Type_Normal     &apos;pending-message-id&apos;: 437,   },   { &apos;alternative&apos;: &apos;main&apos;,     &apos;content-type&apos;: &apos;text/html&apos;,     &apos;content&apos;: &apos;Here is a photo of my cat:&amp;lt;br /&amp;gt;&apos; +                &apos;&amp;lt;img src=&amp;quot;cid:catphoto&amp;quot; alt=&amp;quot;lol!&amp;quot; /&amp;gt;&apos; +                &apos;&amp;lt;br /&amp;gt;Isn&apos;t it cute?&apos;,   },   { &apos;alternative&apos;: &apos;main&apos;,     &apos;content-type&apos;: &apos;text/plain&apos;,     &apos;content&apos;: &apos;Here is a photo of my cat:\n[IMG: lol!]\nIsn&apos;t it cute?&apos;,   },   { &apos;identifier&apos;: &apos;catphoto&apos;,     &apos;content-type&apos;: &apos;image/jpeg&apos;,     &apos;size&apos;: 101000,     &apos;needs-retrieval&apos;: True,   }, ]&lt;/pre&gt;          &lt;p&gt;telepathy-ring, Nokia&apos;s GSM connection manager, represents vCards           sent via SMS as:&lt;/p&gt;          &lt;pre&gt; [   {     &apos;message-token&apos;: &apos;9de9546a-3400-4419-a505-3ea270cb834c&apos;,     &apos;message-sender&apos;: 42,     &apos;message-sent&apos;: 1210067943,     &apos;message-received&apos;: 1210067947,     &apos;message-type&apos;: 0,              # = Channel_Text_Message_Type_Normal     &apos;pending-message-id&apos;: 437,   },   { &apos;content-type&apos;: &apos;text/x-vcard&apos;,     &apos;content&apos;: [ 0x66, 0x69, 0x71, ...], # vCard data as an array of bytes   }, ]&lt;/pre&gt;          &lt;h3&gt;Delivery reports&lt;/h3&gt;          &lt;div&gt;           &lt;p&gt;Delivery reports are also represented as messages with the             &lt;tt&gt;message-type&lt;/tt&gt; header mapping to             &lt;tp:type&gt;Channel_Text_Message_Type&lt;/tp:type&gt; Delivery_Report.             Delivery reports SHOULD contain the &lt;tt&gt;message-sender&lt;/tt&gt; header,             mapping to the intended recipient of the original message, if             possible; other headers specific to delivery reports are defined by             the &lt;tp:type&gt;Delivery_Report_Header_Key&lt;/tp:type&gt; type. The second             and subsequent parts, if present, are a human-readable report from             the IM service.&lt;/p&gt;            &lt;p&gt;For backwards- and forwards-compatibility, whenever a delivery             error report is signalled—that is, with &lt;tt&gt;delivery-status&lt;/tt&gt;             mapping to &lt;tp:type&gt;Delivery_Status&lt;/tp:type&gt; Temporarily_Failed or             Permanently_Failed—&lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Channel.Type.Text&quot;&gt;SendError&lt;/tp:dbus-ref&gt;             SHOULD also be emitted; whenever &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Channel.Type.Text&quot;&gt;SendError&lt;/tp:dbus-ref&gt;             is emitted, a delivery report MUST also be signalled.             Delivery report messages on this interface MUST be represented in             emissions of &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Channel.Type.Text&quot;&gt;Received&lt;/tp:dbus-ref&gt;             as messages with the Non_Text_Content             &lt;tp:type&gt;Channel_Text_Message_Flags&lt;/tp:type&gt;; clients which             understand this interface SHOULD ignore the SendError signal in             favour of listening for delivery reports, as mentioned in the             introduction.&lt;/p&gt;            &lt;p&gt;The result of attempting to send delivery reports using             &lt;tp:member-ref&gt;SendMessage&lt;/tp:member-ref&gt; is currently             undefined.&lt;/p&gt;            &lt;h4&gt;Example delivery reports&lt;/h4&gt;            &lt;dl&gt;             &lt;dt&gt;A minimal delivery report indicating permanent failure of the               sent message whose token was               &lt;code&gt;b9a991bd-8845-4d7f-a704-215186f43bb4&lt;/code&gt; for an unknown               reason&lt;/dt&gt;             &lt;dd&gt;&lt;pre&gt; [{ # header &apos;message-sender&apos;: 123, &apos;message-type&apos;: Channel_Text_Message_Type_Delivery_Report, &apos;delivery-status&apos;: Delivery_Status_Permanently_Failed, &apos;delivery-token&apos;: &apos;b9a991bd-8845-4d7f-a704-215186f43bb4&apos;, } # no body ]&lt;/pre&gt;&lt;/dd&gt;              &lt;dt&gt;A delivery report where the failed message is echoed back to the               sender rather than being referenced by ID, and the failure reason               is that this protocol cannot send messages to offline contacts               such as the contact with handle 123&lt;/dt&gt;             &lt;dd&gt;&lt;pre&gt; [{ # header &apos;message-sender&apos;: 123, &apos;message-type&apos;: Channel_Text_Message_Type_Delivery_Report, &apos;delivery-status&apos;: Delivery_Status_Temporarily_Failed, &apos;delivery-error&apos;: Channel_Text_Send_Error_Offline, &apos;delivery-echo&apos;:     [{ # header of original message     &apos;message-sender&apos;: 1,     &apos;message-sent&apos;: 1210067943,     },     { # body of original message     &apos;content-type&apos;: &apos;text/plain&apos;,     &apos;content&apos;: &apos;Hello, world!&apos;,     }]   ],  # no body ]&lt;/pre&gt;&lt;/dd&gt;              &lt;dt&gt;A maximally complex delivery report: the server reports a               bilingual human-readable failure message because the user sent               a message &amp;quot;Hello, world!&amp;quot; with token               &lt;code&gt;b9a991bd-8845-4d7f-a704-215186f43bb4&lt;/code&gt; to a contact               with handle 123, but that handle represents a contact who does not               actually exist&lt;/dt&gt;             &lt;dd&gt;&lt;pre&gt; [{ # header &apos;message-sender&apos;: 123, &apos;message-type&apos;: Channel_Text_Message_Type_Delivery_Report, &apos;delivery-status&apos;: Delivery_Status_Permanently_Failed, &apos;delivery-error&apos;: Channel_Text_Send_Error_Invalid_Contact, &apos;delivery-token&apos;: &apos;b9a991bd-8845-4d7f-a704-215186f43bb4&apos;, &apos;delivery-echo&apos;:     [{ # header of original message     &apos;message-sender&apos;: 1,     &apos;message-sent&apos;: 1210067943,     },     { # body of original message     &apos;content-type&apos;: &apos;text/plain&apos;,     &apos;content&apos;: &apos;Hello, world!&apos;,     }]   ], }, { # message from server (alternative in English) &apos;alternative&apos;: &apos;404&apos;, &apos;content-type&apos;: &apos;text/plain&apos;, &apos;lang&apos;: &apos;en&apos;, &apos;content&apos;: &apos;I have no contact with that name&apos;, }, { # message from server (alternative in German) &apos;alternative&apos;: &apos;404&apos;. &apos;content-type&apos;: &apos;text/plain&apos;, &apos;lang&apos;: &apos;de&apos;, &apos;content&apos;, &apos;Ich habe keinen Kontakt mit diesem Namen&apos;, } ]&lt;/pre&gt;&lt;/dd&gt;              &lt;dt&gt;A minimal delivery report indicating successful delivery               of the sent message whose token was               &lt;code&gt;b9a991bd-8845-4d7f-a704-215186f43bb4&lt;/code&gt;&lt;/dt&gt;             &lt;dd&gt;&lt;pre&gt; [{ # header &apos;message-sender&apos;: 123, &apos;message-type&apos;: Channel_Text_Message_Type_Delivery_Report, &apos;delivery-status&apos;: Delivery_Status_Delivered, &apos;delivery-token&apos;: &apos;b9a991bd-8845-4d7f-a704-215186f43bb4&apos;, } # no body ]&lt;/pre&gt;&lt;/dd&gt;            &lt;/dl&gt;          &lt;/div&gt;
 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GHashTable
 * appropriate for representing a D-Bus
 * dictionary of signature
 * <literal>a{sv}</literal>.
 *
 * Keys (D-Bus type <literal>s</literal>,
 * named <literal>Key</literal>):
 * A key, which SHOULD be one of the well-known keys specified by           &lt;tp:type&gt;Message_Header_Key&lt;/tp:type&gt;,           &lt;tp:type&gt;Message_Body_Key&lt;/tp:type&gt; or           &lt;tp:type&gt;Delivery_Report_Header_Key&lt;/tp:type&gt; if possible.
 *
 * Values (D-Bus type <literal>v</literal>,
 * named <literal>Value</literal>):
 * The value corresponding to the given key, which SHOULD be one of the           specified types for well-known keys.
 *
 */
/**
 * TP_ARRAY_TYPE_MESSAGE_PART_LIST:

 * Expands to a call to a function
 * that returns the #GType of a #GPtrArray
 * of #TP_HASH_TYPE_MESSAGE_PART.
 */

/**
 * TP_HASH_TYPE_MESSAGE_PART_CONTENT_MAP:
 *
 * A mapping from message part indexes to their content, as returned by         &lt;tp:member-ref&gt;GetPendingMessageContent&lt;/tp:member-ref&gt;.
 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GHashTable
 * appropriate for representing a D-Bus
 * dictionary of signature
 * <literal>a{uv}</literal>.
 *
 * Keys (D-Bus type <literal>u</literal>,
 * type <literal>Message_Part_Index</literal>,
 * named <literal>Part</literal>):
 * Indexes into the array of &lt;tp:type&gt;Message_Part&lt;/tp:type&gt;s that           represents a message. The &amp;quot;headers&amp;quot; part (which is not a valid           argument to GetPendingMessageContent) is considered to be part 0,           so the valid part numbers start at 1 (for the second message part).
 *
 * Values (D-Bus type <literal>v</literal>,
 * named <literal>Content</literal>):
 * The message part&apos;s content. The variant MUST contain either type           &apos;s&apos; or &apos;ay&apos; (UTF-8 text string, or byte array), following the           same rules as for the value of the &apos;content&apos; key in           the &lt;tp:type&gt;Message_Part&lt;/tp:type&gt; mappings.
 *
 */
/**
 * TP_HASH_TYPE_QUALIFIED_PROPERTY_VALUE_MAP:
 *
 * A mapping from strings representing D-Bus       properties (by their namespaced names) to their values.
 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GHashTable
 * appropriate for representing a D-Bus
 * dictionary of signature
 * <literal>a{sv}</literal>.
 *
 * Keys (D-Bus type <literal>s</literal>,
 * type <literal>DBus_Qualified_Member</literal>,
 * named <literal>Key</literal>):
 * A D-Bus interface name, followed by a dot and a D-Bus property name.
 *
 * Values (D-Bus type <literal>v</literal>,
 * named <literal>Value</literal>):
 * The value of the property.
 *
 */
/**
 * TP_ARRAY_TYPE_QUALIFIED_PROPERTY_VALUE_MAP_LIST:

 * Expands to a call to a function
 * that returns the #GType of a #GPtrArray
 * of #TP_HASH_TYPE_QUALIFIED_PROPERTY_VALUE_MAP.
 */

/**
 * TP_HASH_TYPE_STRING_VARIANT_MAP:
 *
 * A mapping from strings to variants representing extra       key-value pairs.
 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GHashTable
 * appropriate for representing a D-Bus
 * dictionary of signature
 * <literal>a{sv}</literal>.
 *
 * Keys (D-Bus type <literal>s</literal>,
 * named <literal>Key</literal>):
 * (Undocumented)
 *
 * Values (D-Bus type <literal>v</literal>,
 * named <literal>Value</literal>):
 * (Undocumented)
 *
 */
/**
 * TP_ARRAY_TYPE_STRING_VARIANT_MAP_LIST:

 * Expands to a call to a function
 * that returns the #GType of a #GPtrArray
 * of #TP_HASH_TYPE_STRING_VARIANT_MAP.
 */

/**
 * TP_HASH_TYPE_STRING_STRING_MAP:
 *
 * A mapping from strings to strings representing extra       key-value pairs.
 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GHashTable
 * appropriate for representing a D-Bus
 * dictionary of signature
 * <literal>a{ss}</literal>.
 *
 * Keys (D-Bus type <literal>s</literal>,
 * named <literal>Key</literal>):
 * (Undocumented)
 *
 * Values (D-Bus type <literal>s</literal>,
 * named <literal>Value</literal>):
 * (Undocumented)
 *
 */
/**
 * TP_ARRAY_TYPE_STRING_STRING_MAP_LIST:

 * Expands to a call to a function
 * that returns the #GType of a #GPtrArray
 * of #TP_HASH_TYPE_STRING_STRING_MAP.
 */

/**
 * TP_HASH_TYPE_OBJECT_IMMUTABLE_PROPERTIES_MAP:
 *
 * A mapping from object path to the immutable properties of         the object.
 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GHashTable
 * appropriate for representing a D-Bus
 * dictionary of signature
 * <literal>a{oa{sv}}</literal>.
 *
 * Keys (D-Bus type <literal>o</literal>,
 * named <literal>Path</literal>):
 * The object path of an object
 *
 * Values (D-Bus type <literal>a{sv}</literal>,
 * type <literal>Qualified_Property_Value_Map</literal>,
 * named <literal>Immutable_Properties</literal>):
 * The immutable properties of the object
 *
 */
/**
 * TP_ARRAY_TYPE_OBJECT_IMMUTABLE_PROPERTIES_MAP_LIST:

 * Expands to a call to a function
 * that returns the #GType of a #GPtrArray
 * of #TP_HASH_TYPE_OBJECT_IMMUTABLE_PROPERTIES_MAP.
 */

/**
 * TP_STRUCT_TYPE_PARAM_SPEC:

 * 
	A struct representing an allowed parameter, as returned
        by GetParameters on the ConnectionManager interface.

 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GValueArray
 * appropriate for representing a D-Bus struct
 * with signature <literal>(susv)</literal>.
 *
 * Member 0 (D-Bus type <literal>s</literal>,
 * named <literal>Name</literal>):
 * A string parameter name
 *
 * Member 1 (D-Bus type <literal>u</literal>,
 * type <literal>Conn_Mgr_Param_Flags</literal>,
 * named <literal>Flags</literal>):
 * A bitwise OR of the parameter flags
 *
 * Member 2 (D-Bus type <literal>s</literal>,
 * type <literal>DBus_Signature</literal>,
 * named <literal>Signature</literal>):
 * A string containing the D-Bus type signature           for this parameter
 *
 * Member 3 (D-Bus type <literal>v</literal>,
 * named <literal>Default_Value</literal>):
 * The default value (if the Has_Default flag is not           present, there is no default and this takes some dummy value,           which SHOULD be of the appropriate D-Bus type)
 *
 */

/**
 * TP_ARRAY_TYPE_PARAM_SPEC_LIST:

 * Expands to a call to a function
 * that returns the #GType of a #GPtrArray
 * of #TP_STRUCT_TYPE_PARAM_SPEC.
 */

/**
 * TP_STRUCT_TYPE_CHANNEL_INFO:

 * 
	A struct representing a channel, as returned by
        ListChannels on the Connection interface.

 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GValueArray
 * appropriate for representing a D-Bus struct
 * with signature <literal>(osuu)</literal>.
 *
 * Member 0 (D-Bus type <literal>o</literal>,
 * named <literal>Channel</literal>):
 * The object path of the channel, which is on the           same bus name as the connection
 *
 * Member 1 (D-Bus type <literal>s</literal>,
 * type <literal>DBus_Interface</literal>,
 * named <literal>Channel_Type</literal>):
 * The channel&apos;s type
 *
 * Member 2 (D-Bus type <literal>u</literal>,
 * type <literal>Handle_Type</literal>,
 * named <literal>Handle_Type</literal>):
 * The type of the handle that the channel communicates           with, or Handle_Type_None if there is no associated           handle
 *
 * Member 3 (D-Bus type <literal>u</literal>,
 * type <literal>Handle</literal>,
 * named <literal>Handle</literal>):
 * The handle that the channel communicates with,           or 0 if there is no associated handle
 *
 */

/**
 * TP_ARRAY_TYPE_CHANNEL_INFO_LIST:

 * Expands to a call to a function
 * that returns the #GType of a #GPtrArray
 * of #TP_STRUCT_TYPE_CHANNEL_INFO.
 */

/**
 * TP_STRUCT_TYPE_ALIAS_PAIR:

 * 
	
        A pair (contact handle, alias) as seen in the
        
	&lt;tp:member-ref&gt;
		AliasesChanged
	&lt;/tp:member-ref&gt;
	 signal.
      

 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GValueArray
 * appropriate for representing a D-Bus struct
 * with signature <literal>(us)</literal>.
 *
 * Member 0 (D-Bus type <literal>u</literal>,
 * type <literal>Contact_Handle</literal>,
 * named <literal>Handle</literal>):
 * (Undocumented)
 *
 * Member 1 (D-Bus type <literal>s</literal>,
 * named <literal>Alias</literal>):
 * (Undocumented)
 *
 */

/**
 * TP_ARRAY_TYPE_ALIAS_PAIR_LIST:

 * Expands to a call to a function
 * that returns the #GType of a #GPtrArray
 * of #TP_STRUCT_TYPE_ALIAS_PAIR.
 */

/**
 * TP_STRUCT_TYPE_CURRENCY_AMOUNT:

 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;
	
        
	&lt;p&gt;
		An amount of money in a specified currency. For example,
          3.21 British pounds would conventionally be represented by
          (
		&lt;var&gt;
			Amount
		&lt;/var&gt;
		 = 
		&lt;tt&gt;
			321
		&lt;/tt&gt;
		, 
		&lt;var&gt;
			Scale
		&lt;/var&gt;
		 = 
		&lt;tt&gt;
			2
		&lt;/tt&gt;
		,
          
		&lt;var&gt;
			Currency
		&lt;/var&gt;
		 = 
		&lt;tt&gt;
			&amp;quot;GBP&amp;quot;
		&lt;/tt&gt;
		), but could be represented by
          (
		&lt;var&gt;
			Amount
		&lt;/var&gt;
		 = 
		&lt;tt&gt;
			3210
		&lt;/tt&gt;
		, 
		&lt;var&gt;
			Scale
		&lt;/var&gt;
		 = 
		&lt;tt&gt;
			3
		&lt;/tt&gt;
		,
          
		&lt;var&gt;
			Currency
		&lt;/var&gt;
		 = 
		&lt;tt&gt;
			&amp;quot;GBP&amp;quot;
		&lt;/tt&gt;
		) in a service that records
          balance in units of 0.001 pounds.
	&lt;/p&gt;
	

        
	&lt;p&gt;
		As a special case, if 
		&lt;var&gt;
			Amount
		&lt;/var&gt;
		 = 
		&lt;tt&gt;
			0
		&lt;/tt&gt;
		,
          
		&lt;var&gt;
			Scale
		&lt;/var&gt;
		 = 
		&lt;tt&gt;
			2**32 - 1
		&lt;/tt&gt;
		 (i.e.  the largest possible
          32-bit unsigned integer) and 
		&lt;var&gt;
			Currency
		&lt;/var&gt;
		 = 
		&lt;tt&gt;
			&amp;quot;&amp;quot;
		&lt;/tt&gt;
		, this
          indicates an unknown amount.
	&lt;/p&gt;
	
      

 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GValueArray
 * appropriate for representing a D-Bus struct
 * with signature <literal>(ius)</literal>.
 *
 * Member 0 (D-Bus type <literal>i</literal>,
 * named <literal>Amount</literal>):
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           &lt;p&gt;The amount, expressed as a fixed-point number with decimal scale             defined by the &lt;var&gt;Scale&lt;/var&gt; field; for instance, an             &lt;var&gt;Amount&lt;/var&gt; value of &lt;tt&gt;1234&lt;/tt&gt; with &lt;var&gt;Scale&lt;/var&gt; of             &lt;tt&gt;2&lt;/tt&gt; represents 12.34 in the currency unit given by the             &lt;var&gt;Currency&lt;/var&gt; field.&lt;/p&gt;
 *
 * Member 1 (D-Bus type <literal>u</literal>,
 * named <literal>Scale</literal>):
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           &lt;p&gt;The decimal scale for the fixed point value of the             &lt;var&gt;Amount&lt;/var&gt; field, defining the number of rightmost decimal             digits from the integer value which form the fractional part of the             resulting currency value.&lt;/p&gt;            &lt;p&gt;As well as defining the interpretation of &lt;var&gt;Amount&lt;/var&gt;, user             interfaces may use this value to determine the precision with which             to display the amount.&lt;/p&gt;
 *
 * Member 2 (D-Bus type <literal>s</literal>,
 * named <literal>Currency</literal>):
 * The currency code represented by this amount, which SHOULD be an           international currency code such as &lt;tt&gt;&amp;quot;EUR&amp;quot;&lt;/tt&gt;, &lt;tt&gt;&amp;quot;USD&amp;quot;&lt;/tt&gt;,           or &lt;tt&gt;&amp;quot;JPY&amp;quot;&lt;/tt&gt; if possible. An empty string can be used to           indicate that the currency is not known.
 *
 */

/**
 * TP_STRUCT_TYPE_CAPABILITY_PAIR:

 * 
	A pair (channel type, type-specific flags) as passed to
        
	&lt;tp:member-ref&gt;
		AdvertiseCapabilities
	&lt;/tp:member-ref&gt;
	 on the
        Capabilities interface.

 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GValueArray
 * appropriate for representing a D-Bus struct
 * with signature <literal>(su)</literal>.
 *
 * Member 0 (D-Bus type <literal>s</literal>,
 * type <literal>DBus_Interface</literal>,
 * named <literal>Channel_Type</literal>):
 * (Undocumented)
 *
 * Member 1 (D-Bus type <literal>u</literal>,
 * named <literal>Type_Specific_Flags</literal>):
 * (Undocumented)
 *
 */

/**
 * TP_ARRAY_TYPE_CAPABILITY_PAIR_LIST:

 * Expands to a call to a function
 * that returns the #GType of a #GPtrArray
 * of #TP_STRUCT_TYPE_CAPABILITY_PAIR.
 */

/**
 * TP_STRUCT_TYPE_CONTACT_CAPABILITY:

 * 
	A struct (contact handle, channel type, generic flags,
        type-specific flags) representing a capability posessed by a contact,
        as returned by 
	&lt;tp:member-ref&gt;
		GetCapabilities
	&lt;/tp:member-ref&gt;
	 on the
        Capabilities interface.

 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GValueArray
 * appropriate for representing a D-Bus struct
 * with signature <literal>(usuu)</literal>.
 *
 * Member 0 (D-Bus type <literal>u</literal>,
 * type <literal>Contact_Handle</literal>,
 * named <literal>Handle</literal>):
 * (Undocumented)
 *
 * Member 1 (D-Bus type <literal>s</literal>,
 * type <literal>DBus_Interface</literal>,
 * named <literal>Channel_Type</literal>):
 * (Undocumented)
 *
 * Member 2 (D-Bus type <literal>u</literal>,
 * type <literal>Connection_Capability_Flags</literal>,
 * named <literal>Generic_Flags</literal>):
 * (Undocumented)
 *
 * Member 3 (D-Bus type <literal>u</literal>,
 * named <literal>Type_Specific_Flags</literal>):
 * (Undocumented)
 *
 */

/**
 * TP_ARRAY_TYPE_CONTACT_CAPABILITY_LIST:

 * Expands to a call to a function
 * that returns the #GType of a #GPtrArray
 * of #TP_STRUCT_TYPE_CONTACT_CAPABILITY.
 */

/**
 * TP_STRUCT_TYPE_CAPABILITY_CHANGE:

 * 
	A struct (contact handle, channel type, old generic flags,
        new generic flags, old type-specific flags, new type-specific flags)
        representing a change to one of a contact&apos;s capabilities, as seen in the
        
	&lt;tp:member-ref&gt;
		CapabilitiesChanged
	&lt;/tp:member-ref&gt;
	 signal on the
        Capabilities interface.

 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GValueArray
 * appropriate for representing a D-Bus struct
 * with signature <literal>(usuuuu)</literal>.
 *
 * Member 0 (D-Bus type <literal>u</literal>,
 * type <literal>Contact_Handle</literal>,
 * named <literal>Handle</literal>):
 * (Undocumented)
 *
 * Member 1 (D-Bus type <literal>s</literal>,
 * type <literal>DBus_Interface</literal>,
 * named <literal>Channel_Type</literal>):
 * (Undocumented)
 *
 * Member 2 (D-Bus type <literal>u</literal>,
 * type <literal>Connection_Capability_Flags</literal>,
 * named <literal>Old_Generic_Flags</literal>):
 * (Undocumented)
 *
 * Member 3 (D-Bus type <literal>u</literal>,
 * type <literal>Connection_Capability_Flags</literal>,
 * named <literal>New_Generic_Flags</literal>):
 * (Undocumented)
 *
 * Member 4 (D-Bus type <literal>u</literal>,
 * named <literal>Old_Type_Specific_Flags</literal>):
 * (Undocumented)
 *
 * Member 5 (D-Bus type <literal>u</literal>,
 * named <literal>New_Type_Specific_Flags</literal>):
 * (Undocumented)
 *
 */

/**
 * TP_ARRAY_TYPE_CAPABILITY_CHANGE_LIST:

 * Expands to a call to a function
 * that returns the #GType of a #GPtrArray
 * of #TP_STRUCT_TYPE_CAPABILITY_CHANGE.
 */

/**
 * TP_STRUCT_TYPE_HANDLER_CAPABILITIES:

 * 
	
        A structure representing the capabilities of a single client.
      

 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GValueArray
 * appropriate for representing a D-Bus struct
 * with signature <literal>(saa{sv}as)</literal>.
 *
 * Member 0 (D-Bus type <literal>s</literal>,
 * type <literal>DBus_Well_Known_Name</literal>,
 * named <literal>Well_Known_Name</literal>):
 * For implementations of the &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy&quot;&gt;Client&lt;/tp:dbus-ref&gt;           interface, the well-known bus name name of the client; for any other           process, any other reversed domain name that uniquely identifies it.
 *
 * Member 1 (D-Bus type <literal>aa{sv}</literal>,
 * type <literal>String_Variant_Map[]</literal>,
 * named <literal>Channel_Classes</literal>):
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           An array of channel classes that can be handled by this client.           This will usually be a copy of the client&apos;s &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Client.Handler&quot;&gt;HandlerChannelFilter&lt;/tp:dbus-ref&gt;           property.
 *
 * Member 2 (D-Bus type <literal>as</literal>,
 * type <literal>Handler_Capability_Token[]</literal>,
 * named <literal>Capabilities</literal>):
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           An array of client capabilities supported by this client, to be           used by the connection manager to determine what capabilities to           advertise. This will usually be a copy of the client&apos;s &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Client.Handler&quot;&gt;Capabilities&lt;/tp:dbus-ref&gt;           property.
 *
 */

/**
 * TP_ARRAY_TYPE_HANDLER_CAPABILITIES_LIST:

 * Expands to a call to a function
 * that returns the #GType of a #GPtrArray
 * of #TP_STRUCT_TYPE_HANDLER_CAPABILITIES.
 */

/**
 * TP_STRUCT_TYPE_CONTACT_INFO_FIELD:

 * 
	
          The name of the field; this is the lowercased name of a vCard field.
          For example, a field representing a contact&apos;s address would be named
          &amp;quot;adr&amp;quot;.
        

 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GValueArray
 * appropriate for representing a D-Bus struct
 * with signature <literal>(sasas)</literal>.
 *
 * Member 0 (D-Bus type <literal>s</literal>,
 * named <literal>Field_Name</literal>):
 * The name of the field; this is the lowercased name of a vCard field.           For example, a field representing a contact&apos;s address would be named           &amp;quot;adr&amp;quot;.
 *
 * Member 1 (D-Bus type <literal>as</literal>,
 * named <literal>Parameters</literal>):
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           &lt;p&gt;A list of vCard type parameters applicable to this field, with their             values. The type parameter names, and any values that are             case-insensitive in vCard, MUST be in lower case. For example, a             contact&apos;s preferred home address would have parameters             &apos;type=home&apos; and &apos;type=pref&apos;.&lt;/p&gt;            &lt;tp:rationale&gt;             The type parameter &apos;type&apos; is likely to be the most common, but             there can be others, such as &apos;language=en&apos;.           &lt;/tp:rationale&gt;            &lt;p&gt;Characters which are required to be escaped in vCard type             parameters should not be escaped in this list. For instance,             a field &amp;quot;X-FOO;SEMICOLON=\;:bar&amp;quot; in a vCard would become             (&apos;x-foo&apos;, [&apos;semicolon=;&apos;], [&apos;bar&apos;]) in this interface.&lt;/p&gt;            &lt;tp:rationale&gt;             This avoids Telepathy UIs having to understand the escaping and             unescaping rules for vCards. The type parameter name is not             allowed (by RFC 2425) to contain an &apos;=&apos; character, so no ambiguity             is introduced.           &lt;/tp:rationale&gt;
 *
 * Member 2 (D-Bus type <literal>as</literal>,
 * named <literal>Field_Value</literal>):
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           &lt;p&gt;For unstructured vCard fields (such as &apos;fn&apos;, a formatted name             field), a single-element array containing the field&apos;s value.&lt;/p&gt;            &lt;p&gt;For structured fields (such as &apos;adr&apos;, an address field), an array             corresponding to the semicolon-separated elements of the field (with             empty strings for empty elements).&lt;/p&gt;            &lt;p&gt;A vCard field with multiple comma-separated values, such as             &apos;nickname&apos;, should be represented by several             &lt;tp:type&gt;Contact_Info_Field&lt;/tp:type&gt;s.&lt;/p&gt;            &lt;p&gt;Characters which are required to be escaped in vCard values, such as             semi-colons and newlines, should not be escaped in this list (e.g. if             a value contains a newline, the data passed over D-Bus should             contain a literal newline character).&lt;/p&gt;            &lt;tp:rationale&gt;             An earlier draft of this interface split structured vCard fields             into multiple Telepathy-level fields; for example, &apos;n&apos; became             &apos;family-name&apos;, &apos;given-name&apos;, etc.  But under this representation,             omitting empty components leads to difficulty identifying where one             name ends and another begins.  Consider the fields [&apos;given-name&apos;,             &apos;honorific-suffixes&apos;, &apos;family-name&apos;, &apos;honorific-prefixes&apos;]: does             this represent two &apos;n&apos; fields, or one with incorrect component             ordering?           &lt;/tp:rationale&gt;
 *
 */

/**
 * TP_ARRAY_TYPE_CONTACT_INFO_FIELD_LIST:

 * Expands to a call to a function
 * that returns the #GType of a #GPtrArray
 * of #TP_STRUCT_TYPE_CONTACT_INFO_FIELD.
 */

/**
 * TP_STRUCT_TYPE_FIELD_SPEC:

 * 
	A struct describing a vCard field, with parameters, that
        may be passed to 
	&lt;tp:member-ref&gt;
		SetContactInfo
	&lt;/tp:member-ref&gt;
	 on this
        Connection.

 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GValueArray
 * appropriate for representing a D-Bus struct
 * with signature <literal>(sasuu)</literal>.
 *
 * Member 0 (D-Bus type <literal>s</literal>,
 * type <literal>VCard_Field</literal>,
 * named <literal>Name</literal>):
 * A vCard field name, such as &apos;tel&apos;.
 *
 * Member 1 (D-Bus type <literal>as</literal>,
 * type <literal>VCard_Type_Parameter[]</literal>,
 * named <literal>Parameters</literal>):
 * The set of vCard type parameters which may be set on this           field. If this list is empty and the           Contact_Info_Field_Flag_Parameters_Exact flag is not set, any vCard type           parameters may be used.
 *
 * Member 2 (D-Bus type <literal>u</literal>,
 * type <literal>Contact_Info_Field_Flags</literal>,
 * named <literal>Flags</literal>):
 * Flags describing the behaviour of this           field.
 *
 * Member 3 (D-Bus type <literal>u</literal>,
 * named <literal>Max</literal>):
 * Maximum number of instances of this field which may be           set.  MAXUINT32 is used to indicate that there is no           limit.
 *
 */

/**
 * TP_ARRAY_TYPE_FIELD_SPECS:

 * Expands to a call to a function
 * that returns the #GType of a #GPtrArray
 * of #TP_STRUCT_TYPE_FIELD_SPEC.
 */

/**
 * TP_STRUCT_TYPE_SIMPLE_PRESENCE:

 * 
	
        A struct representing the presence of a contact.
      

 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GValueArray
 * appropriate for representing a D-Bus struct
 * with signature <literal>(uss)</literal>.
 *
 * Member 0 (D-Bus type <literal>u</literal>,
 * type <literal>Connection_Presence_Type</literal>,
 * named <literal>Type</literal>):
 * The presence type, e.g. Connection_Presence_Type_Away.
 *
 * Member 1 (D-Bus type <literal>s</literal>,
 * named <literal>Status</literal>):
 * The string identifier of the status, e.g. &amp;quot;brb&amp;quot;, as defined in the           &lt;tp:member-ref&gt;Statuses&lt;/tp:member-ref&gt; property.
 *
 * Member 2 (D-Bus type <literal>s</literal>,
 * named <literal>Status_Message</literal>):
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           &lt;p&gt;The user-defined status message, e.g. &amp;quot;Back soon!&amp;quot;.&lt;/p&gt;            &lt;p&gt;Clients SHOULD set the status message for the local             user to the empty string, unless the user has actually provided             a specific message (i.e. one that conveys more information than the             Status).&lt;/p&gt;            &lt;p&gt;User interfaces SHOULD regard an empty status message as unset,             and MAY replace it with a localized string corresponding to the             Status or Type.&lt;/p&gt;            &lt;tp:rationale&gt;             Use case: Daf sets his status in Empathy by choosing the Welsh             translation of &amp;quot;Available&amp;quot; from a menu.             It is more informative for his English-speaking colleagues             to see the English translation of &amp;quot;Available&amp;quot; (as localized             by their own clients) than to see &amp;quot;Ar Gael&amp;quot; (which they don&apos;t             understand anyway).           &lt;/tp:rationale&gt;
 *
 */

/**
 * TP_STRUCT_TYPE_SIMPLE_STATUS_SPEC:

 * 
	
        A struct containing information about a status.
      

 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GValueArray
 * appropriate for representing a D-Bus struct
 * with signature <literal>(ubb)</literal>.
 *
 * Member 0 (D-Bus type <literal>u</literal>,
 * type <literal>Connection_Presence_Type</literal>,
 * named <literal>Type</literal>):
 * The type of a presence. This SHOULD NOT be used as a way to set           statuses that the client does not recognise (as explained in           &lt;tp:member-ref&gt;SetPresence&lt;/tp:member-ref&gt;), but MAY be used to check           that the client&apos;s assumptions about a particular status name           match the connection manager&apos;s.
 *
 * Member 1 (D-Bus type <literal>b</literal>,
 * named <literal>May_Set_On_Self</literal>):
 * If true, the user can set this status on themselves using           &lt;tp:member-ref&gt;SetPresence&lt;/tp:member-ref&gt;.
 *
 * Member 2 (D-Bus type <literal>b</literal>,
 * named <literal>Can_Have_Message</literal>):
 * If true, a non-empty message can be set for this status. Otherwise,           the empty string is the only acceptable message.            &lt;tp:rationale&gt;             On IRC you can be Away with a status message, but if you are             available you cannot set a status message.           &lt;/tp:rationale&gt;
 *
 */

/**
 * TP_STRUCT_TYPE_RICH_PRESENCE_ACCESS_CONTROL:

 * 
	
        An access control mode for extended presence items like geolocation.
        This type isn&apos;t actually used by the SimplePresence interface, but
        it&apos;s included here so it can be referenced by rich presence interfaces
        such as 
	&lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Connection.Interface&quot;&gt;
		Location
	&lt;/tp:dbus-ref&gt;
	.
      

 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GValueArray
 * appropriate for representing a D-Bus struct
 * with signature <literal>(uv)</literal>.
 *
 * Member 0 (D-Bus type <literal>u</literal>,
 * type <literal>Rich_Presence_Access_Control_Type</literal>,
 * named <literal>Type</literal>):
 * The type of access control to apply.
 *
 * Member 1 (D-Bus type <literal>v</literal>,
 * named <literal>Detail</literal>):
 * Any additional information required by the Type. The required           type and semantics are defined for each           &lt;tp:type&gt;Rich_Presence_Access_Control_Type&lt;/tp:type&gt;.
 *
 */

/**
 * TP_STRUCT_TYPE_LAST_ACTIVITY_AND_STATUSES:

 * 
	Structure representing a contact&apos;s presence, containing
        a last-activity time (deprecated) and a Multiple_Status_Map.
      

 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GValueArray
 * appropriate for representing a D-Bus struct
 * with signature <literal>(ua{sa{sv}})</literal>.
 *
 * Member 0 (D-Bus type <literal>u</literal>,
 * type <literal>Unix_Timestamp</literal>,
 * named <literal>Last_Activity</literal>):
 * (Undocumented)
 *
 * Member 1 (D-Bus type <literal>a{sa{sv}}</literal>,
 * type <literal>Multiple_Status_Map</literal>,
 * named <literal>Statuses</literal>):
 * (Undocumented)
 *
 */

/**
 * TP_STRUCT_TYPE_STATUS_SPEC:

 * (Undocumented)
 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GValueArray
 * appropriate for representing a D-Bus struct
 * with signature <literal>(ubba{ss})</literal>.
 *
 * Member 0 (D-Bus type <literal>u</literal>,
 * type <literal>Connection_Presence_Type</literal>,
 * named <literal>Type</literal>):
 * (Undocumented)
 *
 * Member 1 (D-Bus type <literal>b</literal>,
 * named <literal>May_Set_On_Self</literal>):
 * (Undocumented)
 *
 * Member 2 (D-Bus type <literal>b</literal>,
 * named <literal>Exclusive</literal>):
 * (Undocumented)
 *
 * Member 3 (D-Bus type <literal>a{ss}</literal>,
 * type <literal>String_String_Map</literal>,
 * named <literal>Parameter_Types</literal>):
 * (Undocumented)
 *
 */

/**
 * TP_STRUCT_TYPE_CHANNEL_DETAILS:

 * 
	
        Enough details of a channel that clients can work out how to dispatch
        or handle it.
      

 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GValueArray
 * appropriate for representing a D-Bus struct
 * with signature <literal>(oa{sv})</literal>.
 *
 * Member 0 (D-Bus type <literal>o</literal>,
 * named <literal>Channel</literal>):
 * The object path of the channel.
 *
 * Member 1 (D-Bus type <literal>a{sv}</literal>,
 * type <literal>Qualified_Property_Value_Map</literal>,
 * named <literal>Properties</literal>):
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           &lt;p&gt;Properties of the channel.&lt;/p&gt;            &lt;p&gt;Connection managers MUST NOT include properties in this mapping             if their values can change. Clients MUST ignore properties             that appear in this mapping if their values can change.&lt;/p&gt;            &lt;tp:rationale&gt;             &lt;p&gt;If properties that could change were included, the following               race condition would be likely to exist in some cases:&lt;/p&gt;              &lt;ul&gt;               &lt;li&gt;NewChannels or Get(&amp;quot;Channels&amp;quot;) includes a property P with                 value V1&lt;/li&gt;               &lt;li&gt;Client creates a proxy object for the channel&lt;/li&gt;               &lt;li&gt;The value of P changes to V2&lt;/li&gt;               &lt;li&gt;Client connects to PChanged signal&lt;/li&gt;               &lt;li&gt;Client should call Get(&amp;quot;P&amp;quot;) or GetAll here, to avoid the                 race, but client&apos;s author has forgotten to do so&lt;/li&gt;               &lt;li&gt;Proxy object thinks P == V1, but actually P == V2&lt;/li&gt;             &lt;/ul&gt;              &lt;p&gt;We&apos;ve taken the opportunity to make the API encourage the               client author to get it right. Where possible, we intend that               properties whose value will be used in channel dispatching               or other &amp;quot;early&amp;quot; processing will be defined so that they are               immutable (can never change).&lt;/p&gt;           &lt;/tp:rationale&gt;            &lt;p&gt;Each dictionary MUST contain the keys             &lt;tp:dbus-ref&gt;org.freedesktop.Telepathy.Channel.ChannelType&lt;/tp:dbus-ref&gt;,             &lt;tp:dbus-ref&gt;org.freedesktop.Telepathy.Channel.TargetHandleType&lt;/tp:dbus-ref&gt;,             &lt;tp:dbus-ref&gt;org.freedesktop.Telepathy.Channel.TargetHandle&lt;/tp:dbus-ref&gt;,             &lt;tp:dbus-ref&gt;org.freedesktop.Telepathy.Channel.TargetID&lt;/tp:dbus-ref&gt;             and             &lt;tp:dbus-ref&gt;org.freedesktop.Telepathy.Channel.Requested&lt;/tp:dbus-ref&gt;.           &lt;/p&gt;            &lt;tp:rationale&gt;             &lt;p&gt;We expect these to be crucial to the channel-dispatching               process.&lt;/p&gt;           &lt;/tp:rationale&gt;
 *
 */

/**
 * TP_ARRAY_TYPE_CHANNEL_DETAILS_LIST:

 * Expands to a call to a function
 * that returns the #GType of a #GPtrArray
 * of #TP_STRUCT_TYPE_CHANNEL_DETAILS.
 */

/**
 * TP_STRUCT_TYPE_REQUESTABLE_CHANNEL_CLASS:

 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;
	
        
	&lt;p&gt;
		Structure representing a class of channels that can be requested,
          identified by a set of properties that identify that class of
          channel.
	&lt;/p&gt;
	

        
	&lt;tp:rationale&gt;
		
          
		&lt;p&gt;
			This will often just be the channel type and the handle type,
            but can include other properties of the channel - for instance,
            encrypted channels might require properties that
            unencrypted channels do not, like an encryption key.
		&lt;/p&gt;
		
        
	&lt;/tp:rationale&gt;
	

        
	&lt;p&gt;
		In some cases, these classes of channel may overlap, in the sense
          that one class fixes all the properties that another class does,
          plus some more properties.
	&lt;/p&gt;
	

        
	&lt;tp:rationale&gt;
		
          
		&lt;p&gt;
			For older clients to still be able to understand how to request
            channels in the presence of a hypothetical &amp;quot;encryption&amp;quot; interface,
            we&apos;d need to represent it like this:
		&lt;/p&gt;
		

          
		&lt;ul&gt;
			
            
			&lt;li&gt;
				class 1: ChannelType = Text, TargetHandleType = CONTACT
			&lt;/li&gt;
			
            
			&lt;li&gt;
				class 2: Channel.ChannelType = Text,
              Channel.TargetHandleType = CONTACT,
              Encryption.Encrypted = TRUE
			&lt;/li&gt;
			
          
		&lt;/ul&gt;
		
        
	&lt;/tp:rationale&gt;
	
      

 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GValueArray
 * appropriate for representing a D-Bus struct
 * with signature <literal>(a{sv}as)</literal>.
 *
 * Member 0 (D-Bus type <literal>a{sv}</literal>,
 * type <literal>Channel_Class</literal>,
 * named <literal>Fixed_Properties</literal>):
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           &lt;p&gt;The property values that identify this requestable channel class.             These properties MUST be included in requests for a channel of this             class, and MUST take these values.&lt;/p&gt;            &lt;p&gt;Clients that do not understand the semantics of all the             Fixed_Properties MUST NOT request channels of this class, since             they would be unable to avoid making an incorrect request.&lt;/p&gt;            &lt;p&gt;This implies that connection managers wishing to make channels             available to old or minimal clients SHOULD have a channel class             with the minimum number of Fixed_Properties, and MAY additionally             have channel classes with extra Fixed_Properties.&lt;/p&gt;            &lt;p&gt;Interface designers SHOULD avoid introducing fixed properties             whose types are not serializable in a &lt;code&gt;.manager&lt;/code&gt;             file.&lt;/p&gt;            &lt;tp:rationale&gt;             &lt;p&gt;Connection managers with a fixed property that is not               serializable cannot have a complete &lt;code&gt;.manager&lt;/code&gt;               file.&lt;/p&gt;           &lt;/tp:rationale&gt;
 *
 * Member 1 (D-Bus type <literal>as</literal>,
 * type <literal>DBus_Qualified_Member[]</literal>,
 * named <literal>Allowed_Properties</literal>):
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           &lt;p&gt;Properties that MAY be set when requesting a channel of this             channel type and handle type.&lt;/p&gt;            &lt;p&gt;This array MUST NOT include properties that are in the             Fixed_Properties mapping.&lt;/p&gt;            &lt;p&gt;Properties in this array may either be required or optional,             according to their documented semantics.&lt;/p&gt;            &lt;tp:rationale&gt;             &lt;p&gt;For instance, if               TargetHandleType takes a value that is not Handle_Type_None,               one or the other of TargetHandle and TargetID is required.               Clients are expected to understand the documented relationship               between the properties, so we do not have separate arrays               of required and optional properties.&lt;/p&gt;           &lt;/tp:rationale&gt;            &lt;p&gt;If this array contains the             &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Channel.FUTURE&quot;&gt;Bundle&lt;/tp:dbus-ref&gt;             property, then this class of channel can be combined with other             channels with that property in a request, or added to an existing             bundle. If not, this signifies that the connection manager is             unable to mark channels of this class as part of a bundle - this             means that to the remote contact they are likely to be             indistinguishable from channels requested separately.&lt;/p&gt;
 *
 */

/**
 * TP_ARRAY_TYPE_REQUESTABLE_CHANNEL_CLASS_LIST:

 * Expands to a call to a function
 * that returns the #GType of a #GPtrArray
 * of #TP_STRUCT_TYPE_REQUESTABLE_CHANNEL_CLASS.
 */

/**
 * TP_STRUCT_TYPE_SERVICE_POINT_INFO:

 * 
	
          The service point.
        

 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GValueArray
 * appropriate for representing a D-Bus struct
 * with signature <literal>((us)as)</literal>.
 *
 * Member 0 (D-Bus type <literal>(us)</literal>,
 * type <literal>Service_Point</literal>,
 * named <literal>Service_Point</literal>):
 * The service point.
 *
 * Member 1 (D-Bus type <literal>as</literal>,
 * named <literal>Service_IDs</literal>):
 * A list of IDs that are mapped to this service. This is provided as           a convenience for the UIs, but the preferred method for           requesting channel to a service is by setting the &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Channel.Interface.ServicePoint&quot;&gt;InitialServicePoint&lt;/tp:dbus-ref&gt;             property in a channel request.
 *
 */

/**
 * TP_ARRAY_TYPE_SERVICE_POINT_INFO_LIST:

 * Expands to a call to a function
 * that returns the #GType of a #GPtrArray
 * of #TP_STRUCT_TYPE_SERVICE_POINT_INFO.
 */

/**
 * TP_STRUCT_TYPE_SERVICE_POINT:

 * 
	A service point.

 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GValueArray
 * appropriate for representing a D-Bus struct
 * with signature <literal>(us)</literal>.
 *
 * Member 0 (D-Bus type <literal>u</literal>,
 * type <literal>Service_Point_Type</literal>,
 * named <literal>Service_Point_Type</literal>):
 * The service type.
 *
 * Member 1 (D-Bus type <literal>s</literal>,
 * named <literal>Service</literal>):
 * String representation of the service point. The representation is           service specific; it may be a &apos;service&apos; Uniform Resource Name as           specified by &lt;a href=&quot;http://www.rfc-editor.org/rfc/rfc5031.txt&quot;&gt;RFC 5031&lt;/a&gt;,           or may be in some other form. Empty, unused or unknown value is           represented by &amp;quot;&amp;quot;.
 *
 */

/**
 * TP_STRUCT_TYPE_MEDIA_STREAM_INFO:

 * (Undocumented)
 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GValueArray
 * appropriate for representing a D-Bus struct
 * with signature <literal>(uuuuuu)</literal>.
 *
 * Member 0 (D-Bus type <literal>u</literal>,
 * type <literal>Stream_ID</literal>,
 * named <literal>Identifier</literal>):
 * (Undocumented)
 *
 * Member 1 (D-Bus type <literal>u</literal>,
 * type <literal>Contact_Handle</literal>,
 * named <literal>Contact</literal>):
 * (Undocumented)
 *
 * Member 2 (D-Bus type <literal>u</literal>,
 * type <literal>Media_Stream_Type</literal>,
 * named <literal>Type</literal>):
 * (Undocumented)
 *
 * Member 3 (D-Bus type <literal>u</literal>,
 * type <literal>Media_Stream_State</literal>,
 * named <literal>State</literal>):
 * (Undocumented)
 *
 * Member 4 (D-Bus type <literal>u</literal>,
 * type <literal>Media_Stream_Direction</literal>,
 * named <literal>Direction</literal>):
 * (Undocumented)
 *
 * Member 5 (D-Bus type <literal>u</literal>,
 * type <literal>Media_Stream_Pending_Send</literal>,
 * named <literal>Pending_Send_Flags</literal>):
 * (Undocumented)
 *
 */

/**
 * TP_ARRAY_TYPE_MEDIA_STREAM_INFO_LIST:

 * Expands to a call to a function
 * that returns the #GType of a #GPtrArray
 * of #TP_STRUCT_TYPE_MEDIA_STREAM_INFO.
 */

/**
 * TP_STRUCT_TYPE_ROOM_INFO:

 * (Undocumented)
 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GValueArray
 * appropriate for representing a D-Bus struct
 * with signature <literal>(usa{sv})</literal>.
 *
 * Member 0 (D-Bus type <literal>u</literal>,
 * type <literal>Room_Handle</literal>,
 * named <literal>Handle</literal>):
 * (Undocumented)
 *
 * Member 1 (D-Bus type <literal>s</literal>,
 * type <literal>DBus_Interface</literal>,
 * named <literal>Channel_Type</literal>):
 * (Undocumented)
 *
 * Member 2 (D-Bus type <literal>a{sv}</literal>,
 * type <literal>String_Variant_Map</literal>,
 * named <literal>Info</literal>):
 * (Undocumented)
 *
 */

/**
 * TP_ARRAY_TYPE_ROOM_INFO_LIST:

 * Expands to a call to a function
 * that returns the #GType of a #GPtrArray
 * of #TP_STRUCT_TYPE_ROOM_INFO.
 */

/**
 * TP_STRUCT_TYPE_PENDING_TEXT_MESSAGE:

 * 
	A struct (message ID, timestamp in seconds since
        1970-01-01 00:00 UTC, sender&apos;s handle, message type, flags, text)
        representing a pending text message, as returned by
        
	&lt;tp:member-ref&gt;
		ListPendingMessages
	&lt;/tp:member-ref&gt;
	.  The arguments of
        the 
	&lt;tp:member-ref&gt;
		Received
	&lt;/tp:member-ref&gt;
	 signal also match this
        struct&apos;s signature.

 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GValueArray
 * appropriate for representing a D-Bus struct
 * with signature <literal>(uuuuus)</literal>.
 *
 * Member 0 (D-Bus type <literal>u</literal>,
 * type <literal>Message_ID</literal>,
 * named <literal>Identifier</literal>):
 * (Undocumented)
 *
 * Member 1 (D-Bus type <literal>u</literal>,
 * type <literal>Unix_Timestamp</literal>,
 * named <literal>Unix_Timestamp</literal>):
 * (Undocumented)
 *
 * Member 2 (D-Bus type <literal>u</literal>,
 * type <literal>Contact_Handle</literal>,
 * named <literal>Sender</literal>):
 * (Undocumented)
 *
 * Member 3 (D-Bus type <literal>u</literal>,
 * type <literal>Channel_Text_Message_Type</literal>,
 * named <literal>Message_Type</literal>):
 * (Undocumented)
 *
 * Member 4 (D-Bus type <literal>u</literal>,
 * type <literal>Channel_Text_Message_Flags</literal>,
 * named <literal>Flags</literal>):
 * (Undocumented)
 *
 * Member 5 (D-Bus type <literal>s</literal>,
 * named <literal>Text</literal>):
 * (Undocumented)
 *
 */

/**
 * TP_ARRAY_TYPE_PENDING_TEXT_MESSAGE_LIST:

 * Expands to a call to a function
 * that returns the #GType of a #GPtrArray
 * of #TP_STRUCT_TYPE_PENDING_TEXT_MESSAGE.
 */

/**
 * TP_STRUCT_TYPE_TUBE_INFO:

 * 
	A struct (tube ID, initiator handle, tube type,
        service name, parameters, state) representing a tube, as returned
        by ListTubes on the Tubes channel type.

 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GValueArray
 * appropriate for representing a D-Bus struct
 * with signature <literal>(uuusa{sv}u)</literal>.
 *
 * Member 0 (D-Bus type <literal>u</literal>,
 * type <literal>Tube_ID</literal>,
 * named <literal>Identifier</literal>):
 * (Undocumented)
 *
 * Member 1 (D-Bus type <literal>u</literal>,
 * type <literal>Contact_Handle</literal>,
 * named <literal>Initiator</literal>):
 * (Undocumented)
 *
 * Member 2 (D-Bus type <literal>u</literal>,
 * type <literal>Tube_Type</literal>,
 * named <literal>Type</literal>):
 * (Undocumented)
 *
 * Member 3 (D-Bus type <literal>s</literal>,
 * named <literal>Service</literal>):
 * (Undocumented)
 *
 * Member 4 (D-Bus type <literal>a{sv}</literal>,
 * type <literal>String_Variant_Map</literal>,
 * named <literal>Parameters</literal>):
 * (Undocumented)
 *
 * Member 5 (D-Bus type <literal>u</literal>,
 * type <literal>Tube_State</literal>,
 * named <literal>State</literal>):
 * (Undocumented)
 *
 */

/**
 * TP_ARRAY_TYPE_TUBE_INFO_LIST:

 * Expands to a call to a function
 * that returns the #GType of a #GPtrArray
 * of #TP_STRUCT_TYPE_TUBE_INFO.
 */

/**
 * TP_STRUCT_TYPE_DBUS_TUBE_MEMBER:

 * 
	Represents a participant in a multi-user D-Bus tube, as
        returned by 
	&lt;tp:member-ref&gt;
		GetDBusNames
	&lt;/tp:member-ref&gt;
	 and seen in the
        
	&lt;tp:member-ref&gt;
		DBusNamesChanged
	&lt;/tp:member-ref&gt;
	 signal.

 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GValueArray
 * appropriate for representing a D-Bus struct
 * with signature <literal>(us)</literal>.
 *
 * Member 0 (D-Bus type <literal>u</literal>,
 * type <literal>Contact_Handle</literal>,
 * named <literal>Handle</literal>):
 * The handle of a participant in this D-Bus tube.
 *
 * Member 1 (D-Bus type <literal>s</literal>,
 * type <literal>DBus_Unique_Name</literal>,
 * named <literal>Unique_Name</literal>):
 * That participant&apos;s unique name.
 *
 */

/**
 * TP_ARRAY_TYPE_DBUS_TUBE_MEMBER_LIST:

 * Expands to a call to a function
 * that returns the #GType of a #GPtrArray
 * of #TP_STRUCT_TYPE_DBUS_TUBE_MEMBER.
 */

/**
 * TP_STRUCT_TYPE_LOCAL_PENDING_INFO:

 * 
	A structure representing a contact whose attempt to
        join a group is to be confirmed by the local user using
        
	&lt;tp:member-ref&gt;
		AddMembers
	&lt;/tp:member-ref&gt;
	.

 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GValueArray
 * appropriate for representing a D-Bus struct
 * with signature <literal>(uuus)</literal>.
 *
 * Member 0 (D-Bus type <literal>u</literal>,
 * type <literal>Contact_Handle</literal>,
 * named <literal>To_Be_Added</literal>):
 * The contact to be added to the group
 *
 * Member 1 (D-Bus type <literal>u</literal>,
 * type <literal>Contact_Handle</literal>,
 * named <literal>Actor</literal>):
 * The contact requesting or causing the change
 *
 * Member 2 (D-Bus type <literal>u</literal>,
 * type <literal>Channel_Group_Change_Reason</literal>,
 * named <literal>Reason</literal>):
 * The reason for the change
 *
 * Member 3 (D-Bus type <literal>s</literal>,
 * named <literal>Message</literal>):
 * A human-readable message from the Actor, or an empty string           if there is no message
 *
 */

/**
 * TP_ARRAY_TYPE_LOCAL_PENDING_INFO_LIST:

 * Expands to a call to a function
 * that returns the #GType of a #GPtrArray
 * of #TP_STRUCT_TYPE_LOCAL_PENDING_INFO.
 */

/**
 * TP_STRUCT_TYPE_MEDIA_SESSION_HANDLER_INFO:

 * 
	A struct representing a active session handler.

 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GValueArray
 * appropriate for representing a D-Bus struct
 * with signature <literal>(os)</literal>.
 *
 * Member 0 (D-Bus type <literal>o</literal>,
 * named <literal>Session_Handler</literal>):
 * The object path of the session handler, which is on the           same bus name as the channel.
 *
 * Member 1 (D-Bus type <literal>s</literal>,
 * type <literal>Media_Session_Type</literal>,
 * named <literal>Media_Session_Type</literal>):
 * The media session&apos;s type
 *
 */

/**
 * TP_ARRAY_TYPE_MEDIA_SESSION_HANDLER_INFO_LIST:

 * Expands to a call to a function
 * that returns the #GType of a #GPtrArray
 * of #TP_STRUCT_TYPE_MEDIA_SESSION_HANDLER_INFO.
 */

/**
 * TP_STRUCT_TYPE_MEDIA_STREAM_HANDLER_CANDIDATE:

 * (Undocumented)
 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GValueArray
 * appropriate for representing a D-Bus struct
 * with signature <literal>(sa(usuussduss))</literal>.
 *
 * Member 0 (D-Bus type <literal>s</literal>,
 * named <literal>Name</literal>):
 * (Undocumented)
 *
 * Member 1 (D-Bus type <literal>a(usuussduss)</literal>,
 * type <literal>Media_Stream_Handler_Transport[]</literal>,
 * named <literal>Transports</literal>):
 * (Undocumented)
 *
 */

/**
 * TP_ARRAY_TYPE_MEDIA_STREAM_HANDLER_CANDIDATE_LIST:

 * Expands to a call to a function
 * that returns the #GType of a #GPtrArray
 * of #TP_STRUCT_TYPE_MEDIA_STREAM_HANDLER_CANDIDATE.
 */

/**
 * TP_STRUCT_TYPE_MEDIA_STREAM_HANDLER_TRANSPORT:

 * (Undocumented)
 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GValueArray
 * appropriate for representing a D-Bus struct
 * with signature <literal>(usuussduss)</literal>.
 *
 * Member 0 (D-Bus type <literal>u</literal>,
 * named <literal>Component_Number</literal>):
 * (Undocumented)
 *
 * Member 1 (D-Bus type <literal>s</literal>,
 * named <literal>IP_Address</literal>):
 * (Undocumented)
 *
 * Member 2 (D-Bus type <literal>u</literal>,
 * named <literal>Port</literal>):
 * (Undocumented)
 *
 * Member 3 (D-Bus type <literal>u</literal>,
 * type <literal>Media_Stream_Base_Proto</literal>,
 * named <literal>Protocol</literal>):
 * (Undocumented)
 *
 * Member 4 (D-Bus type <literal>s</literal>,
 * named <literal>Subtype</literal>):
 * (Undocumented)
 *
 * Member 5 (D-Bus type <literal>s</literal>,
 * named <literal>Profile</literal>):
 * (Undocumented)
 *
 * Member 6 (D-Bus type <literal>d</literal>,
 * named <literal>Preference_Value</literal>):
 * (Undocumented)
 *
 * Member 7 (D-Bus type <literal>u</literal>,
 * type <literal>Media_Stream_Transport_Type</literal>,
 * named <literal>Transport_Type</literal>):
 * (Undocumented)
 *
 * Member 8 (D-Bus type <literal>s</literal>,
 * named <literal>Username</literal>):
 * (Undocumented)
 *
 * Member 9 (D-Bus type <literal>s</literal>,
 * named <literal>Password</literal>):
 * (Undocumented)
 *
 */

/**
 * TP_ARRAY_TYPE_MEDIA_STREAM_HANDLER_TRANSPORT_LIST:

 * Expands to a call to a function
 * that returns the #GType of a #GPtrArray
 * of #TP_STRUCT_TYPE_MEDIA_STREAM_HANDLER_TRANSPORT.
 */

/**
 * TP_STRUCT_TYPE_MEDIA_STREAM_HANDLER_CODEC:

 * 
	
        Information about a codec supported by a client or a peer&apos;s client.
      

 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GValueArray
 * appropriate for representing a D-Bus struct
 * with signature <literal>(usuuua{ss})</literal>.
 *
 * Member 0 (D-Bus type <literal>u</literal>,
 * named <literal>Codec_ID</literal>):
 * The codec&apos;s payload identifier, as per RFC 3551 (static or dynamic)
 *
 * Member 1 (D-Bus type <literal>s</literal>,
 * named <literal>Name</literal>):
 * The codec&apos;s name
 *
 * Member 2 (D-Bus type <literal>u</literal>,
 * type <literal>Media_Stream_Type</literal>,
 * named <literal>Media_Type</literal>):
 * Type of stream this codec supports
 *
 * Member 3 (D-Bus type <literal>u</literal>,
 * named <literal>Clock_Rate</literal>):
 * Sampling frequency in Hertz
 *
 * Member 4 (D-Bus type <literal>u</literal>,
 * named <literal>Number_Of_Channels</literal>):
 * Number of supported channels
 *
 * Member 5 (D-Bus type <literal>a{ss}</literal>,
 * type <literal>String_String_Map</literal>,
 * named <literal>Parameters</literal>):
 * Codec-specific optional parameters
 *
 */

/**
 * TP_ARRAY_TYPE_MEDIA_STREAM_HANDLER_CODEC_LIST:

 * Expands to a call to a function
 * that returns the #GType of a #GPtrArray
 * of #TP_STRUCT_TYPE_MEDIA_STREAM_HANDLER_CODEC.
 */

/**
 * TP_STRUCT_TYPE_PROPERTY_SPEC:

 * 
	A struct (property ID, property name, D-Bus signature,
        flags) representing a property, as returned by ListProperties on the
        Properties interface.

 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GValueArray
 * appropriate for representing a D-Bus struct
 * with signature <literal>(ussu)</literal>.
 *
 * Member 0 (D-Bus type <literal>u</literal>,
 * named <literal>Property_ID</literal>):
 * (Undocumented)
 *
 * Member 1 (D-Bus type <literal>s</literal>,
 * named <literal>Name</literal>):
 * (Undocumented)
 *
 * Member 2 (D-Bus type <literal>s</literal>,
 * type <literal>DBus_Signature</literal>,
 * named <literal>Signature</literal>):
 * (Undocumented)
 *
 * Member 3 (D-Bus type <literal>u</literal>,
 * type <literal>Property_Flags</literal>,
 * named <literal>Flags</literal>):
 * (Undocumented)
 *
 */

/**
 * TP_ARRAY_TYPE_PROPERTY_SPEC_LIST:

 * Expands to a call to a function
 * that returns the #GType of a #GPtrArray
 * of #TP_STRUCT_TYPE_PROPERTY_SPEC.
 */

/**
 * TP_STRUCT_TYPE_PROPERTY_FLAGS_CHANGE:

 * 
	A struct (property ID, flags) representing a change to
        a property&apos;s flags, as seen in the PropertyFlagsChanged signal on
        the Properties interface.

 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GValueArray
 * appropriate for representing a D-Bus struct
 * with signature <literal>(uu)</literal>.
 *
 * Member 0 (D-Bus type <literal>u</literal>,
 * named <literal>Property_ID</literal>):
 * (Undocumented)
 *
 * Member 1 (D-Bus type <literal>u</literal>,
 * named <literal>New_Flags</literal>):
 * (Undocumented)
 *
 */

/**
 * TP_ARRAY_TYPE_PROPERTY_FLAGS_CHANGE_LIST:

 * Expands to a call to a function
 * that returns the #GType of a #GPtrArray
 * of #TP_STRUCT_TYPE_PROPERTY_FLAGS_CHANGE.
 */

/**
 * TP_STRUCT_TYPE_PROPERTY_VALUE:

 * 
	A struct (property ID, value) representing a
        property&apos;s value, as seen in the PropertiesChanged signal on
        the Properties interface, returned by the GetProperties method
        and passed to the SetProperties method.

 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GValueArray
 * appropriate for representing a D-Bus struct
 * with signature <literal>(uv)</literal>.
 *
 * Member 0 (D-Bus type <literal>u</literal>,
 * type <literal>Property_ID</literal>,
 * named <literal>Identifier</literal>):
 * (Undocumented)
 *
 * Member 1 (D-Bus type <literal>v</literal>,
 * named <literal>Value</literal>):
 * (Undocumented)
 *
 */

/**
 * TP_ARRAY_TYPE_PROPERTY_VALUE_LIST:

 * Expands to a call to a function
 * that returns the #GType of a #GPtrArray
 * of #TP_STRUCT_TYPE_PROPERTY_VALUE.
 */

/**
 * TP_STRUCT_TYPE_AVATAR:

 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;
	
        
	&lt;p&gt;
		A struct containing avatar data marked with its MIME type.
	&lt;/p&gt;
	
      

 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GValueArray
 * appropriate for representing a D-Bus struct
 * with signature <literal>(ays)</literal>.
 *
 * Member 0 (D-Bus type <literal>ay</literal>,
 * named <literal>Avatar_Data</literal>):
 * (Undocumented)
 *
 * Member 1 (D-Bus type <literal>s</literal>,
 * named <literal>MIME_Type</literal>):
 * (Undocumented)
 *
 */

/**
 * TP_STRUCT_TYPE_DISPATCH_OPERATION_DETAILS:

 * 
	
        Details of a channel dispatch operation.
      

 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GValueArray
 * appropriate for representing a D-Bus struct
 * with signature <literal>(oa{sv})</literal>.
 *
 * Member 0 (D-Bus type <literal>o</literal>,
 * named <literal>Channel_Dispatch_Operation</literal>):
 * The object path of the           &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy&quot;&gt;ChannelDispatchOperation&lt;/tp:dbus-ref&gt;.
 *
 * Member 1 (D-Bus type <literal>a{sv}</literal>,
 * type <literal>Qualified_Property_Value_Map</literal>,
 * named <literal>Properties</literal>):
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           &lt;p&gt;Properties of the channel dispatch operation.&lt;/p&gt;            &lt;p&gt;Connection managers MUST NOT include properties in this mapping             if their values can change. Clients MUST ignore properties             that appear in this mapping if their values can change.&lt;/p&gt;            &lt;tp:rationale&gt;             &lt;p&gt;The rationale is the same as for               &lt;tp:type-ref&gt;Channel_Details&lt;/tp:type-ref&gt;.&lt;/p&gt;           &lt;/tp:rationale&gt;            &lt;p&gt;Each dictionary MUST contain at least the following keys:&lt;/p&gt;           &lt;ul&gt;             &lt;li&gt;&lt;tp:dbus-ref&gt;org.freedesktop.Telepathy.ChannelDispatchOperation.Interfaces&lt;/tp:dbus-ref&gt;&lt;/li&gt;             &lt;li&gt;&lt;tp:dbus-ref&gt;org.freedesktop.Telepathy.ChannelDispatchOperation.Connection&lt;/tp:dbus-ref&gt;&lt;/li&gt;             &lt;li&gt;&lt;tp:dbus-ref&gt;org.freedesktop.Telepathy.ChannelDispatchOperation.Account&lt;/tp:dbus-ref&gt;&lt;/li&gt;             &lt;li&gt;&lt;tp:dbus-ref&gt;org.freedesktop.Telepathy.ChannelDispatchOperation.PossibleHandlers&lt;/tp:dbus-ref&gt;&lt;/li&gt;           &lt;/ul&gt;
 *
 */

/**
 * TP_ARRAY_TYPE_DISPATCH_OPERATION_DETAILS_LIST:

 * Expands to a call to a function
 * that returns the #GType of a #GPtrArray
 * of #TP_STRUCT_TYPE_DISPATCH_OPERATION_DETAILS.
 */

/**
 * TP_STRUCT_TYPE_DEBUG_MESSAGE:

 * 
	
        A struct representing a debug message, as returned by
        
	&lt;tp:member-ref&gt;
		GetMessages
	&lt;/tp:member-ref&gt;
	.
      

 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GValueArray
 * appropriate for representing a D-Bus struct
 * with signature <literal>(dsus)</literal>.
 *
 * Member 0 (D-Bus type <literal>d</literal>,
 * named <literal>Timestamp</literal>):
 * Timestamp of the debug message. This is a double to allow           more accuracy in the time the message was logged.
 *
 * Member 1 (D-Bus type <literal>s</literal>,
 * named <literal>Domain</literal>):
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           &lt;p&gt;Domain of the debug message. This is used to identify           the source of debug messages. For example, debug messages           from a connection manager could have this Domain struct           member be the name of the connection manager, and logs           from any helper library could have the name of the helper           library.&lt;/p&gt;            &lt;p&gt;The domain could also contain a category as to where           the log message originated separated by a forward-slash.           For example, if a debug message was output in a connection           manager called &amp;quot;dummy&amp;quot;, in the file-transfer code, this           Domain struct member might be &lt;tt&gt;dummy/file-transfer&lt;/tt&gt;.&lt;/p&gt;
 *
 * Member 2 (D-Bus type <literal>u</literal>,
 * type <literal>Debug_Level</literal>,
 * named <literal>Level</literal>):
 * Level of the debug message. This states the severity of the           debug message.
 *
 * Member 3 (D-Bus type <literal>s</literal>,
 * named <literal>Message</literal>):
 * The text of the debug message.
 *
 */

/**
 * TP_ARRAY_TYPE_DEBUG_MESSAGE_LIST:

 * Expands to a call to a function
 * that returns the #GType of a #GPtrArray
 * of #TP_STRUCT_TYPE_DEBUG_MESSAGE.
 */

/**
 * TP_STRUCT_TYPE_TLS_CERTIFICATE_REJECTION:

 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;
	
        
	&lt;p&gt;
		Struct representing one reason why a TLS certificate was rejected.
	&lt;/p&gt;
	
        
	&lt;p&gt;
		Since there can be multiple things wrong with a TLS certificate,
        arrays of this type are used to represent lists of reasons for
        rejection. In that case, the most important reason SHOULD be placed
        first in the list.
	&lt;/p&gt;
	
      

 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GValueArray
 * appropriate for representing a D-Bus struct
 * with signature <literal>(usa{sv})</literal>.
 *
 * Member 0 (D-Bus type <literal>u</literal>,
 * type <literal>TLS_Certificate_Reject_Reason</literal>,
 * named <literal>Reason</literal>):
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           &lt;p&gt;The value of the TLS_Certificate_Reject_Reason enumeration for           this certificate rejection.           &lt;tp:rationale&gt;             Clients that do not understand the &lt;code&gt;Error&lt;/code&gt; member,             which may be implementation-specific, can use this property to             classify rejection reasons into common categories.           &lt;/tp:rationale&gt; 	  &lt;/p&gt;
 *
 * Member 1 (D-Bus type <literal>s</literal>,
 * type <literal>DBus_Error_Name</literal>,
 * named <literal>Error</literal>):
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           &lt;p&gt;The DBus error name for this certificate rejection.&lt;/p&gt;           &lt;p&gt;This MAY correspond to the value of the &lt;code&gt;Reason&lt;/code&gt; member,           or MAY be a more specific D-Bus error name, perhaps implementation-specific.&lt;/p&gt;
 *
 * Member 2 (D-Bus type <literal>a{sv}</literal>,
 * type <literal>String_Variant_Map</literal>,
 * named <literal>Details</literal>):
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           &lt;p&gt;Additional information about why the certificate was rejected.           This MAY also include one or more of the following well-known keys:&lt;/p&gt;           &lt;p&gt;           &lt;dl&gt;             &lt;dt&gt;user-requested (b)&lt;/dt&gt;             &lt;dd&gt;True if the error was due to an user-requested rejection of             the certificate; False if there was an unrecoverable error in the             verification process.&lt;/dd&gt;             &lt;dt&gt;expected-hostname (s)&lt;/dt&gt;             &lt;dd&gt;If the rejection reason is Hostname_Mismatch, the hostname that             the server certificate was expected to have.&lt;/dd&gt;             &lt;dt&gt;certificate-hostname (s)&lt;/dt&gt;             &lt;dd&gt;If the rejection reason is Hostname_Mismatch, the hostname of             the certificate that was presented.             &lt;tp:rationale&gt;               &lt;p&gt;For instance, if you try to connect to gmail.com but are presented               with a TLS certificate issued to evil.example.org, the error details               for Hostname_Mismatch MAY include:&lt;/p&gt;               &lt;pre&gt;                 {                   &apos;expected-hostname&apos;: &apos;gmail.com&apos;,                   &apos;certificate-hostname&apos;: &apos;evil.example.org&apos;,                 }               &lt;/pre&gt;             &lt;/tp:rationale&gt;             &lt;/dd&gt;             &lt;dt&gt;debug-message (s)&lt;/dt&gt;             &lt;dd&gt;Debugging information on the error, corresponding to the             message part of a D-Bus error message, which SHOULD NOT be             displayed to users under normal circumstances&lt;/dd&gt;           &lt;/dl&gt;           &lt;/p&gt;
 *
 */

/**
 * TP_ARRAY_TYPE_TLS_CERTIFICATE_REJECTION_LIST:

 * Expands to a call to a function
 * that returns the #GType of a #GPtrArray
 * of #TP_STRUCT_TYPE_TLS_CERTIFICATE_REJECTION.
 */

/**
 * TP_STRUCT_TYPE_SOCKET_ADDRESS_IP:

 * 
	An IP address and port.

 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GValueArray
 * appropriate for representing a D-Bus struct
 * with signature <literal>(sq)</literal>.
 *
 * Member 0 (D-Bus type <literal>s</literal>,
 * named <literal>Address</literal>):
 * Either a dotted-quad IPv4 address literal as for         &lt;tp:type&gt;Socket_Address_IPv4&lt;/tp:type&gt;, or an RFC2373 IPv6 address         as for &lt;tp:type&gt;Socket_Address_IPv6&lt;/tp:type&gt;.
 *
 * Member 1 (D-Bus type <literal>q</literal>,
 * named <literal>Port</literal>):
 * The TCP or UDP port number.
 *
 */

/**
 * TP_ARRAY_TYPE_SOCKET_ADDRESS_IP_LIST:

 * Expands to a call to a function
 * that returns the #GType of a #GPtrArray
 * of #TP_STRUCT_TYPE_SOCKET_ADDRESS_IP.
 */

/**
 * TP_STRUCT_TYPE_SOCKET_ADDRESS_IPV4:

 * 
	An IPv4 address and port.

 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GValueArray
 * appropriate for representing a D-Bus struct
 * with signature <literal>(sq)</literal>.
 *
 * Member 0 (D-Bus type <literal>s</literal>,
 * named <literal>Address</literal>):
 * A dotted-quad IPv4 address literal: four ASCII decimal         numbers, each between 0 and 255 inclusive, e.g.         &amp;quot;192.168.0.1&amp;quot;.
 *
 * Member 1 (D-Bus type <literal>q</literal>,
 * named <literal>Port</literal>):
 * The TCP or UDP port number.
 *
 */

/**
 * TP_STRUCT_TYPE_SOCKET_ADDRESS_IPV6:

 * 
	An IPv6 address and port.

 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GValueArray
 * appropriate for representing a D-Bus struct
 * with signature <literal>(sq)</literal>.
 *
 * Member 0 (D-Bus type <literal>s</literal>,
 * named <literal>Address</literal>):
 * An IPv6 address literal as specified by RFC2373         section 2.2, e.g. &amp;quot;2001:DB8::8:800:200C:4171&amp;quot;.
 *
 * Member 1 (D-Bus type <literal>q</literal>,
 * named <literal>Port</literal>):
 * The TCP or UDP port number.
 *
 */

/**
 * TP_STRUCT_TYPE_SOCKET_NETMASK_IPV4:

 * 
	An IPv4 network or subnet.

 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GValueArray
 * appropriate for representing a D-Bus struct
 * with signature <literal>(sy)</literal>.
 *
 * Member 0 (D-Bus type <literal>s</literal>,
 * named <literal>Address</literal>):
 * A dotted-quad IPv4 address literal: four ASCII decimal         numbers, each between 0 and 255 inclusive, e.g.         &amp;quot;192.168.0.1&amp;quot;.
 *
 * Member 1 (D-Bus type <literal>y</literal>,
 * named <literal>Prefix_Length</literal>):
 * The number of leading bits of the address that must         match, for this netmask to be considered to match an         address.
 *
 */

/**
 * TP_STRUCT_TYPE_SOCKET_NETMASK_IPV6:

 * 
	An IPv6 network or subnet.

 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GValueArray
 * appropriate for representing a D-Bus struct
 * with signature <literal>(sy)</literal>.
 *
 * Member 0 (D-Bus type <literal>s</literal>,
 * named <literal>Address</literal>):
 * An IPv6 address literal as specified by RFC2373         section 2.2, e.g. &amp;quot;2001:DB8::8:800:200C:4171&amp;quot;.
 *
 * Member 1 (D-Bus type <literal>y</literal>,
 * named <literal>Prefix_Length</literal>):
 * The number of leading bits of the address that must         match, for this netmask to be considered to match an         address.
 *
 */

