#include "_gen/svc-misc.h"

#include <telepathy-glib/dbus.h>
#include "_gen/signals-marshal.h"

static const DBusGObjectInfo _future_svc_call_content_codec_offer_object_info;

struct _FutureSvcCallContentCodecOfferClass {
    GTypeInterface parent_class;
    future_svc_call_content_codec_offer_accept_impl accept_cb;
    future_svc_call_content_codec_offer_reject_impl reject_cb;
};

static void future_svc_call_content_codec_offer_base_init (gpointer klass);

GType
future_svc_call_content_codec_offer_get_type (void)
{
  static GType type = 0;

  if (G_UNLIKELY (type == 0))
    {
      static const GTypeInfo info = {
        sizeof (FutureSvcCallContentCodecOfferClass),
        future_svc_call_content_codec_offer_base_init, /* base_init */
        NULL, /* base_finalize */
        NULL, /* class_init */
        NULL, /* class_finalize */
        NULL, /* class_data */
        0,
        0, /* n_preallocs */
        NULL /* instance_init */
      };

      type = g_type_register_static (G_TYPE_INTERFACE,
          "FutureSvcCallContentCodecOffer", &info, 0);
    }

  return type;
}

static void
future_svc_call_content_codec_offer_accept (FutureSvcCallContentCodecOffer *self,
    const GPtrArray *in_Codecs,
    DBusGMethodInvocation *context)
{
  future_svc_call_content_codec_offer_accept_impl impl = (FUTURE_SVC_CALL_CONTENT_CODEC_OFFER_GET_CLASS (self)->accept_cb);

  if (impl != NULL)
    {
      (impl) (self,
        in_Codecs,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

void
future_svc_call_content_codec_offer_implement_accept (FutureSvcCallContentCodecOfferClass *klass, future_svc_call_content_codec_offer_accept_impl impl)
{
  klass->accept_cb = impl;
}

static void
future_svc_call_content_codec_offer_reject (FutureSvcCallContentCodecOffer *self,
    DBusGMethodInvocation *context)
{
  future_svc_call_content_codec_offer_reject_impl impl = (FUTURE_SVC_CALL_CONTENT_CODEC_OFFER_GET_CLASS (self)->reject_cb);

  if (impl != NULL)
    {
      (impl) (self,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

void
future_svc_call_content_codec_offer_implement_reject (FutureSvcCallContentCodecOfferClass *klass, future_svc_call_content_codec_offer_reject_impl impl)
{
  klass->reject_cb = impl;
}

static inline void
future_svc_call_content_codec_offer_base_init_once (gpointer klass G_GNUC_UNUSED)
{
  static TpDBusPropertiesMixinPropInfo properties[2] = {
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "a{ua(usuua{ss})}", 0, NULL, NULL }, /* RemoteContactCodecMap */
      { 0, 0, NULL, 0, NULL, NULL }
  };
  static TpDBusPropertiesMixinIfaceInfo interface =
      { 0, properties, NULL, NULL };

  dbus_g_object_type_install_info (future_svc_call_content_codec_offer_get_type (),
      &_future_svc_call_content_codec_offer_object_info);

  interface.dbus_interface = g_quark_from_static_string ("org.freedesktop.Telepathy.Call.Content.CodecOffer.DRAFT");
  properties[0].name = g_quark_from_static_string ("RemoteContactCodecMap");
  properties[0].type = (dbus_g_type_get_map ("GHashTable", G_TYPE_UINT, (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_struct ("GValueArray", G_TYPE_UINT, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_UINT, DBUS_TYPE_G_STRING_STRING_HASHTABLE, G_TYPE_INVALID))))));
  tp_svc_interface_set_dbus_properties_info (FUTURE_TYPE_SVC_CALL_CONTENT_CODEC_OFFER, &interface);

}
static void
future_svc_call_content_codec_offer_base_init (gpointer klass)
{
  static gboolean initialized = FALSE;

  if (!initialized)
    {
      initialized = TRUE;
      future_svc_call_content_codec_offer_base_init_once (klass);
    }
}
static const DBusGMethodInfo _future_svc_call_content_codec_offer_methods[] = {
  { (GCallback) future_svc_call_content_codec_offer_accept, _future_ext_marshal_VOID__BOXED_POINTER, 0 },
  { (GCallback) future_svc_call_content_codec_offer_reject, g_cclosure_marshal_VOID__POINTER, 88 },
};

static const DBusGObjectInfo _future_svc_call_content_codec_offer_object_info = {
  0,
  _future_svc_call_content_codec_offer_methods,
  2,
"org.freedesktop.Telepathy.Call.Content.CodecOffer.DRAFT\0Accept\0A\0Codecs\0I\0a(usuua{ss})\0\0org.freedesktop.Telepathy.Call.Content.CodecOffer.DRAFT\0Reject\0A\0\0\0",
"\0\0",
"\0\0",
};

static const DBusGObjectInfo _future_svc_call_stream_endpoint_object_info;

struct _FutureSvcCallStreamEndpointClass {
    GTypeInterface parent_class;
    future_svc_call_stream_endpoint_set_selected_candidate_impl set_selected_candidate_cb;
    future_svc_call_stream_endpoint_set_stream_state_impl set_stream_state_cb;
};

enum {
    SIGNAL_CALL_STREAM_ENDPOINT_RemoteCredentialsSet,
    SIGNAL_CALL_STREAM_ENDPOINT_RemoteCandidatesAdded,
    SIGNAL_CALL_STREAM_ENDPOINT_CandidateSelected,
    SIGNAL_CALL_STREAM_ENDPOINT_StreamStateChanged,
    N_CALL_STREAM_ENDPOINT_SIGNALS
};
static guint call_stream_endpoint_signals[N_CALL_STREAM_ENDPOINT_SIGNALS] = {0};

static void future_svc_call_stream_endpoint_base_init (gpointer klass);

GType
future_svc_call_stream_endpoint_get_type (void)
{
  static GType type = 0;

  if (G_UNLIKELY (type == 0))
    {
      static const GTypeInfo info = {
        sizeof (FutureSvcCallStreamEndpointClass),
        future_svc_call_stream_endpoint_base_init, /* base_init */
        NULL, /* base_finalize */
        NULL, /* class_init */
        NULL, /* class_finalize */
        NULL, /* class_data */
        0,
        0, /* n_preallocs */
        NULL /* instance_init */
      };

      type = g_type_register_static (G_TYPE_INTERFACE,
          "FutureSvcCallStreamEndpoint", &info, 0);
    }

  return type;
}

static void
future_svc_call_stream_endpoint_set_selected_candidate (FutureSvcCallStreamEndpoint *self,
    const GValueArray *in_Candidate,
    DBusGMethodInvocation *context)
{
  future_svc_call_stream_endpoint_set_selected_candidate_impl impl = (FUTURE_SVC_CALL_STREAM_ENDPOINT_GET_CLASS (self)->set_selected_candidate_cb);

  if (impl != NULL)
    {
      (impl) (self,
        in_Candidate,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

void
future_svc_call_stream_endpoint_implement_set_selected_candidate (FutureSvcCallStreamEndpointClass *klass, future_svc_call_stream_endpoint_set_selected_candidate_impl impl)
{
  klass->set_selected_candidate_cb = impl;
}

static void
future_svc_call_stream_endpoint_set_stream_state (FutureSvcCallStreamEndpoint *self,
    guint in_State,
    DBusGMethodInvocation *context)
{
  future_svc_call_stream_endpoint_set_stream_state_impl impl = (FUTURE_SVC_CALL_STREAM_ENDPOINT_GET_CLASS (self)->set_stream_state_cb);

  if (impl != NULL)
    {
      (impl) (self,
        in_State,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

void
future_svc_call_stream_endpoint_implement_set_stream_state (FutureSvcCallStreamEndpointClass *klass, future_svc_call_stream_endpoint_set_stream_state_impl impl)
{
  klass->set_stream_state_cb = impl;
}

void
future_svc_call_stream_endpoint_emit_remote_credentials_set (gpointer instance,
    const gchar *arg_Username,
    const gchar *arg_Password)
{
  g_assert (instance != NULL);
  g_assert (G_TYPE_CHECK_INSTANCE_TYPE (instance, FUTURE_TYPE_SVC_CALL_STREAM_ENDPOINT));
  g_signal_emit (instance,
      call_stream_endpoint_signals[SIGNAL_CALL_STREAM_ENDPOINT_RemoteCredentialsSet],
      0,
      arg_Username,
      arg_Password);
}

void
future_svc_call_stream_endpoint_emit_remote_candidates_added (gpointer instance,
    const GPtrArray *arg_Candidates)
{
  g_assert (instance != NULL);
  g_assert (G_TYPE_CHECK_INSTANCE_TYPE (instance, FUTURE_TYPE_SVC_CALL_STREAM_ENDPOINT));
  g_signal_emit (instance,
      call_stream_endpoint_signals[SIGNAL_CALL_STREAM_ENDPOINT_RemoteCandidatesAdded],
      0,
      arg_Candidates);
}

void
future_svc_call_stream_endpoint_emit_candidate_selected (gpointer instance,
    const GValueArray *arg_Candidate)
{
  g_assert (instance != NULL);
  g_assert (G_TYPE_CHECK_INSTANCE_TYPE (instance, FUTURE_TYPE_SVC_CALL_STREAM_ENDPOINT));
  g_signal_emit (instance,
      call_stream_endpoint_signals[SIGNAL_CALL_STREAM_ENDPOINT_CandidateSelected],
      0,
      arg_Candidate);
}

void
future_svc_call_stream_endpoint_emit_stream_state_changed (gpointer instance,
    guint arg_state)
{
  g_assert (instance != NULL);
  g_assert (G_TYPE_CHECK_INSTANCE_TYPE (instance, FUTURE_TYPE_SVC_CALL_STREAM_ENDPOINT));
  g_signal_emit (instance,
      call_stream_endpoint_signals[SIGNAL_CALL_STREAM_ENDPOINT_StreamStateChanged],
      0,
      arg_state);
}

static inline void
future_svc_call_stream_endpoint_base_init_once (gpointer klass G_GNUC_UNUSED)
{
  static TpDBusPropertiesMixinPropInfo properties[6] = {
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "(ss)", 0, NULL, NULL }, /* RemoteCredentials */
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "a(usqa{sv})", 0, NULL, NULL }, /* RemoteCandidates */
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "(usqa{sv})", 0, NULL, NULL }, /* SelectedCandidate */
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "u", 0, NULL, NULL }, /* StreamState */
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "u", 0, NULL, NULL }, /* Transport */
      { 0, 0, NULL, 0, NULL, NULL }
  };
  static TpDBusPropertiesMixinIfaceInfo interface =
      { 0, properties, NULL, NULL };

  dbus_g_object_type_install_info (future_svc_call_stream_endpoint_get_type (),
      &_future_svc_call_stream_endpoint_object_info);

  interface.dbus_interface = g_quark_from_static_string ("org.freedesktop.Telepathy.Call.Stream.Endpoint.DRAFT");
  properties[0].name = g_quark_from_static_string ("RemoteCredentials");
  properties[0].type = (dbus_g_type_get_struct ("GValueArray", G_TYPE_STRING, G_TYPE_STRING, G_TYPE_INVALID));
  properties[1].name = g_quark_from_static_string ("RemoteCandidates");
  properties[1].type = (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_struct ("GValueArray", G_TYPE_UINT, G_TYPE_STRING, G_TYPE_UINT, (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)), G_TYPE_INVALID))));
  properties[2].name = g_quark_from_static_string ("SelectedCandidate");
  properties[2].type = (dbus_g_type_get_struct ("GValueArray", G_TYPE_UINT, G_TYPE_STRING, G_TYPE_UINT, (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)), G_TYPE_INVALID));
  properties[3].name = g_quark_from_static_string ("StreamState");
  properties[3].type = G_TYPE_UINT;
  properties[4].name = g_quark_from_static_string ("Transport");
  properties[4].type = G_TYPE_UINT;
  tp_svc_interface_set_dbus_properties_info (FUTURE_TYPE_SVC_CALL_STREAM_ENDPOINT, &interface);

  call_stream_endpoint_signals[SIGNAL_CALL_STREAM_ENDPOINT_RemoteCredentialsSet] =
  g_signal_new ("remote-credentials-set",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST|G_SIGNAL_DETAILED,
      0,
      NULL, NULL,
      _future_ext_marshal_VOID__STRING_STRING,
      G_TYPE_NONE,
      2,
      G_TYPE_STRING,
      G_TYPE_STRING);

  call_stream_endpoint_signals[SIGNAL_CALL_STREAM_ENDPOINT_RemoteCandidatesAdded] =
  g_signal_new ("remote-candidates-added",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST|G_SIGNAL_DETAILED,
      0,
      NULL, NULL,
      g_cclosure_marshal_VOID__BOXED,
      G_TYPE_NONE,
      1,
      (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_struct ("GValueArray", G_TYPE_UINT, G_TYPE_STRING, G_TYPE_UINT, (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)), G_TYPE_INVALID)))));

  call_stream_endpoint_signals[SIGNAL_CALL_STREAM_ENDPOINT_CandidateSelected] =
  g_signal_new ("candidate-selected",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST|G_SIGNAL_DETAILED,
      0,
      NULL, NULL,
      g_cclosure_marshal_VOID__BOXED,
      G_TYPE_NONE,
      1,
      (dbus_g_type_get_struct ("GValueArray", G_TYPE_UINT, G_TYPE_STRING, G_TYPE_UINT, (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)), G_TYPE_INVALID)));

  call_stream_endpoint_signals[SIGNAL_CALL_STREAM_ENDPOINT_StreamStateChanged] =
  g_signal_new ("stream-state-changed",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST|G_SIGNAL_DETAILED,
      0,
      NULL, NULL,
      g_cclosure_marshal_VOID__UINT,
      G_TYPE_NONE,
      1,
      G_TYPE_UINT);

}
static void
future_svc_call_stream_endpoint_base_init (gpointer klass)
{
  static gboolean initialized = FALSE;

  if (!initialized)
    {
      initialized = TRUE;
      future_svc_call_stream_endpoint_base_init_once (klass);
    }
}
static const DBusGMethodInfo _future_svc_call_stream_endpoint_methods[] = {
  { (GCallback) future_svc_call_stream_endpoint_set_selected_candidate, _future_ext_marshal_VOID__BOXED_POINTER, 0 },
  { (GCallback) future_svc_call_stream_endpoint_set_stream_state, g_cclosure_marshal_VOID__UINT_POINTER, 100 },
};

static const DBusGObjectInfo _future_svc_call_stream_endpoint_object_info = {
  0,
  _future_svc_call_stream_endpoint_methods,
  2,
"org.freedesktop.Telepathy.Call.Stream.Endpoint.DRAFT\0SetSelectedCandidate\0A\0Candidate\0I\0(usqa{sv})\0\0org.freedesktop.Telepathy.Call.Stream.Endpoint.DRAFT\0SetStreamState\0A\0State\0I\0u\0\0\0",
"org.freedesktop.Telepathy.Call.Stream.Endpoint.DRAFT\0RemoteCredentialsSet\0org.freedesktop.Telepathy.Call.Stream.Endpoint.DRAFT\0RemoteCandidatesAdded\0org.freedesktop.Telepathy.Call.Stream.Endpoint.DRAFT\0CandidateSelected\0org.freedesktop.Telepathy.Call.Stream.Endpoint.DRAFT\0StreamStateChanged\0\0",
"\0\0",
};


