#include "_gen/svc-channel.h"

#include <telepathy-glib/dbus.h>
#include "_gen/signals-marshal.h"

static const DBusGObjectInfo _future_svc_channel_type_call_object_info;

struct _FutureSvcChannelTypeCallClass {
    GTypeInterface parent_class;
    future_svc_channel_type_call_ringing_impl ringing_cb;
    future_svc_channel_type_call_accept_impl accept_cb;
    future_svc_channel_type_call_hangup_impl hangup_cb;
    future_svc_channel_type_call_add_content_impl add_content_cb;
};

enum {
    SIGNAL_CHANNEL_TYPE_CALL_ContentAdded,
    SIGNAL_CHANNEL_TYPE_CALL_ContentRemoved,
    SIGNAL_CHANNEL_TYPE_CALL_CallStateChanged,
    SIGNAL_CHANNEL_TYPE_CALL_CallMembersChanged,
    N_CHANNEL_TYPE_CALL_SIGNALS
};
static guint channel_type_call_signals[N_CHANNEL_TYPE_CALL_SIGNALS] = {0};

static void future_svc_channel_type_call_base_init (gpointer klass);

GType
future_svc_channel_type_call_get_type (void)
{
  static GType type = 0;

  if (G_UNLIKELY (type == 0))
    {
      static const GTypeInfo info = {
        sizeof (FutureSvcChannelTypeCallClass),
        future_svc_channel_type_call_base_init, /* base_init */
        NULL, /* base_finalize */
        NULL, /* class_init */
        NULL, /* class_finalize */
        NULL, /* class_data */
        0,
        0, /* n_preallocs */
        NULL /* instance_init */
      };

      type = g_type_register_static (G_TYPE_INTERFACE,
          "FutureSvcChannelTypeCall", &info, 0);
    }

  return type;
}

static void
future_svc_channel_type_call_ringing (FutureSvcChannelTypeCall *self,
    DBusGMethodInvocation *context)
{
  future_svc_channel_type_call_ringing_impl impl = (FUTURE_SVC_CHANNEL_TYPE_CALL_GET_CLASS (self)->ringing_cb);

  if (impl != NULL)
    {
      (impl) (self,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

void
future_svc_channel_type_call_implement_ringing (FutureSvcChannelTypeCallClass *klass, future_svc_channel_type_call_ringing_impl impl)
{
  klass->ringing_cb = impl;
}

static void
future_svc_channel_type_call_accept (FutureSvcChannelTypeCall *self,
    DBusGMethodInvocation *context)
{
  future_svc_channel_type_call_accept_impl impl = (FUTURE_SVC_CHANNEL_TYPE_CALL_GET_CLASS (self)->accept_cb);

  if (impl != NULL)
    {
      (impl) (self,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

void
future_svc_channel_type_call_implement_accept (FutureSvcChannelTypeCallClass *klass, future_svc_channel_type_call_accept_impl impl)
{
  klass->accept_cb = impl;
}

static void
future_svc_channel_type_call_hangup (FutureSvcChannelTypeCall *self,
    guint in_Reason,
    const gchar *in_Detailed_Hangup_Reason,
    const gchar *in_Message,
    DBusGMethodInvocation *context)
{
  future_svc_channel_type_call_hangup_impl impl = (FUTURE_SVC_CHANNEL_TYPE_CALL_GET_CLASS (self)->hangup_cb);

  if (impl != NULL)
    {
      (impl) (self,
        in_Reason,
        in_Detailed_Hangup_Reason,
        in_Message,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

void
future_svc_channel_type_call_implement_hangup (FutureSvcChannelTypeCallClass *klass, future_svc_channel_type_call_hangup_impl impl)
{
  klass->hangup_cb = impl;
}

static void
future_svc_channel_type_call_add_content (FutureSvcChannelTypeCall *self,
    const gchar *in_Content_Name,
    guint in_Content_Type,
    DBusGMethodInvocation *context)
{
  future_svc_channel_type_call_add_content_impl impl = (FUTURE_SVC_CHANNEL_TYPE_CALL_GET_CLASS (self)->add_content_cb);

  if (impl != NULL)
    {
      (impl) (self,
        in_Content_Name,
        in_Content_Type,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

void
future_svc_channel_type_call_implement_add_content (FutureSvcChannelTypeCallClass *klass, future_svc_channel_type_call_add_content_impl impl)
{
  klass->add_content_cb = impl;
}

void
future_svc_channel_type_call_emit_content_added (gpointer instance,
    const gchar *arg_Content,
    guint arg_Content_Type)
{
  g_assert (instance != NULL);
  g_assert (G_TYPE_CHECK_INSTANCE_TYPE (instance, FUTURE_TYPE_SVC_CHANNEL_TYPE_CALL));
  g_signal_emit (instance,
      channel_type_call_signals[SIGNAL_CHANNEL_TYPE_CALL_ContentAdded],
      0,
      arg_Content,
      arg_Content_Type);
}

void
future_svc_channel_type_call_emit_content_removed (gpointer instance,
    const gchar *arg_Content)
{
  g_assert (instance != NULL);
  g_assert (G_TYPE_CHECK_INSTANCE_TYPE (instance, FUTURE_TYPE_SVC_CHANNEL_TYPE_CALL));
  g_signal_emit (instance,
      channel_type_call_signals[SIGNAL_CHANNEL_TYPE_CALL_ContentRemoved],
      0,
      arg_Content);
}

void
future_svc_channel_type_call_emit_call_state_changed (gpointer instance,
    guint arg_Call_State,
    guint arg_Call_Flags,
    const GValueArray *arg_Call_State_Reason,
    GHashTable *arg_Call_State_Details)
{
  g_assert (instance != NULL);
  g_assert (G_TYPE_CHECK_INSTANCE_TYPE (instance, FUTURE_TYPE_SVC_CHANNEL_TYPE_CALL));
  g_signal_emit (instance,
      channel_type_call_signals[SIGNAL_CHANNEL_TYPE_CALL_CallStateChanged],
      0,
      arg_Call_State,
      arg_Call_Flags,
      arg_Call_State_Reason,
      arg_Call_State_Details);
}

void
future_svc_channel_type_call_emit_call_members_changed (gpointer instance,
    GHashTable *arg_Flags_Changed,
    const GArray *arg_Removed)
{
  g_assert (instance != NULL);
  g_assert (G_TYPE_CHECK_INSTANCE_TYPE (instance, FUTURE_TYPE_SVC_CHANNEL_TYPE_CALL));
  g_signal_emit (instance,
      channel_type_call_signals[SIGNAL_CHANNEL_TYPE_CALL_CallMembersChanged],
      0,
      arg_Flags_Changed,
      arg_Removed);
}

static inline void
future_svc_channel_type_call_base_init_once (gpointer klass G_GNUC_UNUSED)
{
  static TpDBusPropertiesMixinPropInfo properties[12] = {
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "ao", 0, NULL, NULL }, /* Contents */
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "a{sv}", 0, NULL, NULL }, /* CallStateDetails */
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "u", 0, NULL, NULL }, /* CallState */
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "u", 0, NULL, NULL }, /* CallFlags */
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "(uus)", 0, NULL, NULL }, /* CallStateReason */
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "b", 0, NULL, NULL }, /* HardwareStreaming */
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "a{uu}", 0, NULL, NULL }, /* CallMembers */
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "s", 0, NULL, NULL }, /* InitialTransport */
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "b", 0, NULL, NULL }, /* InitialAudio */
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "b", 0, NULL, NULL }, /* InitialVideo */
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "b", 0, NULL, NULL }, /* MutableContents */
      { 0, 0, NULL, 0, NULL, NULL }
  };
  static TpDBusPropertiesMixinIfaceInfo interface =
      { 0, properties, NULL, NULL };

  dbus_g_object_type_install_info (future_svc_channel_type_call_get_type (),
      &_future_svc_channel_type_call_object_info);

  interface.dbus_interface = g_quark_from_static_string ("org.freedesktop.Telepathy.Channel.Type.Call.DRAFT");
  properties[0].name = g_quark_from_static_string ("Contents");
  properties[0].type = dbus_g_type_get_collection ("GPtrArray", DBUS_TYPE_G_OBJECT_PATH);
  properties[1].name = g_quark_from_static_string ("CallStateDetails");
  properties[1].type = (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE));
  properties[2].name = g_quark_from_static_string ("CallState");
  properties[2].type = G_TYPE_UINT;
  properties[3].name = g_quark_from_static_string ("CallFlags");
  properties[3].type = G_TYPE_UINT;
  properties[4].name = g_quark_from_static_string ("CallStateReason");
  properties[4].type = (dbus_g_type_get_struct ("GValueArray", G_TYPE_UINT, G_TYPE_UINT, G_TYPE_STRING, G_TYPE_INVALID));
  properties[5].name = g_quark_from_static_string ("HardwareStreaming");
  properties[5].type = G_TYPE_BOOLEAN;
  properties[6].name = g_quark_from_static_string ("CallMembers");
  properties[6].type = (dbus_g_type_get_map ("GHashTable", G_TYPE_UINT, G_TYPE_UINT));
  properties[7].name = g_quark_from_static_string ("InitialTransport");
  properties[7].type = G_TYPE_STRING;
  properties[8].name = g_quark_from_static_string ("InitialAudio");
  properties[8].type = G_TYPE_BOOLEAN;
  properties[9].name = g_quark_from_static_string ("InitialVideo");
  properties[9].type = G_TYPE_BOOLEAN;
  properties[10].name = g_quark_from_static_string ("MutableContents");
  properties[10].type = G_TYPE_BOOLEAN;
  tp_svc_interface_set_dbus_properties_info (FUTURE_TYPE_SVC_CHANNEL_TYPE_CALL, &interface);

  channel_type_call_signals[SIGNAL_CHANNEL_TYPE_CALL_ContentAdded] =
  g_signal_new ("content-added",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST|G_SIGNAL_DETAILED,
      0,
      NULL, NULL,
      _future_ext_marshal_VOID__BOXED_UINT,
      G_TYPE_NONE,
      2,
      DBUS_TYPE_G_OBJECT_PATH,
      G_TYPE_UINT);

  channel_type_call_signals[SIGNAL_CHANNEL_TYPE_CALL_ContentRemoved] =
  g_signal_new ("content-removed",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST|G_SIGNAL_DETAILED,
      0,
      NULL, NULL,
      g_cclosure_marshal_VOID__BOXED,
      G_TYPE_NONE,
      1,
      DBUS_TYPE_G_OBJECT_PATH);

  channel_type_call_signals[SIGNAL_CHANNEL_TYPE_CALL_CallStateChanged] =
  g_signal_new ("call-state-changed",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST|G_SIGNAL_DETAILED,
      0,
      NULL, NULL,
      _future_ext_marshal_VOID__UINT_UINT_BOXED_BOXED,
      G_TYPE_NONE,
      4,
      G_TYPE_UINT,
      G_TYPE_UINT,
      (dbus_g_type_get_struct ("GValueArray", G_TYPE_UINT, G_TYPE_UINT, G_TYPE_STRING, G_TYPE_INVALID)),
      (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)));

  channel_type_call_signals[SIGNAL_CHANNEL_TYPE_CALL_CallMembersChanged] =
  g_signal_new ("call-members-changed",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST|G_SIGNAL_DETAILED,
      0,
      NULL, NULL,
      _future_ext_marshal_VOID__BOXED_BOXED,
      G_TYPE_NONE,
      2,
      (dbus_g_type_get_map ("GHashTable", G_TYPE_UINT, G_TYPE_UINT)),
      DBUS_TYPE_G_UINT_ARRAY);

}
static void
future_svc_channel_type_call_base_init (gpointer klass)
{
  static gboolean initialized = FALSE;

  if (!initialized)
    {
      initialized = TRUE;
      future_svc_channel_type_call_base_init_once (klass);
    }
}
static const DBusGMethodInfo _future_svc_channel_type_call_methods[] = {
  { (GCallback) future_svc_channel_type_call_ringing, g_cclosure_marshal_VOID__POINTER, 0 },
  { (GCallback) future_svc_channel_type_call_accept, g_cclosure_marshal_VOID__POINTER, 61 },
  { (GCallback) future_svc_channel_type_call_hangup, _future_ext_marshal_VOID__UINT_STRING_STRING_POINTER, 121 },
  { (GCallback) future_svc_channel_type_call_add_content, _future_ext_marshal_VOID__STRING_UINT_POINTER, 231 },
};

static const DBusGObjectInfo _future_svc_channel_type_call_object_info = {
  0,
  _future_svc_channel_type_call_methods,
  4,
"org.freedesktop.Telepathy.Channel.Type.Call.DRAFT\0Ringing\0A\0\0org.freedesktop.Telepathy.Channel.Type.Call.DRAFT\0Accept\0A\0\0org.freedesktop.Telepathy.Channel.Type.Call.DRAFT\0Hangup\0A\0Reason\0I\0u\0Detailed_Hangup_Reason\0I\0s\0Message\0I\0s\0\0org.freedesktop.Telepathy.Channel.Type.Call.DRAFT\0AddContent\0A\0Content_Name\0I\0s\0Content_Type\0I\0u\0Content\0O\0F\0N\0o\0\0\0",
"org.freedesktop.Telepathy.Channel.Type.Call.DRAFT\0ContentAdded\0org.freedesktop.Telepathy.Channel.Type.Call.DRAFT\0ContentRemoved\0org.freedesktop.Telepathy.Channel.Type.Call.DRAFT\0CallStateChanged\0org.freedesktop.Telepathy.Channel.Type.Call.DRAFT\0CallMembersChanged\0\0",
"\0\0",
};


