#include "_gen/svc-call-stream.h"

#include <telepathy-glib/dbus.h>
#include "_gen/signals-marshal.h"

static const DBusGObjectInfo _future_svc_call_stream_object_info;

struct _FutureSvcCallStreamClass {
    GTypeInterface parent_class;
    future_svc_call_stream_set_sending_impl set_sending_cb;
    future_svc_call_stream_request_receiving_impl request_receiving_cb;
};

enum {
    SIGNAL_CALL_STREAM_SendersChanged,
    N_CALL_STREAM_SIGNALS
};
static guint call_stream_signals[N_CALL_STREAM_SIGNALS] = {0};

static void future_svc_call_stream_base_init (gpointer klass);

GType
future_svc_call_stream_get_type (void)
{
  static GType type = 0;

  if (G_UNLIKELY (type == 0))
    {
      static const GTypeInfo info = {
        sizeof (FutureSvcCallStreamClass),
        future_svc_call_stream_base_init, /* base_init */
        NULL, /* base_finalize */
        NULL, /* class_init */
        NULL, /* class_finalize */
        NULL, /* class_data */
        0,
        0, /* n_preallocs */
        NULL /* instance_init */
      };

      type = g_type_register_static (G_TYPE_INTERFACE,
          "FutureSvcCallStream", &info, 0);
    }

  return type;
}

static void
future_svc_call_stream_set_sending (FutureSvcCallStream *self,
    gboolean in_Send,
    DBusGMethodInvocation *context)
{
  future_svc_call_stream_set_sending_impl impl = (FUTURE_SVC_CALL_STREAM_GET_CLASS (self)->set_sending_cb);

  if (impl != NULL)
    {
      (impl) (self,
        in_Send,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

void
future_svc_call_stream_implement_set_sending (FutureSvcCallStreamClass *klass, future_svc_call_stream_set_sending_impl impl)
{
  klass->set_sending_cb = impl;
}

static void
future_svc_call_stream_request_receiving (FutureSvcCallStream *self,
    guint in_Contact,
    gboolean in_Receive,
    DBusGMethodInvocation *context)
{
  future_svc_call_stream_request_receiving_impl impl = (FUTURE_SVC_CALL_STREAM_GET_CLASS (self)->request_receiving_cb);

  if (impl != NULL)
    {
      (impl) (self,
        in_Contact,
        in_Receive,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

void
future_svc_call_stream_implement_request_receiving (FutureSvcCallStreamClass *klass, future_svc_call_stream_request_receiving_impl impl)
{
  klass->request_receiving_cb = impl;
}

void
future_svc_call_stream_emit_senders_changed (gpointer instance,
    GHashTable *arg_Updates,
    const GArray *arg_Removed)
{
  g_assert (instance != NULL);
  g_assert (G_TYPE_CHECK_INSTANCE_TYPE (instance, FUTURE_TYPE_SVC_CALL_STREAM));
  g_signal_emit (instance,
      call_stream_signals[SIGNAL_CALL_STREAM_SendersChanged],
      0,
      arg_Updates,
      arg_Removed);
}

static inline void
future_svc_call_stream_base_init_once (gpointer klass G_GNUC_UNUSED)
{
  static TpDBusPropertiesMixinPropInfo properties[3] = {
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "as", 0, NULL, NULL }, /* Interfaces */
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "a{uu}", 0, NULL, NULL }, /* Senders */
      { 0, 0, NULL, 0, NULL, NULL }
  };
  static TpDBusPropertiesMixinIfaceInfo interface =
      { 0, properties, NULL, NULL };

  dbus_g_object_type_install_info (future_svc_call_stream_get_type (),
      &_future_svc_call_stream_object_info);

  interface.dbus_interface = g_quark_from_static_string ("org.freedesktop.Telepathy.Call.Stream.DRAFT");
  properties[0].name = g_quark_from_static_string ("Interfaces");
  properties[0].type = G_TYPE_STRV;
  properties[1].name = g_quark_from_static_string ("Senders");
  properties[1].type = (dbus_g_type_get_map ("GHashTable", G_TYPE_UINT, G_TYPE_UINT));
  tp_svc_interface_set_dbus_properties_info (FUTURE_TYPE_SVC_CALL_STREAM, &interface);

  call_stream_signals[SIGNAL_CALL_STREAM_SendersChanged] =
  g_signal_new ("senders-changed",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST|G_SIGNAL_DETAILED,
      0,
      NULL, NULL,
      _future_ext_marshal_VOID__BOXED_BOXED,
      G_TYPE_NONE,
      2,
      (dbus_g_type_get_map ("GHashTable", G_TYPE_UINT, G_TYPE_UINT)),
      DBUS_TYPE_G_UINT_ARRAY);

}
static void
future_svc_call_stream_base_init (gpointer klass)
{
  static gboolean initialized = FALSE;

  if (!initialized)
    {
      initialized = TRUE;
      future_svc_call_stream_base_init_once (klass);
    }
}
static const DBusGMethodInfo _future_svc_call_stream_methods[] = {
  { (GCallback) future_svc_call_stream_set_sending, _future_ext_marshal_VOID__BOOLEAN_POINTER, 0 },
  { (GCallback) future_svc_call_stream_request_receiving, _future_ext_marshal_VOID__UINT_BOOLEAN_POINTER, 67 },
};

static const DBusGObjectInfo _future_svc_call_stream_object_info = {
  0,
  _future_svc_call_stream_methods,
  2,
"org.freedesktop.Telepathy.Call.Stream.DRAFT\0SetSending\0A\0Send\0I\0b\0\0org.freedesktop.Telepathy.Call.Stream.DRAFT\0RequestReceiving\0A\0Contact\0I\0u\0Receive\0I\0b\0\0\0",
"org.freedesktop.Telepathy.Call.Stream.DRAFT\0SendersChanged\0\0",
"\0\0",
};

static const DBusGObjectInfo _future_svc_call_stream_interface_media_object_info;

struct _FutureSvcCallStreamInterfaceMediaClass {
    GTypeInterface parent_class;
    future_svc_call_stream_interface_media_add_candidates_impl add_candidates_cb;
    future_svc_call_stream_interface_media_candidates_prepared_impl candidates_prepared_cb;
};

enum {
    SIGNAL_CALL_STREAM_INTERFACE_MEDIA_LocalCandidatesAdded,
    SIGNAL_CALL_STREAM_INTERFACE_MEDIA_LocalCredentialsSet,
    SIGNAL_CALL_STREAM_INTERFACE_MEDIA_ServerInfoRetrieved,
    SIGNAL_CALL_STREAM_INTERFACE_MEDIA_EndpointsChanged,
    N_CALL_STREAM_INTERFACE_MEDIA_SIGNALS
};
static guint call_stream_interface_media_signals[N_CALL_STREAM_INTERFACE_MEDIA_SIGNALS] = {0};

static void future_svc_call_stream_interface_media_base_init (gpointer klass);

GType
future_svc_call_stream_interface_media_get_type (void)
{
  static GType type = 0;

  if (G_UNLIKELY (type == 0))
    {
      static const GTypeInfo info = {
        sizeof (FutureSvcCallStreamInterfaceMediaClass),
        future_svc_call_stream_interface_media_base_init, /* base_init */
        NULL, /* base_finalize */
        NULL, /* class_init */
        NULL, /* class_finalize */
        NULL, /* class_data */
        0,
        0, /* n_preallocs */
        NULL /* instance_init */
      };

      type = g_type_register_static (G_TYPE_INTERFACE,
          "FutureSvcCallStreamInterfaceMedia", &info, 0);
    }

  return type;
}

static void
future_svc_call_stream_interface_media_add_candidates (FutureSvcCallStreamInterfaceMedia *self,
    const GPtrArray *in_candidates,
    DBusGMethodInvocation *context)
{
  future_svc_call_stream_interface_media_add_candidates_impl impl = (FUTURE_SVC_CALL_STREAM_INTERFACE_MEDIA_GET_CLASS (self)->add_candidates_cb);

  if (impl != NULL)
    {
      (impl) (self,
        in_candidates,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

void
future_svc_call_stream_interface_media_implement_add_candidates (FutureSvcCallStreamInterfaceMediaClass *klass, future_svc_call_stream_interface_media_add_candidates_impl impl)
{
  klass->add_candidates_cb = impl;
}

static void
future_svc_call_stream_interface_media_candidates_prepared (FutureSvcCallStreamInterfaceMedia *self,
    DBusGMethodInvocation *context)
{
  future_svc_call_stream_interface_media_candidates_prepared_impl impl = (FUTURE_SVC_CALL_STREAM_INTERFACE_MEDIA_GET_CLASS (self)->candidates_prepared_cb);

  if (impl != NULL)
    {
      (impl) (self,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

void
future_svc_call_stream_interface_media_implement_candidates_prepared (FutureSvcCallStreamInterfaceMediaClass *klass, future_svc_call_stream_interface_media_candidates_prepared_impl impl)
{
  klass->candidates_prepared_cb = impl;
}

void
future_svc_call_stream_interface_media_emit_local_candidates_added (gpointer instance,
    const GPtrArray *arg_Candidates)
{
  g_assert (instance != NULL);
  g_assert (G_TYPE_CHECK_INSTANCE_TYPE (instance, FUTURE_TYPE_SVC_CALL_STREAM_INTERFACE_MEDIA));
  g_signal_emit (instance,
      call_stream_interface_media_signals[SIGNAL_CALL_STREAM_INTERFACE_MEDIA_LocalCandidatesAdded],
      0,
      arg_Candidates);
}

void
future_svc_call_stream_interface_media_emit_local_credentials_set (gpointer instance,
    const gchar *arg_Username,
    const gchar *arg_Password)
{
  g_assert (instance != NULL);
  g_assert (G_TYPE_CHECK_INSTANCE_TYPE (instance, FUTURE_TYPE_SVC_CALL_STREAM_INTERFACE_MEDIA));
  g_signal_emit (instance,
      call_stream_interface_media_signals[SIGNAL_CALL_STREAM_INTERFACE_MEDIA_LocalCredentialsSet],
      0,
      arg_Username,
      arg_Password);
}

void
future_svc_call_stream_interface_media_emit_server_info_retrieved (gpointer instance)
{
  g_assert (instance != NULL);
  g_assert (G_TYPE_CHECK_INSTANCE_TYPE (instance, FUTURE_TYPE_SVC_CALL_STREAM_INTERFACE_MEDIA));
  g_signal_emit (instance,
      call_stream_interface_media_signals[SIGNAL_CALL_STREAM_INTERFACE_MEDIA_ServerInfoRetrieved],
      0);
}

void
future_svc_call_stream_interface_media_emit_endpoints_changed (gpointer instance,
    const GPtrArray *arg_EndpointsAdded,
    const GPtrArray *arg_EndpointsRemoved)
{
  g_assert (instance != NULL);
  g_assert (G_TYPE_CHECK_INSTANCE_TYPE (instance, FUTURE_TYPE_SVC_CALL_STREAM_INTERFACE_MEDIA));
  g_signal_emit (instance,
      call_stream_interface_media_signals[SIGNAL_CALL_STREAM_INTERFACE_MEDIA_EndpointsChanged],
      0,
      arg_EndpointsAdded,
      arg_EndpointsRemoved);
}

static inline void
future_svc_call_stream_interface_media_base_init_once (gpointer klass G_GNUC_UNUSED)
{
  static TpDBusPropertiesMixinPropInfo properties[8] = {
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "u", 0, NULL, NULL }, /* Transport */
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "a(usqa{sv})", 0, NULL, NULL }, /* LocalCandidates */
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "(ss)", 0, NULL, NULL }, /* LocalCredentials */
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "a(sq)", 0, NULL, NULL }, /* STUNServers */
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "aa{sv}", 0, NULL, NULL }, /* RelayInfo */
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "b", 0, NULL, NULL }, /* RetrievedServerInfo */
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "ao", 0, NULL, NULL }, /* Endpoints */
      { 0, 0, NULL, 0, NULL, NULL }
  };
  static TpDBusPropertiesMixinIfaceInfo interface =
      { 0, properties, NULL, NULL };

  dbus_g_object_type_install_info (future_svc_call_stream_interface_media_get_type (),
      &_future_svc_call_stream_interface_media_object_info);

  interface.dbus_interface = g_quark_from_static_string ("org.freedesktop.Telepathy.Call.Stream.Interface.Media.DRAFT");
  properties[0].name = g_quark_from_static_string ("Transport");
  properties[0].type = G_TYPE_UINT;
  properties[1].name = g_quark_from_static_string ("LocalCandidates");
  properties[1].type = (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_struct ("GValueArray", G_TYPE_UINT, G_TYPE_STRING, G_TYPE_UINT, (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)), G_TYPE_INVALID))));
  properties[2].name = g_quark_from_static_string ("LocalCredentials");
  properties[2].type = (dbus_g_type_get_struct ("GValueArray", G_TYPE_STRING, G_TYPE_STRING, G_TYPE_INVALID));
  properties[3].name = g_quark_from_static_string ("STUNServers");
  properties[3].type = (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_struct ("GValueArray", G_TYPE_STRING, G_TYPE_UINT, G_TYPE_INVALID))));
  properties[4].name = g_quark_from_static_string ("RelayInfo");
  properties[4].type = (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE))));
  properties[5].name = g_quark_from_static_string ("RetrievedServerInfo");
  properties[5].type = G_TYPE_BOOLEAN;
  properties[6].name = g_quark_from_static_string ("Endpoints");
  properties[6].type = dbus_g_type_get_collection ("GPtrArray", DBUS_TYPE_G_OBJECT_PATH);
  tp_svc_interface_set_dbus_properties_info (FUTURE_TYPE_SVC_CALL_STREAM_INTERFACE_MEDIA, &interface);

  call_stream_interface_media_signals[SIGNAL_CALL_STREAM_INTERFACE_MEDIA_LocalCandidatesAdded] =
  g_signal_new ("local-candidates-added",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST|G_SIGNAL_DETAILED,
      0,
      NULL, NULL,
      g_cclosure_marshal_VOID__BOXED,
      G_TYPE_NONE,
      1,
      (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_struct ("GValueArray", G_TYPE_UINT, G_TYPE_STRING, G_TYPE_UINT, (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)), G_TYPE_INVALID)))));

  call_stream_interface_media_signals[SIGNAL_CALL_STREAM_INTERFACE_MEDIA_LocalCredentialsSet] =
  g_signal_new ("local-credentials-set",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST|G_SIGNAL_DETAILED,
      0,
      NULL, NULL,
      _future_ext_marshal_VOID__STRING_STRING,
      G_TYPE_NONE,
      2,
      G_TYPE_STRING,
      G_TYPE_STRING);

  call_stream_interface_media_signals[SIGNAL_CALL_STREAM_INTERFACE_MEDIA_ServerInfoRetrieved] =
  g_signal_new ("server-info-retrieved",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST|G_SIGNAL_DETAILED,
      0,
      NULL, NULL,
      g_cclosure_marshal_VOID__VOID,
      G_TYPE_NONE,
      0);

  call_stream_interface_media_signals[SIGNAL_CALL_STREAM_INTERFACE_MEDIA_EndpointsChanged] =
  g_signal_new ("endpoints-changed",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST|G_SIGNAL_DETAILED,
      0,
      NULL, NULL,
      _future_ext_marshal_VOID__BOXED_BOXED,
      G_TYPE_NONE,
      2,
      dbus_g_type_get_collection ("GPtrArray", DBUS_TYPE_G_OBJECT_PATH),
      dbus_g_type_get_collection ("GPtrArray", DBUS_TYPE_G_OBJECT_PATH));

}
static void
future_svc_call_stream_interface_media_base_init (gpointer klass)
{
  static gboolean initialized = FALSE;

  if (!initialized)
    {
      initialized = TRUE;
      future_svc_call_stream_interface_media_base_init_once (klass);
    }
}
static const DBusGMethodInfo _future_svc_call_stream_interface_media_methods[] = {
  { (GCallback) future_svc_call_stream_interface_media_add_candidates, _future_ext_marshal_VOID__BOXED_POINTER, 0 },
  { (GCallback) future_svc_call_stream_interface_media_candidates_prepared, g_cclosure_marshal_VOID__POINTER, 102 },
};

static const DBusGObjectInfo _future_svc_call_stream_interface_media_object_info = {
  0,
  _future_svc_call_stream_interface_media_methods,
  2,
"org.freedesktop.Telepathy.Call.Stream.Interface.Media.DRAFT\0AddCandidates\0A\0candidates\0I\0a(usqa{sv})\0\0org.freedesktop.Telepathy.Call.Stream.Interface.Media.DRAFT\0CandidatesPrepared\0A\0\0\0",
"org.freedesktop.Telepathy.Call.Stream.Interface.Media.DRAFT\0LocalCandidatesAdded\0org.freedesktop.Telepathy.Call.Stream.Interface.Media.DRAFT\0LocalCredentialsSet\0org.freedesktop.Telepathy.Call.Stream.Interface.Media.DRAFT\0ServerInfoRetrieved\0org.freedesktop.Telepathy.Call.Stream.Interface.Media.DRAFT\0EndpointsChanged\0\0",
"\0\0",
};


