/**
 * future_cli_channel_type_call_signal_callback_content_added:
 * @proxy: The proxy on which future_cli_channel_type_call_connect_to_content_added ()
 *  was called
 * @arg_Content: Path to the newly-created &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Call&quot;&gt;Content.DRAFT&lt;/tp:dbus-ref&gt; object.
 * @arg_Content_Type: The media type of the content which was added
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal ContentAdded.
 */

/**
 * future_cli_channel_type_call_connect_to_content_added:
 * @proxy: A #TpChannel or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal ContentAdded.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Emitted when a new &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Call&quot;&gt;Content.DRAFT&lt;/tp:dbus-ref&gt; is added to the call.&lt;/p&gt;
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * future_cli_channel_type_call_signal_callback_content_removed:
 * @proxy: The proxy on which future_cli_channel_type_call_connect_to_content_removed ()
 *  was called
 * @arg_Content: The &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Call&quot;&gt;Content.DRAFT&lt;/tp:dbus-ref&gt; which was removed.
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal ContentRemoved.
 */

/**
 * future_cli_channel_type_call_connect_to_content_removed:
 * @proxy: A #TpChannel or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal ContentRemoved.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Emitted when a &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Call&quot;&gt;Content.DRAFT&lt;/tp:dbus-ref&gt; is removed from the call.&lt;/p&gt;
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * future_cli_channel_type_call_signal_callback_call_state_changed:
 * @proxy: The proxy on which future_cli_channel_type_call_connect_to_call_state_changed ()
 *  was called
 * @arg_Call_State: The new value of the &lt;tp:member-ref&gt;CallState&lt;/tp:member-ref&gt;           property.
 * @arg_Call_Flags: The new value of the &lt;tp:member-ref&gt;CallFlags&lt;/tp:member-ref&gt;           property.
 * @arg_Call_State_Reason: The new value of the &lt;tp:member-ref&gt;CallStateReason&lt;/tp:member-ref&gt;           property.
 * @arg_Call_State_Details: The new value of the &lt;tp:member-ref&gt;CallStateDetails&lt;/tp:member-ref&gt;           property.
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal CallStateChanged.
 */

/**
 * future_cli_channel_type_call_connect_to_call_state_changed:
 * @proxy: A #TpChannel or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal CallStateChanged.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Emitted when the state of the call as a whole changes.&lt;/p&gt;          &lt;p&gt;This signal is emitted for any change in the properties           corresponding to its arguments, even if the other properties           referenced remain unchanged.&lt;/p&gt;
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * future_cli_channel_type_call_signal_callback_call_members_changed:
 * @proxy: The proxy on which future_cli_channel_type_call_connect_to_call_members_changed ()
 *  was called
 * @arg_Flags_Changed: A map from members of the call to their new call member flags,           including at least the members who have been added to           &lt;tp:member-ref&gt;CallMembers&lt;/tp:member-ref&gt;, and the members whose           flags have changed.
 * @arg_Removed: A list of members who have left the call, i.e. keys to be removed           from &lt;tp:member-ref&gt;CallMembers&lt;/tp:member-ref&gt;.
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal CallMembersChanged.
 */

/**
 * future_cli_channel_type_call_connect_to_call_members_changed:
 * @proxy: A #TpChannel or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal CallMembersChanged.
 *
 * Emitted when the &lt;tp:member-ref&gt;CallMembers&lt;/tp:member-ref&gt; property         changes in any way, either because contacts have been added to the         call, contacts have been removed from the call, or contacts&apos; flags         have changed.
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * future_cli_channel_type_call_callback_for_ringing:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a Ringing method call
 * succeeds or fails.
 */

/**
 * future_cli_channel_type_call_call_ringing:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a Ringing method call.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Indicate that the local user has been alerted about the incoming           call.&lt;/p&gt;          &lt;p&gt;This method is only useful if the channel&apos;s           &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Channel&quot;&gt;Requested&lt;/tp:dbus-ref&gt; property is false, and the           &lt;tp:member-ref&gt;CallState&lt;/tp:member-ref&gt; is           Call_State_Pending_Receiver. While this is the case,           this method SHOULD change the           &lt;tp:member-ref&gt;CallFlags&lt;/tp:member-ref&gt; to include           Call_Flag_Ringing, and notify the remote contact that the local           user has been alerted (if the protocol implements this); repeated           calls to this method SHOULD succeed, but have no further effect.&lt;/p&gt;          &lt;p&gt;In all other states, this method SHOULD fail with the error           NotAvailable.&lt;/p&gt;
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */


/**
 * future_cli_channel_type_call_callback_for_accept:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a Accept method call
 * succeeds or fails.
 */

/**
 * future_cli_channel_type_call_call_accept:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a Accept method call.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;For incoming calls in state Call_State_Pending_Receiver, accept the           incoming call; this changes the           &lt;tp:member-ref&gt;CallState&lt;/tp:member-ref&gt; to Call_State_Accepted.&lt;/p&gt;          &lt;p&gt;For outgoing calls in state Call_State_Pending_Initiator, actually           call the remote contact; this changes the           &lt;tp:member-ref&gt;CallState&lt;/tp:member-ref&gt; to           Call_State_Pending_Receiver.&lt;/p&gt;          &lt;p&gt;Otherwise, this method SHOULD fail with the error NotAvailable.&lt;/p&gt;          &lt;p&gt;This method should be called exactly once per Call, by whatever           client (user interface) is handling the channel.&lt;/p&gt;          &lt;p&gt;When this method is called, for each &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Call&quot;&gt;Content.DRAFT&lt;/tp:dbus-ref&gt; whose &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Call.Content.DRAFT&quot;&gt;Disposition&lt;/tp:dbus-ref&gt; is Call_Content_Disposition_Initial,           any streams where the self-handle&apos;s sending state in &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Call.Stream.DRAFT&quot;&gt;Senders&lt;/tp:dbus-ref&gt; is Sending_State_Pending_Send           will be moved to Sending_State_Sending as if &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Call.Stream.DRAFT&quot;&gt;SetSending&lt;/tp:dbus-ref&gt;(TRUE) had been called.&lt;/p&gt;
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */


/**
 * future_cli_channel_type_call_callback_for_hangup:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a Hangup method call
 * succeeds or fails.
 */

/**
 * future_cli_channel_type_call_call_hangup:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Reason: Used to pass an 'in' argument: A generic hangup reason.
 * @in_Detailed_Hangup_Reason: Used to pass an 'in' argument: A more specific reason for the call hangup, if one is available, or           an empty string otherwise.
 * @in_Message: Used to pass an 'in' argument: A human-readable message to be sent to the remote contact(s).            &lt;tp:rationale&gt;             XMPP Jingle allows calls to be terminated with a human-readable             message.           &lt;/tp:rationale&gt;
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a Hangup method call.
 *
 * Request that the call is ended.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */


/**
 * future_cli_channel_type_call_callback_for_add_content:
 * @proxy: the proxy on which the call was made
 * @out_Content: Used to return an 'out' argument if @error is %NULL: Path to the newly-created &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy&quot;&gt;Call.Content.DRAFT&lt;/tp:dbus-ref&gt; object.
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a AddContent method call
 * succeeds or fails.
 */

/**
 * future_cli_channel_type_call_call_add_content:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Content_Name: Used to pass an 'in' argument: The suggested name of the content to add            &lt;tp:rationale&gt;             [FIXME: rationale]           &lt;/tp:rationale&gt;
 * @in_Content_Type: Used to pass an 'in' argument: The media type of the content to add
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a AddContent method call.
 *
 * [FIXME]
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

