/**
 * future_cli_call_stream_signal_callback_senders_changed:
 * @proxy: The proxy on which future_cli_call_stream_connect_to_senders_changed ()
 *  was called
 * @arg_Updates: A mapping from channel-specific handles to their updated sending           state, whose keys include at least the senders who were added,           and the senders whose states changed.
 * @arg_Removed: The channel-specific handles that were removed from           the keys of the Senders property, as a result of the           contact leaving this stream
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal SendersChanged.
 */

/**
 * future_cli_call_stream_connect_to_senders_changed:
 * @proxy: A #FutureCallStream or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal SendersChanged.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         Emitted when &lt;tp:member-ref&gt;Senders&lt;/tp:member-ref&gt; changes.
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * future_cli_call_stream_callback_for_set_sending:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a SetSending method call
 * succeeds or fails.
 */

/**
 * future_cli_call_stream_call_set_sending:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Send: Used to pass an 'in' argument: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           &lt;p&gt;If true, the local user&apos;s sending state should change             to Sending, if it isn&apos;t already.&lt;/p&gt;            &lt;p&gt;If false, the local user&apos;s sending state should change to None,             if it isn&apos;t already.&lt;/p&gt;
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a SetSending method call.
 *
 * Set the stream to start or stop sending media from the local           user to other contacts.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */


/**
 * future_cli_call_stream_callback_for_request_receiving:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a RequestReceiving method call
 * succeeds or fails.
 */

/**
 * future_cli_call_stream_call_request_receiving:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Contact: Used to pass an 'in' argument: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           &lt;p&gt;Contact from which sending is requested&lt;/p&gt;
 * @in_Receive: Used to pass an 'in' argument: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           &lt;p&gt;If true, request that the given contact starts to send media.             If false, request that the given contact stops sending media.&lt;/p&gt;
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a RequestReceiving method call.
 *
 * Request that a remote contact stops or starts sending on this stream.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */


/**
 * future_cli_call_stream_interface_media_signal_callback_local_candidates_added:
 * @proxy: The proxy on which future_cli_call_stream_interface_media_connect_to_local_candidates_added ()
 *  was called
 * @arg_Candidates: Candidates that have been appended to           &lt;tp:member-ref&gt;LocalCandidates&lt;/tp:member-ref&gt;
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal LocalCandidatesAdded.
 */

/**
 * future_cli_call_stream_interface_media_connect_to_local_candidates_added:
 * @proxy: A #FutureCallStream or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal LocalCandidatesAdded.
 *
 * Emitted when local candidates are added to         &lt;tp:member-ref&gt;LocalCandidates&lt;/tp:member-ref&gt;.
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * future_cli_call_stream_interface_media_signal_callback_local_credentials_set:
 * @proxy: The proxy on which future_cli_call_stream_interface_media_connect_to_local_credentials_set ()
 *  was called
 * @arg_Username: (Undocumented)
 * @arg_Password: (Undocumented)
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal LocalCredentialsSet.
 */

/**
 * future_cli_call_stream_interface_media_connect_to_local_credentials_set:
 * @proxy: A #FutureCallStream or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal LocalCredentialsSet.
 *
 * Emitted when the value of         &lt;tp:member-ref&gt;LocalCredentials&lt;/tp:member-ref&gt; changes.
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * future_cli_call_stream_interface_media_signal_callback_server_info_retrieved:
 * @proxy: The proxy on which future_cli_call_stream_interface_media_connect_to_server_info_retrieved ()
 *  was called
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal ServerInfoRetrieved.
 */

/**
 * future_cli_call_stream_interface_media_connect_to_server_info_retrieved:
 * @proxy: A #FutureCallStream or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal ServerInfoRetrieved.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Signals that the initial information about STUN and Relay servers           has been retrieved, i.e. the           &lt;tp:member-ref&gt;RetrievedServerInfo&lt;/tp:member-ref&gt; property is now           true.&lt;/p&gt;
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * future_cli_call_stream_interface_media_signal_callback_endpoints_changed:
 * @proxy: The proxy on which future_cli_call_stream_interface_media_connect_to_endpoints_changed ()
 *  was called
 * @arg_EndpointsAdded: Endpoints that were added.
 * @arg_EndpointsRemoved: Endpoints that no longer exist.
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal EndpointsChanged.
 */

/**
 * future_cli_call_stream_interface_media_connect_to_endpoints_changed:
 * @proxy: A #FutureCallStream or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal EndpointsChanged.
 *
 * Emitted when the &lt;tp:member-ref&gt;Endpoints&lt;/tp:member-ref&gt; property         changes.
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * future_cli_call_stream_interface_media_callback_for_add_candidates:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a AddCandidates method call
 * succeeds or fails.
 */

/**
 * future_cli_call_stream_interface_media_call_add_candidates:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_candidates: Used to pass an 'in' argument: Candidates to be appended to           &lt;tp:member-ref&gt;LocalCandidates&lt;/tp:member-ref&gt;
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a AddCandidates method call.
 *
 * Add candidates to &lt;tp:member-ref&gt;LocalCandidates&lt;/tp:member-ref&gt;         and signal them to the remote contact(s).
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */


/**
 * future_cli_call_stream_interface_media_callback_for_candidates_prepared:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a CandidatesPrepared method call
 * succeeds or fails.
 */

/**
 * future_cli_call_stream_interface_media_call_candidates_prepared:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a CandidatesPrepared method call.
 *
 * This indicates to the CM that the initial batch of candidates has been         added.          &lt;tp:rationale&gt;           [FIXME: rationale]         &lt;/tp:rationale&gt;
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

