/* We don't want gtkdoc scanning this file, it'll get
 * confused by seeing function definitions, so mark it as: */
/*<private_header>*/

static inline void
future_cli_add_signals_for_call_content (DBusGProxy *proxy)
{
  if (!tp_proxy_dbus_g_proxy_claim_for_signal_adding (proxy))
    return;
  dbus_g_proxy_add_signal (proxy, "StreamAdded",
      DBUS_TYPE_G_OBJECT_PATH,
      G_TYPE_INVALID);
  dbus_g_proxy_add_signal (proxy, "StreamRemoved",
      DBUS_TYPE_G_OBJECT_PATH,
      G_TYPE_INVALID);
}


static void
_future_cli_call_content_collect_args_of_stream_added (DBusGProxy *proxy G_GNUC_UNUSED,
    const gchar *arg_Stream,
    TpProxySignalConnection *sc)
{
  GValueArray *args = g_value_array_new (1);
  GValue blank = { 0 };
  guint i;

  g_value_init (&blank, G_TYPE_INT);

  for (i = 0; i < 1; i++)
    g_value_array_append (args, &blank);

  g_value_unset (args->values + 0);
  g_value_init (args->values + 0, DBUS_TYPE_G_OBJECT_PATH);
  g_value_set_boxed (args->values + 0, arg_Stream);

  tp_proxy_signal_connection_v0_take_results (sc, args);
}
static void
_future_cli_call_content_invoke_callback_for_stream_added (TpProxy *tpproxy,
    GError *error G_GNUC_UNUSED,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  future_cli_call_content_signal_callback_stream_added callback =
      (future_cli_call_content_signal_callback_stream_added) generic_callback;

  if (callback != NULL)
    callback (g_object_ref (tpproxy),
      g_value_get_boxed (args->values + 0),
      user_data,
      weak_object);

  g_value_array_free (args);
  g_object_unref (tpproxy);
}
TpProxySignalConnection *
future_cli_call_content_connect_to_stream_added (FutureCallContent *proxy,
    future_cli_call_content_signal_callback_stream_added callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object,
    GError **error)
{
  GType expected_types[2] = {
      DBUS_TYPE_G_OBJECT_PATH,
      G_TYPE_INVALID };

  g_return_val_if_fail (FUTURE_IS_CALL_CONTENT (proxy), NULL);
  g_return_val_if_fail (callback != NULL, NULL);

  return tp_proxy_signal_connection_v0_new ((TpProxy *) proxy,
      FUTURE_IFACE_QUARK_CALL_CONTENT, "StreamAdded",
      expected_types,
      G_CALLBACK (_future_cli_call_content_collect_args_of_stream_added),
      _future_cli_call_content_invoke_callback_for_stream_added,
      G_CALLBACK (callback), user_data, destroy,
      weak_object, error);
}

static void
_future_cli_call_content_collect_args_of_stream_removed (DBusGProxy *proxy G_GNUC_UNUSED,
    const gchar *arg_Stream,
    TpProxySignalConnection *sc)
{
  GValueArray *args = g_value_array_new (1);
  GValue blank = { 0 };
  guint i;

  g_value_init (&blank, G_TYPE_INT);

  for (i = 0; i < 1; i++)
    g_value_array_append (args, &blank);

  g_value_unset (args->values + 0);
  g_value_init (args->values + 0, DBUS_TYPE_G_OBJECT_PATH);
  g_value_set_boxed (args->values + 0, arg_Stream);

  tp_proxy_signal_connection_v0_take_results (sc, args);
}
static void
_future_cli_call_content_invoke_callback_for_stream_removed (TpProxy *tpproxy,
    GError *error G_GNUC_UNUSED,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  future_cli_call_content_signal_callback_stream_removed callback =
      (future_cli_call_content_signal_callback_stream_removed) generic_callback;

  if (callback != NULL)
    callback (g_object_ref (tpproxy),
      g_value_get_boxed (args->values + 0),
      user_data,
      weak_object);

  g_value_array_free (args);
  g_object_unref (tpproxy);
}
TpProxySignalConnection *
future_cli_call_content_connect_to_stream_removed (FutureCallContent *proxy,
    future_cli_call_content_signal_callback_stream_removed callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object,
    GError **error)
{
  GType expected_types[2] = {
      DBUS_TYPE_G_OBJECT_PATH,
      G_TYPE_INVALID };

  g_return_val_if_fail (FUTURE_IS_CALL_CONTENT (proxy), NULL);
  g_return_val_if_fail (callback != NULL, NULL);

  return tp_proxy_signal_connection_v0_new ((TpProxy *) proxy,
      FUTURE_IFACE_QUARK_CALL_CONTENT, "StreamRemoved",
      expected_types,
      G_CALLBACK (_future_cli_call_content_collect_args_of_stream_removed),
      _future_cli_call_content_invoke_callback_for_stream_removed,
      G_CALLBACK (callback), user_data, destroy,
      weak_object, error);
}

static void
_future_cli_call_content_collect_callback_remove (DBusGProxy *proxy,
    DBusGProxyCall *call,
    gpointer user_data)
{
  GError *error = NULL;

  dbus_g_proxy_end_call (proxy, call, &error,
      G_TYPE_INVALID);
  tp_proxy_pending_call_v0_take_results (user_data, error,NULL);
}
static void
_future_cli_call_content_invoke_callback_remove (TpProxy *self,
    GError *error,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  future_cli_call_content_callback_for_remove callback = (future_cli_call_content_callback_for_remove) generic_callback;

  if (error != NULL)
    {
      callback ((FutureCallContent *) self,
          error, user_data, weak_object);
      g_error_free (error);
      return;
    }
  callback ((FutureCallContent *) self,
      error, user_data, weak_object);

  if (args != NULL)
    g_value_array_free (args);
}

TpProxyPendingCall *
future_cli_call_content_call_remove (FutureCallContent *proxy,
    gint timeout_ms,
    future_cli_call_content_callback_for_remove callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object)
{
  GError *error = NULL;
  GQuark interface = FUTURE_IFACE_QUARK_CALL_CONTENT;
  DBusGProxy *iface;

  g_return_val_if_fail (FUTURE_IS_CALL_CONTENT (proxy), NULL);
  g_return_val_if_fail (callback != NULL || user_data == NULL, NULL);
  g_return_val_if_fail (callback != NULL || destroy == NULL, NULL);
  g_return_val_if_fail (callback != NULL || weak_object == NULL, NULL);

  iface = tp_proxy_borrow_interface_by_id (
      (TpProxy *) proxy,
      interface, &error);

  if (iface == NULL)
    {
      if (callback != NULL)
        callback (proxy,
            error, user_data, weak_object);

      if (destroy != NULL)
        destroy (user_data);

      g_error_free (error);
      return NULL;
    }

  if (callback == NULL)
    {
      dbus_g_proxy_call_no_reply (iface, "Remove",
          G_TYPE_INVALID);
      return NULL;
    }
  else
    {
      TpProxyPendingCall *data;

      data = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
          interface, "Remove", iface,
          _future_cli_call_content_invoke_callback_remove,
          G_CALLBACK (callback), user_data, destroy,
          weak_object, FALSE);
      tp_proxy_pending_call_v0_take_pending_call (data,
          dbus_g_proxy_begin_call_with_timeout (iface,
              "Remove",
              _future_cli_call_content_collect_callback_remove,
              data,
              tp_proxy_pending_call_v0_completed,
              timeout_ms,
              G_TYPE_INVALID));

      return data;
    }
}


static inline void
future_cli_add_signals_for_call_content_interface_media (DBusGProxy *proxy)
{
  if (!tp_proxy_dbus_g_proxy_claim_for_signal_adding (proxy))
    return;
  dbus_g_proxy_add_signal (proxy, "CodecsChanged",
      (dbus_g_type_get_map ("GHashTable", G_TYPE_UINT, (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_struct ("GValueArray", G_TYPE_UINT, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_UINT, DBUS_TYPE_G_STRING_STRING_HASHTABLE, G_TYPE_INVALID)))))),
      DBUS_TYPE_G_UINT_ARRAY,
      G_TYPE_INVALID);
  dbus_g_proxy_add_signal (proxy, "NewCodecOffer",
      DBUS_TYPE_G_OBJECT_PATH,
      (dbus_g_type_get_map ("GHashTable", G_TYPE_UINT, (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_struct ("GValueArray", G_TYPE_UINT, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_UINT, DBUS_TYPE_G_STRING_STRING_HASHTABLE, G_TYPE_INVALID)))))),
      G_TYPE_INVALID);
}


static void
_future_cli_call_content_interface_media_collect_args_of_codecs_changed (DBusGProxy *proxy G_GNUC_UNUSED,
    GHashTable *arg_Updated_Codecs,
    const GArray *arg_Removed_Contacts,
    TpProxySignalConnection *sc)
{
  GValueArray *args = g_value_array_new (2);
  GValue blank = { 0 };
  guint i;

  g_value_init (&blank, G_TYPE_INT);

  for (i = 0; i < 2; i++)
    g_value_array_append (args, &blank);

  g_value_unset (args->values + 0);
  g_value_init (args->values + 0, (dbus_g_type_get_map ("GHashTable", G_TYPE_UINT, (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_struct ("GValueArray", G_TYPE_UINT, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_UINT, DBUS_TYPE_G_STRING_STRING_HASHTABLE, G_TYPE_INVALID)))))));
  g_value_set_boxed (args->values + 0, arg_Updated_Codecs);

  g_value_unset (args->values + 1);
  g_value_init (args->values + 1, DBUS_TYPE_G_UINT_ARRAY);
  g_value_set_boxed (args->values + 1, arg_Removed_Contacts);

  tp_proxy_signal_connection_v0_take_results (sc, args);
}
static void
_future_cli_call_content_interface_media_invoke_callback_for_codecs_changed (TpProxy *tpproxy,
    GError *error G_GNUC_UNUSED,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  future_cli_call_content_interface_media_signal_callback_codecs_changed callback =
      (future_cli_call_content_interface_media_signal_callback_codecs_changed) generic_callback;

  if (callback != NULL)
    callback (g_object_ref (tpproxy),
      g_value_get_boxed (args->values + 0),
      g_value_get_boxed (args->values + 1),
      user_data,
      weak_object);

  g_value_array_free (args);
  g_object_unref (tpproxy);
}
TpProxySignalConnection *
future_cli_call_content_interface_media_connect_to_codecs_changed (FutureCallContent *proxy,
    future_cli_call_content_interface_media_signal_callback_codecs_changed callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object,
    GError **error)
{
  GType expected_types[3] = {
      (dbus_g_type_get_map ("GHashTable", G_TYPE_UINT, (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_struct ("GValueArray", G_TYPE_UINT, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_UINT, DBUS_TYPE_G_STRING_STRING_HASHTABLE, G_TYPE_INVALID)))))),
      DBUS_TYPE_G_UINT_ARRAY,
      G_TYPE_INVALID };

  g_return_val_if_fail (FUTURE_IS_CALL_CONTENT (proxy), NULL);
  g_return_val_if_fail (callback != NULL, NULL);

  return tp_proxy_signal_connection_v0_new ((TpProxy *) proxy,
      FUTURE_IFACE_QUARK_CALL_CONTENT_INTERFACE_MEDIA, "CodecsChanged",
      expected_types,
      G_CALLBACK (_future_cli_call_content_interface_media_collect_args_of_codecs_changed),
      _future_cli_call_content_interface_media_invoke_callback_for_codecs_changed,
      G_CALLBACK (callback), user_data, destroy,
      weak_object, error);
}

static void
_future_cli_call_content_interface_media_collect_args_of_new_codec_offer (DBusGProxy *proxy G_GNUC_UNUSED,
    const gchar *arg_Offer,
    GHashTable *arg_Codecs,
    TpProxySignalConnection *sc)
{
  GValueArray *args = g_value_array_new (2);
  GValue blank = { 0 };
  guint i;

  g_value_init (&blank, G_TYPE_INT);

  for (i = 0; i < 2; i++)
    g_value_array_append (args, &blank);

  g_value_unset (args->values + 0);
  g_value_init (args->values + 0, DBUS_TYPE_G_OBJECT_PATH);
  g_value_set_boxed (args->values + 0, arg_Offer);

  g_value_unset (args->values + 1);
  g_value_init (args->values + 1, (dbus_g_type_get_map ("GHashTable", G_TYPE_UINT, (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_struct ("GValueArray", G_TYPE_UINT, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_UINT, DBUS_TYPE_G_STRING_STRING_HASHTABLE, G_TYPE_INVALID)))))));
  g_value_set_boxed (args->values + 1, arg_Codecs);

  tp_proxy_signal_connection_v0_take_results (sc, args);
}
static void
_future_cli_call_content_interface_media_invoke_callback_for_new_codec_offer (TpProxy *tpproxy,
    GError *error G_GNUC_UNUSED,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  future_cli_call_content_interface_media_signal_callback_new_codec_offer callback =
      (future_cli_call_content_interface_media_signal_callback_new_codec_offer) generic_callback;

  if (callback != NULL)
    callback (g_object_ref (tpproxy),
      g_value_get_boxed (args->values + 0),
      g_value_get_boxed (args->values + 1),
      user_data,
      weak_object);

  g_value_array_free (args);
  g_object_unref (tpproxy);
}
TpProxySignalConnection *
future_cli_call_content_interface_media_connect_to_new_codec_offer (FutureCallContent *proxy,
    future_cli_call_content_interface_media_signal_callback_new_codec_offer callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object,
    GError **error)
{
  GType expected_types[3] = {
      DBUS_TYPE_G_OBJECT_PATH,
      (dbus_g_type_get_map ("GHashTable", G_TYPE_UINT, (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_struct ("GValueArray", G_TYPE_UINT, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_UINT, DBUS_TYPE_G_STRING_STRING_HASHTABLE, G_TYPE_INVALID)))))),
      G_TYPE_INVALID };

  g_return_val_if_fail (FUTURE_IS_CALL_CONTENT (proxy), NULL);
  g_return_val_if_fail (callback != NULL, NULL);

  return tp_proxy_signal_connection_v0_new ((TpProxy *) proxy,
      FUTURE_IFACE_QUARK_CALL_CONTENT_INTERFACE_MEDIA, "NewCodecOffer",
      expected_types,
      G_CALLBACK (_future_cli_call_content_interface_media_collect_args_of_new_codec_offer),
      _future_cli_call_content_interface_media_invoke_callback_for_new_codec_offer,
      G_CALLBACK (callback), user_data, destroy,
      weak_object, error);
}

static void
_future_cli_call_content_interface_media_collect_callback_set_codecs (DBusGProxy *proxy,
    DBusGProxyCall *call,
    gpointer user_data)
{
  GError *error = NULL;

  dbus_g_proxy_end_call (proxy, call, &error,
      G_TYPE_INVALID);
  tp_proxy_pending_call_v0_take_results (user_data, error,NULL);
}
static void
_future_cli_call_content_interface_media_invoke_callback_set_codecs (TpProxy *self,
    GError *error,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  future_cli_call_content_interface_media_callback_for_set_codecs callback = (future_cli_call_content_interface_media_callback_for_set_codecs) generic_callback;

  if (error != NULL)
    {
      callback ((FutureCallContent *) self,
          error, user_data, weak_object);
      g_error_free (error);
      return;
    }
  callback ((FutureCallContent *) self,
      error, user_data, weak_object);

  if (args != NULL)
    g_value_array_free (args);
}

TpProxyPendingCall *
future_cli_call_content_interface_media_call_set_codecs (FutureCallContent *proxy,
    gint timeout_ms,
    const GPtrArray *in_Codecs,
    future_cli_call_content_interface_media_callback_for_set_codecs callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object)
{
  GError *error = NULL;
  GQuark interface = FUTURE_IFACE_QUARK_CALL_CONTENT_INTERFACE_MEDIA;
  DBusGProxy *iface;

  g_return_val_if_fail (FUTURE_IS_CALL_CONTENT (proxy), NULL);
  g_return_val_if_fail (callback != NULL || user_data == NULL, NULL);
  g_return_val_if_fail (callback != NULL || destroy == NULL, NULL);
  g_return_val_if_fail (callback != NULL || weak_object == NULL, NULL);

  iface = tp_proxy_borrow_interface_by_id (
      (TpProxy *) proxy,
      interface, &error);

  if (iface == NULL)
    {
      if (callback != NULL)
        callback (proxy,
            error, user_data, weak_object);

      if (destroy != NULL)
        destroy (user_data);

      g_error_free (error);
      return NULL;
    }

  if (callback == NULL)
    {
      dbus_g_proxy_call_no_reply (iface, "SetCodecs",
          (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_struct ("GValueArray", G_TYPE_UINT, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_UINT, DBUS_TYPE_G_STRING_STRING_HASHTABLE, G_TYPE_INVALID)))), in_Codecs,
          G_TYPE_INVALID);
      return NULL;
    }
  else
    {
      TpProxyPendingCall *data;

      data = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
          interface, "SetCodecs", iface,
          _future_cli_call_content_interface_media_invoke_callback_set_codecs,
          G_CALLBACK (callback), user_data, destroy,
          weak_object, FALSE);
      tp_proxy_pending_call_v0_take_pending_call (data,
          dbus_g_proxy_begin_call_with_timeout (iface,
              "SetCodecs",
              _future_cli_call_content_interface_media_collect_callback_set_codecs,
              data,
              tp_proxy_pending_call_v0_completed,
              timeout_ms,
              (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_struct ("GValueArray", G_TYPE_UINT, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_UINT, DBUS_TYPE_G_STRING_STRING_HASHTABLE, G_TYPE_INVALID)))), in_Codecs,
              G_TYPE_INVALID));

      return data;
    }
}


/*
 * future_cli_call_content_add_signals:
 * @self: the #TpProxy
 * @quark: a quark whose string value is the interface
 *   name whose signals should be added
 * @proxy: the D-Bus proxy to which to add the signals
 * @unused: not used for anything
 *
 * Tell dbus-glib that @proxy has the signatures of all
 * signals on the given interface, if it's one we
 * support.
 *
 * This function should be used as a signal handler for
 * #TpProxy::interface-added.
 */
static void
future_cli_call_content_add_signals (TpProxy *self G_GNUC_UNUSED,
    guint quark,
    DBusGProxy *proxy,
    gpointer unused G_GNUC_UNUSED)
{
  if (quark == FUTURE_IFACE_QUARK_CALL_CONTENT)
    future_cli_add_signals_for_call_content (proxy);
  if (quark == FUTURE_IFACE_QUARK_CALL_CONTENT_INTERFACE_MEDIA)
    future_cli_add_signals_for_call_content_interface_media (proxy);
}
