#include "_gen/svc-connection.h"

#include <telepathy-glib/dbus.h>
#include "_gen/signals-marshal.h"

static const DBusGObjectInfo _example_svc_connection_interface_hats_object_info;

struct _ExampleSvcConnectionInterfaceHatsClass {
    GTypeInterface parent_class;
    example_svc_connection_interface_hats_get_hats_impl get_hats_cb;
    example_svc_connection_interface_hats_set_hat_impl set_hat_cb;
};

enum {
    SIGNAL_CONNECTION_INTERFACE_HATS_HatsChanged,
    N_CONNECTION_INTERFACE_HATS_SIGNALS
};
static guint connection_interface_hats_signals[N_CONNECTION_INTERFACE_HATS_SIGNALS] = {0};

static void example_svc_connection_interface_hats_base_init (gpointer klass);

GType
example_svc_connection_interface_hats_get_type (void)
{
  static GType type = 0;

  if (G_UNLIKELY (type == 0))
    {
      static const GTypeInfo info = {
        sizeof (ExampleSvcConnectionInterfaceHatsClass),
        example_svc_connection_interface_hats_base_init, /* base_init */
        NULL, /* base_finalize */
        NULL, /* class_init */
        NULL, /* class_finalize */
        NULL, /* class_data */
        0,
        0, /* n_preallocs */
        NULL /* instance_init */
      };

      type = g_type_register_static (G_TYPE_INTERFACE,
          "ExampleSvcConnectionInterfaceHats", &info, 0);
    }

  return type;
}

static void
example_svc_connection_interface_hats_get_hats (ExampleSvcConnectionInterfaceHats *self,
    const GArray *in_Contact,
    DBusGMethodInvocation *context)
{
  example_svc_connection_interface_hats_get_hats_impl impl = (EXAMPLE_SVC_CONNECTION_INTERFACE_HATS_GET_CLASS (self)->get_hats_cb);

  if (impl != NULL)
    {
      (impl) (self,
        in_Contact,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

void
example_svc_connection_interface_hats_implement_get_hats (ExampleSvcConnectionInterfaceHatsClass *klass, example_svc_connection_interface_hats_get_hats_impl impl)
{
  klass->get_hats_cb = impl;
}

static void
example_svc_connection_interface_hats_set_hat (ExampleSvcConnectionInterfaceHats *self,
    const gchar *in_Color,
    guint in_Style,
    GHashTable *in_Properties,
    DBusGMethodInvocation *context)
{
  example_svc_connection_interface_hats_set_hat_impl impl = (EXAMPLE_SVC_CONNECTION_INTERFACE_HATS_GET_CLASS (self)->set_hat_cb);

  if (impl != NULL)
    {
      (impl) (self,
        in_Color,
        in_Style,
        in_Properties,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

void
example_svc_connection_interface_hats_implement_set_hat (ExampleSvcConnectionInterfaceHatsClass *klass, example_svc_connection_interface_hats_set_hat_impl impl)
{
  klass->set_hat_cb = impl;
}

void
example_svc_connection_interface_hats_emit_hats_changed (gpointer instance,
    guint arg_Contact,
    const gchar *arg_Color,
    guint arg_Style,
    GHashTable *arg_Properties)
{
  g_assert (instance != NULL);
  g_assert (G_TYPE_CHECK_INSTANCE_TYPE (instance, EXAMPLE_TYPE_SVC_CONNECTION_INTERFACE_HATS));
  g_signal_emit (instance,
      connection_interface_hats_signals[SIGNAL_CONNECTION_INTERFACE_HATS_HatsChanged],
      0,
      arg_Contact,
      arg_Color,
      arg_Style,
      arg_Properties);
}

static inline void
example_svc_connection_interface_hats_base_init_once (gpointer klass G_GNUC_UNUSED)
{
  dbus_g_object_type_install_info (example_svc_connection_interface_hats_get_type (),
      &_example_svc_connection_interface_hats_object_info);

  connection_interface_hats_signals[SIGNAL_CONNECTION_INTERFACE_HATS_HatsChanged] =
  g_signal_new ("hats-changed",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST|G_SIGNAL_DETAILED,
      0,
      NULL, NULL,
      _example_ext_marshal_VOID__UINT_STRING_UINT_BOXED,
      G_TYPE_NONE,
      4,
      G_TYPE_UINT,
      G_TYPE_STRING,
      G_TYPE_UINT,
      (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)));

}
static void
example_svc_connection_interface_hats_base_init (gpointer klass)
{
  static gboolean initialized = FALSE;

  if (!initialized)
    {
      initialized = TRUE;
      example_svc_connection_interface_hats_base_init_once (klass);
    }
}
static const DBusGMethodInfo _example_svc_connection_interface_hats_methods[] = {
  { (GCallback) example_svc_connection_interface_hats_get_hats, _example_ext_marshal_VOID__BOXED_POINTER, 0 },
  { (GCallback) example_svc_connection_interface_hats_set_hat, _example_ext_marshal_VOID__STRING_UINT_BOXED_POINTER, 95 },
};

static const DBusGObjectInfo _example_svc_connection_interface_hats_object_info = {
  0,
  _example_svc_connection_interface_hats_methods,
  2,
"com.example.Telepathy.Connection.Interface.Hats\0GetHats\0A\0Contact\0I\0au\0Hats\0O\0F\0N\0a(usua{sv})\0\0com.example.Telepathy.Connection.Interface.Hats\0SetHat\0A\0Color\0I\0s\0Style\0I\0u\0Properties\0I\0a{sv}\0\0\0",
"com.example.Telepathy.Connection.Interface.Hats\0HatsChanged\0\0",
"\0\0",
};


